/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.HierarchyDescriptor;
import org.apache.flink.table.descriptors.LiteralValue;
import org.apache.flink.types.Either;

@PublicEvolving
public class ClassInstance
extends HierarchyDescriptor {
    private String className;
    private List<Either<LiteralValue, ClassInstance>> constructor = new ArrayList<Either<LiteralValue, ClassInstance>>();

    public ClassInstance of(String className) {
        this.className = className;
        return this;
    }

    public ClassInstance parameterString(String valueString) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().value(valueString)));
        return this;
    }

    public ClassInstance parameter(String typeString, String valueString) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(typeString).value(valueString)));
        return this;
    }

    public ClassInstance parameter(TypeInformation<?> typeInfo, String valueString) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(typeInfo).value(valueString)));
        return this;
    }

    public ClassInstance parameter(boolean value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.BOOLEAN).value(value)));
        return this;
    }

    public ClassInstance parameter(double value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.DOUBLE).value(value)));
        return this;
    }

    public ClassInstance parameter(float value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.FLOAT).value(value)));
        return this;
    }

    public ClassInstance parameter(int value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.INT).value(value)));
        return this;
    }

    public ClassInstance parameter(String value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.STRING).value(value)));
        return this;
    }

    public ClassInstance parameter(long value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.LONG).value(value)));
        return this;
    }

    public ClassInstance parameter(byte value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.BYTE).value(value)));
        return this;
    }

    public ClassInstance parameter(short value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.SHORT).value(value)));
        return this;
    }

    public ClassInstance parameter(BigDecimal value) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Left((Object)new LiteralValue().of(Types.BIG_DEC).value(value)));
        return this;
    }

    public ClassInstance parameter(ClassInstance classInstance) {
        this.constructor.add((Either<LiteralValue, ClassInstance>)Either.Right((Object)classInstance));
        return this;
    }

    @Override
    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        this.addPropertiesWithPrefix("", properties);
        return properties.asMap();
    }

    @Override
    public void addPropertiesWithPrefix(String keyPrefix, DescriptorProperties properties) {
        if (this.className != null) {
            properties.putString(keyPrefix + "class", this.className);
        }
        for (int i = 0; i < this.constructor.size(); ++i) {
            Either<LiteralValue, ClassInstance> either = this.constructor.get(i);
            String keyPrefixWithIdx = keyPrefix + "constructor" + "." + i + ".";
            if (either.isLeft()) {
                ((LiteralValue)either.left()).addPropertiesWithPrefix(keyPrefixWithIdx, properties);
                continue;
            }
            ((ClassInstance)either.right()).addPropertiesWithPrefix(keyPrefixWithIdx, properties);
        }
    }
}

