/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.TableAlreadyExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.catalog.CrudExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0001\u0003\u00015\u0011q#\u00138NK6|'/_#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0014\u0007J,H-\u0012=uKJt\u0017\r\\\"bi\u0006dwn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005!a.Y7f!\ti2E\u0004\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011s$\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012 \u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0011\u0011F\u000b\t\u0003/\u0001AQa\u0007\u0014A\u0002qAq\u0001\f\u0001C\u0002\u0013%Q&A\u0005eCR\f'-Y:fgV\ta\u0006\u0005\u00030iq1T\"\u0001\u0019\u000b\u0005E\u0012\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003g}\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0004GA\u0004ICNDW*\u00199\u0011\u0005]9\u0014B\u0001\u001d\u0003\u0005=)\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0007B\u0002\u001e\u0001A\u0003%a&\u0001\u0006eCR\f'-Y:fg\u0002Bq\u0001\u0010\u0001C\u0002\u0013%Q(\u0001\u0004uC\ndWm]\u000b\u0002}A!q\u0006\u000e\u000f@!\t9\u0002)\u0003\u0002B\u0005\t!R\t\u001f;fe:\fGnQ1uC2|w\rV1cY\u0016Daa\u0011\u0001!\u0002\u0013q\u0014a\u0002;bE2,7\u000f\t\u0005\u0006\u000b\u0002!\tER\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0003H\u00152k\u0005C\u0001\u0010I\u0013\tIuD\u0001\u0003V]&$\b\"B&E\u0001\u0004a\u0012!\u0003;bE2,g*Y7f\u0011\u0015)A\t1\u0001@\u0011\u0015qE\t1\u0001P\u00039IwM\\8sK&3W\t_5tiN\u0004\"A\b)\n\u0005E{\"a\u0002\"p_2,\u0017M\u001c\u0015\u0004\tNc\u0006c\u0001\u0010U-&\u0011Qk\b\u0002\u0007i\"\u0014xn^:\u0011\u0005]SV\"\u0001-\u000b\u0005e#\u0011aA1qS&\u00111\f\u0017\u0002\u001b)\u0006\u0014G.Z!me\u0016\fG-_#ySN$X\t_2faRLwN\\\u0019\u0005=qif/M\u0003$=\n\f8-\u0006\u0002`AV\tA\u0004B\u0003b\u0019\t\u0007aMA\u0001U\u0013\t\u0019G-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003K~\ta\u0001\u001e5s_^\u001c\u0018CA4k!\tq\u0002.\u0003\u0002j?\t9aj\u001c;iS:<\u0007CA6o\u001d\tqB.\u0003\u0002n?\u00059\u0001/Y2lC\u001e,\u0017BA8q\u0005%!\u0006N]8xC\ndWM\u0003\u0002n?E*1E]:uK:\u0011ad]\u0005\u0003K~\tDA\t\u0010 k\n)1oY1mCF\u0012aE\u0016\u0005\u0006q\u0002!\t%_\u0001\nIJ|\u0007\u000fV1cY\u0016$2a\u0012>|\u0011\u0015Yu\u000f1\u0001\u001d\u0011\u0015ax\u000f1\u0001P\u0003EIwM\\8sK&3gj\u001c;Fq&\u001cHo\u001d\u0015\u0005oz\f)\u0001E\u0002\u001f)~\u00042aVA\u0001\u0013\r\t\u0019\u0001\u0017\u0002\u0017)\u0006\u0014G.\u001a(pi\u0016C\u0018n\u001d;Fq\u000e,\u0007\u000f^5p]F2a\u0004HA\u0004\u0003\u001b\tda\t0c\u0003\u0013\u0019\u0017GB\u0012sg\u0006-Q-\r\u0003#=})\u0018G\u0001\u0014\u0000\u0011\u001d\t\t\u0002\u0001C!\u0003'\t!\"\u00197uKJ$\u0016M\u00197f)\u001d9\u0015QCA\f\u00033AaaSA\b\u0001\u0004a\u0002BB\u0003\u0002\u0010\u0001\u0007q\b\u0003\u0004}\u0003\u001f\u0001\ra\u0014\u0015\u0006\u0003\u001fq\u0018QD\u0019\u0007=q\ty\"!\n2\r\rr&-!\tdc\u0019\u0019#o]A\u0012KF\"!EH\u0010vc\t1s\u0010C\u0004\u0002*\u0001!\t%a\u000b\u0002!\r\u0014X-\u0019;f'V\u00147)\u0019;bY><GcB$\u0002.\u0005E\u00121\u0007\u0005\b\u0003_\t9\u00031\u0001\u001d\u0003-\u0019\u0017\r^1m_\u001et\u0015-\\3\t\r\r\t9\u00031\u00017\u0011\u0019q\u0015q\u0005a\u0001\u001f\"2\u0011qEA\u001c\u0003\u007f\u0001BA\b+\u0002:A\u0019q+a\u000f\n\u0007\u0005u\u0002L\u0001\u000fDCR\fGn\\4BYJ,\u0017\rZ=Fq&\u001cH/\u0012=dKB$\u0018n\u001c82\rya\u0012\u0011IA$c\u0019\u0019cLYA\"GF21E]:\u0002F\u0015\fDA\t\u0010 kF\u001aa%!\u000f\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005qAM]8q'V\u00147)\u0019;bY><G#B$\u0002P\u0005E\u0003bBA\u0018\u0003\u0013\u0002\r\u0001\b\u0005\u0007y\u0006%\u0003\u0019A()\r\u0005%\u0013QKA/!\u0011qB+a\u0016\u0011\u0007]\u000bI&C\u0002\u0002\\a\u0013\u0001dQ1uC2|wMT8u\u000bbL7\u000f^#yG\u0016\u0004H/[8oc\u0019qB$a\u0018\u0002fE21E\u00182\u0002b\r\fda\t:t\u0003G*\u0017\u0007\u0002\u0012\u001f?U\f4AJA,\u0011\u001d\tI\u0007\u0001C!\u0003W\nq\"\u00197uKJ\u001cVOY\"bi\u0006dwn\u001a\u000b\b\u000f\u00065\u0014qNA9\u0011\u001d\ty#a\u001aA\u0002qAaaAA4\u0001\u00041\u0004B\u0002?\u0002h\u0001\u0007q\nC\u0004\u0002v\u0001!\t%a\u001e\u0002\u0011\u001d,G\u000fV1cY\u0016$2aPA=\u0011\u0019Y\u00151\u000fa\u00019!9\u0011Q\u0010\u0001\u0005B\u0005}\u0014A\u00037jgR$\u0016M\u00197fgR\u0011\u0011\u0011\u0011\t\u0006\u0003\u0007\u000bI\tH\u0007\u0003\u0003\u000bS1!a\"\u0013\u0003\u0011)H/\u001b7\n\t\u0005-\u0015Q\u0011\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002\u0010\u0002!\t%!%\u0002\u001b\u001d,GoU;c\u0007\u0006$\u0018\r\\8h)\r1\u00141\u0013\u0005\b\u0003_\ti\t1\u0001\u001dQ\u0019\ti)!\u0016\u0002\u0018F2a\u0004HAM\u0003?\u000bda\t0c\u00037\u001b\u0017GB\u0012sg\u0006uU-\r\u0003#=})\u0018g\u0001\u0014\u0002X!9\u00111\u0015\u0001\u0005B\u0005}\u0014a\u00047jgR\u001cVOY\"bi\u0006dwnZ:)\u000f\u0001\t9+!,\u0002>B\u0019a$!+\n\u0007\u0005-vD\u0001\u0006eKB\u0014XmY1uK\u0012\fta\t\u000f\u00020\u0006U6-C\u0002d\u0003cS1!a- \u0003)!W\r\u001d:fG\u0006$X\rZ\u0019\nG\u0005]\u0016\u0011XA^\u0003gs1AHA]\u0013\r\t\u0019lH\u0019\u0005EyyR/\r\u0005$9\u0005}\u00161YAa\u0013\u0011\t\t-!-\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133c%\u0019\u0013qWA]\u0003\u000b\f\u0019,\r\u0003#=})\b")
public class InMemoryExternalCatalog
implements CrudExternalCatalog {
    private final String name;
    private final HashMap<String, ExternalCatalog> databases;
    private final HashMap<String, ExternalCatalogTable> tables;

    private HashMap<String, ExternalCatalog> databases() {
        return this.databases;
    }

    private HashMap<String, ExternalCatalogTable> tables() {
        return this.tables;
    }

    @Override
    public void createTable(String tableName, ExternalCatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.tables().get((Object)tableName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new TableAlreadyExistException(this.name, tableName);
            }
            Option option2 = this.tables().put((Object)tableName, (Object)table);
            return;
        }
    }

    @Override
    public synchronized void dropTable(String tableName, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tables().remove((Object)tableName).isEmpty() && !ignoreIfNotExists) {
            throw new TableNotExistException(this.name, tableName);
        }
    }

    @Override
    public void alterTable(String tableName, ExternalCatalogTable table, boolean ignoreIfNotExists) throws TableNotExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        if (!this.tables().contains((Object)tableName)) break block5;
                        boxedUnit = this.tables().put((Object)tableName, (Object)table);
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new TableNotExistException(this.name, tableName);
        }
    }

    @Override
    public void createSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfExists) throws CatalogAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.databases().get((Object)catalogName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new CatalogAlreadyExistException(catalogName, null);
            }
            Option option2 = this.databases().put((Object)catalogName, (Object)catalog);
            return;
        }
    }

    @Override
    public synchronized void dropSubCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogNotExistException {
        if (this.databases().remove((Object)catalogName).isEmpty() && !ignoreIfNotExists) {
            throw new CatalogNotExistException(catalogName);
        }
    }

    @Override
    public void alterSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfNotExists) {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        if (!this.databases().contains((Object)catalogName)) break block5;
                        boxedUnit = this.databases().put((Object)catalogName, (Object)catalog);
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new CatalogNotExistException(catalogName);
        }
    }

    @Override
    public synchronized ExternalCatalogTable getTable(String tableName) {
        Option option = this.tables().get((Object)tableName);
        if (option instanceof Some) {
            ExternalCatalogTable t;
            Some some = (Some)option;
            ExternalCatalogTable externalCatalogTable = t = (ExternalCatalogTable)some.x();
            return externalCatalogTable;
        }
        throw new TableNotExistException(this.name, tableName);
    }

    @Override
    public synchronized List<String> listTables() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.tables().keys().toList()).asJava();
    }

    @Override
    public synchronized ExternalCatalog getSubCatalog(String catalogName) throws CatalogNotExistException {
        Option option = this.databases().get((Object)catalogName);
        if (option instanceof Some) {
            ExternalCatalog d;
            Some some = (Some)option;
            ExternalCatalog externalCatalog = d = (ExternalCatalog)some.x();
            return externalCatalog;
        }
        throw new CatalogNotExistException(catalogName);
    }

    @Override
    public synchronized List<String> listSubCatalogs() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.databases().keys().toList()).asJava();
    }

    public InMemoryExternalCatalog(String name) {
        this.name = name;
        this.databases = new HashMap();
        this.tables = new HashMap();
    }
}

