/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.QueryOperationCatalogViewTable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.plan.schema.TableSinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;

class DatabaseCalciteSchema
implements Schema {
    private final boolean isStreamingMode;
    private final String databaseName;
    private final String catalogName;
    private final Catalog catalog;

    public DatabaseCalciteSchema(boolean isStreamingMode, String databaseName, String catalogName, Catalog catalog) {
        this.isStreamingMode = isStreamingMode;
        this.databaseName = databaseName;
        this.catalogName = catalogName;
        this.catalog = catalog;
    }

    @Override
    public Table getTable(String tableName) {
        ObjectPath tablePath = new ObjectPath(this.databaseName, tableName);
        try {
            if (!this.catalog.tableExists(tablePath)) {
                return null;
            }
            CatalogBaseTable table = this.catalog.getTable(tablePath);
            if (table instanceof QueryOperationCatalogView) {
                return QueryOperationCatalogViewTable.createCalciteTable((QueryOperationCatalogView)table);
            }
            if (table instanceof ConnectorCatalogTable) {
                return this.convertConnectorTable((ConnectorCatalogTable)table);
            }
            if (table instanceof CatalogTable) {
                return this.convertCatalogTable(tablePath, (CatalogTable)table);
            }
            throw new TableException("Unsupported table type: " + table);
        }
        catch (CatalogException | TableNotExistException e) {
            throw new TableException(String.format("A failure occurred when accessing table. Table path [%s, %s, %s]", this.catalogName, this.databaseName, tableName), e);
        }
    }

    private Table convertConnectorTable(ConnectorCatalogTable<?, ?> table) {
        Optional<TableSourceTable> tableSourceTable = table.getTableSource().map(tableSource -> new TableSourceTable(tableSource, !table.isBatch(), FlinkStatistic.UNKNOWN()));
        if (tableSourceTable.isPresent()) {
            return tableSourceTable.get();
        }
        Optional<TableSinkTable> tableSinkTable = table.getTableSink().map(tableSink -> new TableSinkTable(tableSink, FlinkStatistic.UNKNOWN()));
        if (tableSinkTable.isPresent()) {
            return tableSinkTable.get();
        }
        throw new TableException("Cannot convert a connector table without either source or sink.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Table convertCatalogTable(ObjectPath tablePath, CatalogTable table) {
        TableSource tableSource;
        Optional<TableFactory> tableFactory = this.catalog.getTableFactory();
        if (tableFactory.isPresent()) {
            TableFactory tf = tableFactory.get();
            if (!(tf instanceof TableSourceFactory)) throw new TableException(String.format("Cannot query a sink-only table. TableFactory provided by catalog %s must implement TableSourceFactory", this.catalog.getClass()));
            tableSource = ((TableSourceFactory)tf).createTableSource(tablePath, table);
        } else {
            tableSource = TableFactoryUtil.findAndCreateTableSource(table);
        }
        if (tableSource instanceof StreamTableSource) return new TableSourceTable(tableSource, this.isStreamingMode, FlinkStatistic.UNKNOWN());
        throw new TableException("Catalog tables support only StreamTableSource and InputFormatTableSource");
    }

    @Override
    public Set<String> getTableNames() {
        try {
            return new HashSet<String>(this.catalog.listTables(this.databaseName));
        }
        catch (DatabaseNotExistException e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public RelProtoDataType getType(String name) {
        return null;
    }

    @Override
    public Set<String> getTypeNames() {
        return new HashSet<String>();
    }

    @Override
    public Collection<Function> getFunctions(String s) {
        return new HashSet<Function>();
    }

    @Override
    public Set<String> getFunctionNames() {
        return new HashSet<String>();
    }

    @Override
    public Schema getSubSchema(String s) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

