/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;

public class OverScope
extends ListScope {
    private final SqlCall overCall;

    OverScope(SqlValidatorScope parent, SqlCall overCall) {
        super(parent);
        this.overCall = overCall;
    }

    @Override
    public SqlNode getNode() {
        return this.overCall;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlNode expr) {
        SqlMonotonicity monotonicity = expr.getMonotonicity(this);
        if (monotonicity != SqlMonotonicity.NOT_MONOTONIC) {
            return monotonicity;
        }
        if (this.children.size() == 1) {
            SqlValidatorNamespace child = ((ScopeChild)this.children.get((int)0)).namespace;
            List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs = child.getMonotonicExprs();
            for (Pair<SqlNode, SqlMonotonicity> pair : monotonicExprs) {
                if (!expr.equalsDeep((SqlNode)pair.left, Litmus.IGNORE)) continue;
                return (SqlMonotonicity)((Object)pair.right);
            }
        }
        return super.getMonotonicity(expr);
    }
}

