/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalWindow;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public abstract class ReduceExpressionsRule
extends RelOptRule {
    public static final Pattern EXCLUSION_PATTERN = Pattern.compile("Reduce(Expressions|Values)Rule.*");
    public static final ReduceExpressionsRule FILTER_INSTANCE = new FilterReduceExpressionsRule(LogicalFilter.class, true, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule PROJECT_INSTANCE = new ProjectReduceExpressionsRule(LogicalProject.class, true, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule JOIN_INSTANCE = new JoinReduceExpressionsRule(Join.class, true, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule CALC_INSTANCE = new CalcReduceExpressionsRule(LogicalCalc.class, true, RelFactories.LOGICAL_BUILDER);
    public static final ReduceExpressionsRule WINDOW_INSTANCE = new WindowReduceExpressionsRule(LogicalWindow.class, true, RelFactories.LOGICAL_BUILDER);
    protected final boolean matchNullability;

    protected ReduceExpressionsRule(Class<? extends RelNode> clazz, boolean matchNullability, RelBuilderFactory relBuilderFactory, String description) {
        super(ReduceExpressionsRule.operand(clazz, ReduceExpressionsRule.any()), relBuilderFactory, description);
        this.matchNullability = matchNullability;
    }

    @Deprecated
    protected ReduceExpressionsRule(Class<? extends RelNode> clazz, RelBuilderFactory relBuilderFactory, String description) {
        this(clazz, true, relBuilderFactory, description);
    }

    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates) {
        return ReduceExpressionsRule.reduceExpressions(rel, expList, predicates, false, true);
    }

    @Deprecated
    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates, boolean unknownAsFalse) {
        return ReduceExpressionsRule.reduceExpressions(rel, expList, predicates, unknownAsFalse, true);
    }

    protected static boolean reduceExpressions(RelNode rel, List<RexNode> expList, RelOptPredicateList predicates, boolean unknownAsFalse, boolean matchNullability) {
        RelOptCluster cluster = rel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexExecutor executor = Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR);
        RexSimplify simplify = new RexSimplify(rexBuilder, predicates, executor);
        RexUnknownAs unknownAs = RexUnknownAs.falseIf(unknownAsFalse);
        boolean reduced = ReduceExpressionsRule.reduceExpressionsInternal(rel, simplify, unknownAs, expList, predicates);
        boolean simplified = false;
        for (int i = 0; i < expList.size(); ++i) {
            RexNode expr2 = simplify.simplifyPreservingType(expList.get(i), unknownAs, matchNullability);
            if (expr2.equals(expList.get(i))) continue;
            expList.set(i, expr2);
            simplified = true;
        }
        return reduced || simplified;
    }

    protected static boolean reduceExpressionsInternal(RelNode rel, RexSimplify simplify, RexUnknownAs unknownAs, List<RexNode> expList, RelOptPredicateList predicates) {
        RexExecutor executor;
        boolean changed = false;
        changed |= new CaseShuttle().mutate(expList);
        ArrayList<RexNode> constExps = new ArrayList<RexNode>();
        List<Boolean> addCasts = new ArrayList<Boolean>();
        ArrayList<RexNode> removableCasts = new ArrayList<RexNode>();
        ReduceExpressionsRule.findReducibleExps(rel.getCluster().getTypeFactory(), expList, predicates.constantMap, constExps, addCasts, removableCasts);
        if (constExps.isEmpty() && removableCasts.isEmpty()) {
            return changed;
        }
        if (!removableCasts.isEmpty()) {
            ArrayList<RexNode> reducedExprs = new ArrayList<RexNode>();
            for (RexNode exp : removableCasts) {
                RexCall call = (RexCall)exp;
                reducedExprs.add(call.getOperands().get(0));
            }
            RexReplacer replacer = new RexReplacer(simplify, unknownAs, removableCasts, reducedExprs, Collections.nCopies(removableCasts.size(), false));
            replacer.mutate(expList);
        }
        if (constExps.isEmpty()) {
            return true;
        }
        ArrayList<RexNode> constExps2 = Lists.newArrayList(constExps);
        if (!predicates.constantMap.isEmpty()) {
            ArrayList pairs = Lists.newArrayList(predicates.constantMap.entrySet());
            RexReplacer replacer = new RexReplacer(simplify, unknownAs, Pair.left(pairs), Pair.right(pairs), Collections.nCopies(pairs.size(), false));
            replacer.mutate(constExps2);
        }
        if ((executor = rel.getCluster().getPlanner().getExecutor()) == null) {
            return changed;
        }
        ArrayList<RexNode> reducedValues = new ArrayList<RexNode>();
        executor.reduce(simplify.rexBuilder, constExps2, reducedValues);
        if (RexUtil.strings(constExps).equals(RexUtil.strings(reducedValues))) {
            return changed;
        }
        if (rel instanceof Project) {
            addCasts = Collections.nCopies(reducedValues.size(), true);
        }
        new RexReplacer(simplify, unknownAs, constExps, reducedValues, addCasts).mutate(expList);
        return true;
    }

    protected static void findReducibleExps(RelDataTypeFactory typeFactory, List<RexNode> exps, ImmutableMap<RexNode, RexNode> constants, List<RexNode> constExps, List<Boolean> addCasts, List<RexNode> removableCasts) {
        ReducibleExprLocator gardener = new ReducibleExprLocator(typeFactory, constants, constExps, addCasts, removableCasts);
        for (RexNode exp : exps) {
            gardener.analyze(exp);
        }
        assert (constExps.size() == addCasts.size());
    }

    @Deprecated
    public static <C extends RexNode> ImmutableMap<RexNode, C> predicateConstants(Class<C> clazz, RexBuilder rexBuilder, RelOptPredicateList predicates) {
        return RexUtil.predicateConstants(clazz, rexBuilder, predicates.pulledUpPredicates);
    }

    public static RexCall pushPredicateIntoCase(RexCall call) {
        if (call.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return call;
        }
        switch (call.getKind()) {
            case CASE: 
            case AND: 
            case OR: {
                return call;
            }
            case EQUALS: {
                List<RexNode> equalsOperands = call.getOperands();
                ImmutableBitSet left = RelOptUtil.InputFinder.bits(equalsOperands.get(0));
                ImmutableBitSet right = RelOptUtil.InputFinder.bits(equalsOperands.get(1));
                if (left.isEmpty() || right.isEmpty() || !left.intersect(right).isEmpty()) break;
                return call;
            }
        }
        int caseOrdinal = -1;
        List<RexNode> operands = call.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = operands.get(i);
            switch (operand.getKind()) {
                case CASE: {
                    caseOrdinal = i;
                }
            }
        }
        if (caseOrdinal < 0) {
            return call;
        }
        RexCall case_ = (RexCall)operands.get(caseOrdinal);
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        for (int i = 0; i < case_.getOperands().size(); ++i) {
            RexNode node = case_.getOperands().get(i);
            if (!RexUtil.isCasePredicate(case_, i)) {
                node = ReduceExpressionsRule.substitute(call, caseOrdinal, node);
            }
            nodes.add(node);
        }
        return case_.clone(call.getType(), nodes);
    }

    protected static RexNode substitute(RexCall call, int ordinal, RexNode node) {
        ArrayList<RexNode> newOperands = Lists.newArrayList(call.getOperands());
        newOperands.set(ordinal, node);
        return call.clone(call.getType(), newOperands);
    }

    protected static class CaseShuttle
    extends RexShuttle {
        protected CaseShuttle() {
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexCall old;
            do {
                old = call = (RexCall)super.visitCall(call);
            } while ((call = ReduceExpressionsRule.pushPredicateIntoCase(call)) != old);
            return call;
        }
    }

    protected static class ReducibleExprLocator
    extends RexVisitorImpl<Void> {
        private final RelDataTypeFactory typeFactory;
        private final List<Constancy> stack = new ArrayList<Constancy>();
        private final ImmutableMap<RexNode, RexNode> constants;
        private final List<RexNode> constExprs;
        private final List<Boolean> addCasts;
        private final List<RexNode> removableCasts;
        private final Deque<SqlOperator> parentCallTypeStack = new ArrayDeque<SqlOperator>();

        ReducibleExprLocator(RelDataTypeFactory typeFactory, ImmutableMap<RexNode, RexNode> constants, List<RexNode> constExprs, List<Boolean> addCasts, List<RexNode> removableCasts) {
            super(true);
            this.typeFactory = typeFactory;
            this.constants = constants;
            this.constExprs = constExprs;
            this.addCasts = addCasts;
            this.removableCasts = removableCasts;
        }

        public void analyze(RexNode exp) {
            assert (this.stack.isEmpty());
            exp.accept(this);
            assert (this.stack.size() == 1);
            assert (this.parentCallTypeStack.isEmpty());
            Constancy rootConstancy = this.stack.get(0);
            if (rootConstancy == Constancy.REDUCIBLE_CONSTANT) {
                this.addResult(exp);
            }
            this.stack.clear();
        }

        private Void pushVariable() {
            this.stack.add(Constancy.NON_CONSTANT);
            return null;
        }

        private void addResult(RexNode exp) {
            RexCall cast;
            RexNode operand;
            if (exp.getKind() == SqlKind.CAST && (operand = (cast = (RexCall)exp).getOperands().get(0)) instanceof RexLiteral) {
                return;
            }
            this.constExprs.add(exp);
            if (this.parentCallTypeStack.isEmpty()) {
                this.addCasts.add(false);
            } else {
                this.addCasts.add(this.isUdf(this.parentCallTypeStack.peek()));
            }
        }

        private Boolean isUdf(SqlOperator operator) {
            return false;
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            RexNode constant = this.constants.get(inputRef);
            if (constant != null) {
                if (constant instanceof RexCall) {
                    constant.accept(this);
                } else {
                    this.stack.add(Constancy.REDUCIBLE_CONSTANT);
                }
                return null;
            }
            return this.pushVariable();
        }

        @Override
        public Void visitLiteral(RexLiteral literal) {
            this.stack.add(Constancy.IRREDUCIBLE_CONSTANT);
            return null;
        }

        @Override
        public Void visitOver(RexOver over2) {
            this.analyzeCall(over2, Constancy.NON_CONSTANT);
            return null;
        }

        @Override
        public Void visitCorrelVariable(RexCorrelVariable variable) {
            return this.pushVariable();
        }

        @Override
        public Void visitCall(RexCall call) {
            this.analyzeCall(call, Constancy.REDUCIBLE_CONSTANT);
            return null;
        }

        @Override
        public Void visitSubQuery(RexSubQuery subQuery) {
            this.analyzeCall(subQuery, Constancy.REDUCIBLE_CONSTANT);
            return null;
        }

        private void analyzeCall(RexCall call, Constancy callConstancy) {
            this.parentCallTypeStack.push(call.getOperator());
            super.visitCall(call);
            int operandCount = call.getOperands().size();
            List<Constancy> operandStack = Util.last(this.stack, operandCount);
            for (Constancy operandConstancy : operandStack) {
                if (operandConstancy != Constancy.NON_CONSTANT) continue;
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (!call.getOperator().isDeterministic()) {
                callConstancy = Constancy.NON_CONSTANT;
            } else if (call.getOperator().isDynamicFunction()) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.REDUCIBLE_CONSTANT && call.getOperator() instanceof SqlRowOperator) {
                callConstancy = Constancy.NON_CONSTANT;
            }
            if (callConstancy == Constancy.NON_CONSTANT) {
                for (int iOperand = 0; iOperand < operandCount; ++iOperand) {
                    Constancy constancy = operandStack.get(iOperand);
                    if (constancy != Constancy.REDUCIBLE_CONSTANT) continue;
                    this.addResult(call.getOperands().get(iOperand));
                }
                if (call.getOperator() == SqlStdOperatorTable.CAST) {
                    this.reduceCasts(call);
                }
            }
            operandStack.clear();
            this.parentCallTypeStack.pop();
            this.stack.add(callConstancy);
        }

        private void reduceCasts(RexCall outerCast) {
            RelDataType innerTypeNullable;
            List<RexNode> operands = outerCast.getOperands();
            if (operands.size() != 1) {
                return;
            }
            RelDataType outerCastType = outerCast.getType();
            RelDataType operandType = operands.get(0).getType();
            if (operandType.equals(outerCastType)) {
                this.removableCasts.add(outerCast);
                return;
            }
            if (!(operands.get(0) instanceof RexCall)) {
                return;
            }
            RexCall innerCast = (RexCall)operands.get(0);
            if (innerCast.getOperator() != SqlStdOperatorTable.CAST) {
                return;
            }
            if (innerCast.getOperands().size() != 1) {
                return;
            }
            RelDataType outerTypeNullable = this.typeFactory.createTypeWithNullability(outerCastType, true);
            if (outerTypeNullable != (innerTypeNullable = this.typeFactory.createTypeWithNullability(operandType, true))) {
                return;
            }
            if (operandType.isNullable()) {
                this.removableCasts.add(innerCast);
            }
        }

        @Override
        public Void visitDynamicParam(RexDynamicParam dynamicParam) {
            return this.pushVariable();
        }

        @Override
        public Void visitRangeRef(RexRangeRef rangeRef) {
            return this.pushVariable();
        }

        @Override
        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            return this.pushVariable();
        }

        static enum Constancy {
            NON_CONSTANT,
            REDUCIBLE_CONSTANT,
            IRREDUCIBLE_CONSTANT;

        }
    }

    protected static class RexReplacer
    extends RexShuttle {
        private final RexSimplify simplify;
        private final RexUnknownAs unknownAs;
        private final List<RexNode> reducibleExps;
        private final List<RexNode> reducedValues;
        private final List<Boolean> addCasts;

        RexReplacer(RexSimplify simplify, RexUnknownAs unknownAs, List<RexNode> reducibleExps, List<RexNode> reducedValues, List<Boolean> addCasts) {
            this.simplify = simplify;
            this.unknownAs = unknownAs;
            this.reducibleExps = reducibleExps;
            this.reducedValues = reducedValues;
            this.addCasts = addCasts;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RexNode node = this.visit(inputRef);
            if (node == null) {
                return super.visitInputRef(inputRef);
            }
            return node;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            RexNode node = this.visit(call);
            if (node != null) {
                return node;
            }
            node = super.visitCall(call);
            return node;
        }

        private RexNode visit(RexNode call) {
            int i = this.reducibleExps.indexOf(call);
            if (i == -1) {
                return null;
            }
            RexNode replacement = this.reducedValues.get(i);
            if (this.addCasts.get(i).booleanValue() && replacement.getType() != call.getType()) {
                replacement = this.simplify.rexBuilder.makeAbstractCast(call.getType(), replacement);
            }
            return replacement;
        }
    }

    public static class WindowReduceExpressionsRule
    extends ReduceExpressionsRule {
        public WindowReduceExpressionsRule(Class<? extends Window> windowClass, boolean matchNullability, RelBuilderFactory relBuilderFactory) {
            super(windowClass, matchNullability, relBuilderFactory, "ReduceExpressionsRule(Window)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalWindow window = (LogicalWindow)call.rel(0);
            RexBuilder rexBuilder = window.getCluster().getRexBuilder();
            RelMetadataQuery mq = RelMetadataQuery.instance();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(window.getInput());
            boolean reduced = false;
            ArrayList<Window.Group> groups = new ArrayList<Window.Group>();
            for (Window.Group group : window.groups) {
                ArrayList<Window.RexWinAggCall> aggCalls = new ArrayList<Window.RexWinAggCall>();
                for (Window.RexWinAggCall aggCall : group.aggCalls) {
                    ArrayList<RexNode> expList = new ArrayList<RexNode>(aggCall.getOperands());
                    if (WindowReduceExpressionsRule.reduceExpressions(window, expList, predicates)) {
                        aggCall = new Window.RexWinAggCall((SqlAggFunction)aggCall.getOperator(), aggCall.type, expList, aggCall.ordinal, aggCall.distinct, aggCall.ignoreNulls);
                        reduced = true;
                    }
                    aggCalls.add(aggCall);
                }
                ImmutableBitSet.Builder keyBuilder = ImmutableBitSet.builder();
                group.keys.asList().stream().filter(key -> !predicates.constantMap.containsKey(rexBuilder.makeInputRef(window.getInput(), (int)key))).collect(Collectors.toList()).forEach(i -> keyBuilder.set((int)i));
                ImmutableBitSet keys = keyBuilder.build();
                reduced |= keys.cardinality() != group.keys.cardinality();
                List<RelFieldCollation> collationsList = group.orderKeys.getFieldCollations().stream().filter(fc -> !predicates.constantMap.containsKey(rexBuilder.makeInputRef(window.getInput(), fc.getFieldIndex()))).collect(Collectors.toList());
                boolean collationReduced = group.orderKeys.getFieldCollations().size() != collationsList.size();
                reduced |= collationReduced;
                RelCollation relCollation = collationReduced ? RelCollations.of(collationsList) : group.orderKeys;
                groups.add(new Window.Group(keys, group.isRows, group.lowerBound, group.upperBound, relCollation, aggCalls));
            }
            if (reduced) {
                call.transformTo(LogicalWindow.create(window.getTraitSet(), window.getInput(), window.getConstants(), window.getRowType(), groups));
                call.getPlanner().setImportance(window, 0.0);
            }
        }
    }

    public static class CalcReduceExpressionsRule
    extends ReduceExpressionsRule {
        @Deprecated
        public CalcReduceExpressionsRule(Class<? extends Calc> calcClass, RelBuilderFactory relBuilderFactory) {
            this(calcClass, true, relBuilderFactory);
        }

        public CalcReduceExpressionsRule(Class<? extends Calc> calcClass, boolean matchNullability, RelBuilderFactory relBuilderFactory) {
            super(calcClass, matchNullability, relBuilderFactory, "ReduceExpressionsRule(Calc)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Calc calc = (Calc)call.rel(0);
            RexProgram program = calc.getProgram();
            List<RexNode> exprList = program.getExprList();
            final ArrayList<RexNode> expandedExprList = new ArrayList<RexNode>();
            RexShuttle shuttle = new RexShuttle(){

                @Override
                public RexNode visitLocalRef(RexLocalRef localRef) {
                    return (RexNode)expandedExprList.get(localRef.getIndex());
                }
            };
            for (RexNode expr : exprList) {
                expandedExprList.add(expr.accept(shuttle));
            }
            RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
            if (CalcReduceExpressionsRule.reduceExpressions(calc, expandedExprList, predicates, false, this.matchNullability)) {
                int conditionIndex;
                RexNode newConditionExp;
                RexProgramBuilder builder = new RexProgramBuilder(calc.getInput().getRowType(), calc.getCluster().getRexBuilder());
                ArrayList<RexLocalRef> list = new ArrayList<RexLocalRef>();
                for (RexNode expr : expandedExprList) {
                    list.add(builder.registerInput(expr));
                }
                if (program.getCondition() != null && !(newConditionExp = (RexNode)expandedExprList.get(conditionIndex = program.getCondition().getIndex())).isAlwaysTrue()) {
                    if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                        call.transformTo(this.createEmptyRelOrEquivalent(call, calc));
                        return;
                    }
                    builder.addCondition((RexNode)list.get(conditionIndex));
                }
                int k = 0;
                for (RexLocalRef projectExpr : program.getProjectList()) {
                    int index = projectExpr.getIndex();
                    builder.addProject(((RexLocalRef)list.get(index)).getIndex(), program.getOutputRowType().getFieldNames().get(k++));
                }
                call.transformTo(calc.copy(calc.getTraitSet(), calc.getInput(), builder.getProgram()));
                call.getPlanner().setImportance(calc, 0.0);
            }
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Calc input) {
            return call.builder().push(input).empty().build();
        }
    }

    public static class JoinReduceExpressionsRule
    extends ReduceExpressionsRule {
        @Deprecated
        public JoinReduceExpressionsRule(Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
            this(joinClass, true, relBuilderFactory);
        }

        public JoinReduceExpressionsRule(Class<? extends Join> joinClass, boolean matchNullability, RelBuilderFactory relBuilderFactory) {
            super(joinClass, matchNullability, relBuilderFactory, "ReduceExpressionsRule(Join)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            JoinInfo joinInfo;
            Join join = (Join)call.rel(0);
            ArrayList<RexNode> expList = Lists.newArrayList(join.getCondition());
            int fieldCount = join.getLeft().getRowType().getFieldCount();
            RelMetadataQuery mq = call.getMetadataQuery();
            RelOptPredicateList leftPredicates = mq.getPulledUpPredicates(join.getLeft());
            RelOptPredicateList rightPredicates = mq.getPulledUpPredicates(join.getRight());
            RexBuilder rexBuilder = join.getCluster().getRexBuilder();
            RelOptPredicateList predicates = leftPredicates.union(rexBuilder, rightPredicates.shift(rexBuilder, fieldCount));
            if (!JoinReduceExpressionsRule.reduceExpressions(join, expList, predicates, true, this.matchNullability)) {
                return;
            }
            if (RelOptUtil.forceEquiJoin(join) && !(joinInfo = JoinInfo.of(join.getLeft(), join.getRight(), (RexNode)expList.get(0))).isEqui()) {
                return;
            }
            call.transformTo(join.copy(join.getTraitSet(), (RexNode)expList.get(0), join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
            call.getPlanner().setImportance(join, 0.0);
        }
    }

    public static class ProjectReduceExpressionsRule
    extends ReduceExpressionsRule {
        @Deprecated
        public ProjectReduceExpressionsRule(Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
            this(projectClass, true, relBuilderFactory);
        }

        public ProjectReduceExpressionsRule(Class<? extends Project> projectClass, boolean matchNullability, RelBuilderFactory relBuilderFactory) {
            super(projectClass, matchNullability, relBuilderFactory, "ReduceExpressionsRule(Project)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RelMetadataQuery mq = call.getMetadataQuery();
            RelOptPredicateList predicates = mq.getPulledUpPredicates(project.getInput());
            ArrayList<RexNode> expList = Lists.newArrayList(project.getProjects());
            if (ProjectReduceExpressionsRule.reduceExpressions(project, expList, predicates, false, this.matchNullability)) {
                call.transformTo(call.builder().push(project.getInput()).project(expList, project.getRowType().getFieldNames()).build());
                call.getPlanner().setImportance(project, 0.0);
            }
        }
    }

    public static class FilterReduceExpressionsRule
    extends ReduceExpressionsRule {
        @Deprecated
        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory) {
            this(filterClass, true, relBuilderFactory);
        }

        public FilterReduceExpressionsRule(Class<? extends Filter> filterClass, boolean matchNullability, RelBuilderFactory relBuilderFactory) {
            super(filterClass, matchNullability, relBuilderFactory, "ReduceExpressionsRule(Filter)");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            boolean reduced;
            RexNode newConditionExp;
            RelMetadataQuery mq;
            RelOptPredicateList predicates;
            ArrayList<RexNode> expList;
            Filter filter = (Filter)call.rel(0);
            if (FilterReduceExpressionsRule.reduceExpressions(filter, expList = Lists.newArrayList(filter.getCondition()), predicates = (mq = call.getMetadataQuery()).getPulledUpPredicates(filter.getInput()), true, this.matchNullability)) {
                assert (expList.size() == 1);
                newConditionExp = (RexNode)expList.get(0);
                reduced = true;
            } else {
                newConditionExp = filter.getCondition();
                reduced = false;
            }
            if (newConditionExp.isAlwaysTrue()) {
                call.transformTo(filter.getInput());
            } else if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral(newConditionExp, true)) {
                call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
            } else if (reduced) {
                call.transformTo(call.builder().push(filter.getInput()).filter(newConditionExp).build());
            } else {
                if (newConditionExp instanceof RexCall) {
                    boolean reverse;
                    boolean bl = reverse = newConditionExp.getKind() == SqlKind.NOT;
                    if (reverse) {
                        newConditionExp = ((RexCall)newConditionExp).getOperands().get(0);
                    }
                    this.reduceNotNullableFilter(call, filter, newConditionExp, reverse);
                }
                return;
            }
            call.getPlanner().setImportance(filter, 0.0);
        }

        protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Filter input) {
            return call.builder().push(input).empty().build();
        }

        private void reduceNotNullableFilter(RelOptRuleCall call, Filter filter, RexNode rexNode, boolean reverse) {
            RexInputRef inputRef;
            RexNode operand;
            boolean alwaysTrue;
            switch (rexNode.getKind()) {
                case IS_NULL: 
                case IS_UNKNOWN: {
                    alwaysTrue = false;
                    break;
                }
                case IS_NOT_NULL: {
                    alwaysTrue = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (reverse) {
                boolean bl = alwaysTrue = !alwaysTrue;
            }
            if ((operand = ((RexCall)rexNode).getOperands().get(0)) instanceof RexInputRef && !(inputRef = (RexInputRef)operand).getType().isNullable()) {
                if (alwaysTrue) {
                    call.transformTo(filter.getInput());
                } else {
                    call.transformTo(this.createEmptyRelOrEquivalent(call, filter));
                }
            }
        }
    }
}

