/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.typeutils.DecimalSerializer;

public class DecimalTypeInfo
extends TypeInformation<Decimal> {
    private final int precision;
    private final int scale;

    public static DecimalTypeInfo of(int precision, int scale) {
        return new DecimalTypeInfo(precision, scale);
    }

    public DecimalTypeInfo(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public boolean isBasicType() {
        return true;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<Decimal> getTypeClass() {
        return Decimal.class;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<Decimal> createSerializer(ExecutionConfig config) {
        return new DecimalSerializer(this.precision, this.scale);
    }

    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision, this.scale);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalTypeInfo)) {
            return false;
        }
        DecimalTypeInfo that = (DecimalTypeInfo)((Object)obj);
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        int h0 = ((Object)((Object)this)).getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision, this.scale});
    }

    public boolean canEqual(Object obj) {
        return obj instanceof DecimalTypeInfo;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

