/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.InstantiationUtil;

public class BaseArraySerializer
extends TypeSerializer<BaseArray> {
    private final LogicalType eleType;
    private final TypeSerializer eleSer;
    private transient BinaryArray reuseArray;
    private transient BinaryArrayWriter reuseWriter;

    public BaseArraySerializer(LogicalType eleType, ExecutionConfig conf) {
        this.eleType = eleType;
        this.eleSer = InternalSerializers.create(eleType, conf);
    }

    private BaseArraySerializer(LogicalType eleType, TypeSerializer eleSer) {
        this.eleType = eleType;
        this.eleSer = eleSer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<BaseArray> duplicate() {
        return new BaseArraySerializer(this.eleType, this.eleSer.duplicate());
    }

    public BaseArray createInstance() {
        return new BinaryArray();
    }

    public BaseArray copy(BaseArray from) {
        return from instanceof GenericArray ? this.copyGenericArray((GenericArray)from) : ((BinaryArray)from).copy();
    }

    public BaseArray copy(BaseArray from, BaseArray reuse) {
        return this.copy(from);
    }

    private GenericArray copyGenericArray(GenericArray array) {
        Object[] arr;
        block11: {
            block10: {
                if (!array.isPrimitiveArray()) break block10;
                switch (this.eleType.getTypeRoot()) {
                    case BOOLEAN: {
                        arr = Arrays.copyOf((boolean[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case TINYINT: {
                        arr = Arrays.copyOf((byte[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case SMALLINT: {
                        arr = Arrays.copyOf((short[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case INTEGER: {
                        arr = Arrays.copyOf((int[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case BIGINT: {
                        arr = Arrays.copyOf((long[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case FLOAT: {
                        arr = Arrays.copyOf((float[])array.getArray(), array.numElements());
                        break block11;
                    }
                    case DOUBLE: {
                        arr = Arrays.copyOf((double[])array.getArray(), array.numElements());
                        break block11;
                    }
                    default: {
                        throw new RuntimeException("Unknown type: " + this.eleType);
                    }
                }
            }
            Object[] objectArray = (Object[])array.getArray();
            Object[] newArray = (Object[])Array.newInstance(ClassLogicalTypeConverter.getInternalClassForType(this.eleType), array.numElements());
            for (int i = 0; i < array.numElements(); ++i) {
                newArray[i] = this.eleSer.copy(objectArray[i]);
            }
            arr = newArray;
        }
        return new GenericArray(arr, array.numElements(), array.isPrimitiveArray());
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BaseArray record, DataOutputView target) throws IOException {
        BinaryArray binaryArray = this.toBinaryArray(record);
        target.writeInt(binaryArray.getSizeInBytes());
        SegmentsUtil.copyToView(binaryArray.getSegments(), binaryArray.getOffset(), binaryArray.getSizeInBytes(), target);
    }

    public BinaryArray toBinaryArray(BaseArray from) {
        if (from instanceof BinaryArray) {
            return (BinaryArray)from;
        }
        int numElements = from.numElements();
        if (this.reuseArray == null) {
            this.reuseArray = new BinaryArray();
        }
        if (this.reuseWriter == null || this.reuseWriter.getNumElements() != numElements) {
            this.reuseWriter = new BinaryArrayWriter(this.reuseArray, numElements, BinaryArray.calculateFixLengthPartSize(this.eleType));
        } else {
            this.reuseWriter.reset();
        }
        for (int i = 0; i < numElements; ++i) {
            if (from.isNullAt(i)) {
                this.reuseWriter.setNullAt(i, this.eleType);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, TypeGetterSetters.get(from, i, this.eleType), this.eleType, this.eleSer);
        }
        this.reuseWriter.complete();
        return this.reuseArray;
    }

    public BaseArray deserialize(DataInputView source) throws IOException {
        return this.deserializeReuse(new BinaryArray(), source);
    }

    public BaseArray deserialize(BaseArray reuse, DataInputView source) throws IOException {
        return this.deserializeReuse(reuse instanceof GenericArray ? new BinaryArray() : (BinaryArray)reuse, source);
    }

    private BinaryArray deserializeReuse(BinaryArray reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, bytes.length);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BaseArraySerializer that = (BaseArraySerializer)((Object)o);
        return this.eleType.equals(that.eleType);
    }

    public int hashCode() {
        return this.eleType.hashCode();
    }

    @VisibleForTesting
    public TypeSerializer getEleSer() {
        return this.eleSer;
    }

    public TypeSerializerSnapshot<BaseArray> snapshotConfiguration() {
        return new BaseArraySerializerSnapshot(this.eleType, this.eleSer);
    }

    public static final class BaseArraySerializerSnapshot
    implements TypeSerializerSnapshot<BaseArray> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType previousType;
        private TypeSerializer previousEleSer;

        public BaseArraySerializerSnapshot() {
        }

        BaseArraySerializerSnapshot(LogicalType eleType, TypeSerializer eleSer) {
            this.previousType = eleType;
            this.previousEleSer = eleSer;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousType);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousEleSer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.previousType = (LogicalType)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousEleSer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<BaseArray> restoreSerializer() {
            return new BaseArraySerializer(this.previousType, this.previousEleSer);
        }

        public TypeSerializerSchemaCompatibility<BaseArray> resolveSchemaCompatibility(TypeSerializer<BaseArray> newSerializer) {
            if (!(newSerializer instanceof BaseArraySerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BaseArraySerializer newBaseArraySerializer = (BaseArraySerializer)newSerializer;
            if (!this.previousType.equals(newBaseArraySerializer.eleType) || !this.previousEleSer.equals((Object)newBaseArraySerializer.eleSer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

