/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.table.dataformat.BaseRow;

public class WatermarkAssignerOperator
extends AbstractStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow>,
ProcessingTimeCallback {
    private static final long serialVersionUID = 1L;
    private final int rowtimeFieldIndex;
    private final long watermarkDelay;
    private final long idleTimeout;
    private transient long watermarkInterval;
    private transient long currentWatermark;
    private transient long currentMaxTimestamp;
    private transient long lastRecordTime;
    private transient StreamStatusMaintainer streamStatusMaintainer;

    public WatermarkAssignerOperator(int rowtimeFieldIndex, long watermarkDelay, long idleTimeout) {
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.watermarkDelay = watermarkDelay;
        this.idleTimeout = idleTimeout;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.currentWatermark = 0L;
        this.currentMaxTimestamp = 0L;
        this.watermarkInterval = this.getExecutionConfig().getAutoWatermarkInterval();
        this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
        this.streamStatusMaintainer = this.getContainingTask().getStreamStatusMaintainer();
        if (this.watermarkInterval > 0L) {
            long now = this.getProcessingTimeService().getCurrentProcessingTime();
            this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, (ProcessingTimeCallback)this);
        }
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow row;
        if (this.idleTimeout > 0L) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            this.lastRecordTime = this.getProcessingTimeService().getCurrentProcessingTime();
        }
        if ((row = (BaseRow)element.getValue()).isNullAt(this.rowtimeFieldIndex)) {
            throw new RuntimeException("RowTime field should not be null, please convert it to a non-null long value.");
        }
        long ts = row.getLong(this.rowtimeFieldIndex);
        this.currentMaxTimestamp = Math.max(this.currentMaxTimestamp, ts);
        this.output.collect(element);
        if (this.currentMaxTimestamp - (this.currentWatermark + this.watermarkDelay) > this.watermarkInterval) {
            this.advanceWatermark();
        }
    }

    private void advanceWatermark() {
        long newWatermark = this.currentMaxTimestamp - this.watermarkDelay;
        if (newWatermark > this.currentWatermark) {
            this.currentWatermark = newWatermark;
            this.output.emitWatermark(new Watermark(newWatermark));
        }
    }

    public void onProcessingTime(long timestamp) throws Exception {
        long currentTime;
        this.advanceWatermark();
        if (this.idleTimeout > 0L && (currentTime = this.getProcessingTimeService().getCurrentProcessingTime()) - this.lastRecordTime > this.idleTimeout) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
        }
        long now = this.getProcessingTimeService().getCurrentProcessingTime();
        this.getProcessingTimeService().registerTimer(now + this.watermarkInterval, (ProcessingTimeCallback)this);
    }

    public void processWatermark(Watermark mark) throws Exception {
        if (mark.getTimestamp() == Long.MAX_VALUE && this.currentWatermark != Long.MAX_VALUE) {
            if (this.idleTimeout > 0L) {
                this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
            }
            this.currentWatermark = Long.MAX_VALUE;
            this.output.emitWatermark(mark);
        }
    }

    public void endInput() throws Exception {
        this.processWatermark(Watermark.MAX_WATERMARK);
    }

    public void close() throws Exception {
        this.endInput();
        super.close();
        this.advanceWatermark();
    }
}

