/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.context.ExecutionContextImpl;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.over.frame.OverWindowFrame;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;

public class BufferDataOverWindowOperator
extends TableStreamOperator<BaseRow>
implements OneInputStreamOperator<BaseRow, BaseRow>,
BoundedOneInput {
    private final long memorySize;
    private final OverWindowFrame[] overWindowFrames;
    private GeneratedRecordComparator genComparator;
    private final boolean isRowAllInFixedPart;
    private RecordComparator partitionComparator;
    private BaseRow lastInput;
    private JoinedRow[] joinedRows;
    private StreamRecordCollector<BaseRow> collector;
    private AbstractRowSerializer<BaseRow> serializer;
    private ResettableExternalBuffer currentData;

    public BufferDataOverWindowOperator(long memorySize, OverWindowFrame[] overWindowFrames, GeneratedRecordComparator genComparator, boolean isRowAllInFixedPart) {
        this.memorySize = memorySize;
        this.overWindowFrames = overWindowFrames;
        this.genComparator = genComparator;
        this.isRowAllInFixedPart = isRowAllInFixedPart;
    }

    public void open() throws Exception {
        super.open();
        ClassLoader cl = this.getUserCodeClassloader();
        this.serializer = (AbstractRowSerializer)this.getOperatorConfig().getTypeSerializerIn1(cl);
        this.partitionComparator = (RecordComparator)this.genComparator.newInstance(cl);
        this.genComparator = null;
        MemoryManager memManager = this.getContainingTask().getEnvironment().getMemoryManager();
        this.currentData = new ResettableExternalBuffer(this.getContainingTask().getEnvironment().getMemoryManager(), this.getContainingTask().getEnvironment().getIOManager(), memManager.allocatePages((Object)this, (int)(this.memorySize / (long)memManager.getPageSize())), this.serializer, this.isRowAllInFixedPart);
        this.collector = new StreamRecordCollector(this.output);
        this.joinedRows = new JoinedRow[this.overWindowFrames.length];
        for (int i = 0; i < this.overWindowFrames.length; ++i) {
            this.overWindowFrames[i].open(new ExecutionContextImpl(this, (RuntimeContext)this.getRuntimeContext()));
            this.joinedRows[i] = new JoinedRow();
        }
    }

    public void processElement(StreamRecord<BaseRow> element) throws Exception {
        BaseRow input = (BaseRow)element.getValue();
        if (this.lastInput != null && this.partitionComparator.compare(this.lastInput, input) != 0) {
            this.processCurrentData();
        }
        this.lastInput = (BaseRow)this.serializer.copy(input);
        this.currentData.add(this.lastInput);
    }

    public void endInput() throws Exception {
        if (this.currentData.size() > 0) {
            this.processCurrentData();
        }
    }

    private void processCurrentData() throws Exception {
        this.currentData.complete();
        for (OverWindowFrame frame : this.overWindowFrames) {
            frame.prepare(this.currentData);
        }
        int rowIndex = 0;
        ResettableExternalBuffer.BufferIterator bufferIterator = this.currentData.newIterator();
        while (bufferIterator.advanceNext()) {
            BinaryRow currentRow2;
            BaseRow output = currentRow2 = bufferIterator.getRow();
            for (int i = 0; i < this.overWindowFrames.length; ++i) {
                OverWindowFrame frame = this.overWindowFrames[i];
                BaseRow value = frame.process(rowIndex, currentRow2);
                output = this.joinedRows[i].replace(output, value);
            }
            this.collector.collect(output);
            ++rowIndex;
        }
        bufferIterator.close();
        this.currentData.reset();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.currentData.close();
    }
}

