/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.compression;

import java.nio.ByteBuffer;
import org.apache.flink.table.runtime.compression.BlockDecompressor;
import org.apache.flink.table.runtime.compression.DataCorruptionException;
import org.apache.flink.table.runtime.compression.InsufficientBufferException;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4Exception;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4Factory;
import org.apache.flink.table.shaded.net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.flink.table.shaded.net.jpountz.util.SafeUtils;

public class Lz4BlockDecompressor
implements BlockDecompressor {
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws DataCorruptionException {
        int prevSrcOff = src.position() + srcOff;
        int prevDstOff = dst.position() + dstOff;
        int compressedLen = src.getInt(prevSrcOff);
        int originalLen = src.getInt(prevSrcOff + 4);
        this.validateLength(compressedLen, originalLen);
        if (dst.capacity() - prevDstOff < originalLen) {
            throw new InsufficientBufferException("Buffer length too small");
        }
        if (src.limit() - prevSrcOff - 8 < compressedLen) {
            throw new DataCorruptionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, prevSrcOff + 8, dst, prevDstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new DataCorruptionException("Input is corrupted, unexpected compressed length.");
            }
            src.position(prevSrcOff + compressedLen + 8);
            dst.position(prevDstOff + originalLen);
        }
        catch (LZ4Exception e) {
            throw new DataCorruptionException("Input is corrupted", e);
        }
        return originalLen;
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException, DataCorruptionException {
        int compressedLen = SafeUtils.readIntLE(src, srcOff);
        int originalLen = SafeUtils.readIntLE(src, srcOff + 4);
        this.validateLength(compressedLen, originalLen);
        if (dst.length - dstOff < originalLen) {
            throw new InsufficientBufferException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new DataCorruptionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, srcOff + 8, dst, dstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new DataCorruptionException("Input is corrupted");
            }
        }
        catch (LZ4Exception e) {
            throw new DataCorruptionException("Input is corrupted", e);
        }
        return originalLen;
    }

    private void validateLength(int compressedLen, int originalLen) throws DataCorruptionException {
        if (originalLen < 0 || compressedLen < 0 || originalLen == 0 && compressedLen != 0 || originalLen != 0 && compressedLen == 0) {
            throw new DataCorruptionException("Input is corrupted, invalid length.");
        }
    }
}

