/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.flink.table.planner.plan.schema.FlinkRelOptTable;
import org.apache.flink.table.planner.plan.schema.FlinkTable;

public class FlinkCalciteCatalogReader
extends CalciteCatalogReader {
    public FlinkCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> defaultSchemas, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        super(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), Stream.concat(defaultSchemas.stream(), Stream.of(Collections.emptyList())).collect(Collectors.toList()), typeFactory, config);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        SqlValidatorTable originRelOptTable = super.getTable((List)names);
        if (originRelOptTable == null) {
            return null;
        }
        FlinkTable table = originRelOptTable.unwrap(FlinkTable.class);
        if (table != null) {
            return FlinkRelOptTable.create(originRelOptTable.getRelOptSchema(), originRelOptTable.getRowType(), originRelOptTable.getQualifiedName(), table);
        }
        return originRelOptTable;
    }
}

