/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.BinaryStringUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;

public final class ListAggWsWithRetractAggFunction
extends AggregateFunction<BinaryString, ListAggWsWithRetractAccumulator> {
    private static final long serialVersionUID = -8627988150350160473L;

    @Override
    public ListAggWsWithRetractAccumulator createAccumulator() {
        return new ListAggWsWithRetractAccumulator();
    }

    public void accumulate(ListAggWsWithRetractAccumulator acc, BinaryString value, BinaryString lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            acc.list.add(value);
        }
    }

    public void retract(ListAggWsWithRetractAccumulator acc, BinaryString value, BinaryString lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            if (!acc.list.remove(value)) {
                acc.retractList.add(value);
            }
        }
    }

    public void merge(ListAggWsWithRetractAccumulator acc, Iterable<ListAggWsWithRetractAccumulator> its) throws Exception {
        for (ListAggWsWithRetractAccumulator otherAcc : its) {
            if (!otherAcc.list.get().iterator().hasNext() && !otherAcc.retractList.get().iterator().hasNext()) continue;
            acc.delimiter = otherAcc.delimiter;
            ArrayList<BinaryString> buffer = new ArrayList<BinaryString>();
            for (BinaryString binaryString : acc.list.get()) {
                buffer.add(binaryString);
            }
            for (BinaryString binaryString : otherAcc.list.get()) {
                buffer.add(binaryString);
            }
            ArrayList<BinaryString> retractBuffer = new ArrayList<BinaryString>();
            for (BinaryString binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            for (BinaryString binaryString : otherAcc.retractList.get()) {
                retractBuffer.add(binaryString);
            }
            ArrayList<BinaryString> arrayList = new ArrayList<BinaryString>();
            for (BinaryString binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                arrayList.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(arrayList);
        }
    }

    @Override
    public BinaryString getValue(ListAggWsWithRetractAccumulator acc) {
        try {
            Iterable<BinaryString> accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringUtil.concatWs(acc.delimiter, accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWsWithRetractAccumulator acc) {
        acc.delimiter = BinaryString.fromString(",");
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWsWithRetractAccumulator {
        public ListView<BinaryString> list = new ListView(BinaryStringTypeInfo.INSTANCE);
        public ListView<BinaryString> retractList = new ListView(BinaryStringTypeInfo.INSTANCE);
        public BinaryString delimiter = BinaryString.fromString(",");

        @VisibleForTesting
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWsWithRetractAccumulator that = (ListAggWsWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList) && Objects.equals(this.delimiter, that.delimiter);
        }
    }
}

