/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.util.StringUtils;

@Internal
public abstract class ExecutorBase
implements Executor {
    private static final String DEFAULT_JOB_NAME = "Flink Exec Table Job";
    private final StreamExecutionEnvironment executionEnvironment;
    protected List<Transformation<?>> transformations = new ArrayList();
    protected TableConfig tableConfig;

    public ExecutorBase(StreamExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public void setTableConfig(TableConfig tableConfig) {
        this.tableConfig = tableConfig;
    }

    @Override
    public void apply(List<Transformation<?>> transformations) {
        this.transformations.addAll(transformations);
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public StreamGraph generateStreamGraph(String jobName) {
        return this.generateStreamGraph(this.transformations, jobName);
    }

    public abstract StreamGraph generateStreamGraph(List<Transformation<?>> var1, String var2);

    protected String getNonEmptyJobName(String jobName) {
        if (StringUtils.isNullOrWhitespaceOnly((String)jobName)) {
            return DEFAULT_JOB_NAME;
        }
        return jobName;
    }
}

