/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedAggregateFunction;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class UserFunctionsTypeHelper {
    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserFunctionsTypeHelper.getReturnTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<T> getReturnTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<T> scalaType) {
        TypeInformation<T> userProvidedType = aggregateFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)0);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction) {
        return UserFunctionsTypeHelper.getAccumulatorTypeOfAggregateFunction(aggregateFunction, null);
    }

    public static <T, ACC> TypeInformation<ACC> getAccumulatorTypeOfAggregateFunction(UserDefinedAggregateFunction<T, ACC> aggregateFunction, TypeInformation<ACC> scalaType) {
        TypeInformation<ACC> userProvidedType = aggregateFunction.getAccumulatorType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(aggregateFunction, UserDefinedAggregateFunction.class, aggregateFunction.getClass(), (int)1);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction) {
        return UserFunctionsTypeHelper.getReturnTypeOfTableFunction(tableFunction, null);
    }

    public static <T> TypeInformation<T> getReturnTypeOfTableFunction(TableFunction<T> tableFunction, TypeInformation<T> scalaType) {
        TypeInformation<T> userProvidedType = tableFunction.getResultType();
        if (userProvidedType != null) {
            return userProvidedType;
        }
        if (scalaType != null) {
            return scalaType;
        }
        return TypeExtractor.createTypeInfo(tableFunction, TableFunction.class, tableFunction.getClass(), (int)0);
    }

    public static void validateInstantiation(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            throw new ValidationException(String.format("Function class %s is not public.", clazz.getCanonicalName()));
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            throw new ValidationException(String.format("Function class %s is no proper class, it is either abstract, an interface, or a primitive type.", clazz.getCanonicalName()));
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            throw new ValidationException(String.format("The class %s is an inner class, but not statically accessible.", clazz.getCanonicalName()));
        }
    }

    public static void validateNotSingleton(Class<?> clazz) {
        if (Arrays.stream(clazz.getFields()).anyMatch(f -> f.getName().equals("MODULE$"))) {
            throw new ValidationException(String.format("TableFunction implemented by class %s is a Scala object. This is forbidden because of concurrency problems when using them.", clazz.getCanonicalName()));
        }
    }

    private UserFunctionsTypeHelper() {
    }
}

