/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class UnresolvedCallExpression
implements Expression {
    @Nullable
    private final ObjectIdentifier objectIdentifier;
    private final FunctionDefinition functionDefinition;
    private final List<Expression> args;

    public UnresolvedCallExpression(ObjectIdentifier objectIdentifier, FunctionDefinition functionDefinition, List<Expression> args) {
        this.objectIdentifier = (ObjectIdentifier)Preconditions.checkNotNull((Object)objectIdentifier, (String)"Object identifier must not be null.");
        this.functionDefinition = (FunctionDefinition)Preconditions.checkNotNull((Object)functionDefinition, (String)"Function definition must not be null.");
        this.args = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(args, (String)"Arguments must not be null.")));
    }

    public UnresolvedCallExpression(FunctionDefinition functionDefinition, List<Expression> args) {
        this.objectIdentifier = null;
        this.functionDefinition = (FunctionDefinition)Preconditions.checkNotNull((Object)functionDefinition, (String)"Function definition must not be null.");
        this.args = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(args, (String)"Arguments must not be null.")));
    }

    public Optional<ObjectIdentifier> getObjectIdentifier() {
        return Optional.ofNullable(this.objectIdentifier);
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public UnresolvedCallExpression replaceArgs(List<Expression> args) {
        if (this.objectIdentifier == null) {
            return new UnresolvedCallExpression(this.functionDefinition, args);
        }
        return new UnresolvedCallExpression(this.objectIdentifier, this.functionDefinition, args);
    }

    public CallExpression resolve(List<ResolvedExpression> args, DataType dataType2) {
        if (this.objectIdentifier == null) {
            return new CallExpression(this.functionDefinition, args, dataType2);
        }
        return new CallExpression(this.objectIdentifier, this.functionDefinition, args, dataType2);
    }

    @Override
    public String asSummaryString() {
        String functionName = this.objectIdentifier == null ? this.functionDefinition.toString() : this.objectIdentifier.asSerializableString();
        String argList = this.args.stream().map(Expression::asSummaryString).collect(Collectors.joining(", ", "(", ")"));
        return functionName + argList;
    }

    @Override
    public List<Expression> getChildren() {
        return this.args;
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnresolvedCallExpression that = (UnresolvedCallExpression)o;
        return Objects.equals(this.objectIdentifier, that.objectIdentifier) && this.functionDefinition.equals(that.functionDefinition) && this.args.equals(that.args);
    }

    public int hashCode() {
        return Objects.hash(this.objectIdentifier, this.functionDefinition, this.args);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

