/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorValidator;
import org.apache.flink.table.descriptors.RowtimeValidator;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.sources.wmstrategies.WatermarkStrategy;

@PublicEvolving
public class SchemaValidator
implements DescriptorValidator {
    private final boolean isStreamEnvironment;
    private final boolean supportsSourceTimestamps;
    private final boolean supportsSourceWatermarks;

    public SchemaValidator(boolean isStreamEnvironment, boolean supportsSourceTimestamps, boolean supportsSourceWatermarks) {
        this.isStreamEnvironment = isStreamEnvironment;
        this.supportsSourceTimestamps = supportsSourceTimestamps;
        this.supportsSourceWatermarks = supportsSourceWatermarks;
    }

    @Override
    public void validate(DescriptorProperties properties) {
        Map<String, String> names = properties.getIndexedProperty("schema", "name");
        Map<String, String> types = properties.getIndexedProperty("schema", "type");
        if (names.isEmpty() && types.isEmpty()) {
            throw new ValidationException(String.format("Could not find the required schema in property '%s'.", "schema"));
        }
        boolean proctimeFound = false;
        for (int i = 0; i < Math.max(names.size(), types.size()); ++i) {
            properties.validateString("schema." + i + "." + "name", false, 1);
            properties.validateType("schema." + i + "." + "type", false, false);
            properties.validateString("schema." + i + "." + "from", true, 1);
            String proctime2 = "schema." + i + "." + "proctime";
            String rowtime2 = "schema." + i + "." + "rowtime";
            if (properties.containsKey(proctime2)) {
                if (!this.isStreamEnvironment) {
                    throw new ValidationException(String.format("Property '%s' is not allowed in a batch environment.", proctime2));
                }
                if (proctimeFound) {
                    throw new ValidationException("A proctime attribute must only be defined once.");
                }
                properties.validateBoolean(proctime2, false);
                proctimeFound = properties.getBoolean(proctime2);
                properties.validatePrefixExclusion(rowtime2);
                continue;
            }
            if (!properties.hasPrefix(rowtime2)) continue;
            RowtimeValidator rowtimeValidator = new RowtimeValidator(this.supportsSourceTimestamps, this.supportsSourceWatermarks, "schema." + i + ".");
            rowtimeValidator.validate(properties);
            properties.validateExclusion(proctime2);
        }
    }

    public static List<String> getSchemaDerivationKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("schema.#.type");
        keys.add("schema.#.name");
        keys.add("schema.#.from");
        keys.add("schema.#.proctime");
        keys.add("schema.#.rowtime.timestamps.type");
        keys.add("schema.#.rowtime.timestamps.from");
        keys.add("schema.#.rowtime.timestamps.class");
        keys.add("schema.#.rowtime.timestamps.serialized");
        keys.add("schema.#.rowtime.watermarks.type");
        keys.add("schema.#.rowtime.watermarks.class");
        keys.add("schema.#.rowtime.watermarks.serialized");
        keys.add("schema.#.rowtime.watermarks.delay");
        return keys;
    }

    public static Optional<String> deriveProctimeAttribute(DescriptorProperties properties) {
        Map<String, String> names = properties.getIndexedProperty("schema", "name");
        for (int i = 0; i < names.size(); ++i) {
            Optional<Boolean> isProctime = properties.getOptionalBoolean("schema." + i + "." + "proctime");
            if (!isProctime.isPresent() || !isProctime.get().booleanValue()) continue;
            return Optional.of(names.get("schema." + i + "." + "name"));
        }
        return Optional.empty();
    }

    public static List<RowtimeAttributeDescriptor> deriveRowtimeAttributes(DescriptorProperties properties) {
        Map<String, String> names = properties.getIndexedProperty("schema", "name");
        ArrayList<RowtimeAttributeDescriptor> attributes = new ArrayList<RowtimeAttributeDescriptor>();
        int i = 0;
        while (i < names.size()) {
            Optional<Tuple2<TimestampExtractor, WatermarkStrategy>> rowtimeComponents = RowtimeValidator.getRowtimeComponents(properties, "schema." + i + ".");
            int index = i++;
            rowtimeComponents.ifPresent(tuple2 -> attributes.add(new RowtimeAttributeDescriptor(properties.getString("schema." + index + "." + "name"), (TimestampExtractor)tuple2.f0, (WatermarkStrategy)tuple2.f1)));
        }
        return attributes;
    }

    @Deprecated
    public static TableSchema deriveTableSinkSchema(DescriptorProperties properties) {
        TableSchema.Builder builder = TableSchema.builder();
        TableSchema schema = properties.getTableSchema("schema");
        block6: for (int i = 0; i < schema.getFieldCount(); ++i) {
            TypeInformation<?> t = schema.getFieldTypes()[i];
            String n = schema.getFieldNames()[i];
            boolean isProctime = properties.getOptionalBoolean("schema." + i + "." + "proctime").orElse(false);
            String tsType = "schema." + i + "." + "rowtime.timestamps.type";
            boolean isRowtime = properties.containsKey(tsType);
            if (!isProctime && !isRowtime) {
                String fieldName = properties.getOptionalString("schema." + i + "." + "from").orElse(n);
                builder.field(fieldName, t);
                continue;
            }
            if (!isRowtime) continue;
            switch (properties.getString(tsType)) {
                case "from-field": {
                    String field = properties.getString("schema." + i + "." + "rowtime.timestamps.from");
                    builder.field(field, t);
                    continue block6;
                }
                default: {
                    throw new TableException(String.format("Unsupported rowtime type '%s' for sink table schema. Currently only '%s' is supported for table sinks.", t, "from-field"));
                }
            }
        }
        return builder.build();
    }

    public static Map<String, String> deriveFieldMapping(DescriptorProperties properties, Optional<TypeInformation<?>> inputType) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        TableSchema schema = properties.getTableSchema("schema");
        ArrayList columnNames = new ArrayList();
        inputType.ifPresent(t -> columnNames.addAll(Arrays.asList(((CompositeType)t).getFieldNames())));
        columnNames.forEach(name -> mapping.put((String)name, (String)name));
        Arrays.stream(schema.getFieldNames()).forEach(name -> mapping.put((String)name, (String)name));
        Map<String, String> names = properties.getIndexedProperty("schema", "name");
        for (int i = 0; i < names.size(); ++i) {
            String name2 = properties.getString("schema." + i + "." + "name");
            Optional<String> source = properties.getOptionalString("schema." + i + "." + "from");
            if (source.isPresent()) {
                mapping.put(name2, source.get());
                continue;
            }
            boolean isProctime = properties.getOptionalBoolean("schema." + i + "." + "proctime").orElse(false);
            boolean isRowtime = properties.containsKey("schema." + i + "." + "rowtime.timestamps.type");
            if (isProctime || isRowtime) {
                mapping.remove(name2);
                continue;
            }
            if (columnNames.contains(name2)) continue;
            throw new ValidationException(String.format("Could not map the schema field '%s' to a field from source. Please specify the source field from which it can be derived.", name2));
        }
        return mapping;
    }
}

