/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public interface TypeGetterSetters {
    public boolean isNullAt(int var1);

    public void setNullAt(int var1);

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public BinaryString getString(int var1);

    public Decimal getDecimal(int var1, int var2, int var3);

    public <T> BinaryGeneric<T> getGeneric(int var1);

    public byte[] getBinary(int var1);

    public BaseArray getArray(int var1);

    public BaseMap getMap(int var1);

    public BaseRow getRow(int var1, int var2);

    public void setBoolean(int var1, boolean var2);

    public void setByte(int var1, byte var2);

    public void setShort(int var1, short var2);

    public void setInt(int var1, int var2);

    public void setLong(int var1, long var2);

    public void setFloat(int var1, float var2);

    public void setDouble(int var1, double var2);

    public void setDecimal(int var1, Decimal var2, int var3);

    public static Object get(TypeGetterSetters row, int ordinal, LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return row.getBoolean(ordinal);
            }
            case TINYINT: {
                return row.getByte(ordinal);
            }
            case SMALLINT: {
                return row.getShort(ordinal);
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: 
            case INTERVAL_YEAR_MONTH: {
                return row.getInt(ordinal);
            }
            case BIGINT: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY_TIME: {
                return row.getLong(ordinal);
            }
            case FLOAT: {
                return Float.valueOf(row.getFloat(ordinal));
            }
            case DOUBLE: {
                return row.getDouble(ordinal);
            }
            case CHAR: 
            case VARCHAR: {
                return row.getString(ordinal);
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                return row.getDecimal(ordinal, decimalType.getPrecision(), decimalType.getScale());
            }
            case ARRAY: {
                return row.getArray(ordinal);
            }
            case MAP: 
            case MULTISET: {
                return row.getMap(ordinal);
            }
            case ROW: {
                return row.getRow(ordinal, ((RowType)type).getFieldCount());
            }
            case BINARY: 
            case VARBINARY: {
                return row.getBinary(ordinal);
            }
            case ANY: {
                return row.getGeneric(ordinal);
            }
        }
        throw new RuntimeException("Not support type: " + type);
    }
}

