/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function2;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Feature;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ModifiableViewTable;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlAccessEnum;
import org.apache.calcite.sql.SqlAccessType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.calcite.sql.SqlMerge;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSampleSpec;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSnapshot;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.AssignableOperandTypeChecker;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.AggFinder;
import org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.AliasNamespace;
import org.apache.calcite.sql.validate.CatalogScope;
import org.apache.calcite.sql.validate.CollectNamespace;
import org.apache.calcite.sql.validate.CollectScope;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.EmptyScope;
import org.apache.calcite.sql.validate.FieldNamespace;
import org.apache.calcite.sql.validate.GroupByScope;
import org.apache.calcite.sql.validate.IdentifierNamespace;
import org.apache.calcite.sql.validate.JoinNamespace;
import org.apache.calcite.sql.validate.JoinScope;
import org.apache.calcite.sql.validate.ListScope;
import org.apache.calcite.sql.validate.MatchRecognizeNamespace;
import org.apache.calcite.sql.validate.MatchRecognizeScope;
import org.apache.calcite.sql.validate.OrderByScope;
import org.apache.calcite.sql.validate.OverScope;
import org.apache.calcite.sql.validate.ParameterScope;
import org.apache.calcite.sql.validate.ProcedureNamespace;
import org.apache.calcite.sql.validate.ScopeChild;
import org.apache.calcite.sql.validate.SelectNamespace;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SetopNamespace;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlIdentifierMoniker;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlScopedShuttle;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql.validate.SqlValidatorWithHints;
import org.apache.calcite.sql.validate.TableConstructorNamespace;
import org.apache.calcite.sql.validate.TableNamespace;
import org.apache.calcite.sql.validate.TableScope;
import org.apache.calcite.sql.validate.UnnestNamespace;
import org.apache.calcite.sql.validate.WithItemNamespace;
import org.apache.calcite.sql.validate.WithNamespace;
import org.apache.calcite.sql.validate.WithScope;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.calcite.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;

public class SqlValidatorImpl
implements SqlValidatorWithHints {
    public static final Logger TRACER = CalciteTrace.PARSER_LOGGER;
    public static final String UPDATE_SRC_ALIAS = "SYS$SRC";
    public static final String UPDATE_TGT_ALIAS = "SYS$TGT";
    public static final String UPDATE_ANON_PREFIX = "SYS$ANON";
    private final SqlOperatorTable opTab;
    final SqlValidatorCatalogReader catalogReader;
    protected final Map<String, IdInfo> idPositions = new HashMap<String, IdInfo>();
    protected final Map<SqlNode, SqlValidatorScope> scopes = new IdentityHashMap<SqlNode, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> whereScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> groupByScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> selectScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> orderScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private final Map<SqlSelect, SqlValidatorScope> cursorScopes = new IdentityHashMap<SqlSelect, SqlValidatorScope>();
    private TableScope tableScope = null;
    protected final Map<SqlNode, SqlValidatorNamespace> namespaces = new IdentityHashMap<SqlNode, SqlValidatorNamespace>();
    private final Set<SqlNode> cursorSet = Sets.newIdentityHashSet();
    protected final Deque<FunctionParamInfo> functionCallStack = new ArrayDeque<FunctionParamInfo>();
    private int nextGeneratedId;
    protected final RelDataTypeFactory typeFactory;
    protected final RelDataType unknownType;
    private final RelDataType booleanType;
    private final Map<SqlNode, RelDataType> nodeToTypeMap = new IdentityHashMap<SqlNode, RelDataType>();
    private final AggFinder aggFinder;
    private final AggFinder aggOrOverFinder;
    private final AggFinder aggOrOverOrGroupFinder;
    private final AggFinder groupFinder;
    private final AggFinder overFinder;
    private final SqlConformance conformance;
    private final Map<SqlNode, SqlNode> originalExprs = new HashMap<SqlNode, SqlNode>();
    private SqlNode top;
    protected boolean expandIdentifiers;
    protected boolean expandColumnReferences;
    private boolean rewriteCalls;
    private NullCollation nullCollation = NullCollation.HIGH;
    private boolean validatingSqlMerge;
    private boolean inWindow;
    private final ValidationErrorFunction validationErrorFunction = new ValidationErrorFunction();

    protected SqlValidatorImpl(SqlOperatorTable opTab, SqlValidatorCatalogReader catalogReader, RelDataTypeFactory typeFactory, SqlConformance conformance) {
        this.opTab = Objects.requireNonNull(opTab);
        this.catalogReader = Objects.requireNonNull(catalogReader);
        this.typeFactory = Objects.requireNonNull(typeFactory);
        this.conformance = Objects.requireNonNull(conformance);
        this.unknownType = typeFactory.createUnknownType();
        this.booleanType = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        this.rewriteCalls = true;
        this.expandColumnReferences = true;
        SqlNameMatcher nameMatcher = catalogReader.nameMatcher();
        this.aggFinder = new AggFinder(opTab, false, true, false, null, nameMatcher);
        this.aggOrOverFinder = new AggFinder(opTab, true, true, false, null, nameMatcher);
        this.overFinder = new AggFinder(opTab, true, false, false, this.aggOrOverFinder, nameMatcher);
        this.groupFinder = new AggFinder(opTab, false, false, true, null, nameMatcher);
        this.aggOrOverOrGroupFinder = new AggFinder(opTab, true, true, true, null, nameMatcher);
    }

    @Override
    public SqlConformance getConformance() {
        return this.conformance;
    }

    @Override
    public SqlValidatorCatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public SqlOperatorTable getOperatorTable() {
        return this.opTab;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public RelDataType getUnknownType() {
        return this.unknownType;
    }

    @Override
    public SqlNodeList expandStar(SqlNodeList selectList, SqlSelect select, boolean includeSystemVars) {
        ArrayList<SqlNode> list = new ArrayList<SqlNode>();
        ArrayList<Map.Entry<String, RelDataType>> types = new ArrayList<Map.Entry<String, RelDataType>>();
        for (int i = 0; i < selectList.size(); ++i) {
            SqlNode selectItem = selectList.get(i);
            RelDataType originalType = this.getValidatedNodeTypeIfKnown(selectItem);
            this.expandSelectItem(selectItem, select, Util.first(originalType, this.unknownType), list, this.catalogReader.nameMatcher().createSet(), types, includeSystemVars);
        }
        this.getRawSelectScope(select).setExpandedSelectList(list);
        return new SqlNodeList(list, SqlParserPos.ZERO);
    }

    @Override
    public void declareCursor(SqlSelect select, SqlValidatorScope parentScope) {
        this.cursorSet.add(select);
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<Integer, SqlSelect> cursorMap = funcParamInfo.cursorPosToSelectMap;
        int numCursors = cursorMap.size();
        cursorMap.put(numCursors, select);
        SelectScope cursorScope = new SelectScope(parentScope, null, select);
        this.cursorScopes.put(select, cursorScope);
        SelectNamespace selectNs = this.createSelectNamespace(select, select);
        String alias2 = this.deriveAlias(select, this.nextGeneratedId++);
        this.registerNamespace(cursorScope, alias2, selectNs, false);
    }

    @Override
    public void pushFunctionCall() {
        FunctionParamInfo funcInfo = new FunctionParamInfo();
        this.functionCallStack.push(funcInfo);
    }

    @Override
    public void popFunctionCall() {
        this.functionCallStack.pop();
    }

    @Override
    public String getParentCursor(String columnListParamName) {
        FunctionParamInfo funcParamInfo = this.functionCallStack.peek();
        Map<String, String> parentCursorMap = funcParamInfo.columnListParamToParentCursorMap;
        return parentCursorMap.get(columnListParamName);
    }

    private boolean expandSelectItem(SqlNode selectItem, SqlSelect select, RelDataType targetType, List<SqlNode> selectItems, Set<String> aliases, List<Map.Entry<String, RelDataType>> fields2, boolean includeSystemVars) {
        String newAlias;
        SelectScope scope = (SelectScope)this.getWhereScope(select);
        if (this.expandStar(selectItems, aliases, fields2, includeSystemVars, scope, selectItem)) {
            return true;
        }
        SqlNode expanded = this.expand(selectItem, scope);
        String alias2 = this.deriveAlias(selectItem, aliases.size());
        SqlValidatorScope selectScope = this.getSelectScope(select);
        if (expanded != selectItem && !(newAlias = this.deriveAlias(expanded, aliases.size())).equals(alias2)) {
            expanded = SqlStdOperatorTable.AS.createCall(selectItem.getParserPosition(), expanded, new SqlIdentifier(alias2, SqlParserPos.ZERO));
            this.deriveTypeImpl(selectScope, expanded);
        }
        selectItems.add(expanded);
        aliases.add(alias2);
        if (expanded != null) {
            this.inferUnknownTypes(targetType, scope, expanded);
        }
        RelDataType type = this.deriveType(selectScope, expanded);
        this.setValidatedNodeType(expanded, type);
        fields2.add(Pair.of(alias2, type));
        return false;
    }

    private boolean expandStar(List<SqlNode> selectItems, Set<String> aliases, List<Map.Entry<String, RelDataType>> fields2, boolean includeSystemVars, SelectScope scope, SqlNode node) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        if (!identifier.isStar()) {
            return false;
        }
        SqlParserPos startPosition = identifier.getParserPosition();
        switch (identifier.names.size()) {
            case 1: {
                boolean hasDynamicStruct = false;
                for (ScopeChild child : scope.children) {
                    int before = fields2.size();
                    if (child.namespace.getRowType().isDynamicStruct()) {
                        hasDynamicStruct = true;
                        SqlIdentifier exp = new SqlIdentifier(ImmutableList.of(child.name, "**"), startPosition);
                        this.addToSelectList(selectItems, aliases, fields2, exp, scope, includeSystemVars);
                    } else {
                        SqlNode from = child.namespace.getNode();
                        SqlValidatorNamespace fromNs = this.getNamespace(from, (SqlValidatorScope)scope);
                        assert (fromNs != null);
                        RelDataType rowType = fromNs.getRowType();
                        for (RelDataTypeField field : rowType.getFieldList()) {
                            String columnName = field.getName();
                            SqlIdentifier exp = new SqlIdentifier(ImmutableList.of(child.name, columnName), startPosition);
                            if (this.isRolledUpColumn(exp, scope)) continue;
                            this.addOrExpandField(selectItems, aliases, fields2, includeSystemVars, scope, exp, field);
                        }
                    }
                    if (!child.nullable) continue;
                    for (int i = before; i < fields2.size(); ++i) {
                        Map.Entry<String, RelDataType> entry = fields2.get(i);
                        RelDataType type = entry.getValue();
                        if (type.isNullable()) continue;
                        fields2.set(i, Pair.of(entry.getKey(), this.typeFactory.createTypeWithNullability(type, true)));
                    }
                }
                if (!hasDynamicStruct) {
                    new Permute(scope.getNode().getFrom(), 0).permute(selectItems, fields2);
                }
                return true;
            }
        }
        SqlIdentifier prefixId = identifier.skipLast(1);
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        SqlNameMatcher nameMatcher = scope.validator.catalogReader.nameMatcher();
        scope.resolve(prefixId.names, nameMatcher, true, resolved);
        if (resolved.count() == 0) {
            throw this.newValidationError(prefixId, Static.RESOURCE.unknownIdentifier(prefixId.toString()));
        }
        RelDataType rowType = resolved.only().rowType();
        if (rowType.isDynamicStruct()) {
            this.addToSelectList(selectItems, aliases, fields2, prefixId.plus("**", startPosition), scope, includeSystemVars);
        } else if (rowType.isStruct()) {
            for (RelDataTypeField field : rowType.getFieldList()) {
                String columnName = field.getName();
                this.addOrExpandField(selectItems, aliases, fields2, includeSystemVars, scope, prefixId.plus(columnName, startPosition), field);
            }
        } else {
            throw this.newValidationError(prefixId, Static.RESOURCE.starRequiresRecordType());
        }
        return true;
    }

    private SqlNode maybeCast(SqlNode node, RelDataType currentType, RelDataType desiredType) {
        return currentType.equals(desiredType) || currentType.isNullable() != desiredType.isNullable() && this.typeFactory.createTypeWithNullability(currentType, desiredType.isNullable()).equals(desiredType) ? node : SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, node, SqlTypeUtil.convertTypeToSpec(desiredType));
    }

    private boolean addOrExpandField(List<SqlNode> selectItems, Set<String> aliases, List<Map.Entry<String, RelDataType>> fields2, boolean includeSystemVars, SelectScope scope, SqlIdentifier id, RelDataTypeField field) {
        switch (field.getType().getStructKind()) {
            case PEEK_FIELDS: 
            case PEEK_FIELDS_DEFAULT: {
                SqlIdentifier starExp = id.plusStar();
                this.expandStar(selectItems, aliases, fields2, includeSystemVars, scope, starExp);
                return true;
            }
        }
        this.addToSelectList(selectItems, aliases, fields2, id, scope, includeSystemVars);
        return false;
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        SqlValidatorScope scope = new EmptyScope(this);
        scope = new CatalogScope(scope, ImmutableList.of("CATALOG"));
        SqlNode topNode2 = this.validateScopedExpression(topNode, scope);
        RelDataType type = this.getValidatedNodeType(topNode2);
        Util.discard(type);
        return topNode2;
    }

    @Override
    public List<SqlMoniker> lookupHints(SqlNode topNode, SqlParserPos pos) {
        SqlValidatorNamespace ns;
        EmptyScope scope = new EmptyScope(this);
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        if ((ns = this.getNamespace(outermostNode)) == null) {
            throw new AssertionError((Object)("Not a query: " + outermostNode));
        }
        TreeSet<SqlMoniker> hintList = Sets.newTreeSet(SqlMoniker.COMPARATOR);
        this.lookupSelectHints(ns, pos, hintList);
        return ImmutableList.copyOf(hintList);
    }

    @Override
    public SqlMoniker lookupQualifiedName(SqlNode topNode, SqlParserPos pos) {
        String posString = pos.toString();
        IdInfo info = this.idPositions.get(posString);
        if (info != null) {
            SqlQualified qualified = info.scope.fullyQualify(info.id);
            return new SqlIdentifierMoniker(qualified.identifier);
        }
        return null;
    }

    void lookupSelectHints(SqlSelect select, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        IdInfo info = this.idPositions.get(pos.toString());
        if (info == null || info.scope == null) {
            SqlNode fromNode = select.getFrom();
            SqlValidatorScope fromScope = this.getFromScope(select);
            this.lookupFromHints(fromNode, fromScope, pos, hintList);
        } else {
            this.lookupNameCompletionHints(info.scope, info.id.names, info.id.getParserPosition(), hintList);
        }
    }

    private void lookupSelectHints(SqlValidatorNamespace ns, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode node = ns.getNode();
        if (node instanceof SqlSelect) {
            this.lookupSelectHints((SqlSelect)node, pos, hintList);
        }
    }

    private void lookupFromHints(SqlNode node, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        if (node == null) {
            return;
        }
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns.isWrapperFor(IdentifierNamespace.class)) {
            IdentifierNamespace idNs = ns.unwrap(IdentifierNamespace.class);
            SqlIdentifier id = idNs.getId();
            for (int i = 0; i < id.names.size(); ++i) {
                if (!pos.toString().equals(id.getComponent(i).getParserPosition().toString())) continue;
                ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
                SqlValidatorUtil.getSchemaObjectMonikers(this.getCatalogReader(), id.names.subList(0, i + 1), objNames);
                for (SqlMoniker objName : objNames) {
                    if (objName.getType() == SqlMonikerType.FUNCTION) continue;
                    hintList.add(objName);
                }
                return;
            }
        }
        switch (node.getKind()) {
            case JOIN: {
                this.lookupJoinHints((SqlJoin)node, scope, pos, hintList);
                break;
            }
            default: {
                this.lookupSelectHints(ns, pos, hintList);
            }
        }
    }

    private void lookupJoinHints(SqlJoin join, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        this.lookupFromHints(left, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        this.lookupFromHints(right, scope, pos, hintList);
        if (hintList.size() > 0) {
            return;
        }
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.scopes.get(join);
        switch (conditionType) {
            case ON: {
                condition.findValidOptions(this, joinScope, pos, hintList);
                return;
            }
        }
    }

    public final void lookupNameCompletionHints(SqlValidatorScope scope, List<String> names, SqlParserPos pos, Collection<SqlMoniker> hintList) {
        List<String> subNames = Util.skipLast(names);
        if (subNames.size() > 0) {
            RelDataType rowType;
            SqlValidatorNamespace ns = null;
            for (String name : subNames) {
                if (ns == null) {
                    SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                    SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
                    scope.resolve(ImmutableList.of(name), nameMatcher, false, resolved);
                    if (resolved.count() == 1) {
                        ns = resolved.only().namespace;
                    }
                } else {
                    ns = ns.lookupChild(name);
                }
                if (ns != null) continue;
                break;
            }
            if (ns != null && (rowType = ns.getRowType()).isStruct()) {
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
            SqlValidatorImpl.findAllValidFunctionNames(names, this, hintList, pos);
        } else {
            scope.findAliases(hintList);
            SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
            if (selectScope != null && selectScope.getChildren().size() == 1) {
                RelDataType rowType = selectScope.getChildren().get(0).getRowType();
                for (RelDataTypeField field : rowType.getFieldList()) {
                    hintList.add(new SqlMonikerImpl(field.getName(), SqlMonikerType.COLUMN));
                }
            }
        }
        SqlValidatorImpl.findAllValidUdfNames(names, this, hintList);
    }

    private static void findAllValidUdfNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result) {
        ArrayList<SqlMoniker> objNames = new ArrayList<SqlMoniker>();
        SqlValidatorUtil.getSchemaObjectMonikers(validator.getCatalogReader(), names, objNames);
        for (SqlMoniker objName : objNames) {
            if (objName.getType() != SqlMonikerType.FUNCTION) continue;
            result.add(objName);
        }
    }

    private static void findAllValidFunctionNames(List<String> names, SqlValidator validator, Collection<SqlMoniker> result, SqlParserPos pos) {
        if (names.size() > 1) {
            return;
        }
        for (SqlOperator op : validator.getOperatorTable().getOperatorList()) {
            SqlIdentifier curOpId = new SqlIdentifier(op.getName(), pos);
            SqlCall call = validator.makeNullaryCall(curOpId);
            if (call != null) {
                result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
                continue;
            }
            if (op.getSyntax() != SqlSyntax.FUNCTION && op.getSyntax() != SqlSyntax.PREFIX) continue;
            if (op.getOperandTypeChecker() != null) {
                String sig = op.getAllowedSignatures();
                sig = sig.replaceAll("'", "");
                result.add(new SqlMonikerImpl(sig, SqlMonikerType.FUNCTION));
                continue;
            }
            result.add(new SqlMonikerImpl(op.getName(), SqlMonikerType.FUNCTION));
        }
    }

    @Override
    public SqlNode validateParameterizedExpression(SqlNode topNode, Map<String, RelDataType> nameToTypeMap) {
        ParameterScope scope = new ParameterScope(this, nameToTypeMap);
        return this.validateScopedExpression(topNode, scope);
    }

    private SqlNode validateScopedExpression(SqlNode topNode, SqlValidatorScope scope) {
        SqlNode outermostNode = this.performUnconditionalRewrites(topNode, false);
        this.cursorSet.add(outermostNode);
        this.top = outermostNode;
        TRACER.trace("After unconditional rewrite: {}", (Object)outermostNode);
        if (outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.registerQuery(scope, null, outermostNode, outermostNode, null, false);
        }
        outermostNode.validate(this, scope);
        if (!outermostNode.isA(SqlKind.TOP_LEVEL)) {
            this.deriveType(scope, outermostNode);
        }
        TRACER.trace("After validation: {}", (Object)outermostNode);
        return outermostNode;
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope, RelDataType targetRowType) {
        SqlValidatorNamespace ns = this.getNamespace(node, scope);
        if (node.getKind() == SqlKind.TABLESAMPLE) {
            List<SqlNode> operands = ((SqlCall)node).getOperandList();
            SqlSampleSpec sampleSpec = SqlLiteral.sampleValue(operands.get(1));
            if (sampleSpec instanceof SqlSampleSpec.SqlTableSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeature_T613(), node.getParserPosition());
            } else if (sampleSpec instanceof SqlSampleSpec.SqlSubstitutionSampleSpec) {
                this.validateFeature(Static.RESOURCE.sQLFeatureExt_T613_Substitution(), node.getParserPosition());
            }
        }
        this.validateNamespace(ns, targetRowType);
        switch (node.getKind()) {
            case EXTEND: {
                this.deriveType(scope, node);
            }
        }
        if (node == this.top) {
            this.validateModality(node);
        }
        this.validateAccess(node, ns.getTable(), SqlAccessEnum.SELECT);
        if (node.getKind() == SqlKind.SNAPSHOT) {
            SqlSnapshot snapshot = (SqlSnapshot)node;
            SqlNode period = snapshot.getPeriod();
            RelDataType dataType2 = this.deriveType(scope, period);
            if (dataType2.getSqlTypeName() != SqlTypeName.TIMESTAMP) {
                throw this.newValidationError(period, Static.RESOURCE.illegalExpressionForTemporal(dataType2.getSqlTypeName().getName()));
            }
            if (!ns.getTable().isTemporal()) {
                List<String> qualifiedName = ns.getTable().getQualifiedName();
                String tableName = qualifiedName.get(qualifiedName.size() - 1);
                throw this.newValidationError(snapshot.getTableRef(), Static.RESOURCE.notTemporalTable(tableName));
            }
        }
    }

    protected void validateNamespace(SqlValidatorNamespace namespace, RelDataType targetRowType) {
        namespace.validate(targetRowType);
        if (namespace.getNode() != null) {
            this.setValidatedNodeType(namespace.getNode(), namespace.getType());
        }
    }

    @VisibleForTesting
    public SqlValidatorScope getEmptyScope() {
        return new EmptyScope(this);
    }

    public SqlValidatorScope getCursorScope(SqlSelect select) {
        return this.cursorScopes.get(select);
    }

    @Override
    public SqlValidatorScope getWhereScope(SqlSelect select) {
        return this.whereScopes.get(select);
    }

    @Override
    public SqlValidatorScope getSelectScope(SqlSelect select) {
        return this.selectScopes.get(select);
    }

    @Override
    public SelectScope getRawSelectScope(SqlSelect select) {
        SqlValidatorScope scope = this.getSelectScope(select);
        if (scope instanceof AggregatingSelectScope) {
            scope = ((AggregatingSelectScope)scope).getParent();
        }
        return (SelectScope)scope;
    }

    @Override
    public SqlValidatorScope getHavingScope(SqlSelect select) {
        return this.selectScopes.get(select);
    }

    @Override
    public SqlValidatorScope getGroupScope(SqlSelect select) {
        return this.groupByScopes.get(select);
    }

    @Override
    public SqlValidatorScope getFromScope(SqlSelect select) {
        return this.scopes.get(select);
    }

    @Override
    public SqlValidatorScope getOrderScope(SqlSelect select) {
        return this.orderScopes.get(select);
    }

    @Override
    public SqlValidatorScope getMatchRecognizeScope(SqlMatchRecognize node) {
        return this.scopes.get(node);
    }

    @Override
    public SqlValidatorScope getJoinScope(SqlNode node) {
        return this.scopes.get(SqlUtil.stripAs(node));
    }

    @Override
    public SqlValidatorScope getOverScope(SqlNode node) {
        return this.scopes.get(node);
    }

    private SqlValidatorNamespace getNamespace(SqlNode node, SqlValidatorScope scope) {
        if (node instanceof SqlIdentifier && scope instanceof DelegatingScope) {
            SqlIdentifier id = (SqlIdentifier)node;
            DelegatingScope idScope = (DelegatingScope)((DelegatingScope)scope).getParent();
            return this.getNamespace(id, idScope);
        }
        if (node instanceof SqlCall) {
            SqlCall call = (SqlCall)node;
            switch (call.getOperator().getKind()) {
                case EXTEND: {
                    SqlIdentifier id = (SqlIdentifier)call.getOperandList().get(0);
                    DelegatingScope idScope = (DelegatingScope)scope;
                    return this.getNamespace(id, idScope);
                }
                case AS: {
                    SqlNode nested = call.getOperandList().get(0);
                    switch (nested.getKind()) {
                        case EXTEND: {
                            return this.getNamespace(nested, scope);
                        }
                    }
                }
            }
        }
        return this.getNamespace(node);
    }

    private SqlValidatorNamespace getNamespace(SqlIdentifier id, DelegatingScope scope) {
        if (id.isSimple()) {
            SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
            SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
            scope.resolve(id.names, nameMatcher, false, resolved);
            if (resolved.count() == 1) {
                return resolved.only().namespace;
            }
        }
        return this.getNamespace(id);
    }

    @Override
    public SqlValidatorNamespace getNamespace(SqlNode node) {
        switch (node.getKind()) {
            case AS: {
                SqlValidatorNamespace ns = this.namespaces.get(node);
                if (ns != null) {
                    return ns;
                }
            }
            case SNAPSHOT: 
            case OVER: 
            case COLLECTION_TABLE: 
            case ORDER_BY: 
            case TABLESAMPLE: {
                return this.getNamespace((SqlNode)((SqlCall)node).operand(0));
            }
        }
        return this.namespaces.get(node);
    }

    private void handleOffsetFetch(SqlNode offset, SqlNode fetch) {
        if (offset instanceof SqlDynamicParam) {
            this.setValidatedNodeType(offset, this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
        if (fetch instanceof SqlDynamicParam) {
            this.setValidatedNodeType(fetch, this.typeFactory.createSqlType(SqlTypeName.INTEGER));
        }
    }

    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode newOperand;
        if (node == null) {
            return node;
        }
        if (node instanceof SqlCall) {
            if (node instanceof SqlMerge) {
                this.validatingSqlMerge = true;
            }
            SqlCall call = (SqlCall)node;
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            for (int i = 0; i < operands.size(); ++i) {
                boolean childUnderFrom;
                SqlNode operand = operands.get(i);
                newOperand = this.performUnconditionalRewrites(operand, childUnderFrom = kind == SqlKind.SELECT ? i == 2 : (kind == SqlKind.AS && i == 0 ? underFrom : false));
                if (newOperand == null || newOperand == operand) continue;
                call.setOperand(i, newOperand);
            }
            if (call.getOperator() instanceof SqlUnresolvedFunction) {
                assert (call instanceof SqlBasicCall);
                SqlUnresolvedFunction function = (SqlUnresolvedFunction)call.getOperator();
                ArrayList<SqlOperator> overloads = new ArrayList<SqlOperator>();
                this.opTab.lookupOperatorOverloads(function.getNameAsId(), function.getFunctionType(), SqlSyntax.FUNCTION, overloads, this.catalogReader.nameMatcher());
                if (overloads.size() == 1) {
                    ((SqlBasicCall)call).setOperator((SqlOperator)overloads.get(0));
                }
            }
            if (this.rewriteCalls) {
                node = call.getOperator().rewriteCall(this, call);
            }
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                SqlNode operand = list.get(i);
                newOperand = this.performUnconditionalRewrites(operand, false);
                if (newOperand == null) continue;
                list.getList().set(i, newOperand);
            }
        }
        SqlKind kind = node.getKind();
        switch (kind) {
            case VALUES: {
                if (!underFrom) {
                    // empty if block
                }
                return node;
            }
            case ORDER_BY: {
                SqlNodeList orderList;
                SqlSelect select;
                SqlOrderBy orderBy = (SqlOrderBy)node;
                this.handleOffsetFetch(orderBy.offset, orderBy.fetch);
                if (orderBy.query instanceof SqlSelect && (select = (SqlSelect)orderBy.query).getOrderList() == null) {
                    select.setOrderBy(orderBy.orderList);
                    select.setOffset(orderBy.offset);
                    select.setFetch(orderBy.fetch);
                    return select;
                }
                if (orderBy.query instanceof SqlWith && ((SqlWith)orderBy.query).body instanceof SqlSelect) {
                    SqlWith with = (SqlWith)orderBy.query;
                    SqlSelect select2 = (SqlSelect)with.body;
                    if (select2.getOrderList() == null) {
                        select2.setOrderBy(orderBy.orderList);
                        select2.setOffset(orderBy.offset);
                        select2.setFetch(orderBy.fetch);
                        return with;
                    }
                }
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                if (this.getInnerSelect(node) != null && this.isAggregate(this.getInnerSelect(node))) {
                    orderList = SqlNode.clone(orderBy.orderList);
                    for (int i = 0; i < orderList.size(); ++i) {
                        SqlNode sqlNode = orderList.get(i);
                        SqlNodeList selectList2 = this.getInnerSelect(node).getSelectList();
                        for (Ord<SqlNode> sel : Ord.zip(selectList2)) {
                            if (!SqlUtil.stripAs((SqlNode)sel.e).equalsDeep(sqlNode, Litmus.IGNORE)) continue;
                            orderList.set(i, SqlLiteral.createExactNumeric(Integer.toString(sel.i + 1), SqlParserPos.ZERO));
                        }
                    }
                } else {
                    orderList = orderBy.orderList;
                }
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, orderBy.query, null, null, null, null, orderList, orderBy.offset, orderBy.fetch);
            }
            case EXPLICIT_TABLE: {
                SqlCall call = (SqlCall)node;
                SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
                selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
                return new SqlSelect(SqlParserPos.ZERO, null, selectList, (SqlNode)call.operand(0), null, null, null, null, null, null, null);
            }
            case DELETE: {
                SqlCall call = (SqlDelete)node;
                SqlSelect select = this.createSourceSelectForDelete((SqlDelete)call);
                ((SqlDelete)call).setSourceSelect(select);
                break;
            }
            case UPDATE: {
                SqlNode selfJoinSrcExpr;
                SqlCall call = (SqlUpdate)node;
                SqlSelect select = this.createSourceSelectForUpdate((SqlUpdate)call);
                ((SqlUpdate)call).setSourceSelect(select);
                if (this.validatingSqlMerge || (selfJoinSrcExpr = this.getSelfJoinExprForUpdate(((SqlUpdate)call).getTargetTable(), UPDATE_SRC_ALIAS)) == null) break;
                node = this.rewriteUpdateToMerge((SqlUpdate)call, selfJoinSrcExpr);
                break;
            }
            case MERGE: {
                SqlCall call = (SqlMerge)node;
                this.rewriteMerge((SqlMerge)call);
                break;
            }
        }
        return node;
    }

    private SqlSelect getInnerSelect(SqlNode node) {
        while (true) {
            if (node instanceof SqlSelect) {
                return (SqlSelect)node;
            }
            if (node instanceof SqlOrderBy) {
                node = ((SqlOrderBy)node).query;
                continue;
            }
            if (!(node instanceof SqlWith)) break;
            node = ((SqlWith)node).body;
        }
        return null;
    }

    private void rewriteMerge(SqlMerge call) {
        SqlNodeList selectList;
        SqlUpdate updateStmt = call.getUpdateCall();
        if (updateStmt != null) {
            selectList = SqlNode.clone(updateStmt.getSourceSelect().getSelectList());
        } else {
            selectList = new SqlNodeList(SqlParserPos.ZERO);
            selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        }
        SqlNode targetTable = call.getTargetTable();
        if (call.getAlias() != null) {
            targetTable = SqlValidatorUtil.addAlias(targetTable, call.getAlias().getSimple());
        }
        SqlNode sourceTableRef = call.getSourceTableRef();
        SqlInsert insertCall = call.getInsertCall();
        JoinType joinType = insertCall == null ? JoinType.INNER : JoinType.LEFT;
        SqlNode leftJoinTerm = SqlNode.clone(sourceTableRef);
        SqlJoin outerJoin = new SqlJoin(SqlParserPos.ZERO, leftJoinTerm, SqlLiteral.createBoolean(false, SqlParserPos.ZERO), joinType.symbol(SqlParserPos.ZERO), targetTable, JoinConditionType.ON.symbol(SqlParserPos.ZERO), call.getCondition());
        SqlSelect select = new SqlSelect(SqlParserPos.ZERO, null, selectList, outerJoin, null, null, null, null, null, null, null);
        call.setSourceSelect(select);
        if (insertCall != null) {
            SqlCall valuesCall = (SqlCall)insertCall.getSource();
            SqlCall rowCall = (SqlCall)valuesCall.operand(0);
            selectList = new SqlNodeList(rowCall.getOperandList(), SqlParserPos.ZERO);
            SqlNode insertSource = SqlNode.clone(sourceTableRef);
            select = new SqlSelect(SqlParserPos.ZERO, null, selectList, insertSource, null, null, null, null, null, null, null);
            insertCall.setSource(select);
        }
    }

    private SqlNode rewriteUpdateToMerge(SqlUpdate updateCall, SqlNode selfJoinSrcExpr) {
        if (updateCall.getAlias() == null) {
            updateCall.setAlias(new SqlIdentifier(UPDATE_TGT_ALIAS, SqlParserPos.ZERO));
        }
        SqlNode selfJoinTgtExpr = this.getSelfJoinExprForUpdate(updateCall.getTargetTable(), updateCall.getAlias().getSimple());
        assert (selfJoinTgtExpr != null);
        SqlNode condition = updateCall.getCondition();
        SqlCall selfJoinCond = SqlStdOperatorTable.EQUALS.createCall(SqlParserPos.ZERO, selfJoinSrcExpr, selfJoinTgtExpr);
        condition = condition == null ? selfJoinCond : SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, selfJoinCond, condition);
        SqlNode target = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        IdentifierNamespace ns = new IdentifierNamespace(this, target, null, null);
        RelDataType rowType = ns.getRowType();
        SqlNode source = updateCall.getTargetTable().clone(SqlParserPos.ZERO);
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        int i = 1;
        for (RelDataTypeField field : rowType.getFieldList()) {
            SqlIdentifier col = new SqlIdentifier(field.getName(), SqlParserPos.ZERO);
            selectList.add(SqlValidatorUtil.addAlias(col, UPDATE_ANON_PREFIX + i));
            ++i;
        }
        source = new SqlSelect(SqlParserPos.ZERO, null, selectList, source, null, null, null, null, null, null, null);
        source = SqlValidatorUtil.addAlias(source, UPDATE_SRC_ALIAS);
        SqlMerge mergeCall = new SqlMerge(updateCall.getParserPosition(), target, condition, source, updateCall, null, null, updateCall.getAlias());
        this.rewriteMerge(mergeCall);
        return mergeCall;
    }

    protected SqlNode getSelfJoinExprForUpdate(SqlNode table, String alias2) {
        return null;
    }

    protected SqlSelect createSourceSelectForUpdate(SqlUpdate call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        int ordinal = 0;
        for (SqlNode exp : call.getSourceExpressionList()) {
            String alias2 = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias2));
            ++ordinal;
        }
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    protected SqlSelect createSourceSelectForDelete(SqlDelete call) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        selectList.add(SqlIdentifier.star(SqlParserPos.ZERO));
        SqlNode sourceTable = call.getTargetTable();
        if (call.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, call.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, call.getCondition(), null, null, null, null, null, null);
    }

    RelDataType getTableConstructorRowType(SqlCall values, SqlValidatorScope scope) {
        List<SqlNode> rows = values.getOperandList();
        assert (rows.size() >= 1);
        ArrayList<RelDataType> rowTypes = new ArrayList<RelDataType>();
        for (SqlNode row : rows) {
            assert (row.getKind() == SqlKind.ROW);
            SqlCall rowConstructor = (SqlCall)row;
            ArrayList<String> aliasList = new ArrayList<String>();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
            for (Ord<SqlNode> column : Ord.zip(rowConstructor.getOperandList())) {
                String alias2 = this.deriveAlias((SqlNode)column.e, column.i);
                aliasList.add(alias2);
                RelDataType type = this.deriveType(scope, (SqlNode)column.e);
                typeList.add(type);
            }
            rowTypes.add(this.typeFactory.createStructType(typeList, aliasList));
        }
        if (rows.size() == 1) {
            return (RelDataType)rowTypes.get(0);
        }
        return this.typeFactory.leastRestrictive(rowTypes);
    }

    @Override
    public RelDataType getValidatedNodeType(SqlNode node) {
        RelDataType type = this.getValidatedNodeTypeIfKnown(node);
        if (type == null) {
            throw Util.needToImplement(node);
        }
        return type;
    }

    @Override
    public RelDataType getValidatedNodeTypeIfKnown(SqlNode node) {
        RelDataType type = this.nodeToTypeMap.get(node);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(node);
        if (ns != null) {
            return ns.getType();
        }
        SqlNode original = this.originalExprs.get(node);
        if (original != null && original != node) {
            return this.getValidatedNodeType(original);
        }
        if (node instanceof SqlIdentifier) {
            return this.getCatalogReader().getNamedType((SqlIdentifier)node);
        }
        return null;
    }

    @Override
    public final void setValidatedNodeType(SqlNode node, RelDataType type) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(node);
        if (type.equals(this.unknownType)) {
            return;
        }
        this.nodeToTypeMap.put(node, type);
    }

    @Override
    public void removeValidatedNodeType(SqlNode node) {
        this.nodeToTypeMap.remove(node);
    }

    @Override
    @Nullable
    public SqlCall makeNullaryCall(SqlIdentifier id) {
        if (id.names.size() == 1 && !id.isComponentQuoted(0)) {
            ArrayList<SqlOperator> list = new ArrayList<SqlOperator>();
            this.opTab.lookupOperatorOverloads(id, null, SqlSyntax.FUNCTION, list, this.catalogReader.nameMatcher());
            for (SqlOperator operator : list) {
                if (operator.getSyntax() != SqlSyntax.FUNCTION_ID) continue;
                return new SqlBasicCall(operator, SqlNode.EMPTY_ARRAY, id.getParserPosition(), true, null);
            }
        }
        return null;
    }

    @Override
    public RelDataType deriveType(SqlValidatorScope scope, SqlNode expr) {
        Objects.requireNonNull(scope);
        Objects.requireNonNull(expr);
        RelDataType type = this.nodeToTypeMap.get(expr);
        if (type != null) {
            return type;
        }
        SqlValidatorNamespace ns = this.getNamespace(expr);
        if (ns != null) {
            return ns.getType();
        }
        type = this.deriveTypeImpl(scope, expr);
        Preconditions.checkArgument(type != null, "SqlValidator.deriveTypeInternal returned null");
        this.setValidatedNodeType(expr, type);
        return type;
    }

    RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        DeriveTypeVisitor v = new DeriveTypeVisitor(scope);
        RelDataType type = operand.accept(v);
        return Objects.requireNonNull(scope.nullifyType(operand, type));
    }

    @Override
    public RelDataType deriveConstructorType(SqlValidatorScope scope, SqlCall call, SqlFunction unresolvedConstructor, SqlFunction resolvedConstructor, List<RelDataType> argTypes) {
        SqlIdentifier sqlIdentifier = unresolvedConstructor.getSqlIdentifier();
        assert (sqlIdentifier != null);
        RelDataType type = this.catalogReader.getNamedType(sqlIdentifier);
        if (type == null) {
            throw this.newValidationError(sqlIdentifier, Static.RESOURCE.unknownDatatypeName(sqlIdentifier.toString()));
        }
        if (resolvedConstructor == null) {
            if (call.operandCount() > 0) {
                throw this.handleUnresolvedFunction(call, unresolvedConstructor, argTypes, null);
            }
        } else {
            SqlCall testCall = resolvedConstructor.createCall(call.getParserPosition(), call.getOperandList());
            RelDataType returnType = resolvedConstructor.validateOperands(this, scope, testCall);
            assert (type == returnType);
        }
        if (this.shouldExpandIdentifiers()) {
            if (resolvedConstructor != null) {
                ((SqlBasicCall)call).setOperator(resolvedConstructor);
            } else {
                ((SqlBasicCall)call).setOperator(new SqlFunction(type.getSqlIdentifier(), ReturnTypes.explicit(type), null, null, null, SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR));
            }
        }
        return type;
    }

    @Override
    public CalciteException handleUnresolvedFunction(SqlCall call, SqlFunction unresolvedFunction, List<RelDataType> argTypes, List<String> argNames) {
        SqlFunction fun;
        ArrayList<SqlOperator> overloads = new ArrayList<SqlOperator>();
        this.opTab.lookupOperatorOverloads(unresolvedFunction.getNameAsId(), null, SqlSyntax.FUNCTION, overloads, this.catalogReader.nameMatcher());
        if (overloads.size() == 1 && (fun = (SqlFunction)overloads.get(0)).getSqlIdentifier() == null && fun.getSyntax() != SqlSyntax.FUNCTION_ID) {
            int expectedArgCount = fun.getOperandCountRange().getMin();
            throw this.newValidationError(call, Static.RESOURCE.invalidArgCount(call.getOperator().getName(), expectedArgCount));
        }
        AssignableOperandTypeChecker typeChecking = new AssignableOperandTypeChecker(argTypes, argNames);
        String signature = typeChecking.getAllowedSignatures(unresolvedFunction, unresolvedFunction.getName());
        throw this.newValidationError(call, Static.RESOURCE.validatorUnknownFunction(signature));
    }

    protected void inferUnknownTypes(@Nonnull RelDataType inferredType, @Nonnull SqlValidatorScope scope, @Nonnull SqlNode node) {
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            Objects.requireNonNull(inferredType);
                            Objects.requireNonNull(scope);
                            Objects.requireNonNull(node);
                            SqlValidatorScope newScope = this.scopes.get(node);
                            if (newScope != null) {
                                scope = newScope;
                            }
                            boolean isNullLiteral = SqlUtil.isNullLiteral(node, false);
                            if (!(node instanceof SqlDynamicParam) && !isNullLiteral) break block14;
                            if (inferredType.equals(this.unknownType)) {
                                if (isNullLiteral) {
                                    throw this.newValidationError(node, Static.RESOURCE.nullIllegal());
                                }
                                throw this.newValidationError(node, Static.RESOURCE.dynamicParamIllegal());
                            }
                            RelDataType newInferredType = this.typeFactory.createTypeWithNullability(inferredType, true);
                            if (SqlTypeUtil.inCharFamily(inferredType)) {
                                newInferredType = this.typeFactory.createTypeWithCharsetAndCollation(newInferredType, inferredType.getCharset(), inferredType.getCollation());
                            }
                            this.setValidatedNodeType(node, newInferredType);
                            break block15;
                        }
                        if (!(node instanceof SqlNodeList)) break block16;
                        SqlNodeList nodeList = (SqlNodeList)node;
                        if (inferredType.isStruct() && inferredType.getFieldCount() != nodeList.size()) {
                            return;
                        }
                        int i = 0;
                        for (SqlNode sqlNode : nodeList) {
                            RelDataType type;
                            if (inferredType.isStruct()) {
                                type = inferredType.getFieldList().get(i).getType();
                                ++i;
                            } else {
                                type = inferredType;
                            }
                            this.inferUnknownTypes(type, scope, sqlNode);
                        }
                        break block15;
                    }
                    if (!(node instanceof SqlCase)) break block17;
                    SqlCase caseCall = (SqlCase)node;
                    RelDataType whenType = caseCall.getValueOperand() == null ? this.booleanType : this.unknownType;
                    for (SqlNode sqlNode : caseCall.getWhenOperands().getList()) {
                        this.inferUnknownTypes(whenType, scope, sqlNode);
                    }
                    RelDataType returnType = this.deriveType(scope, node);
                    for (SqlNode sqlNode : caseCall.getThenOperands().getList()) {
                        this.inferUnknownTypes(returnType, scope, sqlNode);
                    }
                    if (!SqlUtil.isNullLiteral(caseCall.getElseOperand(), false)) {
                        this.inferUnknownTypes(returnType, scope, caseCall.getElseOperand());
                    } else {
                        this.setValidatedNodeType(caseCall.getElseOperand(), returnType);
                    }
                    break block15;
                }
                if (node.getKind() != SqlKind.AS) break block18;
                this.inferUnknownTypes(inferredType, scope, (SqlNode)((SqlCall)node).operand(0));
                break block15;
            }
            if (!(node instanceof SqlCall)) break block15;
            SqlCall call = (SqlCall)node;
            SqlOperandTypeInference operandTypeInference = call.getOperator().getOperandTypeInference();
            SqlCallBinding callBinding = new SqlCallBinding(this, scope, call);
            List<SqlNode> list = callBinding.operands();
            Object[] operandTypes = new RelDataType[list.size()];
            Arrays.fill(operandTypes, this.unknownType);
            if (operandTypeInference != null) {
                operandTypeInference.inferOperandTypes(callBinding, inferredType, (RelDataType[])operandTypes);
            }
            for (int i = 0; i < list.size(); ++i) {
                SqlNode operand = list.get(i);
                if (operand == null) continue;
                this.inferUnknownTypes((RelDataType)operandTypes[i], scope, operand);
            }
        }
    }

    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SqlValidatorScope scope, boolean includeSystemVars) {
        String uniqueAlias;
        String alias2 = SqlValidatorUtil.getAlias(exp, -1);
        if (!alias2.equals(uniqueAlias = SqlValidatorUtil.uniquify(alias2, aliases, SqlValidatorUtil.EXPR_SUGGESTER))) {
            exp = SqlValidatorUtil.addAlias(exp, uniqueAlias);
        }
        fieldList.add(Pair.of(uniqueAlias, this.deriveType(scope, exp)));
        list.add(exp);
    }

    @Override
    public String deriveAlias(SqlNode node, int ordinal) {
        return SqlValidatorUtil.getAlias(node, ordinal);
    }

    @Override
    public void setIdentifierExpansion(boolean expandIdentifiers) {
        this.expandIdentifiers = expandIdentifiers;
    }

    @Override
    public void setColumnReferenceExpansion(boolean expandColumnReferences) {
        this.expandColumnReferences = expandColumnReferences;
    }

    @Override
    public boolean getColumnReferenceExpansion() {
        return this.expandColumnReferences;
    }

    @Override
    public void setDefaultNullCollation(NullCollation nullCollation) {
        this.nullCollation = Objects.requireNonNull(nullCollation);
    }

    @Override
    public NullCollation getDefaultNullCollation() {
        return this.nullCollation;
    }

    @Override
    public void setCallRewrite(boolean rewriteCalls) {
        this.rewriteCalls = rewriteCalls;
    }

    @Override
    public boolean shouldExpandIdentifiers() {
        return this.expandIdentifiers;
    }

    protected boolean shouldAllowIntermediateOrderBy() {
        return true;
    }

    private void registerMatchRecognize(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlMatchRecognize call, SqlNode enclosingNode, String alias2, boolean forceNullable) {
        MatchRecognizeNamespace matchRecognizeNamespace = this.createMatchRecognizeNameSpace(call, enclosingNode);
        this.registerNamespace(usingScope, alias2, matchRecognizeNamespace, forceNullable);
        MatchRecognizeScope matchRecognizeScope = new MatchRecognizeScope(parentScope, call);
        this.scopes.put(call, matchRecognizeScope);
        SqlNode expr = call.getTableRef();
        SqlNode newExpr = this.registerFrom(usingScope, matchRecognizeScope, true, expr, expr, null, null, forceNullable, false);
        if (expr != newExpr) {
            call.setOperand(0, newExpr);
        }
    }

    protected MatchRecognizeNamespace createMatchRecognizeNameSpace(SqlMatchRecognize call, SqlNode enclosingNode) {
        return new MatchRecognizeNamespace(this, call, enclosingNode);
    }

    protected void registerNamespace(SqlValidatorScope usingScope, String alias2, SqlValidatorNamespace ns, boolean forceNullable) {
        this.namespaces.put(ns.getNode(), ns);
        if (usingScope != null) {
            usingScope.addChild(ns, alias2, forceNullable);
        }
    }

    private SqlNode registerFrom(SqlValidatorScope parentScope, SqlValidatorScope usingScope, boolean register, SqlNode node, SqlNode enclosingNode, String alias2, SqlNodeList extendList, boolean forceNullable, boolean lateral) {
        SqlKind kind = node.getKind();
        SqlNode newNode = node;
        if (alias2 == null) {
            switch (kind) {
                case OVER: 
                case IDENTIFIER: {
                    alias2 = this.deriveAlias(node, -1);
                    if (alias2 == null) {
                        alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                    }
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias2);
                    break;
                }
                case COLLECTION_TABLE: 
                case VALUES: 
                case SELECT: 
                case UNION: 
                case INTERSECT: 
                case EXCEPT: 
                case UNNEST: 
                case OTHER_FUNCTION: 
                case MATCH_RECOGNIZE: {
                    alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                    if (!this.shouldExpandIdentifiers()) break;
                    newNode = SqlValidatorUtil.addAlias(node, alias2);
                }
            }
        }
        if (lateral) {
            SqlValidatorScope s = usingScope;
            while (s instanceof JoinScope) {
                s = ((JoinScope)s).getUsingScope();
            }
            SqlNode node2 = s != null ? s.getNode() : node;
            TableScope tableScope = new TableScope(parentScope, node2);
            if (usingScope instanceof ListScope) {
                for (ScopeChild child : ((ListScope)usingScope).children) {
                    tableScope.addChild(child.namespace, child.name, child.nullable);
                }
            }
            parentScope = tableScope;
        }
        switch (kind) {
            case AS: {
                Object expr;
                boolean needAlias;
                SqlNode newExpr;
                SqlCall call = (SqlCall)node;
                if (alias2 == null) {
                    alias2 = ((SqlNode)call.operand(1)).toString();
                }
                if ((newExpr = this.registerFrom(parentScope, usingScope, !(needAlias = call.operandCount() > 2), (SqlNode)(expr = call.operand(0)), enclosingNode, alias2, extendList, forceNullable, lateral)) != expr) {
                    call.setOperand(0, newExpr);
                }
                if (needAlias) {
                    this.registerNamespace(usingScope, alias2, new AliasNamespace(this, call, enclosingNode), forceNullable);
                }
                return node;
            }
            case MATCH_RECOGNIZE: {
                this.registerMatchRecognize(parentScope, usingScope, (SqlMatchRecognize)node, enclosingNode, alias2, forceNullable);
                return node;
            }
            case TABLESAMPLE: {
                SqlCall call = (SqlCall)node;
                Object expr = call.operand(0);
                SqlNode newExpr = this.registerFrom(parentScope, usingScope, true, (SqlNode)expr, enclosingNode, alias2, extendList, forceNullable, lateral);
                if (newExpr != expr) {
                    call.setOperand(0, newExpr);
                }
                return node;
            }
            case JOIN: {
                SqlNode newRight;
                SqlJoin join = (SqlJoin)node;
                JoinScope joinScope = new JoinScope(parentScope, usingScope, join);
                this.scopes.put(join, joinScope);
                SqlNode left = join.getLeft();
                SqlNode right = join.getRight();
                boolean rightIsLateral = SqlValidatorImpl.isLateral(right);
                boolean forceLeftNullable = forceNullable;
                boolean forceRightNullable = forceNullable;
                switch (join.getJoinType()) {
                    case LEFT: {
                        forceRightNullable = true;
                        break;
                    }
                    case RIGHT: {
                        forceLeftNullable = true;
                        break;
                    }
                    case FULL: {
                        forceLeftNullable = true;
                        forceRightNullable = true;
                    }
                }
                SqlNode newLeft = this.registerFrom(parentScope, joinScope, true, left, left, null, null, forceLeftNullable, lateral);
                if (newLeft != left) {
                    join.setLeft(newLeft);
                }
                if ((newRight = this.registerFrom(parentScope, joinScope, true, right, right, null, null, forceRightNullable, lateral)) != right) {
                    join.setRight(newRight);
                }
                this.registerSubQueries(joinScope, join.getCondition());
                JoinNamespace joinNamespace = new JoinNamespace(this, join);
                this.registerNamespace(null, null, joinNamespace, forceNullable);
                return join;
            }
            case IDENTIFIER: {
                SqlIdentifier id = (SqlIdentifier)node;
                IdentifierNamespace newNs = new IdentifierNamespace(this, id, extendList, enclosingNode, parentScope);
                this.registerNamespace(register ? usingScope : null, alias2, newNs, forceNullable);
                if (this.tableScope == null) {
                    this.tableScope = new TableScope(parentScope, node);
                }
                this.tableScope.addChild(newNs, alias2, forceNullable);
                if (extendList != null && extendList.size() != 0) {
                    return enclosingNode;
                }
                return newNode;
            }
            case LATERAL: {
                return this.registerFrom(parentScope, usingScope, register, (SqlNode)((SqlCall)node).operand(0), enclosingNode, alias2, extendList, forceNullable, true);
            }
            case COLLECTION_TABLE: {
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, usingScope, register, (SqlNode)operand, enclosingNode, alias2, extendList, forceNullable, lateral);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                this.scopes.put(node, parentScope);
                return newNode;
            }
            case UNNEST: {
                if (!lateral) {
                    return this.registerFrom(parentScope, usingScope, register, node, enclosingNode, alias2, extendList, forceNullable, true);
                }
            }
            case VALUES: 
            case SELECT: 
            case UNION: 
            case INTERSECT: 
            case EXCEPT: 
            case OTHER_FUNCTION: 
            case WITH: {
                if (alias2 == null) {
                    alias2 = this.deriveAlias(node, this.nextGeneratedId++);
                }
                this.registerQuery(parentScope, register ? usingScope : null, node, enclosingNode, alias2, forceNullable);
                return newNode;
            }
            case OVER: {
                if (!this.shouldAllowOverRelation()) {
                    throw Util.unexpected(kind);
                }
                SqlCall call = (SqlCall)node;
                OverScope overScope = new OverScope(usingScope, call);
                this.scopes.put(call, overScope);
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(parentScope, overScope, true, (SqlNode)operand, enclosingNode, alias2, extendList, forceNullable, lateral);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                for (ScopeChild child : overScope.children) {
                    this.registerNamespace(register ? usingScope : null, child.name, child.namespace, forceNullable);
                }
                return newNode;
            }
            case EXTEND: {
                SqlCall extend = (SqlCall)node;
                return this.registerFrom(parentScope, usingScope, true, extend.getOperandList().get(0), extend, alias2, (SqlNodeList)extend.getOperandList().get(1), forceNullable, lateral);
            }
            case SNAPSHOT: {
                SqlCall call = (SqlCall)node;
                Object operand = call.operand(0);
                SqlNode newOperand = this.registerFrom(this.tableScope == null ? parentScope : this.tableScope, usingScope, register, (SqlNode)operand, enclosingNode, alias2, extendList, forceNullable, true);
                if (newOperand != operand) {
                    call.setOperand(0, newOperand);
                }
                this.scopes.put(node, parentScope);
                return newNode;
            }
        }
        throw Util.unexpected(kind);
    }

    private static boolean isLateral(SqlNode node) {
        switch (node.getKind()) {
            case UNNEST: 
            case LATERAL: {
                return true;
            }
            case AS: {
                return SqlValidatorImpl.isLateral(((SqlCall)node).operand(0));
            }
        }
        return false;
    }

    protected boolean shouldAllowOverRelation() {
        return false;
    }

    protected SelectNamespace createSelectNamespace(SqlSelect select, SqlNode enclosingNode) {
        return new SelectNamespace(this, select, enclosingNode);
    }

    protected SetopNamespace createSetopNamespace(SqlCall call, SqlNode enclosingNode) {
        return new SetopNamespace(this, call, enclosingNode);
    }

    private void registerQuery(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable) {
        Preconditions.checkArgument(usingScope == null || alias2 != null);
        this.registerQuery(parentScope, usingScope, node, enclosingNode, alias2, forceNullable, true);
    }

    private void registerQuery(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable, boolean checkUpdate) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(enclosingNode);
        Preconditions.checkArgument(usingScope == null || alias2 != null);
        switch (node.getKind()) {
            case SELECT: {
                SqlCall agg;
                SqlNode newFrom;
                SqlSelect select = (SqlSelect)node;
                SelectNamespace selectNs = this.createSelectNamespace(select, enclosingNode);
                this.registerNamespace(usingScope, alias2, selectNs, forceNullable);
                SqlValidatorScope windowParentScope = usingScope != null ? usingScope : parentScope;
                SelectScope selectScope = new SelectScope(parentScope, windowParentScope, select);
                this.scopes.put(select, selectScope);
                this.whereScopes.put(select, selectScope);
                this.registerOperandSubQueries(selectScope, select, 3);
                SqlNode from = select.getFrom();
                if (from != null && (newFrom = this.registerFrom(parentScope, selectScope, true, from, from, null, null, false, false)) != from) {
                    select.setFrom(newFrom);
                }
                DelegatingScope aggScope = selectScope;
                if (this.isAggregate(select)) {
                    aggScope = new AggregatingSelectScope(selectScope, select, false);
                    this.selectScopes.put(select, aggScope);
                } else {
                    this.selectScopes.put(select, selectScope);
                }
                if (select.getGroup() != null) {
                    GroupByScope groupByScope = new GroupByScope(selectScope, select.getGroup(), select);
                    this.groupByScopes.put(select, groupByScope);
                    this.registerSubQueries(groupByScope, select.getGroup());
                }
                this.registerOperandSubQueries(aggScope, select, 5);
                this.registerSubQueries(aggScope, select.getSelectList());
                SqlNodeList orderList = select.getOrderList();
                if (orderList == null) break;
                if (select.isDistinct()) {
                    aggScope = new AggregatingSelectScope(selectScope, select, true);
                }
                OrderByScope orderScope = new OrderByScope(aggScope, orderList, select);
                this.orderScopes.put(select, orderScope);
                this.registerSubQueries(orderScope, orderList);
                if (this.isAggregate(select) || (agg = this.aggFinder.findAgg(orderList)) == null) break;
                throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInOrderBy());
            }
            case INTERSECT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_F302(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case EXCEPT: {
                this.validateFeature(Static.RESOURCE.sQLFeature_E071_03(), node.getParserPosition());
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case UNION: {
                this.registerSetop(parentScope, usingScope, node, node, alias2, forceNullable);
                break;
            }
            case WITH: {
                this.registerWith(parentScope, usingScope, (SqlWith)node, enclosingNode, alias2, forceNullable, checkUpdate);
                break;
            }
            case VALUES: {
                SqlCall call = (SqlCall)node;
                this.scopes.put(call, parentScope);
                TableConstructorNamespace tableConstructorNamespace = new TableConstructorNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias2, tableConstructorNamespace, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    assert (operands.get(i).getKind() == SqlKind.ROW);
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break;
            }
            case INSERT: {
                SqlInsert insertCall = (SqlInsert)node;
                InsertNamespace insertNs = new InsertNamespace(this, insertCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, insertNs, forceNullable);
                this.registerQuery(parentScope, usingScope, insertCall.getSource(), enclosingNode, null, false);
                break;
            }
            case DELETE: {
                SqlDelete deleteCall = (SqlDelete)node;
                DeleteNamespace deleteNs = new DeleteNamespace(this, deleteCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, deleteNs, forceNullable);
                this.registerQuery(parentScope, usingScope, deleteCall.getSourceSelect(), enclosingNode, null, false);
                break;
            }
            case UPDATE: {
                if (checkUpdate) {
                    this.validateFeature(Static.RESOURCE.sQLFeature_E101_03(), node.getParserPosition());
                }
                SqlUpdate updateCall = (SqlUpdate)node;
                UpdateNamespace updateNs = new UpdateNamespace(this, updateCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, updateNs, forceNullable);
                this.registerQuery(parentScope, usingScope, updateCall.getSourceSelect(), enclosingNode, null, false);
                break;
            }
            case MERGE: {
                this.validateFeature(Static.RESOURCE.sQLFeature_F312(), node.getParserPosition());
                SqlMerge mergeCall = (SqlMerge)node;
                MergeNamespace mergeNs = new MergeNamespace(this, mergeCall, enclosingNode, parentScope);
                this.registerNamespace(usingScope, null, mergeNs, forceNullable);
                this.registerQuery(parentScope, usingScope, mergeCall.getSourceSelect(), enclosingNode, null, false);
                if (mergeCall.getUpdateCall() != null) {
                    this.registerQuery(this.whereScopes.get(mergeCall.getSourceSelect()), null, mergeCall.getUpdateCall(), enclosingNode, null, false, false);
                }
                if (mergeCall.getInsertCall() == null) break;
                this.registerQuery(parentScope, null, mergeCall.getInsertCall(), enclosingNode, null, false);
                break;
            }
            case UNNEST: {
                SqlCall call = (SqlCall)node;
                UnnestNamespace unnestNs = new UnnestNamespace(this, call, parentScope, enclosingNode);
                this.registerNamespace(usingScope, alias2, unnestNs, forceNullable);
                this.registerOperandSubQueries(parentScope, call, 0);
                this.scopes.put(node, parentScope);
                break;
            }
            case OTHER_FUNCTION: {
                SqlCall call = (SqlCall)node;
                ProcedureNamespace procNs = new ProcedureNamespace(this, parentScope, call, enclosingNode);
                this.registerNamespace(usingScope, alias2, procNs, forceNullable);
                this.registerSubQueries(parentScope, call);
                break;
            }
            case MULTISET_QUERY_CONSTRUCTOR: 
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
                SqlCall call = (SqlCall)node;
                CollectScope cs = new CollectScope(parentScope, usingScope, call);
                CollectNamespace tableConstructorNs = new CollectNamespace(call, cs, enclosingNode);
                String alias22 = this.deriveAlias(node, this.nextGeneratedId++);
                this.registerNamespace(usingScope, alias22, tableConstructorNs, forceNullable);
                List<SqlNode> operands = call.getOperandList();
                for (int i = 0; i < operands.size(); ++i) {
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break;
            }
            default: {
                throw Util.unexpected(node.getKind());
            }
        }
    }

    private void registerSetop(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlNode node, SqlNode enclosingNode, String alias2, boolean forceNullable) {
        SqlCall call = (SqlCall)node;
        SetopNamespace setopNamespace = this.createSetopNamespace(call, enclosingNode);
        this.registerNamespace(usingScope, alias2, setopNamespace, forceNullable);
        this.scopes.put(call, parentScope);
        for (SqlNode operand : call.getOperandList()) {
            this.registerQuery(parentScope, null, operand, operand, null, false);
        }
    }

    private void registerWith(SqlValidatorScope parentScope, SqlValidatorScope usingScope, SqlWith with, SqlNode enclosingNode, String alias2, boolean forceNullable, boolean checkUpdate) {
        WithNamespace withNamespace = new WithNamespace(this, with, enclosingNode);
        this.registerNamespace(usingScope, alias2, withNamespace, forceNullable);
        SqlValidatorScope scope = parentScope;
        for (SqlNode withItem_ : with.withList) {
            SqlWithItem withItem = (SqlWithItem)withItem_;
            WithScope withScope = new WithScope(scope, withItem);
            this.scopes.put(withItem, withScope);
            this.registerQuery(scope, null, withItem.query, with, withItem.name.getSimple(), false);
            this.registerNamespace(null, alias2, new WithItemNamespace(this, withItem, enclosingNode), false);
            scope = withScope;
        }
        this.registerQuery(scope, null, with.body, enclosingNode, alias2, forceNullable, checkUpdate);
    }

    @Override
    public boolean isAggregate(SqlSelect select) {
        if (this.getAggregate(select) != null) {
            return true;
        }
        for (SqlCall call : this.overFinder.findAll(select.getSelectList())) {
            assert (call.getKind() == SqlKind.OVER);
            if (this.isNestedAggregateWindow((SqlNode)call.operand(0))) {
                return true;
            }
            if (!this.isOverAggregateWindow((SqlNode)call.operand(1))) continue;
            return true;
        }
        return false;
    }

    protected boolean isNestedAggregateWindow(SqlNode node) {
        AggFinder nestedAggFinder = new AggFinder(this.opTab, false, false, false, this.aggFinder, this.catalogReader.nameMatcher());
        return nestedAggFinder.findAgg(node) != null;
    }

    protected boolean isOverAggregateWindow(SqlNode node) {
        return this.aggFinder.findAgg(node) != null;
    }

    protected SqlNode getAggregate(SqlSelect select) {
        SqlNode node = select.getGroup();
        if (node != null) {
            return node;
        }
        node = select.getHaving();
        if (node != null) {
            return node;
        }
        return this.getAgg(select);
    }

    private SqlNode getAgg(SqlSelect select) {
        List<SqlNode> selectList;
        SelectScope selectScope = this.getRawSelectScope(select);
        if (selectScope != null && (selectList = selectScope.getExpandedSelectList()) != null) {
            return this.aggFinder.findAgg(selectList);
        }
        return this.aggFinder.findAgg(select.getSelectList());
    }

    @Override
    public boolean isAggregate(SqlNode selectNode) {
        return this.aggFinder.findAgg(selectNode) != null;
    }

    private void validateNodeFeature(SqlNode node) {
        switch (node.getKind()) {
            case MULTISET_VALUE_CONSTRUCTOR: {
                this.validateFeature(Static.RESOURCE.sQLFeature_S271(), node.getParserPosition());
            }
        }
    }

    private void registerSubQueries(SqlValidatorScope parentScope, SqlNode node) {
        block5: {
            block6: {
                block4: {
                    if (node == null) {
                        return;
                    }
                    if (!node.getKind().belongsTo(SqlKind.QUERY) && node.getKind() != SqlKind.MULTISET_QUERY_CONSTRUCTOR && node.getKind() != SqlKind.MULTISET_VALUE_CONSTRUCTOR) break block4;
                    this.registerQuery(parentScope, null, node, node, null, false);
                    break block5;
                }
                if (!(node instanceof SqlCall)) break block6;
                this.validateNodeFeature(node);
                SqlCall call = (SqlCall)node;
                for (int i = 0; i < call.operandCount(); ++i) {
                    this.registerOperandSubQueries(parentScope, call, i);
                }
                break block5;
            }
            if (!(node instanceof SqlNodeList)) break block5;
            SqlNodeList list = (SqlNodeList)node;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                SqlNode listNode = list.get(i);
                if (listNode.getKind().belongsTo(SqlKind.QUERY)) {
                    listNode = SqlStdOperatorTable.SCALAR_QUERY.createCall(listNode.getParserPosition(), listNode);
                    list.set(i, listNode);
                }
                this.registerSubQueries(parentScope, listNode);
            }
        }
    }

    private void registerOperandSubQueries(SqlValidatorScope parentScope, SqlCall call, int operandOrdinal) {
        Object operand = call.operand(operandOrdinal);
        if (operand == null) {
            return;
        }
        if (((SqlNode)operand).getKind().belongsTo(SqlKind.QUERY) && call.getOperator().argumentMustBeScalar(operandOrdinal)) {
            operand = SqlStdOperatorTable.SCALAR_QUERY.createCall(((SqlNode)operand).getParserPosition(), new SqlNode[]{operand});
            call.setOperand(operandOrdinal, (SqlNode)operand);
        }
        this.registerSubQueries(parentScope, (SqlNode)operand);
    }

    @Override
    public void validateIdentifier(SqlIdentifier id, SqlValidatorScope scope) {
        SqlQualified fqId = scope.fullyQualify(id);
        if (this.expandColumnReferences) {
            id.assignNamesFrom(fqId.identifier);
        } else {
            Util.discard(fqId);
        }
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        switch (literal.getTypeName()) {
            case DECIMAL: {
                BigDecimal bd = (BigDecimal)literal.getValue();
                BigInteger unscaled = bd.unscaledValue();
                long longValue = unscaled.longValue();
                if (BigInteger.valueOf(longValue).equals(unscaled)) break;
                throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
            }
            case DOUBLE: {
                this.validateLiteralAsDouble(literal);
                break;
            }
            case BINARY: {
                BitString bitString = (BitString)literal.getValue();
                if (bitString.getBitCount() % 8 == 0) break;
                throw this.newValidationError(literal, Static.RESOURCE.binaryLiteralOdd());
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                Calendar calendar = literal.getValueAs(Calendar.class);
                int year = calendar.get(1);
                int era = calendar.get(0);
                if (year >= 1 && era != 0 && year <= 9999) break;
                throw this.newValidationError(literal, Static.RESOURCE.dateLiteralOutOfRange(literal.toString()));
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                if (!(literal instanceof SqlIntervalLiteral)) break;
                SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
                SqlIntervalQualifier intervalQualifier = interval.getIntervalQualifier();
                this.validateIntervalQualifier(intervalQualifier);
                String intervalStr = interval.getIntervalLiteral();
                int[] values = intervalQualifier.evaluateIntervalLiteral(intervalStr, literal.getParserPosition(), this.typeFactory.getTypeSystem());
                Util.discard(values);
                break;
            }
        }
    }

    private void validateLiteralAsDouble(SqlLiteral literal) {
        BigDecimal bd = (BigDecimal)literal.getValue();
        double d = bd.doubleValue();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw this.newValidationError(literal, Static.RESOURCE.numberLiteralOutOfRange(Util.toScientificNotation(bd)));
        }
    }

    @Override
    public void validateIntervalQualifier(SqlIntervalQualifier qualifier) {
        assert (qualifier != null);
        boolean startPrecisionOutOfRange = false;
        boolean fractionalSecondPrecisionOutOfRange = false;
        RelDataTypeSystem typeSystem = this.typeFactory.getTypeSystem();
        int startPrecision = qualifier.getStartPrecision(typeSystem);
        int fracPrecision = qualifier.getFractionalSecondPrecision(typeSystem);
        int maxPrecision = typeSystem.getMaxPrecision(qualifier.typeName());
        int minPrecision = qualifier.typeName().getMinPrecision();
        int minScale = qualifier.typeName().getMinScale();
        int maxScale = typeSystem.getMaxScale(qualifier.typeName());
        if (qualifier.isYearMonth()) {
            if (startPrecision < minPrecision || startPrecision > maxPrecision) {
                startPrecisionOutOfRange = true;
            } else if (fracPrecision < minScale || fracPrecision > maxScale) {
                fractionalSecondPrecisionOutOfRange = true;
            }
        } else if (startPrecision < minPrecision || startPrecision > maxPrecision) {
            startPrecisionOutOfRange = true;
        } else if (fracPrecision < minScale || fracPrecision > maxScale) {
            fractionalSecondPrecisionOutOfRange = true;
        }
        if (startPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalStartPrecisionOutOfRange(startPrecision, "INTERVAL " + qualifier));
        }
        if (fractionalSecondPrecisionOutOfRange) {
            throw this.newValidationError(qualifier, Static.RESOURCE.intervalFractionalSecondPrecisionOutOfRange(fracPrecision, "INTERVAL " + qualifier));
        }
    }

    protected void validateFrom(SqlNode node, RelDataType targetRowType, SqlValidatorScope scope) {
        Objects.requireNonNull(targetRowType);
        switch (node.getKind()) {
            case AS: {
                this.validateFrom((SqlNode)((SqlCall)node).operand(0), targetRowType, scope);
                break;
            }
            case VALUES: {
                this.validateValues((SqlCall)node, targetRowType, scope);
                break;
            }
            case JOIN: {
                this.validateJoin((SqlJoin)node, scope);
                break;
            }
            case OVER: {
                this.validateOver((SqlCall)node, scope);
                break;
            }
            case UNNEST: {
                this.validateUnnest((SqlCall)node, scope, targetRowType);
                break;
            }
            default: {
                this.validateQuery(node, scope, targetRowType);
            }
        }
        this.getNamespace(node, scope).validate(targetRowType);
    }

    protected void validateOver(SqlCall call, SqlValidatorScope scope) {
        throw new AssertionError((Object)"OVER unexpected in this context");
    }

    protected void validateUnnest(SqlCall call, SqlValidatorScope scope, RelDataType targetRowType) {
        for (int i = 0; i < call.operandCount(); ++i) {
            SqlNode expandedItem = this.expand((SqlNode)call.operand(i), scope);
            call.setOperand(i, expandedItem);
        }
        this.validateQuery(call, scope, targetRowType);
    }

    private void checkRollUpInUsing(SqlIdentifier identifier, SqlNode leftOrRight, SqlValidatorScope scope) {
        String column;
        Table table;
        SqlValidatorTable sqlValidatorTable;
        SqlValidatorNamespace namespace = this.getNamespace(leftOrRight, scope);
        if (namespace != null && (sqlValidatorTable = namespace.getTable()) != null && (table = sqlValidatorTable.unwrap(Table.class)).isRolledUp(column = Util.last(identifier.names))) {
            throw this.newValidationError(identifier, Static.RESOURCE.rolledUpNotAllowed(column, "USING"));
        }
    }

    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        SqlNode left = join.getLeft();
        SqlNode right = join.getRight();
        SqlNode condition = join.getCondition();
        boolean natural = join.isNatural();
        JoinType joinType = join.getJoinType();
        JoinConditionType conditionType = join.getConditionType();
        SqlValidatorScope joinScope = this.scopes.get(join);
        this.validateFrom(left, this.unknownType, joinScope);
        this.validateFrom(right, this.unknownType, joinScope);
        switch (conditionType) {
            case NONE: {
                Preconditions.checkArgument(condition == null);
                break;
            }
            case ON: {
                Preconditions.checkArgument(condition != null);
                SqlNode expandedCondition = this.expand(condition, joinScope);
                join.setOperand(5, expandedCondition);
                condition = join.getCondition();
                this.validateWhereOrOn(joinScope, condition, "ON");
                this.checkRollUp(null, join, condition, joinScope, "ON");
                break;
            }
            case USING: {
                SqlNodeList list = (SqlNodeList)condition;
                Preconditions.checkArgument(list.size() > 0, "Empty USING clause");
                for (SqlNode node : list) {
                    RelDataType rightColType;
                    SqlIdentifier id = (SqlIdentifier)node;
                    RelDataType leftColType = this.validateUsingCol(id, left);
                    if (!SqlTypeUtil.isComparable(leftColType, rightColType = this.validateUsingCol(id, right))) {
                        throw this.newValidationError(id, Static.RESOURCE.naturalOrUsingColumnNotCompatible(id.getSimple(), leftColType.toString(), rightColType.toString()));
                    }
                    this.checkRollUpInUsing(id, left, scope);
                    this.checkRollUpInUsing(id, right, scope);
                }
                break;
            }
            default: {
                throw Util.unexpected(conditionType);
            }
        }
        if (natural) {
            if (condition != null) {
                throw this.newValidationError(condition, Static.RESOURCE.naturalDisallowsOnOrUsing());
            }
            RelDataType leftRowType = this.getNamespace(left).getRowType();
            RelDataType rightRowType = this.getNamespace(right).getRowType();
            SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
            List<String> naturalColumnNames = SqlValidatorUtil.deriveNaturalJoinColumnList(nameMatcher, leftRowType, rightRowType);
            for (String name : naturalColumnNames) {
                RelDataType rightColType;
                RelDataType leftColType = nameMatcher.field(leftRowType, name).getType();
                if (SqlTypeUtil.isComparable(leftColType, rightColType = nameMatcher.field(rightRowType, name).getType())) continue;
                throw this.newValidationError(join, Static.RESOURCE.naturalOrUsingColumnNotCompatible(name, leftColType.toString(), rightColType.toString()));
            }
        }
        switch (joinType) {
            case LEFT_SEMI_JOIN: {
                if (!this.conformance.isLiberal()) {
                    throw this.newValidationError(join.getJoinTypeNode(), Static.RESOURCE.dialectDoesNotSupportFeature("LEFT SEMI JOIN"));
                }
            }
            case LEFT: 
            case RIGHT: 
            case FULL: 
            case INNER: {
                if (condition != null || natural) break;
                throw this.newValidationError(join, Static.RESOURCE.joinRequiresCondition());
            }
            case COMMA: 
            case CROSS: {
                if (condition != null) {
                    throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
                }
                if (!natural) break;
                throw this.newValidationError(join.getConditionTypeNode(), Static.RESOURCE.crossJoinDisallowsCondition());
            }
            default: {
                throw Util.unexpected(joinType);
            }
        }
    }

    private void validateNoAggs(AggFinder aggFinder, SqlNode node, String clause) {
        SqlCall agg = aggFinder.findAgg(node);
        if (agg == null) {
            return;
        }
        SqlOperator op = agg.getOperator();
        if (op == SqlStdOperatorTable.OVER) {
            throw this.newValidationError(agg, Static.RESOURCE.windowedAggregateIllegalInClause(clause));
        }
        if (op.isGroup() || op.isGroupAuxiliary()) {
            throw this.newValidationError(agg, Static.RESOURCE.groupFunctionMustAppearInGroupByClause(op.getName()));
        }
        throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInClause(clause));
    }

    private RelDataType validateUsingCol(SqlIdentifier id, SqlNode leftOrRight) {
        if (id.names.size() == 1) {
            String name = (String)id.names.get(0);
            SqlValidatorNamespace namespace = this.getNamespace(leftOrRight);
            RelDataType rowType = namespace.getRowType();
            SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
            RelDataTypeField field = nameMatcher.field(rowType, name);
            if (field != null) {
                if (nameMatcher.frequency(rowType.getFieldNames(), name) > 1) {
                    throw this.newValidationError(id, Static.RESOURCE.columnInUsingNotUnique(id.toString()));
                }
                return field.getType();
            }
        }
        throw this.newValidationError(id, Static.RESOURCE.columnNotFound(id.toString()));
    }

    protected void validateSelect(SqlSelect select, RelDataType targetRowType) {
        int duplicateAliasOrdinal;
        SqlIdentifier id;
        SqlNode selectItem;
        assert (targetRowType != null);
        SelectNamespace ns = this.getNamespace(select).unwrap(SelectNamespace.class);
        assert (ns.rowType == null);
        if (select.isDistinct()) {
            this.validateFeature(Static.RESOURCE.sQLFeature_E051_01(), select.getModifierNode(SqlSelectKeyword.DISTINCT).getParserPosition());
        }
        SqlNodeList selectItems = select.getSelectList();
        RelDataType fromType = this.unknownType;
        if (selectItems.size() == 1 && (selectItem = selectItems.get(0)) instanceof SqlIdentifier && (id = (SqlIdentifier)selectItem).isStar() && id.names.size() == 1) {
            fromType = targetRowType;
        }
        SelectScope fromScope = (SelectScope)this.getFromScope(select);
        List<String> names = fromScope.getChildNames();
        if (!this.catalogReader.nameMatcher().isCaseSensitive()) {
            names = Lists.transform(names, s -> s.toUpperCase(Locale.ROOT));
        }
        if ((duplicateAliasOrdinal = Util.firstDuplicate(names)) >= 0) {
            ScopeChild child = (ScopeChild)fromScope.children.get(duplicateAliasOrdinal);
            throw this.newValidationError(child.namespace.getEnclosingNode(), Static.RESOURCE.fromAliasDuplicate(child.name));
        }
        if (select.getFrom() == null) {
            if (this.conformance.isFromRequired()) {
                throw this.newValidationError(select, Static.RESOURCE.selectMissingFrom());
            }
        } else {
            this.validateFrom(select.getFrom(), fromType, fromScope);
        }
        this.validateWhereClause(select);
        this.validateGroupClause(select);
        this.validateHavingClause(select);
        this.validateWindowClause(select);
        this.handleOffsetFetch(select.getOffset(), select.getFetch());
        RelDataType rowType = this.validateSelectList(selectItems, select, targetRowType);
        ns.setType(rowType);
        this.validateOrderList(select);
        if (this.shouldCheckForRollUp(select.getFrom())) {
            this.checkRollUpInSelectList(select);
            this.checkRollUp(null, select, select.getWhere(), this.getWhereScope(select));
            this.checkRollUp(null, select, select.getHaving(), this.getHavingScope(select));
            this.checkRollUpInWindowDecl(select);
            this.checkRollUpInGroupBy(select);
            this.checkRollUpInOrderBy(select);
        }
    }

    private void checkRollUpInSelectList(SqlSelect select) {
        SqlValidatorScope scope = this.getSelectScope(select);
        for (SqlNode item : select.getSelectList()) {
            this.checkRollUp(null, select, item, scope);
        }
    }

    private void checkRollUpInGroupBy(SqlSelect select) {
        SqlNodeList group = select.getGroup();
        if (group != null) {
            for (SqlNode node : group) {
                this.checkRollUp(null, select, node, this.getGroupScope(select), "GROUP BY");
            }
        }
    }

    private void checkRollUpInOrderBy(SqlSelect select) {
        SqlNodeList orderList = select.getOrderList();
        if (orderList != null) {
            for (SqlNode node : orderList) {
                this.checkRollUp(null, select, node, this.getOrderScope(select), "ORDER BY");
            }
        }
    }

    private void checkRollUpInWindow(SqlWindow window, SqlValidatorScope scope) {
        if (window != null) {
            for (SqlNode node : window.getPartitionList()) {
                this.checkRollUp(null, window, node, scope, "PARTITION BY");
            }
            for (SqlNode node : window.getOrderList()) {
                this.checkRollUp(null, window, node, scope, "ORDER BY");
            }
        }
    }

    private void checkRollUpInWindowDecl(SqlSelect select) {
        for (SqlNode decl : select.getWindowList()) {
            this.checkRollUpInWindow((SqlWindow)decl, this.getSelectScope(select));
        }
    }

    private SqlNode stripDot(SqlNode node) {
        if (node != null && node.getKind() == SqlKind.DOT) {
            return this.stripDot((SqlNode)((SqlCall)node).operand(0));
        }
        return node;
    }

    private void checkRollUp(SqlNode grandParent, SqlNode parent, SqlNode current, SqlValidatorScope scope, String optionalClause) {
        SqlIdentifier id;
        if ((current = SqlUtil.stripAs(current)) instanceof SqlCall && !(current instanceof SqlSelect)) {
            this.checkRollUpInWindow(this.getWindowInOver(current), scope);
            current = SqlValidatorImpl.stripOver(current);
            List<SqlNode> children = ((SqlCall)this.stripDot(current)).getOperandList();
            for (SqlNode child : children) {
                this.checkRollUp(parent, current, child, scope, optionalClause);
            }
        } else if (!(!(current instanceof SqlIdentifier) || (id = (SqlIdentifier)current).isStar() || !this.isRolledUpColumn(id, scope) || SqlValidatorImpl.isAggregation(parent.getKind()) && this.isRolledUpColumnAllowedInAgg(id, scope, (SqlCall)parent, grandParent))) {
            String context = optionalClause != null ? optionalClause : parent.getKind().toString();
            throw this.newValidationError(id, Static.RESOURCE.rolledUpNotAllowed(this.deriveAlias(id, 0), context));
        }
    }

    private void checkRollUp(SqlNode grandParent, SqlNode parent, SqlNode current, SqlValidatorScope scope) {
        this.checkRollUp(grandParent, parent, current, scope, null);
    }

    private SqlWindow getWindowInOver(SqlNode over2) {
        if (over2.getKind() == SqlKind.OVER) {
            SqlNode window = ((SqlCall)over2).getOperandList().get(1);
            if (window instanceof SqlWindow) {
                return (SqlWindow)window;
            }
            return null;
        }
        return null;
    }

    private static SqlNode stripOver(SqlNode node) {
        switch (node.getKind()) {
            case OVER: {
                return ((SqlCall)node).getOperandList().get(0);
            }
        }
        return node;
    }

    private Pair<String, String> findTableColumnPair(SqlIdentifier identifier, SqlValidatorScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return new Pair<String, String>((String)names.get(names.size() - 2), Util.last(names));
    }

    private boolean isRolledUpColumnAllowedInAgg(SqlIdentifier identifier, SqlValidatorScope scope, SqlCall aggCall, SqlNode parent) {
        Pair<String, String> pair = this.findTableColumnPair(identifier, scope);
        if (pair == null) {
            return true;
        }
        String columnName = (String)pair.right;
        SqlValidatorTable sqlValidatorTable = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (sqlValidatorTable != null) {
            Table table = sqlValidatorTable.unwrap(Table.class);
            return table.rolledUpColumnValidInsideAgg(columnName, aggCall, parent, this.catalogReader.getConfig());
        }
        return true;
    }

    private boolean isRolledUpColumn(SqlIdentifier identifier, SqlValidatorScope scope) {
        Pair<String, String> pair = this.findTableColumnPair(identifier, scope);
        if (pair == null) {
            return false;
        }
        String columnName = (String)pair.right;
        SqlValidatorTable sqlValidatorTable = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (sqlValidatorTable != null) {
            Table table = sqlValidatorTable.unwrap(Table.class);
            return table.isRolledUp(columnName);
        }
        return false;
    }

    private boolean shouldCheckForRollUp(SqlNode from) {
        if (from != null) {
            SqlKind kind = SqlUtil.stripAs(from).getKind();
            return kind != SqlKind.VALUES && kind != SqlKind.SELECT;
        }
        return false;
    }

    private void validateModality(SqlNode query) {
        SqlModality modality = this.deduceModality(query);
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            this.validateModality(select, modality, true);
        } else if (query.getKind() == SqlKind.VALUES) {
            switch (modality) {
                case STREAM: {
                    throw this.newValidationError(query, Static.RESOURCE.cannotStreamValues());
                }
            }
        } else {
            assert (query.isA(SqlKind.SET_QUERY));
            SqlCall call = (SqlCall)query;
            for (SqlNode operand : call.getOperandList()) {
                if (this.deduceModality(operand) != modality) {
                    throw this.newValidationError(operand, Static.RESOURCE.streamSetOpInconsistentInputs());
                }
                this.validateModality(operand);
            }
        }
    }

    private SqlModality deduceModality(SqlNode query) {
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            return select.getModifierNode(SqlSelectKeyword.STREAM) != null ? SqlModality.STREAM : SqlModality.RELATION;
        }
        if (query.getKind() == SqlKind.VALUES) {
            return SqlModality.RELATION;
        }
        assert (query.isA(SqlKind.SET_QUERY));
        SqlCall call = (SqlCall)query;
        return this.deduceModality(call.getOperandList().get(0));
    }

    @Override
    public boolean validateModality(SqlSelect select, SqlModality modality, boolean fail) {
        SqlNodeList orderList;
        SqlNode aggregateNode;
        SelectScope scope = this.getRawSelectScope(select);
        switch (modality) {
            case STREAM: {
                if (scope.children.size() == 1) {
                    for (Object child : scope.children) {
                        if (((ScopeChild)child).namespace.supportsModality(modality)) continue;
                        if (fail) {
                            throw this.newValidationError(((ScopeChild)child).namespace.getNode(), Static.RESOURCE.cannotConvertToStream(((ScopeChild)child).name));
                        }
                        return false;
                    }
                    break;
                }
                int supportsModalityCount = 0;
                for (ScopeChild child : scope.children) {
                    if (!child.namespace.supportsModality(modality)) continue;
                    ++supportsModalityCount;
                }
                if (supportsModalityCount != 0) break;
                if (fail) {
                    String inputs = String.join((CharSequence)", ", scope.getChildNames());
                    throw this.newValidationError(select, Static.RESOURCE.cannotStreamResultsForNonStreamingInputs(inputs));
                }
                return false;
            }
            default: {
                for (Object child : scope.children) {
                    if (((ScopeChild)child).namespace.supportsModality(modality)) continue;
                    if (fail) {
                        throw this.newValidationError(((ScopeChild)child).namespace.getNode(), Static.RESOURCE.cannotConvertToRelation(((ScopeChild)child).name));
                    }
                    return false;
                }
            }
        }
        if ((aggregateNode = this.getAggregate(select)) != null) {
            switch (modality) {
                case STREAM: {
                    SqlNodeList groupList = select.getGroup();
                    if (groupList != null && SqlValidatorUtil.containsMonotonic(scope, groupList)) break;
                    if (fail) {
                        throw this.newValidationError(aggregateNode, Static.RESOURCE.streamMustGroupByMonotonic());
                    }
                    return false;
                }
            }
        }
        if ((orderList = select.getOrderList()) != null && orderList.size() > 0) {
            switch (modality) {
                case STREAM: {
                    if (this.hasSortedPrefix(scope, orderList)) break;
                    if (fail) {
                        throw this.newValidationError(orderList.get(0), Static.RESOURCE.streamMustOrderByMonotonic());
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean hasSortedPrefix(SelectScope scope, SqlNodeList orderList) {
        return this.isSortCompatible(scope, orderList.get(0), false);
    }

    private boolean isSortCompatible(SelectScope scope, SqlNode node, boolean descending) {
        switch (node.getKind()) {
            case DESCENDING: {
                return this.isSortCompatible(scope, ((SqlCall)node).getOperandList().get(0), true);
            }
        }
        SqlMonotonicity monotonicity = scope.getMonotonicity(node);
        switch (monotonicity) {
            case INCREASING: 
            case STRICTLY_INCREASING: {
                return !descending;
            }
            case DECREASING: 
            case STRICTLY_DECREASING: {
                return descending;
            }
        }
        return false;
    }

    protected void validateWindowClause(SqlSelect select) {
        SqlNodeList windowList = select.getWindowList();
        List<SqlNode> windows = windowList.getList();
        if (windows.isEmpty()) {
            return;
        }
        SelectScope windowScope = (SelectScope)this.getFromScope(select);
        assert (windowScope != null);
        for (SqlWindow sqlWindow : windows) {
            SqlIdentifier declName = sqlWindow.getDeclName();
            if (!declName.isSimple()) {
                throw this.newValidationError(declName, Static.RESOURCE.windowNameMustBeSimple());
            }
            if (windowScope.existingWindowName(declName.toString())) {
                throw this.newValidationError(declName, Static.RESOURCE.duplicateWindowName());
            }
            windowScope.addWindowName(declName.toString());
        }
        for (int i = 0; i < windows.size(); ++i) {
            SqlNode sqlNode = windows.get(i);
            for (int j2 = i + 1; j2 < windows.size(); ++j2) {
                SqlNode window2 = windows.get(j2);
                if (!sqlNode.equalsDeep(window2, Litmus.IGNORE)) continue;
                throw this.newValidationError(window2, Static.RESOURCE.dupWindowSpec());
            }
        }
        for (SqlWindow sqlWindow : windows) {
            SqlNodeList expandedOrderList = (SqlNodeList)this.expand(sqlWindow.getOrderList(), windowScope);
            sqlWindow.setOrderList(expandedOrderList);
            expandedOrderList.validate(this, windowScope);
            SqlNodeList expandedPartitionList = (SqlNodeList)this.expand(sqlWindow.getPartitionList(), windowScope);
            sqlWindow.setPartitionList(expandedPartitionList);
            expandedPartitionList.validate(this, windowScope);
        }
        windowList.validate(this, windowScope);
    }

    @Override
    public void validateWith(SqlWith with, SqlValidatorScope scope) {
        SqlValidatorNamespace namespace = this.getNamespace(with);
        this.validateNamespace(namespace, this.unknownType);
    }

    @Override
    public void validateWithItem(SqlWithItem withItem) {
        if (withItem.columnList != null) {
            RelDataType rowType = this.getValidatedNodeType(withItem.query);
            int fieldCount = rowType.getFieldCount();
            if (withItem.columnList.size() != fieldCount) {
                throw this.newValidationError(withItem.columnList, Static.RESOURCE.columnCountMismatch());
            }
            SqlValidatorUtil.checkIdentifierListForDuplicates(withItem.columnList.getList(), this.validationErrorFunction);
        } else {
            List<String> fieldNames = this.getValidatedNodeType(withItem.query).getFieldNames();
            int i = Util.firstDuplicate(fieldNames);
            if (i >= 0) {
                throw this.newValidationError(withItem.query, Static.RESOURCE.duplicateColumnAndNoColumnList(fieldNames.get(i)));
            }
        }
    }

    @Override
    public void validateSequenceValue(SqlValidatorScope scope, SqlIdentifier id) {
        SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
        scope.resolveTable(id.names, this.catalogReader.nameMatcher(), SqlValidatorScope.Path.EMPTY, resolved);
        if (resolved.count() != 1) {
            throw this.newValidationError(id, Static.RESOURCE.tableNameNotFound(id.toString()));
        }
        SqlValidatorNamespace ns = resolved.only().namespace;
        if (ns instanceof TableNamespace) {
            Table table = ns.getTable().unwrap(Table.class);
            switch (table.getJdbcTableType()) {
                case SEQUENCE: 
                case TEMPORARY_SEQUENCE: {
                    return;
                }
            }
        }
        throw this.newValidationError(id, Static.RESOURCE.notASequence(id.toString()));
    }

    @Override
    public SqlValidatorScope getWithScope(SqlNode withItem) {
        assert (withItem.getKind() == SqlKind.WITH_ITEM);
        return this.scopes.get(withItem);
    }

    protected void validateOrderList(SqlSelect select) {
        SqlNodeList orderList = select.getOrderList();
        if (orderList == null) {
            return;
        }
        if (!this.shouldAllowIntermediateOrderBy() && !this.cursorSet.contains(select)) {
            throw this.newValidationError(select, Static.RESOURCE.invalidOrderByPos());
        }
        SqlValidatorScope orderScope = this.getOrderScope(select);
        Objects.requireNonNull(orderScope);
        ArrayList<SqlNode> expandList = new ArrayList<SqlNode>();
        for (SqlNode orderItem : orderList) {
            SqlNode expandedOrderItem = this.expand(orderItem, orderScope);
            expandList.add(expandedOrderItem);
        }
        SqlNodeList expandedOrderList = new SqlNodeList(expandList, orderList.getParserPosition());
        select.setOrderBy(expandedOrderList);
        for (SqlNode orderItem : expandedOrderList) {
            this.validateOrderItem(select, orderItem);
        }
    }

    private void validateGroupByItem(SqlSelect select, SqlNode groupByItem) {
        SqlValidatorScope groupByScope = this.getGroupScope(select);
        groupByScope.validateExpr(groupByItem);
    }

    private void validateOrderItem(SqlSelect select, SqlNode orderItem) {
        switch (orderItem.getKind()) {
            case DESCENDING: {
                this.validateFeature(Static.RESOURCE.sQLConformance_OrderByDesc(), orderItem.getParserPosition());
                this.validateOrderItem(select, (SqlNode)((SqlCall)orderItem).operand(0));
                return;
            }
        }
        SqlValidatorScope orderScope = this.getOrderScope(select);
        this.validateExpr(orderItem, orderScope);
    }

    @Override
    public SqlNode expandOrderExpr(SqlSelect select, SqlNode orderExpr) {
        SqlNode newSqlNode = new OrderExpressionExpander(select, orderExpr).go();
        if (newSqlNode != orderExpr) {
            SqlValidatorScope scope = this.getOrderScope(select);
            this.inferUnknownTypes(this.unknownType, scope, newSqlNode);
            RelDataType type = this.deriveType(scope, newSqlNode);
            this.setValidatedNodeType(newSqlNode, type);
        }
        return newSqlNode;
    }

    protected void validateGroupClause(SqlSelect select) {
        SqlNodeList groupList = select.getGroup();
        if (groupList == null) {
            return;
        }
        String clause = "GROUP BY";
        this.validateNoAggs(this.aggOrOverFinder, groupList, "GROUP BY");
        SqlValidatorScope groupScope = this.getGroupScope(select);
        this.inferUnknownTypes(this.unknownType, groupScope, groupList);
        ArrayList<SqlNode> expandedList = new ArrayList<SqlNode>();
        for (SqlNode groupItem : groupList) {
            SqlNode expandedItem = this.expandGroupByOrHavingExpr(groupItem, groupScope, select, false);
            expandedList.add(expandedItem);
        }
        groupList = new SqlNodeList(expandedList, groupList.getParserPosition());
        select.setGroupBy(groupList);
        for (SqlNode groupItem : expandedList) {
            this.validateGroupByItem(select, groupItem);
        }
        block5: for (SqlNode node : groupList) {
            switch (node.getKind()) {
                case GROUPING_SETS: 
                case ROLLUP: 
                case CUBE: {
                    node.validate(this, groupScope);
                    continue block5;
                }
            }
            node.validateExpr(this, groupScope);
        }
        SqlValidatorScope selectScope = this.getSelectScope(select);
        AggregatingSelectScope aggregatingScope = null;
        if (selectScope instanceof AggregatingSelectScope) {
            aggregatingScope = (AggregatingSelectScope)selectScope;
        }
        for (SqlNode groupItem : groupList) {
            if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).size() == 0) continue;
            this.validateGroupItem(groupScope, aggregatingScope, groupItem);
        }
        SqlCall agg = this.aggFinder.findAgg(groupList);
        if (agg != null) {
            throw this.newValidationError(agg, Static.RESOURCE.aggregateIllegalInClause("GROUP BY"));
        }
    }

    private void validateGroupItem(SqlValidatorScope groupScope, AggregatingSelectScope aggregatingScope, SqlNode groupItem) {
        switch (groupItem.getKind()) {
            case GROUPING_SETS: 
            case ROLLUP: 
            case CUBE: {
                this.validateGroupingSets(groupScope, aggregatingScope, (SqlCall)groupItem);
                break;
            }
            default: {
                if (groupItem instanceof SqlNodeList) break;
                RelDataType type = this.deriveType(groupScope, groupItem);
                this.setValidatedNodeType(groupItem, type);
            }
        }
    }

    private void validateGroupingSets(SqlValidatorScope groupScope, AggregatingSelectScope aggregatingScope, SqlCall groupItem) {
        for (SqlNode node : groupItem.getOperandList()) {
            this.validateGroupItem(groupScope, aggregatingScope, node);
        }
    }

    protected void validateWhereClause(SqlSelect select) {
        SqlNode where = select.getWhere();
        if (where == null) {
            return;
        }
        SqlValidatorScope whereScope = this.getWhereScope(select);
        SqlNode expandedWhere = this.expand(where, whereScope);
        select.setWhere(expandedWhere);
        this.validateWhereOrOn(whereScope, expandedWhere, "WHERE");
    }

    protected void validateWhereOrOn(SqlValidatorScope scope, SqlNode condition, String clause) {
        this.validateNoAggs(this.aggOrOverOrGroupFinder, condition, clause);
        this.inferUnknownTypes(this.booleanType, scope, condition);
        condition.validate(this, scope);
        RelDataType type = this.deriveType(scope, condition);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(condition, Static.RESOURCE.condMustBeBoolean(clause));
        }
    }

    protected void validateHavingClause(SqlSelect select) {
        SqlNode newExpr;
        SqlNode having = select.getHaving();
        if (having == null) {
            return;
        }
        AggregatingScope havingScope = (AggregatingScope)this.getSelectScope(select);
        if (this.getConformance().isHavingAlias() && having != (newExpr = this.expandGroupByOrHavingExpr(having, havingScope, select, true))) {
            having = newExpr;
            select.setHaving(newExpr);
        }
        havingScope.checkAggregateExpr(having, true);
        this.inferUnknownTypes(this.booleanType, havingScope, having);
        having.validate(this, havingScope);
        RelDataType type = this.deriveType(havingScope, having);
        if (!SqlTypeUtil.inBooleanFamily(type)) {
            throw this.newValidationError(having, Static.RESOURCE.havingMustBeBoolean());
        }
    }

    protected RelDataType validateSelectList(SqlNodeList selectItems, SqlSelect select, RelDataType targetRowType) {
        SqlValidatorScope selectScope = this.getSelectScope(select);
        ArrayList<SqlNode> expandedSelectItems = new ArrayList<SqlNode>();
        HashSet<String> aliases = new HashSet<String>();
        ArrayList<Map.Entry<String, RelDataType>> fieldList = new ArrayList<Map.Entry<String, RelDataType>>();
        for (int i = 0; i < selectItems.size(); ++i) {
            SqlNode selectItem = selectItems.get(i);
            if (selectItem instanceof SqlSelect) {
                this.handleScalarSubQuery(select, (SqlSelect)selectItem, expandedSelectItems, aliases, fieldList);
                continue;
            }
            this.expandSelectItem(selectItem, select, targetRowType.isStruct() && targetRowType.getFieldCount() >= i ? targetRowType.getFieldList().get(i).getType() : this.unknownType, expandedSelectItems, aliases, fieldList, false);
        }
        SqlNodeList newSelectList = new SqlNodeList(expandedSelectItems, selectItems.getParserPosition());
        if (this.shouldExpandIdentifiers()) {
            select.setSelectList(newSelectList);
        }
        this.getRawSelectScope(select).setExpandedSelectList(expandedSelectItems);
        this.inferUnknownTypes(targetRowType, selectScope, newSelectList);
        for (SqlNode selectItem : expandedSelectItems) {
            this.validateNoAggs(this.groupFinder, selectItem, "SELECT");
            this.validateExpr(selectItem, selectScope);
        }
        return this.typeFactory.createStructType(fieldList);
    }

    private void validateExpr(SqlNode expr, SqlValidatorScope scope) {
        SqlOperator op;
        if (expr instanceof SqlCall && (op = ((SqlCall)expr).getOperator()).isAggregator() && op.requiresOver()) {
            throw this.newValidationError(expr, Static.RESOURCE.absentOverClause());
        }
        expr.validateExpr(this, scope);
        scope.validateExpr(expr);
    }

    private void handleScalarSubQuery(SqlSelect parentSelect, SqlSelect selectItem, List<SqlNode> expandedSelectItems, Set<String> aliasList, List<Map.Entry<String, RelDataType>> fieldList) {
        if (1 != selectItem.getSelectList().size()) {
            throw this.newValidationError(selectItem, Static.RESOURCE.onlyScalarSubQueryAllowed());
        }
        expandedSelectItems.add(selectItem);
        String alias2 = this.deriveAlias(selectItem, aliasList.size());
        aliasList.add(alias2);
        SelectScope scope = (SelectScope)this.getWhereScope(parentSelect);
        RelDataType type = this.deriveType(scope, selectItem);
        this.setValidatedNodeType(selectItem, type);
        assert (type instanceof RelRecordType);
        RelRecordType rec = (RelRecordType)type;
        RelDataType nodeType = rec.getFieldList().get(0).getType();
        nodeType = this.typeFactory.createTypeWithNullability(nodeType, true);
        fieldList.add(Pair.of(alias2, nodeType));
    }

    protected RelDataType createTargetRowType(SqlValidatorTable table, SqlNodeList targetColumnList, boolean append) {
        RelDataType baseRowType = table.getRowType();
        if (targetColumnList == null) {
            return baseRowType;
        }
        List<RelDataTypeField> targetFields = baseRowType.getFieldList();
        ArrayList<Map.Entry<String, RelDataType>> fields2 = new ArrayList<Map.Entry<String, RelDataType>>();
        if (append) {
            for (RelDataTypeField targetField : targetFields) {
                fields2.add(Pair.of(SqlUtil.deriveAliasFromOrdinal(fields2.size()), targetField.getType()));
            }
        }
        HashSet<Integer> assignedFields = new HashSet<Integer>();
        RelOptTable relOptTable = table instanceof RelOptTable ? (RelOptTable)((Object)table) : null;
        for (SqlNode node : targetColumnList) {
            SqlIdentifier id = (SqlIdentifier)node;
            RelDataTypeField targetField = SqlValidatorUtil.getTargetField(baseRowType, this.typeFactory, id, this.catalogReader, relOptTable);
            if (targetField == null) {
                throw this.newValidationError(id, Static.RESOURCE.unknownTargetColumn(id.toString()));
            }
            if (!assignedFields.add(targetField.getIndex())) {
                throw this.newValidationError(id, Static.RESOURCE.duplicateTargetColumn(targetField.getName()));
            }
            fields2.add(targetField);
        }
        return this.typeFactory.createStructType(fields2);
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        SqlValidatorNamespace targetNamespace = this.getNamespace(insert);
        this.validateNamespace(targetNamespace, this.unknownType);
        RelOptTable relOptTable = SqlValidatorUtil.getRelOptTable(targetNamespace, this.catalogReader.unwrap(Prepare.CatalogReader.class), null, null);
        SqlValidatorTable table = relOptTable == null ? targetNamespace.getTable() : relOptTable.unwrap(SqlValidatorTable.class);
        RelDataType targetRowType = this.createTargetRowType(table, insert.getTargetColumnList(), false);
        SqlNode source = insert.getSource();
        if (source instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)source;
            this.validateSelect(sqlSelect, targetRowType);
        } else {
            SqlValidatorScope scope = this.scopes.get(source);
            this.validateQuery(source, scope, targetRowType);
        }
        RelDataType sourceRowType = this.getNamespace(source).getRowType();
        RelDataType logicalTargetRowType = this.getLogicalTargetRowType(targetRowType, insert);
        this.setValidatedNodeType(insert, logicalTargetRowType);
        RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
        this.checkFieldCount(insert.getTargetTable(), table, source, logicalSourceRowType, logicalTargetRowType);
        this.checkTypeAssignment(logicalSourceRowType, logicalTargetRowType, insert);
        this.checkConstraint(table, source, logicalTargetRowType);
        this.validateAccess(insert.getTargetTable(), table, SqlAccessEnum.INSERT);
    }

    private void checkConstraint(SqlValidatorTable validatorTable, SqlNode source, RelDataType targetRowType) {
        ModifiableViewTable modifiableViewTable = validatorTable.unwrap(ModifiableViewTable.class);
        if (modifiableViewTable != null && source instanceof SqlCall) {
            Table table = modifiableViewTable.unwrap(Table.class);
            RelDataType tableRowType = table.getRowType(this.typeFactory);
            List<RelDataTypeField> tableFields = tableRowType.getFieldList();
            ImmutableMap<Integer, RelDataTypeField> tableIndexToTargetField = SqlValidatorUtil.getIndexToFieldMap(tableFields, targetRowType);
            Map<Integer, RexNode> projectMap = RelOptUtil.getColumnConstraints(modifiableViewTable, targetRowType, this.typeFactory);
            ImmutableBitSet targetColumns = ImmutableBitSet.of(tableIndexToTargetField.keySet());
            ImmutableBitSet constrainedColumns = ImmutableBitSet.of(projectMap.keySet());
            ImmutableBitSet constrainedTargetColumns = targetColumns.intersect(constrainedColumns);
            List<SqlNode> values = ((SqlCall)source).getOperandList();
            for (int colIndex : constrainedTargetColumns.asList()) {
                String colName = tableFields.get(colIndex).getName();
                RelDataTypeField targetField = (RelDataTypeField)tableIndexToTargetField.get(colIndex);
                for (SqlNode row : values) {
                    SqlCall call = (SqlCall)row;
                    Object sourceValue = call.operand(targetField.getIndex());
                    ValidationError validationError = new ValidationError((SqlNode)sourceValue, Static.RESOURCE.viewConstraintNotSatisfied(colName, Util.last(validatorTable.getQualifiedName())));
                    RelOptUtil.validateValueAgainstConstraint(sourceValue, projectMap.get(colIndex), validationError);
                }
            }
        }
    }

    private void checkConstraint(SqlValidatorTable validatorTable, SqlUpdate update, RelDataType targetRowType) {
        ModifiableViewTable modifiableViewTable = validatorTable.unwrap(ModifiableViewTable.class);
        if (modifiableViewTable != null) {
            Table table = modifiableViewTable.unwrap(Table.class);
            RelDataType tableRowType = table.getRowType(this.typeFactory);
            Map<Integer, RexNode> projectMap = RelOptUtil.getColumnConstraints(modifiableViewTable, targetRowType, this.typeFactory);
            Map<String, Integer> nameToIndex = SqlValidatorUtil.mapNameToIndex(tableRowType.getFieldList());
            List<SqlNode> targets = update.getTargetColumnList().getList();
            List<SqlNode> sources = update.getSourceExpressionList().getList();
            for (Pair<SqlNode, SqlNode> column : Pair.zip(targets, sources)) {
                String columnName = ((SqlIdentifier)column.left).getSimple();
                Integer columnIndex = nameToIndex.get(columnName);
                if (!projectMap.containsKey(columnIndex)) continue;
                RexNode columnConstraint = projectMap.get(columnIndex);
                ValidationError validationError = new ValidationError((SqlNode)column.right, Static.RESOURCE.viewConstraintNotSatisfied(columnName, Util.last(validatorTable.getQualifiedName())));
                RelOptUtil.validateValueAgainstConstraint((SqlNode)column.right, columnConstraint, validationError);
            }
        }
    }

    private void checkFieldCount(SqlNode node, SqlValidatorTable table, SqlNode source, RelDataType logicalSourceRowType, RelDataType logicalTargetRowType) {
        int targetFieldCount;
        int sourceFieldCount = logicalSourceRowType.getFieldCount();
        if (sourceFieldCount != (targetFieldCount = logicalTargetRowType.getFieldCount())) {
            throw this.newValidationError(node, Static.RESOURCE.unmatchInsertColumn(targetFieldCount, sourceFieldCount));
        }
        InitializerContext rexBuilder = new InitializerContext(){

            @Override
            public RexBuilder getRexBuilder() {
                return new RexBuilder(SqlValidatorImpl.this.typeFactory);
            }

            @Override
            public RexNode convertExpression(SqlNode e) {
                throw new UnsupportedOperationException();
            }
        };
        List<ColumnStrategy> strategies = table.unwrap(RelOptTable.class).getColumnStrategies();
        for (RelDataTypeField field : table.getRowType().getFieldList()) {
            RelDataTypeField targetField = logicalTargetRowType.getField(field.getName(), true, false);
            switch (strategies.get(field.getIndex())) {
                case NOT_NULLABLE: {
                    assert (!field.getType().isNullable());
                    if (targetField != null) break;
                    throw this.newValidationError(node, Static.RESOURCE.columnNotNullable(field.getName()));
                }
                case NULLABLE: {
                    assert (field.getType().isNullable());
                    break;
                }
                case VIRTUAL: 
                case STORED: {
                    if (targetField == null || this.isValuesWithDefault(source, targetField.getIndex())) break;
                    throw this.newValidationError(node, Static.RESOURCE.insertIntoAlwaysGenerated(field.getName()));
                }
            }
        }
    }

    private boolean isValuesWithDefault(SqlNode source, int column) {
        switch (source.getKind()) {
            case VALUES: {
                for (SqlNode operand : ((SqlCall)source).getOperandList()) {
                    if (this.isRowWithDefault(operand, column)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isRowWithDefault(SqlNode operand, int column) {
        switch (operand.getKind()) {
            case ROW: {
                SqlCall row = (SqlCall)operand;
                return row.getOperandList().size() >= column && row.getOperandList().get(column).getKind() == SqlKind.DEFAULT;
            }
        }
        return false;
    }

    protected RelDataType getLogicalTargetRowType(RelDataType targetRowType, SqlInsert insert) {
        if (insert.getTargetColumnList() == null && this.conformance.isInsertSubsetColumnsAllowed()) {
            SqlNode source = insert.getSource();
            RelDataType sourceRowType = this.getNamespace(source).getRowType();
            RelDataType logicalSourceRowType = this.getLogicalSourceRowType(sourceRowType, insert);
            RelDataType implicitTargetRowType = this.typeFactory.createStructType(targetRowType.getFieldList().subList(0, logicalSourceRowType.getFieldCount()));
            SqlValidatorNamespace targetNamespace = this.getNamespace(insert);
            this.validateNamespace(targetNamespace, implicitTargetRowType);
            return implicitTargetRowType;
        }
        return targetRowType;
    }

    protected RelDataType getLogicalSourceRowType(RelDataType sourceRowType, SqlInsert insert) {
        return sourceRowType;
    }

    protected void checkTypeAssignment(RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        List<RelDataTypeField> sourceFields = sourceRowType.getFieldList();
        List<RelDataTypeField> targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        for (int i = 0; i < sourceCount; ++i) {
            String targetTypeString;
            String sourceTypeString;
            RelDataType sourceType = sourceFields.get(i).getType();
            RelDataType targetType = targetFields.get(i).getType();
            if (SqlTypeUtil.canAssignFrom(targetType, sourceType)) continue;
            int iAdjusted = i;
            if (query instanceof SqlUpdate) {
                int nUpdateColumns = ((SqlUpdate)query).getTargetColumnList().size();
                assert (sourceFields.size() >= nUpdateColumns);
                iAdjusted -= sourceFields.size() - nUpdateColumns;
            }
            SqlNode node = this.getNthExpr(query, iAdjusted, sourceCount);
            if (SqlTypeUtil.areCharacterSetsMismatched(sourceType, targetType)) {
                sourceTypeString = sourceType.getFullTypeString();
                targetTypeString = targetType.getFullTypeString();
            } else {
                sourceTypeString = sourceType.toString();
                targetTypeString = targetType.toString();
            }
            throw this.newValidationError(node, Static.RESOURCE.typeNotAssignable(targetFields.get(i).getName(), targetTypeString, sourceFields.get(i).getName(), sourceTypeString));
        }
    }

    private SqlNode getNthExpr(SqlNode query, int ordinal, int sourceCount) {
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getTargetColumnList() != null) {
                return insert.getTargetColumnList().get(ordinal);
            }
            return this.getNthExpr(insert.getSource(), ordinal, sourceCount);
        }
        if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            if (update.getTargetColumnList() != null) {
                return update.getTargetColumnList().get(ordinal);
            }
            if (update.getSourceExpressionList() != null) {
                return update.getSourceExpressionList().get(ordinal);
            }
            return this.getNthExpr(update.getSourceSelect(), ordinal, sourceCount);
        }
        if (query instanceof SqlSelect) {
            SqlSelect select = (SqlSelect)query;
            if (select.getSelectList().size() == sourceCount) {
                return select.getSelectList().get(ordinal);
            }
            return query;
        }
        return query;
    }

    @Override
    public void validateDelete(SqlDelete call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        this.validateSelect(sqlSelect, this.unknownType);
        SqlValidatorNamespace targetNamespace = this.getNamespace(call);
        this.validateNamespace(targetNamespace, this.unknownType);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.DELETE);
    }

    @Override
    public void validateUpdate(SqlUpdate call) {
        SqlValidatorNamespace targetNamespace = this.getNamespace(call);
        this.validateNamespace(targetNamespace, this.unknownType);
        RelOptTable relOptTable = SqlValidatorUtil.getRelOptTable(targetNamespace, this.catalogReader.unwrap(Prepare.CatalogReader.class), null, null);
        SqlValidatorTable table = relOptTable == null ? targetNamespace.getTable() : relOptTable.unwrap(SqlValidatorTable.class);
        RelDataType targetRowType = this.createTargetRowType(table, call.getTargetColumnList(), true);
        SqlSelect select = call.getSourceSelect();
        this.validateSelect(select, targetRowType);
        RelDataType sourceRowType = this.getNamespace(call).getRowType();
        this.checkTypeAssignment(sourceRowType, targetRowType, call);
        this.checkConstraint(table, call, targetRowType);
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
    }

    @Override
    public void validateMerge(SqlMerge call) {
        SqlSelect sqlSelect = call.getSourceSelect();
        IdentifierNamespace targetNamespace = (IdentifierNamespace)this.getNamespace(call.getTargetTable());
        this.validateNamespace(targetNamespace, this.unknownType);
        SqlValidatorTable table = targetNamespace.getTable();
        this.validateAccess(call.getTargetTable(), table, SqlAccessEnum.UPDATE);
        RelDataType targetRowType = this.unknownType;
        if (call.getUpdateCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getUpdateCall().getTargetColumnList(), true);
        }
        if (call.getInsertCall() != null) {
            targetRowType = this.createTargetRowType(table, call.getInsertCall().getTargetColumnList(), false);
        }
        this.validateSelect(sqlSelect, targetRowType);
        if (call.getUpdateCall() != null) {
            this.validateUpdate(call.getUpdateCall());
        }
        if (call.getInsertCall() != null) {
            this.validateInsert(call.getInsertCall());
        }
    }

    private void validateAccess(SqlNode node, SqlValidatorTable table, SqlAccessEnum requiredAccess) {
        SqlAccessType access;
        if (table != null && !(access = table.getAllowedAccess()).allowsAccess(requiredAccess)) {
            throw this.newValidationError(node, Static.RESOURCE.accessNotAllowed(requiredAccess.name(), table.getQualifiedName().toString()));
        }
    }

    protected void validateValues(SqlCall node, RelDataType targetRowType, final SqlValidatorScope scope) {
        assert (node.getKind() == SqlKind.VALUES);
        final List<SqlNode> operands = node.getOperandList();
        for (SqlNode operand : operands) {
            if (operand.getKind() != SqlKind.ROW) {
                throw Util.needToImplement("Values function where operands are scalars");
            }
            SqlCall rowConstructor = (SqlCall)operand;
            if (this.conformance.isInsertSubsetColumnsAllowed() && targetRowType.isStruct() && rowConstructor.operandCount() < targetRowType.getFieldCount()) {
                targetRowType = this.typeFactory.createStructType(targetRowType.getFieldList().subList(0, rowConstructor.operandCount()));
            } else if (targetRowType.isStruct() && rowConstructor.operandCount() != targetRowType.getFieldCount()) {
                return;
            }
            this.inferUnknownTypes(targetRowType, scope, rowConstructor);
            if (!targetRowType.isStruct()) continue;
            for (Pair pair : Pair.zip(rowConstructor.getOperandList(), targetRowType.getFieldList())) {
                if (((RelDataTypeField)pair.right).getType().isNullable() || !SqlUtil.isNullLiteral((SqlNode)pair.left, false)) continue;
                throw this.newValidationError(node, Static.RESOURCE.columnNotNullable(((RelDataTypeField)pair.right).getName()));
            }
        }
        for (SqlNode operand : operands) {
            operand.validate(this, scope);
        }
        int rowCount = operands.size();
        if (rowCount >= 2) {
            SqlCall firstRow = (SqlCall)operands.get(0);
            int columnCount = firstRow.operandCount();
            for (SqlNode sqlNode : operands) {
                SqlCall thisRow = (SqlCall)sqlNode;
                if (columnCount == thisRow.operandCount()) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
            int col = 0;
            while (col < columnCount) {
                int n;
                RelDataType type;
                if (null != (type = this.typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(n = col++, rowCount){
                    final /* synthetic */ int val$c;
                    final /* synthetic */ int val$rowCount;
                    {
                        this.val$c = n;
                        this.val$rowCount = n2;
                    }

                    @Override
                    public RelDataType get(int row) {
                        SqlCall thisRow = (SqlCall)operands.get(row);
                        return SqlValidatorImpl.this.deriveType(scope, (SqlNode)thisRow.operand(this.val$c));
                    }

                    @Override
                    public int size() {
                        return this.val$rowCount;
                    }
                }))) continue;
                throw this.newValidationError(node, Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName()));
            }
        }
    }

    @Override
    public void validateDataType(SqlDataTypeSpec dataType2) {
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
    }

    public ValidationErrorFunction getValidationErrorFunction() {
        return this.validationErrorFunction;
    }

    @Override
    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        assert (node != null);
        SqlParserPos pos = node.getParserPosition();
        return SqlUtil.newContextException(pos, e);
    }

    protected SqlWindow getWindowByName(SqlIdentifier id, SqlValidatorScope scope) {
        SqlWindow window = null;
        if (id.isSimple()) {
            String name = id.getSimple();
            window = scope.lookupWindow(name);
        }
        if (window == null) {
            throw this.newValidationError(id, Static.RESOURCE.windowNotFound(id.toString()));
        }
        return window;
    }

    @Override
    public SqlWindow resolveWindow(SqlNode windowOrRef, SqlValidatorScope scope, boolean populateBounds) {
        SqlIdentifier refId;
        SqlWindow window = windowOrRef instanceof SqlIdentifier ? this.getWindowByName((SqlIdentifier)windowOrRef, scope) : (SqlWindow)windowOrRef;
        while ((refId = window.getRefName()) != null) {
            String refName = refId.getSimple();
            SqlWindow refWindow = scope.lookupWindow(refName);
            if (refWindow == null) {
                throw this.newValidationError(refId, Static.RESOURCE.windowNotFound(refName));
            }
            window = window.overlay(refWindow, this);
        }
        if (populateBounds) {
            window.populateBounds();
        }
        return window;
    }

    public SqlNode getOriginal(SqlNode expr) {
        SqlNode original = this.originalExprs.get(expr);
        if (original == null) {
            original = expr;
        }
        return original;
    }

    public void setOriginal(SqlNode expr, SqlNode original) {
        this.originalExprs.putIfAbsent(expr, original);
    }

    SqlValidatorNamespace lookupFieldNamespace(RelDataType rowType, String name) {
        SqlNameMatcher nameMatcher = this.catalogReader.nameMatcher();
        RelDataTypeField field = nameMatcher.field(rowType, name);
        if (field == null) {
            return null;
        }
        return new FieldNamespace(this, field.getType());
    }

    @Override
    public void validateWindow(SqlNode windowOrId, SqlValidatorScope scope, SqlCall call) {
        SqlWindow targetWindow;
        this.inWindow = true;
        switch (windowOrId.getKind()) {
            case IDENTIFIER: {
                targetWindow = this.getWindowByName((SqlIdentifier)windowOrId, scope);
                break;
            }
            case WINDOW: {
                targetWindow = (SqlWindow)windowOrId;
                break;
            }
            default: {
                throw Util.unexpected(windowOrId.getKind());
            }
        }
        assert (targetWindow.getWindowCall() == null);
        targetWindow.setWindowCall(call);
        targetWindow.validate(this, scope);
        targetWindow.setWindowCall(null);
        call.validate(this, scope);
        this.validateAggregateParams(call, null, null, scope);
        this.inWindow = false;
    }

    @Override
    public void validateMatchRecognize(SqlCall call) {
        SqlNode skipTo;
        SqlNodeList orderBy;
        SqlMatchRecognize matchRecognize = (SqlMatchRecognize)call;
        MatchRecognizeScope scope = (MatchRecognizeScope)this.getMatchRecognizeScope(matchRecognize);
        MatchRecognizeNamespace ns = this.getNamespace(call).unwrap(MatchRecognizeNamespace.class);
        assert (ns.rowType == null);
        SqlLiteral rowsPerMatch = matchRecognize.getRowsPerMatch();
        boolean allRows = rowsPerMatch != null && rowsPerMatch.getValue() == SqlMatchRecognize.RowsPerMatchOption.ALL_ROWS;
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.typeFactory.builder();
        SqlNodeList partitionBy = matchRecognize.getPartitionList();
        if (partitionBy != null) {
            for (Object node : partitionBy) {
                SqlIdentifier identifier = (SqlIdentifier)node;
                identifier.validate(this, scope);
                RelDataType type = this.deriveType(scope, identifier);
                String name = (String)identifier.names.get(1);
                ((RelDataTypeFactory.Builder)typeBuilder).add(name, type);
            }
        }
        if ((orderBy = matchRecognize.getOrderList()) != null) {
            for (SqlNode node : orderBy) {
                node.validate(this, scope);
                SqlIdentifier identifier = node instanceof SqlBasicCall ? (SqlIdentifier)((SqlBasicCall)node).getOperands()[0] : (SqlIdentifier)node;
                if (!allRows) continue;
                RelDataType type = this.deriveType(scope, identifier);
                String name = (String)identifier.names.get(1);
                if (typeBuilder.nameExists(name)) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(name, type);
            }
        }
        if (allRows) {
            SqlValidatorNamespace sqlNs = this.getNamespace(matchRecognize.getTableRef());
            RelDataType inputDataType = sqlNs.getRowType();
            for (RelDataTypeField fs : inputDataType.getFieldList()) {
                if (typeBuilder.nameExists(fs.getName())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(fs);
            }
        }
        SqlNode pattern = matchRecognize.getPattern();
        PatternVarVisitor visitor = new PatternVarVisitor(scope);
        pattern.accept(visitor);
        SqlLiteral interval = matchRecognize.getInterval();
        if (interval != null) {
            interval.validate(this, scope);
            if (((SqlIntervalLiteral)interval).signum() < 0) {
                throw this.newValidationError(interval, Static.RESOURCE.intervalMustBeNonNegative(interval.toValue()));
            }
            if (orderBy == null || orderBy.size() == 0) {
                throw this.newValidationError(interval, Static.RESOURCE.cannotUseWithinWithoutOrderBy());
            }
            SqlNode firstOrderByColumn = orderBy.getList().get(0);
            SqlIdentifier identifier = firstOrderByColumn instanceof SqlBasicCall ? (SqlIdentifier)((SqlBasicCall)firstOrderByColumn).getOperands()[0] : (SqlIdentifier)firstOrderByColumn;
            RelDataType firstOrderByColumnType = this.deriveType(scope, identifier);
            if (firstOrderByColumnType.getSqlTypeName() != SqlTypeName.TIMESTAMP) {
                throw this.newValidationError(interval, Static.RESOURCE.firstColumnOfOrderByMustBeTimestamp());
            }
            SqlNode expand = this.expand(interval, scope);
            RelDataType relDataType = this.deriveType(scope, expand);
            this.setValidatedNodeType(interval, relDataType);
        }
        this.validateDefinitions(matchRecognize, scope);
        SqlNodeList subsets = matchRecognize.getSubsetList();
        if (subsets != null && subsets.size() > 0) {
            for (SqlNode node : subsets) {
                List<SqlNode> operands = ((SqlCall)node).getOperandList();
                String string = ((SqlIdentifier)operands.get(0)).getSimple();
                if (scope.getPatternVars().contains(string)) {
                    throw this.newValidationError(operands.get(0), Static.RESOURCE.patternVarAlreadyDefined(string));
                }
                scope.addPatternVar(string);
                for (SqlNode right : (SqlNodeList)operands.get(1)) {
                    SqlIdentifier id = (SqlIdentifier)right;
                    if (!scope.getPatternVars().contains(id.getSimple())) {
                        throw this.newValidationError(id, Static.RESOURCE.unknownPattern(id.getSimple()));
                    }
                    scope.addPatternVar(id.getSimple());
                }
            }
        }
        if ((skipTo = matchRecognize.getAfter()) instanceof SqlCall) {
            SqlCall skipToCall = (SqlCall)skipTo;
            SqlIdentifier id = (SqlIdentifier)skipToCall.operand(0);
            if (!scope.getPatternVars().contains(id.getSimple())) {
                throw this.newValidationError(id, Static.RESOURCE.unknownPattern(id.getSimple()));
            }
        }
        List<Map.Entry<String, RelDataType>> measureColumns = this.validateMeasure(matchRecognize, scope, allRows);
        for (Map.Entry entry : measureColumns) {
            if (typeBuilder.nameExists((String)entry.getKey())) continue;
            ((RelDataTypeFactory.Builder)typeBuilder).add((String)entry.getKey(), (RelDataType)entry.getValue());
        }
        RelDataType rowType = typeBuilder.build();
        if (matchRecognize.getMeasureList().size() == 0) {
            ns.setType(this.getNamespace(matchRecognize.getTableRef()).getRowType());
        } else {
            ns.setType(rowType);
        }
    }

    private List<Map.Entry<String, RelDataType>> validateMeasure(SqlMatchRecognize mr, MatchRecognizeScope scope, boolean allRows) {
        ArrayList<String> aliases = new ArrayList<String>();
        ArrayList<SqlCall> sqlNodes = new ArrayList<SqlCall>();
        SqlNodeList measures = mr.getMeasureList();
        ArrayList<Map.Entry<String, RelDataType>> fields2 = new ArrayList<Map.Entry<String, RelDataType>>();
        for (SqlNode measure : measures) {
            assert (measure instanceof SqlCall);
            String alias2 = this.deriveAlias(measure, aliases.size());
            aliases.add(alias2);
            SqlNode expand = this.expand(measure, scope);
            expand = this.navigationInMeasure(expand, allRows);
            this.setOriginal(expand, measure);
            this.inferUnknownTypes(this.unknownType, scope, expand);
            RelDataType type = this.deriveType(scope, expand);
            this.setValidatedNodeType(measure, type);
            fields2.add(Pair.of(alias2, type));
            sqlNodes.add(SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, expand, new SqlIdentifier(alias2, SqlParserPos.ZERO)));
        }
        SqlNodeList list = new SqlNodeList(sqlNodes, measures.getParserPosition());
        this.inferUnknownTypes(this.unknownType, scope, list);
        for (SqlNode node : list) {
            this.validateExpr(node, scope);
        }
        mr.setOperand(5, list);
        return fields2;
    }

    private SqlNode navigationInMeasure(SqlNode node, boolean allRows) {
        Set<String> prefix = node.accept(new PatternValidator(true));
        Util.discard(prefix);
        List<SqlNode> ops = ((SqlCall)node).getOperandList();
        SqlPrefixOperator defaultOp = allRows ? SqlStdOperatorTable.RUNNING : SqlStdOperatorTable.FINAL;
        SqlNode op0 = ops.get(0);
        if (!SqlValidatorImpl.isRunningOrFinal(op0.getKind()) || !allRows && op0.getKind() == SqlKind.RUNNING) {
            SqlCall newNode = defaultOp.createCall(SqlParserPos.ZERO, op0);
            node = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, newNode, ops.get(1));
        }
        node = new NavigationExpander().go(node);
        return node;
    }

    private void validateDefinitions(SqlMatchRecognize mr, MatchRecognizeScope scope) {
        Set<String> aliases = this.catalogReader.nameMatcher().createSet();
        for (SqlNode sqlNode : mr.getPatternDefList().getList()) {
            String alias2 = SqlValidatorImpl.alias(sqlNode);
            if (!aliases.add(alias2)) {
                throw this.newValidationError(sqlNode, Static.RESOURCE.patternVarAlreadyDefined(alias2));
            }
            scope.addPatternVar(alias2);
        }
        ArrayList<SqlCall> sqlNodes = new ArrayList<SqlCall>();
        for (SqlNode item : mr.getPatternDefList().getList()) {
            String alias3 = SqlValidatorImpl.alias(item);
            SqlNode expand = this.expand(item, scope);
            expand = this.navigationInDefine(expand, alias3);
            this.setOriginal(expand, item);
            this.inferUnknownTypes(this.booleanType, scope, expand);
            expand.validate(this, scope);
            sqlNodes.add(SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, expand, new SqlIdentifier(alias3, SqlParserPos.ZERO)));
            RelDataType type = this.deriveType(scope, expand);
            if (!SqlTypeUtil.inBooleanFamily(type)) {
                throw this.newValidationError(expand, Static.RESOURCE.condMustBeBoolean("DEFINE"));
            }
            this.setValidatedNodeType(item, type);
        }
        SqlNodeList sqlNodeList = new SqlNodeList(sqlNodes, mr.getPatternDefList().getParserPosition());
        this.inferUnknownTypes(this.unknownType, scope, sqlNodeList);
        for (SqlNode node : sqlNodeList) {
            this.validateExpr(node, scope);
        }
        mr.setOperand(4, sqlNodeList);
    }

    private static String alias(SqlNode item) {
        assert (item instanceof SqlCall);
        assert (item.getKind() == SqlKind.AS);
        SqlIdentifier identifier = (SqlIdentifier)((SqlCall)item).operand(1);
        return identifier.getSimple();
    }

    private SqlNode navigationInDefine(SqlNode node, String alpha) {
        Set<String> prefix = node.accept(new PatternValidator(false));
        Util.discard(prefix);
        node = new NavigationExpander().go(node);
        node = new NavigationReplacer(alpha).go(node);
        return node;
    }

    @Override
    public void validateAggregateParams(SqlCall aggCall, SqlNode filter, SqlNodeList orderList, SqlValidatorScope scope) {
        AggFinder a = this.inWindow ? this.overFinder : this.aggOrOverFinder;
        for (SqlNode param : aggCall.getOperandList()) {
            if (a.findAgg(param) == null) continue;
            throw this.newValidationError(aggCall, Static.RESOURCE.nestedAggIllegal());
        }
        if (filter != null && a.findAgg(filter) != null) {
            throw this.newValidationError(filter, Static.RESOURCE.aggregateInFilterIllegal());
        }
        if (orderList != null) {
            for (SqlNode param : orderList) {
                if (a.findAgg(param) == null) continue;
                throw this.newValidationError(aggCall, Static.RESOURCE.aggregateInWithinGroupIllegal());
            }
        }
        SqlAggFunction op = (SqlAggFunction)aggCall.getOperator();
        switch (op.requiresGroupOrder()) {
            case MANDATORY: {
                if (orderList != null && orderList.size() != 0) break;
                throw this.newValidationError(aggCall, Static.RESOURCE.aggregateMissingWithinGroupClause(op.getName()));
            }
            case OPTIONAL: {
                break;
            }
            case IGNORED: {
                if (orderList == null) break;
                orderList.getList().clear();
                break;
            }
            case FORBIDDEN: {
                if (orderList == null || orderList.size() == 0) break;
                throw this.newValidationError(aggCall, Static.RESOURCE.withinGroupClauseIllegalInAggregate(op.getName()));
            }
            default: {
                throw new AssertionError(op);
            }
        }
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        SqlOperator operator = call.getOperator();
        if (call.operandCount() == 0 && operator.getSyntax() == SqlSyntax.FUNCTION_ID && !call.isExpanded() && !this.conformance.allowNiladicParentheses()) {
            throw this.handleUnresolvedFunction(call, (SqlFunction)operator, ImmutableList.of(), null);
        }
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        if (operator instanceof SqlFunction && ((SqlFunction)operator).getFunctionType() == SqlFunctionCategory.MATCH_RECOGNIZE && !(operandScope instanceof MatchRecognizeScope)) {
            throw this.newValidationError(call, Static.RESOURCE.functionMatchRecognizeOnly(call.toString()));
        }
        operator.validateCall(call, this, scope, operandScope);
    }

    protected void validateFeature(Feature feature, SqlParserPos context) {
        assert (feature.getProperties().get("FeatureDefinition") != null);
    }

    @Override
    public SqlNode expand(SqlNode expr, SqlValidatorScope scope) {
        Expander expander = new Expander(this, scope);
        SqlNode newExpr = expr.accept(expander);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    public SqlNode expandGroupByOrHavingExpr(SqlNode expr, SqlValidatorScope scope, SqlSelect select, boolean havingExpression) {
        ExtendedExpander expander = new ExtendedExpander(this, scope, select, expr, havingExpression);
        SqlNode newExpr = expr.accept(expander);
        if (expr != newExpr) {
            this.setOriginal(newExpr, expr);
        }
        return newExpr;
    }

    @Override
    public boolean isSystemField(RelDataTypeField field) {
        return false;
    }

    @Override
    public List<List<String>> getFieldOrigins(SqlNode sqlQuery) {
        if (sqlQuery instanceof SqlExplain) {
            return Collections.emptyList();
        }
        RelDataType rowType = this.getValidatedNodeType(sqlQuery);
        int fieldCount = rowType.getFieldCount();
        if (!sqlQuery.isA(SqlKind.QUERY)) {
            return Collections.nCopies(fieldCount, null);
        }
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (int i = 0; i < fieldCount; ++i) {
            list.add(this.getFieldOrigin(sqlQuery, i));
        }
        return ImmutableNullableList.copyOf(list);
    }

    private List<String> getFieldOrigin(SqlNode sqlQuery, int i) {
        if (sqlQuery instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)sqlQuery;
            SelectScope scope = this.getRawSelectScope(sqlSelect);
            List<SqlNode> selectList = scope.getExpandedSelectList();
            SqlNode selectItem = SqlUtil.stripAs(selectList.get(i));
            if (selectItem instanceof SqlIdentifier) {
                SqlQualified qualified = scope.fullyQualify((SqlIdentifier)selectItem);
                SqlValidatorNamespace namespace = qualified.namespace;
                SqlValidatorTable table = namespace.getTable();
                if (table == null) {
                    return null;
                }
                ArrayList<String> origin = new ArrayList<String>(table.getQualifiedName());
                for (String name : qualified.suffix()) {
                    if ((namespace = namespace.lookupChild(name)) == null) {
                        return null;
                    }
                    origin.add(name);
                }
                return origin;
            }
            return null;
        }
        if (sqlQuery instanceof SqlOrderBy) {
            return this.getFieldOrigin(((SqlOrderBy)sqlQuery).query, i);
        }
        return null;
    }

    @Override
    public RelDataType getParameterRowType(SqlNode sqlQuery) {
        final ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        final HashSet alreadyVisited = new HashSet();
        sqlQuery.accept(new SqlShuttle(){

            @Override
            public SqlNode visit(SqlDynamicParam param) {
                if (alreadyVisited.add(param)) {
                    RelDataType type = SqlValidatorImpl.this.getValidatedNodeType(param);
                    types.add(type);
                }
                return param;
            }
        });
        return this.typeFactory.createStructType(types, (List<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                return "?" + index;
            }

            @Override
            public int size() {
                return types.size();
            }
        });
    }

    @Override
    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
        throw new UnsupportedOperationException();
    }

    private static boolean isPhysicalNavigation(SqlKind kind) {
        return kind == SqlKind.PREV || kind == SqlKind.NEXT;
    }

    private static boolean isLogicalNavigation(SqlKind kind) {
        return kind == SqlKind.FIRST || kind == SqlKind.LAST;
    }

    private static boolean isAggregation(SqlKind kind) {
        return kind == SqlKind.SUM || kind == SqlKind.SUM0 || kind == SqlKind.AVG || kind == SqlKind.COUNT || kind == SqlKind.MAX || kind == SqlKind.MIN;
    }

    private static boolean isRunningOrFinal(SqlKind kind) {
        return kind == SqlKind.RUNNING || kind == SqlKind.FINAL;
    }

    private static boolean isSingleVarRequired(SqlKind kind) {
        return SqlValidatorImpl.isPhysicalNavigation(kind) || SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isAggregation(kind);
    }

    public static enum Status {
        UNVALIDATED,
        IN_PROGRESS,
        VALID;

    }

    private class Permute {
        final List<ImmutableIntList> sources;
        final RelDataType rowType;
        final boolean trivial;

        Permute(SqlNode from, int offset) {
            switch (from.getKind()) {
                case JOIN: {
                    ImmutableIntList source;
                    SqlJoin join = (SqlJoin)from;
                    Permute left = new Permute(join.getLeft(), offset);
                    int fieldCount = SqlValidatorImpl.this.getValidatedNodeType(join.getLeft()).getFieldList().size();
                    Permute right = new Permute(join.getRight(), offset + fieldCount);
                    List<String> names = this.usingNames(join);
                    ArrayList<ImmutableIntList> sources = new ArrayList<ImmutableIntList>();
                    HashSet<ImmutableIntList> sourceSet = new HashSet<ImmutableIntList>();
                    RelDataTypeFactory.FieldInfoBuilder b = SqlValidatorImpl.this.typeFactory.builder();
                    if (names != null) {
                        for (String name : names) {
                            RelDataTypeField f = left.field(name);
                            ImmutableIntList source2 = left.sources.get(f.getIndex());
                            sourceSet.add(source2);
                            RelDataTypeField f2 = right.field(name);
                            ImmutableIntList source22 = right.sources.get(f2.getIndex());
                            sourceSet.add(source22);
                            sources.add(source2.appendAll(source22));
                            boolean nullable = !(!f.getType().isNullable() && !join.getJoinType().generatesNullsOnLeft() || !f2.getType().isNullable() && !join.getJoinType().generatesNullsOnRight());
                            ((RelDataTypeFactory.Builder)b).add(f).nullable(nullable);
                        }
                    }
                    for (RelDataTypeField f : left.rowType.getFieldList()) {
                        source = left.sources.get(f.getIndex());
                        if (!sourceSet.add(source)) continue;
                        sources.add(source);
                        ((RelDataTypeFactory.Builder)b).add(f);
                    }
                    for (RelDataTypeField f : right.rowType.getFieldList()) {
                        source = right.sources.get(f.getIndex());
                        if (!sourceSet.add(source)) continue;
                        sources.add(source);
                        ((RelDataTypeFactory.Builder)b).add(f);
                    }
                    this.rowType = b.build();
                    this.sources = ImmutableList.copyOf(sources);
                    this.trivial = left.trivial && right.trivial && (names == null || names.isEmpty());
                    break;
                }
                default: {
                    this.rowType = SqlValidatorImpl.this.getValidatedNodeType(from);
                    this.sources = Functions.generate(this.rowType.getFieldCount(), i -> ImmutableIntList.of(offset + i));
                    this.trivial = true;
                }
            }
        }

        private RelDataTypeField field(String name) {
            return SqlValidatorImpl.this.catalogReader.nameMatcher().field(this.rowType, name);
        }

        private List<String> usingNames(SqlJoin join) {
            switch (join.getConditionType()) {
                case USING: {
                    ImmutableList.Builder list = ImmutableList.builder();
                    Set<String> names = SqlValidatorImpl.this.catalogReader.nameMatcher().createSet();
                    for (SqlNode node : (SqlNodeList)join.getCondition()) {
                        String name = ((SqlIdentifier)node).getSimple();
                        if (!names.add(name)) continue;
                        list.add(name);
                    }
                    return list.build();
                }
                case NONE: {
                    if (!join.isNatural()) break;
                    RelDataType t0 = SqlValidatorImpl.this.getValidatedNodeType(join.getLeft());
                    RelDataType t1 = SqlValidatorImpl.this.getValidatedNodeType(join.getRight());
                    return SqlValidatorUtil.deriveNaturalJoinColumnList(SqlValidatorImpl.this.catalogReader.nameMatcher(), t0, t1);
                }
            }
            return null;
        }

        public void permute(List<SqlNode> selectItems, List<Map.Entry<String, RelDataType>> fields2) {
            if (this.trivial) {
                return;
            }
            ImmutableList<SqlNode> oldSelectItems = ImmutableList.copyOf(selectItems);
            selectItems.clear();
            ImmutableList<Map.Entry<String, RelDataType>> oldFields = ImmutableList.copyOf(fields2);
            fields2.clear();
            for (ImmutableIntList source : this.sources) {
                int p0 = source.get(0);
                Map.Entry field = (Map.Entry)oldFields.get(p0);
                String name = (String)field.getKey();
                RelDataType type = (RelDataType)field.getValue();
                SqlNode selectItem = (SqlNode)oldSelectItems.get(p0);
                for (int p1 : Util.skip(source)) {
                    Map.Entry field1 = (Map.Entry)oldFields.get(p1);
                    SqlNode selectItem1 = (SqlNode)oldSelectItems.get(p1);
                    RelDataType type1 = (RelDataType)field1.getValue();
                    boolean nullable = type.isNullable() && type1.isNullable();
                    RelDataType type2 = SqlTypeUtil.leastRestrictiveForComparison(SqlValidatorImpl.this.typeFactory, type, type1);
                    selectItem = SqlStdOperatorTable.AS.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.COALESCE.createCall(SqlParserPos.ZERO, SqlValidatorImpl.this.maybeCast(selectItem, type, type2), SqlValidatorImpl.this.maybeCast(selectItem1, type1, type2)), new SqlIdentifier(name, SqlParserPos.ZERO));
                    type = SqlValidatorImpl.this.typeFactory.createTypeWithNullability(type2, nullable);
                }
                fields2.add(Pair.of(name, type));
                selectItems.add(selectItem);
            }
        }
    }

    private class PatternValidator
    extends SqlBasicVisitor<Set<String>> {
        private final boolean isMeasure;
        int firstLastCount;
        int prevNextCount;
        int aggregateCount;

        PatternValidator(boolean isMeasure) {
            this(isMeasure, 0, 0, 0);
        }

        PatternValidator(boolean isMeasure, int firstLastCount, int prevNextCount, int aggregateCount) {
            this.isMeasure = isMeasure;
            this.firstLastCount = firstLastCount;
            this.prevNextCount = prevNextCount;
            this.aggregateCount = aggregateCount;
        }

        @Override
        public Set<String> visit(SqlCall call) {
            boolean isSingle = false;
            HashSet<String> vars = new HashSet<String>();
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            if (SqlValidatorImpl.isSingleVarRequired(kind)) {
                isSingle = true;
                if (SqlValidatorImpl.isPhysicalNavigation(kind)) {
                    if (this.isMeasure) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionInMeasure(call.toString()));
                    }
                    if (this.firstLastCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionOrder(call.toString()));
                    }
                    ++this.prevNextCount;
                } else if (SqlValidatorImpl.isLogicalNavigation(kind)) {
                    if (this.firstLastCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternPrevFunctionOrder(call.toString()));
                    }
                    ++this.firstLastCount;
                } else if (SqlValidatorImpl.isAggregation(kind)) {
                    if (this.firstLastCount != 0 || this.prevNextCount != 0) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternAggregationInNavigation(call.toString()));
                    }
                    if (kind == SqlKind.COUNT && call.getOperandList().size() > 1) {
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternCountFunctionArg());
                    }
                    ++this.aggregateCount;
                }
            }
            if (SqlValidatorImpl.isRunningOrFinal(kind) && !this.isMeasure) {
                throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternRunningFunctionInDefine(call.toString()));
            }
            for (SqlNode node : operands) {
                if (node == null) continue;
                vars.addAll((Collection<String>)node.accept(new PatternValidator(this.isMeasure, this.firstLastCount, this.prevNextCount, this.aggregateCount)));
            }
            if (isSingle) {
                switch (kind) {
                    case COUNT: {
                        if (vars.size() <= 1) break;
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternCountFunctionArg());
                    }
                    default: {
                        if (operands.size() != 0 && operands.get(0) instanceof SqlCall && ((SqlCall)operands.get(0)).getOperator() == SqlStdOperatorTable.CLASSIFIER) break;
                        if (vars.isEmpty()) {
                            throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternFunctionNullCheck(call.toString()));
                        }
                        if (vars.size() == 1) break;
                        throw SqlValidatorImpl.this.newValidationError(call, Static.RESOURCE.patternFunctionVariableCheck(call.toString()));
                    }
                }
            }
            return vars;
        }

        @Override
        public Set<String> visit(SqlIdentifier identifier) {
            boolean check = this.prevNextCount > 0 || this.firstLastCount > 0 || this.aggregateCount > 0;
            HashSet<String> vars = new HashSet<String>();
            if (identifier.names.size() > 1 && check) {
                vars.add((String)identifier.names.get(0));
            }
            return vars;
        }

        @Override
        public Set<String> visit(SqlLiteral literal) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlIntervalQualifier qualifier) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlDataTypeSpec type) {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> visit(SqlDynamicParam param) {
            return ImmutableSet.of();
        }
    }

    private static class NavigationReplacer
    extends NavigationModifier {
        private final String alpha;

        NavigationReplacer(String alpha) {
            this.alpha = alpha;
        }

        @Override
        public SqlNode visit(SqlCall call) {
            SqlKind kind = call.getKind();
            if (SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isAggregation(kind) || SqlValidatorImpl.isRunningOrFinal(kind)) {
                return call;
            }
            switch (kind) {
                case PREV: {
                    List<SqlNode> operands = call.getOperandList();
                    if (!(operands.get(0) instanceof SqlIdentifier)) break;
                    String name = (String)((SqlIdentifier)operands.get((int)0)).names.get(0);
                    return name.equals(this.alpha) ? call : SqlStdOperatorTable.LAST.createCall(SqlParserPos.ZERO, operands);
                }
            }
            return super.visit(call);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple()) {
                return id;
            }
            SqlFunction operator = ((String)id.names.get(0)).equals(this.alpha) ? SqlStdOperatorTable.PREV : SqlStdOperatorTable.LAST;
            return operator.createCall(SqlParserPos.ZERO, id, SqlLiteral.createExactNumeric("0", SqlParserPos.ZERO));
        }
    }

    private static class NavigationExpander
    extends NavigationModifier {
        final SqlOperator op;
        final SqlNode offset;

        NavigationExpander() {
            this(null, null);
        }

        NavigationExpander(SqlOperator operator, SqlNode offset) {
            this.offset = offset;
            this.op = operator;
        }

        @Override
        public SqlNode visit(SqlCall call) {
            SqlKind kind = call.getKind();
            List<SqlNode> operands = call.getOperandList();
            ArrayList<SqlNode> newOperands = new ArrayList<SqlNode>();
            if (SqlValidatorImpl.isLogicalNavigation(kind) || SqlValidatorImpl.isPhysicalNavigation(kind)) {
                SqlKind innerKind;
                SqlNode inner = operands.get(0);
                SqlNode offset = operands.get(1);
                if (SqlValidatorImpl.isPhysicalNavigation(kind) && SqlValidatorImpl.isPhysicalNavigation(innerKind = inner.getKind())) {
                    List<SqlNode> innerOperands = ((SqlCall)inner).getOperandList();
                    SqlNode innerOffset = innerOperands.get(1);
                    SqlBinaryOperator newOperator = innerKind == kind ? SqlStdOperatorTable.PLUS : SqlStdOperatorTable.MINUS;
                    offset = newOperator.createCall(SqlParserPos.ZERO, offset, innerOffset);
                    inner = call.getOperator().createCall(SqlParserPos.ZERO, innerOperands.get(0), offset);
                }
                SqlNode newInnerNode = inner.accept(new NavigationExpander(call.getOperator(), offset));
                if (this.op != null) {
                    newInnerNode = this.op.createCall(SqlParserPos.ZERO, newInnerNode, this.offset);
                }
                return newInnerNode;
            }
            if (operands.size() > 0) {
                for (SqlNode node : operands) {
                    if (node != null) {
                        SqlNode newNode = node.accept(new NavigationExpander());
                        if (this.op != null) {
                            newNode = this.op.createCall(SqlParserPos.ZERO, newNode, this.offset);
                        }
                        newOperands.add(newNode);
                        continue;
                    }
                    newOperands.add(null);
                }
                return call.getOperator().createCall(SqlParserPos.ZERO, newOperands);
            }
            if (this.op == null) {
                return call;
            }
            return this.op.createCall(SqlParserPos.ZERO, call, this.offset);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (this.op == null) {
                return id;
            }
            return this.op.createCall(SqlParserPos.ZERO, id, this.offset);
        }
    }

    private static class NavigationModifier
    extends SqlShuttle {
        private NavigationModifier() {
        }

        public SqlNode go(SqlNode node) {
            return node.accept(this);
        }
    }

    protected static class FunctionParamInfo {
        public final Map<Integer, SqlSelect> cursorPosToSelectMap = new HashMap<Integer, SqlSelect>();
        public final Map<String, String> columnListParamToParentCursorMap = new HashMap<String, String>();
    }

    protected static class IdInfo {
        public final SqlValidatorScope scope;
        public final SqlIdentifier id;

        public IdInfo(SqlValidatorScope scope, SqlIdentifier id) {
            this.scope = scope;
            this.id = id;
        }
    }

    static class ExtendedExpander
    extends Expander {
        final SqlSelect select;
        final SqlNode root;
        final boolean havingExpr;

        ExtendedExpander(SqlValidatorImpl validator, SqlValidatorScope scope, SqlSelect select, SqlNode root, boolean havingExpr) {
            super(validator, scope);
            this.select = select;
            this.root = root;
            this.havingExpr = havingExpr;
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && (this.havingExpr ? this.validator.getConformance().isHavingAlias() : this.validator.getConformance().isGroupByAlias())) {
                String name = id.getSimple();
                SqlNode expr = null;
                SqlNameMatcher nameMatcher = this.validator.catalogReader.nameMatcher();
                int n = 0;
                for (SqlNode s : this.select.getSelectList()) {
                    String alias2 = SqlValidatorUtil.getAlias(s, -1);
                    if (alias2 == null || !nameMatcher.matches(alias2, name)) continue;
                    expr = s;
                    ++n;
                }
                if (n == 0) {
                    return super.visit(id);
                }
                if (n > 1) {
                    throw this.validator.newValidationError(id, Static.RESOURCE.columnAmbiguous(name));
                }
                if (this.havingExpr && this.validator.isAggregate(this.root)) {
                    return super.visit(id);
                }
                if ((expr = SqlUtil.stripAs(expr)) instanceof SqlIdentifier) {
                    SqlIdentifier sid = (SqlIdentifier)expr;
                    SqlIdentifier fqId = this.getScope().fullyQualify((SqlIdentifier)sid).identifier;
                    expr = this.expandDynamicStar(sid, fqId);
                }
                return expr;
            }
            return super.visit(id);
        }

        @Override
        public SqlNode visit(SqlLiteral literal) {
            if (this.havingExpr || !this.validator.getConformance().isGroupByOrdinal()) {
                return super.visit(literal);
            }
            boolean isOrdinalLiteral = literal == this.root;
            block0 : switch (this.root.getKind()) {
                case GROUPING_SETS: 
                case ROLLUP: 
                case CUBE: {
                    if (!(this.root instanceof SqlBasicCall)) break;
                    List<SqlNode> operandList = ((SqlBasicCall)this.root).getOperandList();
                    for (SqlNode node : operandList) {
                        if (!node.equals(literal)) continue;
                        isOrdinalLiteral = true;
                        break block0;
                    }
                    break;
                }
            }
            if (isOrdinalLiteral) {
                switch (literal.getTypeName()) {
                    case DECIMAL: 
                    case DOUBLE: {
                        int intValue = literal.intValue(false);
                        if (intValue < 0) break;
                        if (intValue < 1 || intValue > this.select.getSelectList().size()) {
                            throw this.validator.newValidationError(literal, Static.RESOURCE.orderByOrdinalOutOfRange());
                        }
                        int ordinal = intValue - 1;
                        return SqlUtil.stripAs(this.select.getSelectList().get(ordinal));
                    }
                }
            }
            return super.visit(literal);
        }
    }

    class OrderExpressionExpander
    extends SqlScopedShuttle {
        private final List<String> aliasList;
        private final SqlSelect select;
        private final SqlNode root;

        OrderExpressionExpander(SqlSelect select, SqlNode root) {
            super(SqlValidatorImpl.this.getOrderScope(select));
            this.select = select;
            this.root = root;
            this.aliasList = SqlValidatorImpl.this.getNamespace(select).getRowType().getFieldNames();
        }

        public SqlNode go() {
            return this.root.accept(this);
        }

        @Override
        public SqlNode visit(SqlLiteral literal) {
            if (literal == this.root && SqlValidatorImpl.this.getConformance().isSortByOrdinal()) {
                switch (literal.getTypeName()) {
                    case DECIMAL: 
                    case DOUBLE: {
                        int intValue = literal.intValue(false);
                        if (intValue < 0) break;
                        if (intValue < 1 || intValue > this.aliasList.size()) {
                            throw SqlValidatorImpl.this.newValidationError(literal, Static.RESOURCE.orderByOrdinalOutOfRange());
                        }
                        int ordinal = intValue - 1;
                        return this.nthSelectItem(ordinal, literal.getParserPosition());
                    }
                }
            }
            return super.visit(literal);
        }

        private SqlNode nthSelectItem(int ordinal, SqlParserPos pos) {
            SqlNodeList expandedSelectList = SqlValidatorImpl.this.expandStar(this.select.getSelectList(), this.select, false);
            SqlNode expr = expandedSelectList.get(ordinal);
            if ((expr = SqlUtil.stripAs(expr)) instanceof SqlIdentifier) {
                expr = this.getScope().fullyQualify((SqlIdentifier)((SqlIdentifier)expr)).identifier;
            }
            return expr.clone(pos);
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            if (id.isSimple() && SqlValidatorImpl.this.getConformance().isSortByAlias()) {
                String alias2 = id.getSimple();
                SqlValidatorNamespace selectNs = SqlValidatorImpl.this.getNamespace(this.select);
                RelDataType rowType = selectNs.getRowTypeSansSystemColumns();
                SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                RelDataTypeField field = nameMatcher.field(rowType, alias2);
                if (field != null) {
                    return this.nthSelectItem(field.getIndex(), id.getParserPosition());
                }
            }
            return this.getScope().fullyQualify((SqlIdentifier)id).identifier;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            if (call instanceof SqlSelect) {
                return call;
            }
            return super.visitScoped(call);
        }
    }

    private static class Expander
    extends SqlScopedShuttle {
        protected final SqlValidatorImpl validator;

        Expander(SqlValidatorImpl validator, SqlValidatorScope scope) {
            super(scope);
            this.validator = validator;
        }

        @Override
        public SqlNode visit(SqlIdentifier id) {
            SqlCall call = this.validator.makeNullaryCall(id);
            if (call != null) {
                return call.accept(this);
            }
            SqlIdentifier fqId = this.getScope().fullyQualify((SqlIdentifier)id).identifier;
            SqlNode expandedExpr = this.expandDynamicStar(id, fqId);
            this.validator.setOriginal(expandedExpr, id);
            return expandedExpr;
        }

        @Override
        protected SqlNode visitScoped(SqlCall call) {
            switch (call.getKind()) {
                case WITH: 
                case SCALAR_QUERY: 
                case CURRENT_VALUE: 
                case NEXT_VALUE: {
                    return call;
                }
            }
            SqlShuttle.CallCopyingArgHandler argHandler = new SqlShuttle.CallCopyingArgHandler(call, false);
            call.getOperator().acceptCall(this, call, true, argHandler);
            SqlNode result = (SqlNode)argHandler.result();
            this.validator.setOriginal(result, call);
            return result;
        }

        protected SqlNode expandDynamicStar(SqlIdentifier id, SqlIdentifier fqId) {
            if (DynamicRecordType.isDynamicStarColName(Util.last(fqId.names)) && !DynamicRecordType.isDynamicStarColName(Util.last(id.names))) {
                SqlNode[] inputs = new SqlNode[]{fqId, SqlLiteral.createCharString(Util.last(id.names), id.getParserPosition())};
                return new SqlBasicCall(SqlStdOperatorTable.ITEM, inputs, id.getParserPosition());
            }
            return fqId;
        }
    }

    private class DeriveTypeVisitor
    implements SqlVisitor<RelDataType> {
        private final SqlValidatorScope scope;

        DeriveTypeVisitor(SqlValidatorScope scope) {
            this.scope = scope;
        }

        @Override
        public RelDataType visit(SqlLiteral literal) {
            return literal.createSqlType(SqlValidatorImpl.this.typeFactory);
        }

        @Override
        public RelDataType visit(SqlCall call) {
            SqlOperator operator = call.getOperator();
            return operator.deriveType(SqlValidatorImpl.this, this.scope, call);
        }

        @Override
        public RelDataType visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public RelDataType visit(SqlIdentifier id) {
            int i;
            SqlCall call = SqlValidatorImpl.this.makeNullaryCall(id);
            if (call != null) {
                return call.getOperator().validateOperands(SqlValidatorImpl.this, this.scope, call);
            }
            RelDataType type = null;
            if (!(this.scope instanceof EmptyScope)) {
                id = this.scope.fullyQualify((SqlIdentifier)id).identifier;
            }
            for (i = id.names.size() - 1; i > 0; --i) {
                SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                SqlValidatorScope.ResolvedImpl resolved = new SqlValidatorScope.ResolvedImpl();
                this.scope.resolve(id.names.subList(0, i), nameMatcher, false, resolved);
                if (resolved.count() != 1) continue;
                SqlValidatorScope.Resolve resolve = resolved.only();
                type = resolve.rowType();
                for (SqlValidatorScope.Step p : Util.skip(resolve.path.steps())) {
                    type = type.getFieldList().get(p.i).getType();
                }
                break;
            }
            if (type == null || id.names.size() == 1) {
                RelDataType colType = this.scope.resolveColumn((String)id.names.get(0), id);
                if (colType != null) {
                    type = colType;
                }
                ++i;
            }
            if (type == null) {
                SqlIdentifier last = id.getComponent(i - 1, i);
                throw SqlValidatorImpl.this.newValidationError(last, Static.RESOURCE.unknownIdentifier(last.toString()));
            }
            while (i < id.names.size()) {
                RelDataTypeField field;
                String name = (String)id.names.get(i);
                if (name.equals("")) {
                    name = "*";
                    field = null;
                } else {
                    SqlNameMatcher nameMatcher = SqlValidatorImpl.this.catalogReader.nameMatcher();
                    field = nameMatcher.field(type, name);
                }
                if (field == null) {
                    throw SqlValidatorImpl.this.newValidationError(id.getComponent(i), Static.RESOURCE.unknownField(name));
                }
                type = field.getType();
                ++i;
            }
            type = SqlTypeUtil.addCharsetAndCollation(type, SqlValidatorImpl.this.getTypeFactory());
            return type;
        }

        @Override
        public RelDataType visit(SqlDataTypeSpec dataType2) {
            SqlValidatorImpl.this.validateDataType(dataType2);
            return dataType2.deriveType(SqlValidatorImpl.this);
        }

        @Override
        public RelDataType visit(SqlDynamicParam param) {
            return SqlValidatorImpl.this.unknownType;
        }

        @Override
        public RelDataType visit(SqlIntervalQualifier intervalQualifier) {
            return SqlValidatorImpl.this.typeFactory.createSqlIntervalType(intervalQualifier);
        }
    }

    private class PatternVarVisitor
    implements SqlVisitor<Void> {
        private MatchRecognizeScope scope;

        PatternVarVisitor(MatchRecognizeScope scope) {
            this.scope = scope;
        }

        @Override
        public Void visit(SqlLiteral literal) {
            return null;
        }

        @Override
        public Void visit(SqlCall call) {
            for (int i = 0; i < call.getOperandList().size(); ++i) {
                call.getOperandList().get(i).accept(this);
            }
            return null;
        }

        @Override
        public Void visit(SqlNodeList nodeList) {
            throw Util.needToImplement(nodeList);
        }

        @Override
        public Void visit(SqlIdentifier id) {
            Preconditions.checkArgument(id.isSimple());
            this.scope.addPatternVar(id.getSimple());
            return null;
        }

        @Override
        public Void visit(SqlDataTypeSpec type) {
            throw Util.needToImplement(type);
        }

        @Override
        public Void visit(SqlDynamicParam param) {
            throw Util.needToImplement(param);
        }

        @Override
        public Void visit(SqlIntervalQualifier intervalQualifier) {
            throw Util.needToImplement(intervalQualifier);
        }
    }

    private static class MergeNamespace
    extends DmlNamespace {
        private final SqlMerge node;

        MergeNamespace(SqlValidatorImpl validator, SqlMerge node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node);
        }

        @Override
        public SqlMerge getNode() {
            return this.node;
        }
    }

    private static class DeleteNamespace
    extends DmlNamespace {
        private final SqlDelete node;

        DeleteNamespace(SqlValidatorImpl validator, SqlDelete node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node);
        }

        @Override
        public SqlDelete getNode() {
            return this.node;
        }
    }

    private static class UpdateNamespace
    extends DmlNamespace {
        private final SqlUpdate node;

        UpdateNamespace(SqlValidatorImpl validator, SqlUpdate node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node);
        }

        @Override
        public SqlUpdate getNode() {
            return this.node;
        }
    }

    private static class InsertNamespace
    extends DmlNamespace {
        private final SqlInsert node;

        InsertNamespace(SqlValidatorImpl validator, SqlInsert node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, node.getTargetTable(), enclosingNode, parentScope);
            this.node = Objects.requireNonNull(node);
        }

        @Override
        public SqlInsert getNode() {
            return this.node;
        }
    }

    public static class DmlNamespace
    extends IdentifierNamespace {
        protected DmlNamespace(SqlValidatorImpl validator, SqlNode id, SqlNode enclosingNode, SqlValidatorScope parentScope) {
            super(validator, id, enclosingNode, parentScope);
        }
    }

    class ValidationErrorFunction
    implements Function2<SqlNode, Resources.ExInst<SqlValidatorException>, CalciteContextException> {
        ValidationErrorFunction() {
        }

        @Override
        public CalciteContextException apply(SqlNode v0, Resources.ExInst<SqlValidatorException> v1) {
            return SqlValidatorImpl.this.newValidationError(v0, v1);
        }
    }

    private class ValidationError
    implements Supplier<CalciteContextException> {
        private final SqlNode sqlNode;
        private final Resources.ExInst<SqlValidatorException> validatorException;

        ValidationError(SqlNode sqlNode, Resources.ExInst<SqlValidatorException> validatorException) {
            this.sqlNode = sqlNode;
            this.validatorException = validatorException;
        }

        @Override
        public CalciteContextException get() {
            return SqlValidatorImpl.this.newValidationError(this.sqlNode, this.validatorException);
        }
    }
}

