/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.utils.CollectionUtils;

public class WriteTxnMarkersResponse
extends AbstractResponse {
    private static final String TXN_MARKER_ENTRY_KEY_NAME = "transaction_markers";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Map<Long, Map<TopicPartition, Errors>> errors;

    public WriteTxnMarkersResponse(Map<Long, Map<TopicPartition, Errors>> errors) {
        this.errors = errors;
    }

    public WriteTxnMarkersResponse(Struct struct) {
        Object[] responseArray;
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>();
        for (Object responseObj : responseArray = struct.getArray(TXN_MARKER_ENTRY_KEY_NAME)) {
            Object[] topicPartitionsArray;
            Struct responseStruct = (Struct)responseObj;
            long producerId = responseStruct.getLong(PRODUCER_ID_KEY_NAME);
            HashMap<TopicPartition, Errors> errorPerPartition = new HashMap<TopicPartition, Errors>();
            for (Object topicPartitionObj : topicPartitionsArray = responseStruct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
                Struct topicPartitionStruct = (Struct)topicPartitionObj;
                String topic = topicPartitionStruct.getString(TOPIC_KEY_NAME);
                for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                    Struct partitionStruct = (Struct)partitionObj;
                    Integer partition = partitionStruct.getInt(PARTITION_KEY_NAME);
                    Errors error = Errors.forCode(partitionStruct.getShort(ERROR_CODE_KEY_NAME));
                    errorPerPartition.put(new TopicPartition(topic, partition), error);
                }
            }
            errors.put(producerId, errorPerPartition);
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.WRITE_TXN_MARKERS.responseSchema(version));
        Object[] responsesArray = new Object[this.errors.size()];
        int k = 0;
        for (Map.Entry<Long, Map<TopicPartition, Errors>> responseEntry : this.errors.entrySet()) {
            Struct responseStruct = struct.instance(TXN_MARKER_ENTRY_KEY_NAME);
            responseStruct.set(PRODUCER_ID_KEY_NAME, (Object)responseEntry.getKey());
            Map<TopicPartition, Errors> partitionAndErrors = responseEntry.getValue();
            Map<String, Map<Integer, Errors>> mappedPartitions = CollectionUtils.groupDataByTopic(partitionAndErrors);
            Object[] partitionsArray = new Object[mappedPartitions.size()];
            int i = 0;
            for (Map.Entry<String, Map<Integer, Errors>> topicAndPartitions : mappedPartitions.entrySet()) {
                Struct topicPartitionsStruct = responseStruct.instance(TOPIC_PARTITIONS_KEY_NAME);
                topicPartitionsStruct.set(TOPIC_KEY_NAME, (Object)topicAndPartitions.getKey());
                Map<Integer, Errors> partitionIdAndErrors = topicAndPartitions.getValue();
                Object[] partitionAndErrorsArray = new Object[partitionIdAndErrors.size()];
                int j = 0;
                for (Map.Entry<Integer, Errors> partitionAndError : partitionIdAndErrors.entrySet()) {
                    Struct partitionAndErrorStruct = topicPartitionsStruct.instance(PARTITIONS_KEY_NAME);
                    partitionAndErrorStruct.set(PARTITION_KEY_NAME, (Object)partitionAndError.getKey());
                    partitionAndErrorStruct.set(ERROR_CODE_KEY_NAME, (Object)partitionAndError.getValue().code());
                    partitionAndErrorsArray[j++] = partitionAndErrorStruct;
                }
                topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)partitionAndErrorsArray);
                partitionsArray[i++] = topicPartitionsStruct;
            }
            responseStruct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)partitionsArray);
            responsesArray[k++] = responseStruct;
        }
        struct.set(TXN_MARKER_ENTRY_KEY_NAME, (Object)responsesArray);
        return struct;
    }

    public Map<TopicPartition, Errors> errors(long producerId) {
        return this.errors.get(producerId);
    }

    public static WriteTxnMarkersResponse parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersResponse(ApiKeys.WRITE_TXN_MARKERS.parseResponse(version, buffer));
    }
}

