/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.SerializedValue;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumer09;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.config.OffsetCommitMode;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internal.Kafka010Fetcher;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internal.Kafka010PartitionDiscoverer;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.AbstractPartitionDiscoverer;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaDeserializationSchemaWrapper;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.KafkaConsumer;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;

@PublicEvolving
public class FlinkKafkaConsumer010<T>
extends FlinkKafkaConsumer09<T> {
    private static final long serialVersionUID = 2324564345203409112L;

    public FlinkKafkaConsumer010(String topic, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(Collections.singletonList(topic), valueDeserializer, props);
    }

    public FlinkKafkaConsumer010(String topic, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(Collections.singletonList(topic), deserializer, props);
    }

    public FlinkKafkaConsumer010(List<String> topics, DeserializationSchema<T> deserializer, Properties props) {
        this(topics, new KafkaDeserializationSchemaWrapper<T>(deserializer), props);
    }

    public FlinkKafkaConsumer010(List<String> topics, KafkaDeserializationSchema<T> deserializer, Properties props) {
        super(topics, deserializer, props);
    }

    @PublicEvolving
    public FlinkKafkaConsumer010(Pattern subscriptionPattern, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(subscriptionPattern, new KafkaDeserializationSchemaWrapper<T>(valueDeserializer), props);
    }

    @PublicEvolving
    public FlinkKafkaConsumer010(Pattern subscriptionPattern, KafkaDeserializationSchema<T> deserializer, Properties props) {
        super(subscriptionPattern, deserializer, props);
    }

    @Override
    protected AbstractFetcher<T, ?> createFetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, StreamingRuntimeContext runtimeContext, OffsetCommitMode offsetCommitMode, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        FlinkKafkaConsumer010.adjustAutoCommitConfig(this.properties, offsetCommitMode);
        FlinkConnectorRateLimiter rateLimiter = super.getRateLimiter();
        if (rateLimiter != null) {
            rateLimiter.open((RuntimeContext)runtimeContext);
        }
        return new Kafka010Fetcher<T>(sourceContext, assignedPartitionsWithInitialOffsets, watermarksPeriodic, watermarksPunctuated, runtimeContext.getProcessingTimeService(), runtimeContext.getExecutionConfig().getAutoWatermarkInterval(), runtimeContext.getUserCodeClassLoader(), runtimeContext.getTaskNameWithSubtasks(), this.deserializer, this.properties, this.pollTimeout, runtimeContext.getMetricGroup(), consumerMetricGroup, useMetrics, rateLimiter);
    }

    @Override
    protected AbstractPartitionDiscoverer createPartitionDiscoverer(KafkaTopicsDescriptor topicsDescriptor, int indexOfThisSubtask, int numParallelSubtasks) {
        return new Kafka010PartitionDiscoverer(topicsDescriptor, indexOfThisSubtask, numParallelSubtasks, this.properties);
    }

    @Override
    public FlinkKafkaConsumerBase<T> setStartFromTimestamp(long startupOffsetsTimestamp) {
        return super.setStartFromTimestamp(startupOffsetsTimestamp);
    }

    @Override
    protected Map<KafkaTopicPartition, Long> fetchOffsetsWithTimestamp(Collection<KafkaTopicPartition> partitions, long timestamp) {
        HashMap<TopicPartition, Long> partitionOffsetsRequest = new HashMap<TopicPartition, Long>(partitions.size());
        for (KafkaTopicPartition partition : partitions) {
            partitionOffsetsRequest.put(new TopicPartition(partition.getTopic(), partition.getPartition()), timestamp);
        }
        HashMap<KafkaTopicPartition, Long> result = new HashMap<KafkaTopicPartition, Long>(partitions.size());
        try (KafkaConsumer consumer = new KafkaConsumer(this.properties);){
            for (Map.Entry<TopicPartition, OffsetAndTimestamp> partitionToOffset : consumer.offsetsForTimes(partitionOffsetsRequest).entrySet()) {
                result.put(new KafkaTopicPartition(partitionToOffset.getKey().topic(), partitionToOffset.getKey().partition()), partitionToOffset.getValue() == null ? null : Long.valueOf(partitionToOffset.getValue().offset()));
            }
        }
        return result;
    }
}

