/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.util.NoSuchElementException;

public enum TimestampType {
    NO_TIMESTAMP_TYPE(-1, "NoTimestampType"),
    CREATE_TIME(0, "CreateTime"),
    LOG_APPEND_TIME(1, "LogAppendTime");

    public final int id;
    public final String name;

    private TimestampType(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public byte updateAttributes(byte attributes) {
        return this == CREATE_TIME ? (byte)(attributes & 0xFFFFFFF7) : (byte)(attributes | 8);
    }

    public static TimestampType forAttributes(byte attributes) {
        int timestampType = (attributes & 8) >> 3;
        return timestampType == 0 ? CREATE_TIME : LOG_APPEND_TIME;
    }

    public static TimestampType forName(String name) {
        for (TimestampType t : TimestampType.values()) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        throw new NoSuchElementException("Invalid timestamp type " + name);
    }

    public String toString() {
        return this.name;
    }
}

