/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka010.org.apache.kafka.common.Node;

@Internal
public class KafkaTopicPartitionLeader
implements Serializable {
    private static final long serialVersionUID = 9145855900303748582L;
    private final int leaderId;
    private final int leaderPort;
    private final String leaderHost;
    private final KafkaTopicPartition topicPartition;
    private final int cachedHash;

    public KafkaTopicPartitionLeader(KafkaTopicPartition topicPartition, Node leader) {
        this.topicPartition = topicPartition;
        if (leader == null) {
            this.leaderId = -1;
            this.leaderHost = null;
            this.leaderPort = -1;
        } else {
            this.leaderId = leader.id();
            this.leaderPort = leader.port();
            this.leaderHost = leader.host();
        }
        int cachedHash = leader == null ? 14 : leader.hashCode();
        this.cachedHash = 31 * cachedHash + topicPartition.hashCode();
    }

    public KafkaTopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public Node getLeader() {
        if (this.leaderId == -1) {
            return null;
        }
        return new Node(this.leaderId, this.leaderHost, this.leaderPort);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaTopicPartitionLeader)) {
            return false;
        }
        KafkaTopicPartitionLeader that = (KafkaTopicPartitionLeader)o;
        if (!this.topicPartition.equals(that.topicPartition)) {
            return false;
        }
        return this.leaderId == that.leaderId && this.leaderPort == that.leaderPort && this.leaderHost.equals(that.leaderHost);
    }

    public int hashCode() {
        return this.cachedHash;
    }

    public String toString() {
        return "KafkaTopicPartitionLeader{leaderId=" + this.leaderId + ", leaderPort=" + this.leaderPort + ", leaderHost='" + this.leaderHost + '\'' + ", topic=" + this.topicPartition.getTopic() + ", partition=" + this.topicPartition.getPartition() + '}';
    }
}

