/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal.Handover;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internal.KafkaConsumerCallBridge09;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.ClosableBlockingQueue;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaCommitCallback;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.internals.metrics.KafkaMetricWrapper;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.ConsumerRecord;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.ConsumerRecords;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.KafkaConsumer;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import shaded.alink.kafka010.org.apache.kafka.clients.consumer.OffsetCommitCallback;
import shaded.alink.kafka010.org.apache.kafka.common.Metric;
import shaded.alink.kafka010.org.apache.kafka.common.MetricName;
import shaded.alink.kafka010.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka010.org.apache.kafka.common.errors.WakeupException;

@Internal
public class KafkaConsumerThread
extends Thread {
    private final Logger log;
    private final Handover handover;
    private final AtomicReference<Tuple2<Map<TopicPartition, OffsetAndMetadata>, KafkaCommitCallback>> nextOffsetsToCommit;
    private final Properties kafkaProperties;
    private final ClosableBlockingQueue<KafkaTopicPartitionState<TopicPartition>> unassignedPartitionsQueue;
    private final KafkaConsumerCallBridge09 consumerCallBridge;
    private final long pollTimeout;
    private final boolean useMetrics;
    @Deprecated
    private final MetricGroup subtaskMetricGroup;
    private final MetricGroup consumerMetricGroup;
    private volatile KafkaConsumer<byte[], byte[]> consumer;
    private final Object consumerReassignmentLock;
    private boolean hasAssignedPartitions;
    private volatile boolean hasBufferedWakeup;
    private volatile boolean running;
    private volatile boolean commitInProgress;
    private FlinkConnectorRateLimiter rateLimiter;

    public KafkaConsumerThread(Logger log, Handover handover, Properties kafkaProperties, ClosableBlockingQueue<KafkaTopicPartitionState<TopicPartition>> unassignedPartitionsQueue, KafkaConsumerCallBridge09 consumerCallBridge, String threadName, long pollTimeout, boolean useMetrics, MetricGroup consumerMetricGroup, MetricGroup subtaskMetricGroup, FlinkConnectorRateLimiter rateLimiter) {
        super(threadName);
        this.setDaemon(true);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
        this.handover = (Handover)Preconditions.checkNotNull((Object)handover);
        this.kafkaProperties = (Properties)Preconditions.checkNotNull((Object)kafkaProperties);
        this.consumerMetricGroup = (MetricGroup)Preconditions.checkNotNull((Object)consumerMetricGroup);
        this.subtaskMetricGroup = (MetricGroup)Preconditions.checkNotNull((Object)subtaskMetricGroup);
        this.consumerCallBridge = (KafkaConsumerCallBridge09)Preconditions.checkNotNull((Object)consumerCallBridge);
        this.unassignedPartitionsQueue = (ClosableBlockingQueue)Preconditions.checkNotNull(unassignedPartitionsQueue);
        this.pollTimeout = pollTimeout;
        this.useMetrics = useMetrics;
        this.consumerReassignmentLock = new Object();
        this.nextOffsetsToCommit = new AtomicReference();
        this.running = true;
        if (rateLimiter != null) {
            this.rateLimiter = rateLimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.running) {
            return;
        }
        Handover handover = this.handover;
        try {
            this.consumer = this.getConsumer(this.kafkaProperties);
        }
        catch (Throwable t) {
            handover.reportError(t);
            return;
        }
        try {
            if (this.useMetrics) {
                Map<MetricName, Metric> metrics = this.consumer.metrics();
                if (metrics == null) {
                    this.log.info("Consumer implementation does not support metrics");
                } else {
                    for (Map.Entry<MetricName, Metric> metric : metrics.entrySet()) {
                        this.consumerMetricGroup.gauge(metric.getKey().name(), (Gauge)new KafkaMetricWrapper(metric.getValue()));
                        this.subtaskMetricGroup.gauge(metric.getKey().name(), (Gauge)new KafkaMetricWrapper(metric.getValue()));
                    }
                }
            }
            if (!this.running) {
                return;
            }
            ConsumerRecords<byte[], byte[]> records = null;
            while (this.running) {
                block32: {
                    Tuple2 commitOffsetsAndCallback;
                    if (!this.commitInProgress && (commitOffsetsAndCallback = (Tuple2)this.nextOffsetsToCommit.getAndSet(null)) != null) {
                        this.log.debug("Sending async offset commit request to Kafka broker");
                        this.commitInProgress = true;
                        this.consumer.commitAsync((Map)commitOffsetsAndCallback.f0, new CommitCallback((KafkaCommitCallback)commitOffsetsAndCallback.f1));
                    }
                    try {
                        List<KafkaTopicPartitionState<TopicPartition>> newPartitions = this.hasAssignedPartitions ? this.unassignedPartitionsQueue.pollBatch() : this.unassignedPartitionsQueue.getBatchBlocking();
                        if (newPartitions == null) break block32;
                        this.reassignPartitions(newPartitions);
                    }
                    catch (AbortedReassignmentException e) {
                        continue;
                    }
                }
                if (!this.hasAssignedPartitions) continue;
                if (records == null) {
                    try {
                        records = this.getRecordsFromKafka();
                    }
                    catch (WakeupException we) {
                        continue;
                    }
                }
                try {
                    handover.produce(records);
                    records = null;
                }
                catch (Handover.WakeupException wakeupException) {}
            }
        }
        catch (Throwable t) {
            handover.reportError(t);
        }
        finally {
            handover.close();
            if (this.rateLimiter != null) {
                this.rateLimiter.close();
            }
            try {
                this.consumer.close();
            }
            catch (Throwable t) {
                this.log.warn("Error while closing Kafka consumer", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.running = false;
        this.unassignedPartitionsQueue.close();
        this.handover.wakeupProducer();
        Object object = this.consumerReassignmentLock;
        synchronized (object) {
            if (this.consumer != null) {
                this.consumer.wakeup();
            } else {
                this.hasBufferedWakeup = true;
            }
        }
        if (this.rateLimiter != null) {
            this.rateLimiter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOffsetsToCommit(Map<TopicPartition, OffsetAndMetadata> offsetsToCommit, @Nonnull KafkaCommitCallback commitCallback) {
        if (this.nextOffsetsToCommit.getAndSet((Tuple2<Map<TopicPartition, OffsetAndMetadata>, KafkaCommitCallback>)Tuple2.of(offsetsToCommit, (Object)commitCallback)) != null) {
            this.log.warn("Committing offsets to Kafka takes longer than the checkpoint interval. Skipping commit of previous offsets because newer complete checkpoint offsets are available. This does not compromise Flink's checkpoint integrity.");
        }
        this.handover.wakeupProducer();
        Object object = this.consumerReassignmentLock;
        synchronized (object) {
            if (this.consumer != null) {
                this.consumer.wakeup();
            } else {
                this.hasBufferedWakeup = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void reassignPartitions(List<KafkaTopicPartitionState<TopicPartition>> newPartitions) throws Exception {
        KafkaConsumer<byte[], byte[]> consumerTmp;
        if (newPartitions.size() == 0) {
            return;
        }
        this.hasAssignedPartitions = true;
        boolean reassignmentStarted = false;
        Object object = this.consumerReassignmentLock;
        synchronized (object) {
            consumerTmp = this.consumer;
            this.consumer = null;
        }
        HashMap<TopicPartition, Long> oldPartitionAssignmentsToPosition = new HashMap<TopicPartition, Long>();
        try {
            for (TopicPartition oldPartition : consumerTmp.assignment()) {
                oldPartitionAssignmentsToPosition.put(oldPartition, consumerTmp.position(oldPartition));
            }
            ArrayList<TopicPartition> newPartitionAssignments = new ArrayList<TopicPartition>(newPartitions.size() + oldPartitionAssignmentsToPosition.size());
            newPartitionAssignments.addAll(oldPartitionAssignmentsToPosition.keySet());
            newPartitionAssignments.addAll(KafkaConsumerThread.convertKafkaPartitions(newPartitions));
            this.consumerCallBridge.assignPartitions(consumerTmp, newPartitionAssignments);
            reassignmentStarted = true;
            for (Map.Entry entry : oldPartitionAssignmentsToPosition.entrySet()) {
                consumerTmp.seek((TopicPartition)entry.getKey(), (Long)entry.getValue());
            }
            for (KafkaTopicPartitionState kafkaTopicPartitionState : newPartitions) {
                if (kafkaTopicPartitionState.getOffset() == -915623761775L) {
                    this.consumerCallBridge.seekPartitionToBeginning(consumerTmp, (TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle());
                    kafkaTopicPartitionState.setOffset(consumerTmp.position((TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle()) - 1L);
                    continue;
                }
                if (kafkaTopicPartitionState.getOffset() == -915623761774L) {
                    this.consumerCallBridge.seekPartitionToEnd(consumerTmp, (TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle());
                    kafkaTopicPartitionState.setOffset(consumerTmp.position((TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle()) - 1L);
                    continue;
                }
                if (kafkaTopicPartitionState.getOffset() == -915623761773L) {
                    kafkaTopicPartitionState.setOffset(consumerTmp.position((TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle()) - 1L);
                    continue;
                }
                consumerTmp.seek((TopicPartition)kafkaTopicPartitionState.getKafkaPartitionHandle(), kafkaTopicPartitionState.getOffset() + 1L);
            }
        }
        catch (WakeupException e) {
            Object object2 = this.consumerReassignmentLock;
            synchronized (object2) {
                this.consumer = consumerTmp;
                if (reassignmentStarted) {
                    this.consumerCallBridge.assignPartitions(this.consumer, new ArrayList<TopicPartition>(oldPartitionAssignmentsToPosition.keySet()));
                    for (Map.Entry entry : oldPartitionAssignmentsToPosition.entrySet()) {
                        this.consumer.seek((TopicPartition)entry.getKey(), (Long)entry.getValue());
                    }
                }
                this.hasBufferedWakeup = false;
                for (KafkaTopicPartitionState<TopicPartition> kafkaTopicPartitionState : newPartitions) {
                    this.unassignedPartitionsQueue.add(kafkaTopicPartitionState);
                }
                throw new AbortedReassignmentException();
            }
        }
        Object object3 = this.consumerReassignmentLock;
        synchronized (object3) {
            this.consumer = consumerTmp;
            if (this.hasBufferedWakeup) {
                this.consumer.wakeup();
                this.hasBufferedWakeup = false;
            }
        }
    }

    @VisibleForTesting
    KafkaConsumer<byte[], byte[]> getConsumer(Properties kafkaProperties) {
        return new KafkaConsumer<byte[], byte[]>(kafkaProperties);
    }

    @VisibleForTesting
    FlinkConnectorRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    private int getRecordBatchSize(ConsumerRecords<byte[], byte[]> records) {
        int recordBatchSizeBytes = 0;
        for (ConsumerRecord<byte[], byte[]> consumerRecord : records) {
            if (consumerRecord.key() != null) {
                recordBatchSizeBytes += consumerRecord.key().length;
            }
            recordBatchSizeBytes += consumerRecord.value().length;
        }
        return recordBatchSizeBytes;
    }

    @VisibleForTesting
    protected ConsumerRecords<byte[], byte[]> getRecordsFromKafka() {
        ConsumerRecords<byte[], byte[]> records = this.consumer.poll(this.pollTimeout);
        if (this.rateLimiter != null) {
            int bytesRead = this.getRecordBatchSize(records);
            this.rateLimiter.acquire(bytesRead);
        }
        return records;
    }

    private static List<TopicPartition> convertKafkaPartitions(List<KafkaTopicPartitionState<TopicPartition>> partitions) {
        ArrayList<TopicPartition> result = new ArrayList<TopicPartition>(partitions.size());
        for (KafkaTopicPartitionState<TopicPartition> p : partitions) {
            result.add(p.getKafkaPartitionHandle());
        }
        return result;
    }

    private static class AbortedReassignmentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private AbortedReassignmentException() {
        }
    }

    private class CommitCallback
    implements OffsetCommitCallback {
        private final KafkaCommitCallback internalCommitCallback;

        CommitCallback(KafkaCommitCallback internalCommitCallback) {
            this.internalCommitCallback = (KafkaCommitCallback)Preconditions.checkNotNull((Object)internalCommitCallback);
        }

        @Override
        public void onComplete(Map<TopicPartition, OffsetAndMetadata> offsets, Exception ex) {
            KafkaConsumerThread.this.commitInProgress = false;
            if (ex != null) {
                KafkaConsumerThread.this.log.warn("Committing offsets to Kafka failed. This does not compromise Flink's checkpoints.", ex);
                this.internalCommitCallback.onException(ex);
            } else {
                this.internalCommitCallback.onSuccess();
            }
        }
    }
}

