/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import shaded.alink.kafka.org.apache.kafka.common.acl.AccessControlEntryFilter;
import shaded.alink.kafka.org.apache.kafka.common.acl.AclBindingFilter;
import shaded.alink.kafka.org.apache.kafka.common.errors.UnsupportedVersionException;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.ApiError;
import shaded.alink.kafka.org.apache.kafka.common.requests.DescribeAclsResponse;
import shaded.alink.kafka.org.apache.kafka.common.requests.RequestUtils;
import shaded.alink.kafka.org.apache.kafka.common.resource.PatternType;
import shaded.alink.kafka.org.apache.kafka.common.resource.ResourcePatternFilter;

public class DescribeAclsRequest
extends AbstractRequest {
    private static final Schema DESCRIBE_ACLS_REQUEST_V0 = new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME_FILTER, CommonFields.PRINCIPAL_FILTER, CommonFields.HOST_FILTER, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE);
    private static final Schema DESCRIBE_ACLS_REQUEST_V1 = new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME_FILTER, CommonFields.RESOURCE_PATTERN_TYPE_FILTER, CommonFields.PRINCIPAL_FILTER, CommonFields.HOST_FILTER, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE);
    private final AclBindingFilter filter;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_ACLS_REQUEST_V0, DESCRIBE_ACLS_REQUEST_V1};
    }

    DescribeAclsRequest(AclBindingFilter filter, short version) {
        super(ApiKeys.DELETE_ACLS, version);
        this.filter = filter;
        this.validate(filter, version);
    }

    public DescribeAclsRequest(Struct struct, short version) {
        super(ApiKeys.DELETE_ACLS, version);
        ResourcePatternFilter resourceFilter = RequestUtils.resourcePatternFilterFromStructFields(struct);
        AccessControlEntryFilter entryFilter = RequestUtils.aceFilterFromStructFields(struct);
        this.filter = new AclBindingFilter(resourceFilter, entryFilter);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.DESCRIBE_ACLS.requestSchema(this.version()));
        RequestUtils.resourcePatternFilterSetStructFields(this.filter.patternFilter(), struct);
        RequestUtils.aceFilterSetStructFields(this.filter.entryFilter(), struct);
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new DescribeAclsResponse(throttleTimeMs, ApiError.fromThrowable(throwable), Collections.emptySet());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.DESCRIBE_ACLS.latestVersion()));
    }

    public static DescribeAclsRequest parse(ByteBuffer buffer, short version) {
        return new DescribeAclsRequest(ApiKeys.DESCRIBE_ACLS.parseRequest(version, buffer), version);
    }

    public AclBindingFilter filter() {
        return this.filter;
    }

    private void validate(AclBindingFilter filter, short version) {
        if (version == 0 && filter.patternFilter().patternType() != PatternType.LITERAL && filter.patternFilter().patternType() != PatternType.ANY) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        if (filter.isUnknown()) {
            throw new IllegalArgumentException("Filter contain UNKNOWN elements");
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeAclsRequest> {
        private final AclBindingFilter filter;

        public Builder(AclBindingFilter filter) {
            super(ApiKeys.DESCRIBE_ACLS);
            this.filter = filter;
        }

        @Override
        public DescribeAclsRequest build(short version) {
            return new DescribeAclsRequest(this.filter, version);
        }

        public String toString() {
            return "(type=DescribeAclsRequest, filter=" + this.filter + ")";
        }
    }
}

