/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.ArrayOf;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    private static final String API_VERSIONS_KEY_NAME = "api_versions";
    private static final String API_KEY_NAME = "api_key";
    private static final String MIN_VERSION_KEY_NAME = "min_version";
    private static final String MAX_VERSION_KEY_NAME = "max_version";
    private static final Schema API_VERSIONS_V0 = new Schema(new Field("api_key", Type.INT16, "API key."), new Field("min_version", Type.INT16, "Minimum supported version."), new Field("max_version", Type.INT16, "Maximum supported version."));
    private static final Schema API_VERSIONS_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("api_versions", new ArrayOf(API_VERSIONS_V0), "API versions supported by the broker."));
    private static final Schema API_VERSIONS_RESPONSE_V1;
    private static final Schema API_VERSIONS_RESPONSE_V2;
    private static volatile ApiVersionsResponse defaultApiVersionsResponse;
    private final Errors error;
    private final int throttleTimeMs;
    private final Map<Short, ApiVersion> apiKeyToApiVersion;

    public static Schema[] schemaVersions() {
        return new Schema[]{API_VERSIONS_RESPONSE_V0, API_VERSIONS_RESPONSE_V1, API_VERSIONS_RESPONSE_V2};
    }

    public ApiVersionsResponse(Errors error, List<ApiVersion> apiVersions) {
        this(0, error, apiVersions);
    }

    public ApiVersionsResponse(int throttleTimeMs, Errors error, List<ApiVersion> apiVersions) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(apiVersions);
    }

    public ApiVersionsResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        ArrayList<ApiVersion> tempApiVersions = new ArrayList<ApiVersion>();
        for (Object apiVersionsObj : struct.getArray(API_VERSIONS_KEY_NAME)) {
            Struct apiVersionStruct = (Struct)apiVersionsObj;
            short apiKey = apiVersionStruct.getShort(API_KEY_NAME);
            short minVersion = apiVersionStruct.getShort(MIN_VERSION_KEY_NAME);
            short maxVersion = apiVersionStruct.getShort(MAX_VERSION_KEY_NAME);
            tempApiVersions.add(new ApiVersion(apiKey, minVersion, maxVersion));
        }
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(tempApiVersions);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.API_VERSIONS.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        ArrayList<Struct> apiVersionList = new ArrayList<Struct>();
        for (ApiVersion apiVersion : this.apiKeyToApiVersion.values()) {
            Struct apiVersionStruct = struct.instance(API_VERSIONS_KEY_NAME);
            apiVersionStruct.set(API_KEY_NAME, (Object)apiVersion.apiKey);
            apiVersionStruct.set(MIN_VERSION_KEY_NAME, (Object)apiVersion.minVersion);
            apiVersionStruct.set(MAX_VERSION_KEY_NAME, (Object)apiVersion.maxVersion);
            apiVersionList.add(apiVersionStruct);
        }
        struct.set(API_VERSIONS_KEY_NAME, (Object)apiVersionList.toArray());
        return struct;
    }

    public static ApiVersionsResponse apiVersionsResponse(int throttleTimeMs, byte maxMagic) {
        if (maxMagic == 2 && throttleTimeMs == 0) {
            return ApiVersionsResponse.defaultApiVersionsResponse();
        }
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, maxMagic);
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Collection<ApiVersion> apiVersions() {
        return this.apiKeyToApiVersion.values();
    }

    public ApiVersion apiVersion(short apiKey) {
        return this.apiKeyToApiVersion.get(apiKey);
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version) {
        return new ApiVersionsResponse(ApiKeys.API_VERSIONS.parseResponse(version, buffer));
    }

    private Map<Short, ApiVersion> buildApiKeyToApiVersion(List<ApiVersion> apiVersions) {
        HashMap<Short, ApiVersion> tempApiIdToApiVersion = new HashMap<Short, ApiVersion>();
        for (ApiVersion apiVersion : apiVersions) {
            tempApiIdToApiVersion.put(apiVersion.apiKey, apiVersion);
        }
        return tempApiIdToApiVersion;
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, byte minMagic) {
        ArrayList<ApiVersion> versionList = new ArrayList<ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            if (apiKey.minRequiredInterBrokerMagic > minMagic) continue;
            versionList.add(new ApiVersion(apiKey));
        }
        return new ApiVersionsResponse(throttleTimeMs, Errors.NONE, versionList);
    }

    public static ApiVersionsResponse defaultApiVersionsResponse() {
        if (defaultApiVersionsResponse == null) {
            defaultApiVersionsResponse = ApiVersionsResponse.createApiVersionsResponse(0, (byte)2);
        }
        return defaultApiVersionsResponse;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    static {
        API_VERSIONS_RESPONSE_V2 = API_VERSIONS_RESPONSE_V1 = new Schema(CommonFields.ERROR_CODE, new Field(API_VERSIONS_KEY_NAME, new ArrayOf(API_VERSIONS_V0), "API versions supported by the broker."), CommonFields.THROTTLE_TIME_MS);
    }

    public static final class ApiVersion {
        public final short apiKey;
        public final short minVersion;
        public final short maxVersion;

        public ApiVersion(ApiKeys apiKey) {
            this(apiKey.id, apiKey.oldestVersion(), apiKey.latestVersion());
        }

        public ApiVersion(short apiKey, short minVersion, short maxVersion) {
            this.apiKey = apiKey;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        }

        public String toString() {
            return "ApiVersion(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion= " + this.maxVersion + ")";
        }
    }
}

