/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.network;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka.org.apache.kafka.common.memory.MemoryPool;
import shaded.alink.kafka.org.apache.kafka.common.network.InvalidReceiveException;
import shaded.alink.kafka.org.apache.kafka.common.network.Receive;

public class NetworkReceive
implements Receive {
    public static final String UNKNOWN_SOURCE = "";
    public static final int UNLIMITED = -1;
    private static final Logger log = LoggerFactory.getLogger(NetworkReceive.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final String source;
    private final ByteBuffer size;
    private final int maxSize;
    private final MemoryPool memoryPool;
    private int requestedBufferSize = -1;
    private ByteBuffer buffer;

    public NetworkReceive(String source, ByteBuffer buffer) {
        this.source = source;
        this.buffer = buffer;
        this.size = null;
        this.maxSize = -1;
        this.memoryPool = MemoryPool.NONE;
    }

    public NetworkReceive(String source) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
        this.maxSize = -1;
        this.memoryPool = MemoryPool.NONE;
    }

    public NetworkReceive(int maxSize, String source) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
        this.maxSize = maxSize;
        this.memoryPool = MemoryPool.NONE;
    }

    public NetworkReceive(int maxSize, String source, MemoryPool memoryPool) {
        this.source = source;
        this.size = ByteBuffer.allocate(4);
        this.buffer = null;
        this.maxSize = maxSize;
        this.memoryPool = memoryPool;
    }

    public NetworkReceive() {
        this(UNKNOWN_SOURCE);
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public boolean complete() {
        return !this.size.hasRemaining() && this.buffer != null && !this.buffer.hasRemaining();
    }

    @Override
    public long readFrom(ScatteringByteChannel channel) throws IOException {
        int bytesRead;
        int read = 0;
        if (this.size.hasRemaining()) {
            bytesRead = channel.read(this.size);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read += bytesRead;
            if (!this.size.hasRemaining()) {
                this.size.rewind();
                int receiveSize = this.size.getInt();
                if (receiveSize < 0) {
                    throw new InvalidReceiveException("Invalid receive (size = " + receiveSize + ")");
                }
                if (this.maxSize != -1 && receiveSize > this.maxSize) {
                    throw new InvalidReceiveException("Invalid receive (size = " + receiveSize + " larger than " + this.maxSize + ")");
                }
                this.requestedBufferSize = receiveSize;
                if (receiveSize == 0) {
                    this.buffer = EMPTY_BUFFER;
                }
            }
        }
        if (this.buffer == null && this.requestedBufferSize != -1) {
            this.buffer = this.memoryPool.tryAllocate(this.requestedBufferSize);
            if (this.buffer == null) {
                log.trace("Broker low on memory - could not allocate buffer of size {} for source {}", (Object)this.requestedBufferSize, (Object)this.source);
            }
        }
        if (this.buffer != null) {
            bytesRead = channel.read(this.buffer);
            if (bytesRead < 0) {
                throw new EOFException();
            }
            read += bytesRead;
        }
        return read;
    }

    @Override
    public boolean requiredMemoryAmountKnown() {
        return this.requestedBufferSize != -1;
    }

    @Override
    public boolean memoryAllocated() {
        return this.buffer != null;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null && this.buffer != EMPTY_BUFFER) {
            this.memoryPool.release(this.buffer);
            this.buffer = null;
        }
    }

    public ByteBuffer payload() {
        return this.buffer;
    }

    public int size() {
        return this.payload().limit() + this.size.limit();
    }
}

