/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.flink.streaming.connectors.kafka.internals;

import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class KafkaTopicsDescriptor
implements Serializable {
    private static final long serialVersionUID = -3807227764764900975L;
    private final List<String> fixedTopics;
    private final Pattern topicPattern;

    public KafkaTopicsDescriptor(@Nullable List<String> fixedTopics, @Nullable Pattern topicPattern) {
        Preconditions.checkArgument((fixedTopics != null && topicPattern == null || fixedTopics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Exactly one of either fixedTopics or topicPattern must be specified.");
        if (fixedTopics != null) {
            Preconditions.checkArgument((!fixedTopics.isEmpty() ? 1 : 0) != 0, (Object)"If subscribing to a fixed topics list, the supplied list cannot be empty.");
        }
        this.fixedTopics = fixedTopics;
        this.topicPattern = topicPattern;
    }

    public boolean isFixedTopics() {
        return this.fixedTopics != null;
    }

    public boolean isTopicPattern() {
        return this.topicPattern != null;
    }

    public boolean isMatchingTopic(String topic) {
        if (this.isFixedTopics()) {
            return this.getFixedTopics().contains(topic);
        }
        return this.topicPattern.matcher(topic).matches();
    }

    public List<String> getFixedTopics() {
        return this.fixedTopics;
    }

    public String toString() {
        return this.fixedTopics == null ? "Topic Regex Pattern (" + this.topicPattern.pattern() + ")" : "Fixed Topics (" + this.fixedTopics + ")";
    }
}

