/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

@Internal
public class HiveTypeUtil {
    private HiveTypeUtil() {
    }

    public static String toHiveTypeName(DataType type) {
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
        return HiveTypeUtil.toHiveTypeInfo(type).getTypeName();
    }

    public static TypeInfo toHiveTypeInfo(DataType dataType) {
        Preconditions.checkNotNull((Object)dataType, (String)"type cannot be null");
        LogicalType logicalType = dataType.getLogicalType();
        return (TypeInfo)logicalType.accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(dataType));
    }

    public static DataType toFlinkType(ObjectInspector inspector) {
        return HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)inspector.getTypeName()));
    }

    public static DataType toFlinkType(TypeInfo hiveType) {
        Preconditions.checkNotNull((Object)hiveType, (String)"hiveType cannot be null");
        switch (hiveType.getCategory()) {
            case PRIMITIVE: {
                return HiveTypeUtil.toFlinkPrimitiveType((PrimitiveTypeInfo)hiveType);
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)hiveType;
                return DataTypes.ARRAY((DataType)HiveTypeUtil.toFlinkType(listTypeInfo.getListElementTypeInfo()));
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)hiveType;
                return DataTypes.MAP((DataType)HiveTypeUtil.toFlinkType(mapTypeInfo.getMapKeyTypeInfo()), (DataType)HiveTypeUtil.toFlinkType(mapTypeInfo.getMapValueTypeInfo()));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)hiveType;
                ArrayList names = structTypeInfo.getAllStructFieldNames();
                ArrayList typeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                DataTypes.Field[] fields = new DataTypes.Field[names.size()];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = DataTypes.FIELD((String)((String)names.get(i)), (DataType)HiveTypeUtil.toFlinkType((TypeInfo)typeInfos.get(i)));
                }
                return DataTypes.ROW((DataTypes.Field[])fields);
            }
        }
        throw new UnsupportedOperationException(String.format("Flink doesn't support Hive data type %s yet.", hiveType));
    }

    private static DataType toFlinkPrimitiveType(PrimitiveTypeInfo hiveType) {
        Preconditions.checkNotNull((Object)hiveType, (String)"hiveType cannot be null");
        switch (hiveType.getPrimitiveCategory()) {
            case CHAR: {
                return DataTypes.CHAR((int)((CharTypeInfo)hiveType).getLength());
            }
            case VARCHAR: {
                return DataTypes.VARCHAR((int)((VarcharTypeInfo)hiveType).getLength());
            }
            case STRING: {
                return DataTypes.STRING();
            }
            case BOOLEAN: {
                return DataTypes.BOOLEAN();
            }
            case BYTE: {
                return DataTypes.TINYINT();
            }
            case SHORT: {
                return DataTypes.SMALLINT();
            }
            case INT: {
                return DataTypes.INT();
            }
            case LONG: {
                return DataTypes.BIGINT();
            }
            case FLOAT: {
                return DataTypes.FLOAT();
            }
            case DOUBLE: {
                return DataTypes.DOUBLE();
            }
            case DATE: {
                return DataTypes.DATE();
            }
            case TIMESTAMP: {
                return DataTypes.TIMESTAMP();
            }
            case BINARY: {
                return DataTypes.BYTES();
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)hiveType;
                return DataTypes.DECIMAL((int)decimalTypeInfo.getPrecision(), (int)decimalTypeInfo.getScale());
            }
        }
        throw new UnsupportedOperationException(String.format("Flink doesn't support Hive primitive type %s yet", hiveType));
    }

    private static class TypeInfoLogicalTypeVisitor
    extends LogicalTypeDefaultVisitor<TypeInfo> {
        private final DataType dataType;

        public TypeInfoLogicalTypeVisitor(DataType dataType) {
            this.dataType = dataType;
        }

        public TypeInfo visit(CharType charType) {
            if (charType.getLength() > 255) {
                throw new CatalogException(String.format("HiveCatalog doesn't support char type with length of '%d'. The maximum length is %d", charType.getLength(), 255));
            }
            return TypeInfoFactory.getCharTypeInfo((int)charType.getLength());
        }

        public TypeInfo visit(VarCharType varCharType) {
            if (varCharType.getLength() == Integer.MAX_VALUE) {
                return TypeInfoFactory.stringTypeInfo;
            }
            if (varCharType.getLength() > 65535) {
                throw new CatalogException(String.format("HiveCatalog doesn't support varchar type with length of '%d'. The maximum length is %d", varCharType.getLength(), 65535));
            }
            return TypeInfoFactory.getVarcharTypeInfo((int)varCharType.getLength());
        }

        public TypeInfo visit(BooleanType booleanType) {
            return TypeInfoFactory.booleanTypeInfo;
        }

        public TypeInfo visit(VarBinaryType varBinaryType) {
            if (varBinaryType.getLength() == Integer.MAX_VALUE) {
                return TypeInfoFactory.binaryTypeInfo;
            }
            return this.defaultMethod((LogicalType)varBinaryType);
        }

        public TypeInfo visit(DecimalType decimalType) {
            return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        public TypeInfo visit(TinyIntType tinyIntType) {
            return TypeInfoFactory.byteTypeInfo;
        }

        public TypeInfo visit(SmallIntType smallIntType) {
            return TypeInfoFactory.shortTypeInfo;
        }

        public TypeInfo visit(IntType intType) {
            return TypeInfoFactory.intTypeInfo;
        }

        public TypeInfo visit(BigIntType bigIntType) {
            return TypeInfoFactory.longTypeInfo;
        }

        public TypeInfo visit(FloatType floatType) {
            return TypeInfoFactory.floatTypeInfo;
        }

        public TypeInfo visit(DoubleType doubleType) {
            return TypeInfoFactory.doubleTypeInfo;
        }

        public TypeInfo visit(DateType dateType) {
            return TypeInfoFactory.dateTypeInfo;
        }

        public TypeInfo visit(TimestampType timestampType) {
            return TypeInfoFactory.timestampTypeInfo;
        }

        public TypeInfo visit(ArrayType arrayType) {
            LogicalType elementType = arrayType.getElementType();
            TypeInfo elementTypeInfo = (TypeInfo)elementType.accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(this.dataType));
            if (null != elementTypeInfo) {
                return TypeInfoFactory.getListTypeInfo((TypeInfo)elementTypeInfo);
            }
            return this.defaultMethod((LogicalType)arrayType);
        }

        public TypeInfo visit(MapType mapType) {
            LogicalType keyType = mapType.getKeyType();
            LogicalType valueType = mapType.getValueType();
            TypeInfo keyTypeInfo = (TypeInfo)keyType.accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(this.dataType));
            TypeInfo valueTypeInfo = (TypeInfo)valueType.accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(this.dataType));
            if (null == keyTypeInfo || null == valueTypeInfo) {
                return this.defaultMethod((LogicalType)mapType);
            }
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyTypeInfo, (TypeInfo)valueTypeInfo);
        }

        public TypeInfo visit(RowType rowType) {
            List names = rowType.getFieldNames();
            ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(names.size());
            for (String name : names) {
                TypeInfo typeInfo = (TypeInfo)rowType.getTypeAt(rowType.getFieldIndex(name)).accept((LogicalTypeVisitor)new TypeInfoLogicalTypeVisitor(this.dataType));
                if (null != typeInfo) {
                    typeInfos.add(typeInfo);
                    continue;
                }
                return this.defaultMethod((LogicalType)rowType);
            }
            return TypeInfoFactory.getStructTypeInfo((List)names, typeInfos);
        }

        protected TypeInfo defaultMethod(LogicalType logicalType) {
            throw new UnsupportedOperationException(String.format("Flink doesn't support converting type %s to Hive type yet.", this.dataType.toString()));
        }
    }
}

