/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HiveTableUtil {
    private HiveTableUtil() {
    }

    public static TableSchema createTableSchema(List<FieldSchema> cols, List<FieldSchema> partitionKeys) {
        ArrayList<FieldSchema> allCols = new ArrayList<FieldSchema>(cols);
        allCols.addAll(partitionKeys);
        String[] colNames = new String[allCols.size()];
        DataType[] colTypes = new DataType[allCols.size()];
        for (int i = 0; i < allCols.size(); ++i) {
            FieldSchema fs = (FieldSchema)allCols.get(i);
            colNames[i] = fs.getName();
            colTypes[i] = HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)fs.getType()));
        }
        return TableSchema.builder().fields(colNames, colTypes).build();
    }

    public static List<FieldSchema> createHiveColumns(TableSchema schema) {
        String[] fieldNames = schema.getFieldNames();
        DataType[] fieldTypes = schema.getFieldDataTypes();
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>(fieldNames.length);
        for (int i = 0; i < fieldNames.length; ++i) {
            columns.add(new FieldSchema(fieldNames[i], HiveTypeUtil.toHiveTypeName(fieldTypes[i]), null));
        }
        return columns;
    }

    public static Properties createPropertiesFromStorageDescriptor(StorageDescriptor storageDescriptor) {
        SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
        Map parameters = serDeInfo.getParameters();
        Properties properties = new Properties();
        properties.setProperty("serialization.format", (String)parameters.get("serialization.format"));
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colNames = new ArrayList<String>();
        List cols = storageDescriptor.getCols();
        for (FieldSchema col : cols) {
            colTypes.add(col.getType());
            colNames.add(col.getName());
        }
        properties.setProperty("columns", StringUtils.join(colNames, (String)String.valueOf(',')));
        properties.setProperty("column.name.delimite", String.valueOf(','));
        properties.setProperty("columns.types", StringUtils.join(colTypes, (String)":"));
        properties.setProperty("serialization.null.format", "NULL");
        properties.putAll((Map<?, ?>)parameters);
        return properties;
    }

    public static Partition createHivePartition(String dbName, String tableName, List<String> values, StorageDescriptor sd, Map<String, String> parameters) {
        Partition partition = new Partition();
        partition.setDbName(dbName);
        partition.setTableName(tableName);
        partition.setValues(values);
        partition.setParameters(parameters);
        partition.setSd(sd);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        partition.setCreateTime(currentTime);
        partition.setLastAccessTime(currentTime);
        return partition;
    }
}

