/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.hive.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.util.HiveTypeUtil;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStatsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStatsUtil.class);
    public static final String DEFAULT_STATS_ZERO_CONST = "0";

    private HiveStatsUtil() {
    }

    public static Map<String, CatalogColumnStatisticsDataBase> createCatalogColumnStats(@Nonnull List<ColumnStatisticsObj> hiveColStats) {
        Preconditions.checkNotNull(hiveColStats, (String)"hiveColStats can not be null");
        HashMap<String, CatalogColumnStatisticsDataBase> colStats = new HashMap<String, CatalogColumnStatisticsDataBase>();
        for (ColumnStatisticsObj colStatsObj : hiveColStats) {
            CatalogColumnStatisticsDataBase columnStats = HiveStatsUtil.createTableColumnStats(HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)colStatsObj.getColType())), colStatsObj.getStatsData());
            colStats.put(colStatsObj.getColName(), columnStats);
        }
        return colStats;
    }

    public static ColumnStatistics createTableColumnStats(Table hiveTable, Map<String, CatalogColumnStatisticsDataBase> colStats) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(true, hiveTable.getDbName(), hiveTable.getTableName());
        return HiveStatsUtil.createHiveColumnStatistics(colStats, hiveTable.getSd(), desc);
    }

    public static ColumnStatistics createPartitionColumnStats(Partition hivePartition, String partName, Map<String, CatalogColumnStatisticsDataBase> colStats) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc(false, hivePartition.getDbName(), hivePartition.getTableName());
        desc.setPartName(partName);
        return HiveStatsUtil.createHiveColumnStatistics(colStats, hivePartition.getSd(), desc);
    }

    private static ColumnStatistics createHiveColumnStatistics(Map<String, CatalogColumnStatisticsDataBase> colStats, StorageDescriptor sd, ColumnStatisticsDesc desc) {
        ArrayList<ColumnStatisticsObj> colStatsList = new ArrayList<ColumnStatisticsObj>();
        for (FieldSchema field : sd.getCols()) {
            String hiveColName = field.getName();
            String hiveColType = field.getType();
            CatalogColumnStatisticsDataBase flinkColStat = colStats.get(field.getName());
            if (null == flinkColStat) continue;
            ColumnStatisticsData statsData = HiveStatsUtil.getColumnStatisticsData(HiveTypeUtil.toFlinkType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveColType)), flinkColStat);
            ColumnStatisticsObj columnStatisticsObj = new ColumnStatisticsObj(hiveColName, hiveColType, statsData);
            colStatsList.add(columnStatisticsObj);
        }
        return new ColumnStatistics(desc, colStatsList);
    }

    private static CatalogColumnStatisticsDataBase createTableColumnStats(DataType colType, ColumnStatisticsData stats) {
        if (stats.isSetBinaryStats()) {
            BinaryColumnStatsData binaryStats = stats.getBinaryStats();
            return new CatalogColumnStatisticsDataBinary(binaryStats.getMaxColLen(), binaryStats.getAvgColLen(), binaryStats.getNumNulls());
        }
        if (stats.isSetBooleanStats()) {
            BooleanColumnStatsData booleanStats = stats.getBooleanStats();
            return new CatalogColumnStatisticsDataBoolean(booleanStats.getNumTrues(), booleanStats.getNumFalses(), booleanStats.getNumNulls());
        }
        if (stats.isSetDateStats()) {
            DateColumnStatsData dateStats = stats.getDateStats();
            return new CatalogColumnStatisticsDataDate(new org.apache.flink.table.catalog.stats.Date(dateStats.getLowValue().getDaysSinceEpoch()), new org.apache.flink.table.catalog.stats.Date(dateStats.getHighValue().getDaysSinceEpoch()), dateStats.getNumDVs(), dateStats.getNumNulls());
        }
        if (stats.isSetDoubleStats()) {
            DoubleColumnStatsData doubleStats = stats.getDoubleStats();
            return new CatalogColumnStatisticsDataDouble(doubleStats.getLowValue(), doubleStats.getHighValue(), doubleStats.getNumDVs(), doubleStats.getNumNulls());
        }
        if (stats.isSetLongStats()) {
            LongColumnStatsData longColStats = stats.getLongStats();
            return new CatalogColumnStatisticsDataLong(longColStats.getLowValue(), longColStats.getHighValue(), longColStats.getNumDVs(), longColStats.getNumNulls());
        }
        if (stats.isSetStringStats()) {
            StringColumnStatsData stringStats = stats.getStringStats();
            return new CatalogColumnStatisticsDataString(stringStats.getMaxColLen(), stringStats.getAvgColLen(), stringStats.getNumDVs(), stringStats.getNumNulls());
        }
        LOG.warn("Flink does not support converting ColumnStatisticsData '{}' for Hive column type '{}' yet.", (Object)stats, (Object)colType);
        return null;
    }

    private static ColumnStatisticsData getColumnStatisticsData(DataType colType, CatalogColumnStatisticsDataBase colStat) {
        LogicalTypeRoot type = colType.getLogicalType().getTypeRoot();
        if (type.equals((Object)LogicalTypeRoot.CHAR) || type.equals((Object)LogicalTypeRoot.VARCHAR)) {
            if (colStat instanceof CatalogColumnStatisticsDataString) {
                CatalogColumnStatisticsDataString stringColStat = (CatalogColumnStatisticsDataString)colStat;
                return ColumnStatisticsData.stringStats((StringColumnStatsData)new StringColumnStatsData(stringColStat.getMaxLength(), stringColStat.getAvgLength(), stringColStat.getNullCount(), stringColStat.getNdv()));
            }
        } else if (type.equals((Object)LogicalTypeRoot.BOOLEAN)) {
            if (colStat instanceof CatalogColumnStatisticsDataBoolean) {
                CatalogColumnStatisticsDataBoolean booleanColStat = (CatalogColumnStatisticsDataBoolean)colStat;
                BooleanColumnStatsData boolStats = new BooleanColumnStatsData(booleanColStat.getTrueCount().longValue(), booleanColStat.getFalseCount().longValue(), booleanColStat.getNullCount());
                return ColumnStatisticsData.booleanStats((BooleanColumnStatsData)boolStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.TINYINT) || type.equals((Object)LogicalTypeRoot.SMALLINT) || type.equals((Object)LogicalTypeRoot.INTEGER) || type.equals((Object)LogicalTypeRoot.BIGINT) || type.equals((Object)LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) || type.equals((Object)LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE) || type.equals((Object)LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE)) {
            if (colStat instanceof CatalogColumnStatisticsDataLong) {
                CatalogColumnStatisticsDataLong longColStat = (CatalogColumnStatisticsDataLong)colStat;
                LongColumnStatsData longColumnStatsData = new LongColumnStatsData(longColStat.getNullCount(), longColStat.getNdv());
                longColumnStatsData.setHighValue(longColStat.getMax());
                longColumnStatsData.setLowValue(longColStat.getMin());
                return ColumnStatisticsData.longStats((LongColumnStatsData)longColumnStatsData);
            }
        } else if (type.equals((Object)LogicalTypeRoot.FLOAT) || type.equals((Object)LogicalTypeRoot.DOUBLE)) {
            if (colStat instanceof CatalogColumnStatisticsDataDouble) {
                CatalogColumnStatisticsDataDouble doubleColumnStatsData = (CatalogColumnStatisticsDataDouble)colStat;
                DoubleColumnStatsData floatStats = new DoubleColumnStatsData(doubleColumnStatsData.getNullCount(), doubleColumnStatsData.getNdv());
                floatStats.setHighValue(doubleColumnStatsData.getMax());
                floatStats.setLowValue(doubleColumnStatsData.getMin());
                return ColumnStatisticsData.doubleStats((DoubleColumnStatsData)floatStats);
            }
        } else if (type.equals((Object)LogicalTypeRoot.DATE)) {
            if (colStat instanceof CatalogColumnStatisticsDataDate) {
                CatalogColumnStatisticsDataDate dateColumnStatsData = (CatalogColumnStatisticsDataDate)colStat;
                DateColumnStatsData dateStats = new DateColumnStatsData(dateColumnStatsData.getNullCount(), dateColumnStatsData.getNdv());
                dateStats.setHighValue(new Date(dateColumnStatsData.getMax().getDaysSinceEpoch()));
                dateStats.setLowValue(new Date(dateColumnStatsData.getMin().getDaysSinceEpoch()));
                return ColumnStatisticsData.dateStats((DateColumnStatsData)dateStats);
            }
        } else if ((type.equals((Object)LogicalTypeRoot.VARBINARY) || type.equals((Object)LogicalTypeRoot.BINARY) || type.equals((Object)LogicalTypeRoot.BINARY)) && colStat instanceof CatalogColumnStatisticsDataBinary) {
            CatalogColumnStatisticsDataBinary binaryColumnStatsData = (CatalogColumnStatisticsDataBinary)colStat;
            BinaryColumnStatsData binaryColumnStats = new BinaryColumnStatsData(binaryColumnStatsData.getMaxLength(), binaryColumnStatsData.getAvgLength(), binaryColumnStatsData.getNullCount());
            return ColumnStatisticsData.binaryStats((BinaryColumnStatsData)binaryColumnStats);
        }
        throw new CatalogException(String.format("Flink does not support converting ColumnStats '%s' for Hive column type '%s' yet", colStat, colType));
    }
}

