/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTableInputFormat;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.table.sources.PartitionableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableSource
extends InputFormatTableSource<Row>
implements PartitionableTableSource {
    private static Logger logger = LoggerFactory.getLogger(HiveTableSource.class);
    private final JobConf jobConf;
    private final ObjectPath tablePath;
    private final CatalogTable catalogTable;
    private List<HiveTablePartition> allHivePartitions;
    private String hiveVersion;
    private List<Map<String, String>> partitionList = new ArrayList<Map<String, String>>();
    private Map<Map<String, String>, HiveTablePartition> partitionSpec2HiveTablePartition = new HashMap<Map<String, String>, HiveTablePartition>();
    private boolean initAllPartitions;
    private boolean partitionPruned;

    public HiveTableSource(JobConf jobConf, ObjectPath tablePath, CatalogTable catalogTable) {
        this.jobConf = (JobConf)Preconditions.checkNotNull((Object)jobConf);
        this.tablePath = (ObjectPath)Preconditions.checkNotNull((Object)tablePath);
        this.catalogTable = (CatalogTable)Preconditions.checkNotNull((Object)catalogTable);
        this.hiveVersion = (String)Preconditions.checkNotNull((Object)jobConf.get("hive-version"), (String)"Hive version is not defined");
        this.initAllPartitions = false;
        this.partitionPruned = false;
    }

    private HiveTableSource(JobConf jobConf, ObjectPath tablePath, CatalogTable catalogTable, List<HiveTablePartition> allHivePartitions, String hiveVersion, List<Map<String, String>> partitionList) {
        this.jobConf = (JobConf)Preconditions.checkNotNull((Object)jobConf);
        this.tablePath = (ObjectPath)Preconditions.checkNotNull((Object)tablePath);
        this.catalogTable = (CatalogTable)Preconditions.checkNotNull((Object)catalogTable);
        this.allHivePartitions = allHivePartitions;
        this.hiveVersion = hiveVersion;
        this.partitionList = partitionList;
        this.initAllPartitions = true;
        this.partitionPruned = true;
    }

    public InputFormat getInputFormat() {
        if (!this.initAllPartitions) {
            this.initAllPartitions();
        }
        return new HiveTableInputFormat(this.jobConf, this.catalogTable, this.allHivePartitions);
    }

    public TableSchema getTableSchema() {
        return this.catalogTable.getSchema();
    }

    public DataType getProducedDataType() {
        TableSchema tableSchema = this.catalogTable.getSchema();
        DataTypes.Field[] fields = new DataTypes.Field[tableSchema.getFieldCount()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = DataTypes.FIELD((String)((String)tableSchema.getFieldName(i).get()), (DataType)((DataType)tableSchema.getFieldDataType(i).get()));
        }
        return DataTypes.ROW((DataTypes.Field[])fields);
    }

    public TypeInformation<Row> getReturnType() {
        TableSchema tableSchema = this.catalogTable.getSchema();
        return new RowTypeInfo(tableSchema.getFieldTypes(), tableSchema.getFieldNames());
    }

    public List<Map<String, String>> getPartitions() {
        if (!this.initAllPartitions) {
            this.initAllPartitions();
        }
        return this.partitionList;
    }

    public List<String> getPartitionFieldNames() {
        return this.catalogTable.getPartitionKeys();
    }

    public TableSource applyPartitionPruning(List<Map<String, String>> remainingPartitions) {
        if (this.catalogTable.getPartitionKeys() == null || this.catalogTable.getPartitionKeys().size() == 0) {
            return this;
        }
        ArrayList<HiveTablePartition> remainingHivePartitions = new ArrayList<HiveTablePartition>();
        for (Map<String, String> partitionSpec : remainingPartitions) {
            HiveTablePartition hiveTablePartition = this.partitionSpec2HiveTablePartition.get(partitionSpec);
            Preconditions.checkNotNull((Object)hiveTablePartition, (String)String.format("remainingPartitions must contain partition spec %s", partitionSpec));
            remainingHivePartitions.add(hiveTablePartition);
        }
        return new HiveTableSource(this.jobConf, this.tablePath, this.catalogTable, remainingHivePartitions, this.hiveVersion, this.partitionList);
    }

    private void initAllPartitions() {
        this.allHivePartitions = new ArrayList<HiveTablePartition>();
        try (HiveMetastoreClientWrapper client = HiveMetastoreClientFactory.create(new HiveConf((Configuration)this.jobConf, HiveConf.class), this.hiveVersion);){
            String dbName = this.tablePath.getDatabaseName();
            String tableName = this.tablePath.getObjectName();
            List partitionColNames = this.catalogTable.getPartitionKeys();
            if (partitionColNames != null && partitionColNames.size() > 0) {
                String defaultPartitionName = this.jobConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname, HiveConf.ConfVars.DEFAULTPARTITIONNAME.defaultStrVal);
                List<Partition> partitions = client.listPartitions(dbName, tableName, (short)-1);
                for (Partition partition : partitions) {
                    StorageDescriptor sd = partition.getSd();
                    HashMap<String, Object> partitionColValues = new HashMap<String, Object>();
                    HashMap<String, String> partitionSpec = new HashMap<String, String>();
                    for (int i = 0; i < partitionColNames.size(); ++i) {
                        LogicalTypeRoot typeRoot;
                        String partitionColName = (String)partitionColNames.get(i);
                        String partitionValue = (String)partition.getValues().get(i);
                        partitionSpec.put(partitionColName, partitionValue);
                        DataType type = (DataType)this.catalogTable.getSchema().getFieldDataType(partitionColName).get();
                        Object partitionObject = defaultPartitionName.equals(partitionValue) ? ((typeRoot = type.getLogicalType().getTypeRoot()) == LogicalTypeRoot.CHAR || typeRoot == LogicalTypeRoot.VARCHAR ? defaultPartitionName : null) : this.restorePartitionValueFromFromType(partitionValue, type);
                        partitionColValues.put(partitionColName, partitionObject);
                    }
                    HiveTablePartition hiveTablePartition = new HiveTablePartition(sd, partitionColValues);
                    this.allHivePartitions.add(hiveTablePartition);
                    this.partitionList.add(partitionSpec);
                    this.partitionSpec2HiveTablePartition.put(partitionSpec, hiveTablePartition);
                }
            } else {
                this.allHivePartitions.add(new HiveTablePartition(client.getTable(dbName, tableName).getSd(), null));
            }
        }
        catch (TException e) {
            throw new FlinkHiveException("Failed to collect all partitions from hive metaStore", e);
        }
        this.initAllPartitions = true;
    }

    private Object restorePartitionValueFromFromType(String valStr, DataType type) {
        LogicalTypeRoot typeRoot = type.getLogicalType().getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return valStr;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valStr);
            }
            case TINYINT: {
                return Integer.valueOf(valStr).byteValue();
            }
            case SMALLINT: {
                return Short.valueOf(valStr);
            }
            case INTEGER: {
                return Integer.valueOf(valStr);
            }
            case BIGINT: {
                return Long.valueOf(valStr);
            }
            case FLOAT: {
                return Float.valueOf(valStr);
            }
            case DOUBLE: {
                return Double.valueOf(valStr);
            }
            case DATE: {
                return Date.valueOf(valStr);
            }
        }
        throw new FlinkHiveException(new IllegalArgumentException(String.format("Can not convert %s to type %s for partition value", valStr, type)));
    }

    public String explainSource() {
        return super.explainSource() + String.format(" TablePath: %s, PartitionPruned: %s, PartitionNums: %d", this.tablePath.getFullName(), this.partitionPruned, null == this.allHivePartitions ? 0 : this.allHivePartitions.size());
    }
}

