/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.common.HadoopOutputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapreduce.utils.HadoopUtils;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientFactory;
import org.apache.flink.table.catalog.hive.client.HiveMetastoreClientWrapper;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.table.functions.hive.conversion.HiveObjectConversion;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableOutputFormat
extends HadoopOutputFormatCommonBase<Row>
implements InitializeOnMaster,
FinalizeOnMaster {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableOutputFormat.class);
    private static final long serialVersionUID = 5167529504848109023L;
    private transient JobConf jobConf;
    private transient ObjectPath tablePath;
    private transient List<String> partitionColumns;
    private transient RowTypeInfo rowTypeInfo;
    private transient HiveTablePartition hiveTablePartition;
    private transient Properties tableProperties;
    private transient boolean overwrite;
    private transient boolean isPartitioned;
    private transient boolean isDynamicPartition;
    private transient int numNonPartitionColumns;
    private transient Serializer recordSerDe;
    private transient StructObjectInspector rowObjectInspector;
    private transient Class<? extends Writable> outputClass;
    private transient TaskAttemptContext context;
    private transient Map<String, HivePartitionWriter> partitionToWriter = new HashMap<String, HivePartitionWriter>();
    private transient HivePartitionWriter staticWriter;
    private transient int dynamicPartitionOffset;
    private transient String hiveVersion;
    private transient HiveObjectConversion[] hiveConversions;
    private transient String defaultPartitionName;

    public HiveTableOutputFormat(JobConf jobConf, ObjectPath tablePath, CatalogTable table, HiveTablePartition hiveTablePartition, Properties tableProperties, boolean overwrite) {
        super(jobConf.getCredentials());
        Preconditions.checkNotNull((Object)table, (String)"table cannot be null");
        Preconditions.checkNotNull((Object)hiveTablePartition, (String)"HiveTablePartition cannot be null");
        Preconditions.checkNotNull((Object)tableProperties, (String)"Table properties cannot be null");
        HadoopUtils.mergeHadoopConf((org.apache.hadoop.conf.Configuration)jobConf);
        this.jobConf = jobConf;
        this.tablePath = tablePath;
        this.partitionColumns = table.getPartitionKeys();
        TableSchema tableSchema = table.getSchema();
        this.rowTypeInfo = new RowTypeInfo(tableSchema.getFieldTypes(), tableSchema.getFieldNames());
        this.hiveTablePartition = hiveTablePartition;
        this.tableProperties = tableProperties;
        this.overwrite = overwrite;
        this.isPartitioned = this.partitionColumns != null && !this.partitionColumns.isEmpty();
        this.isDynamicPartition = this.isPartitioned && this.partitionColumns.size() > hiveTablePartition.getPartitionSpec().size();
        this.hiveVersion = (String)Preconditions.checkNotNull((Object)jobConf.get("hive-version"), (String)"Hive version is not defined");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        this.jobConf.write((DataOutput)out);
        out.writeObject(this.isPartitioned);
        out.writeObject(this.isDynamicPartition);
        out.writeObject(this.overwrite);
        out.writeObject(this.rowTypeInfo);
        out.writeObject(this.hiveTablePartition);
        out.writeObject(this.partitionColumns);
        out.writeObject(this.tablePath);
        out.writeObject(this.tableProperties);
        out.writeObject(this.hiveVersion);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        this.jobConf.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HadoopInputFormatCommonBase.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            this.jobConf.getCredentials().addAll(currentUserCreds);
        }
        this.isPartitioned = (Boolean)in.readObject();
        this.isDynamicPartition = (Boolean)in.readObject();
        this.overwrite = (Boolean)in.readObject();
        this.rowTypeInfo = (RowTypeInfo)in.readObject();
        this.hiveTablePartition = (HiveTablePartition)in.readObject();
        this.partitionColumns = (List)in.readObject();
        this.tablePath = (ObjectPath)in.readObject();
        this.partitionToWriter = new HashMap<String, HivePartitionWriter>();
        this.tableProperties = (Properties)in.readObject();
        this.hiveVersion = (String)in.readObject();
    }

    public void finalizeGlobal(int parallelism) throws IOException {
        StorageDescriptor jobSD = this.hiveTablePartition.getStorageDescriptor();
        Path stagingDir = new Path(jobSD.getLocation());
        FileSystem fs = stagingDir.getFileSystem((org.apache.hadoop.conf.Configuration)this.jobConf);
        try (HiveMetastoreClientWrapper client = HiveMetastoreClientFactory.create(new HiveConf((org.apache.hadoop.conf.Configuration)this.jobConf, HiveConf.class), this.hiveVersion);){
            Table table = client.getTable(this.tablePath.getDatabaseName(), this.tablePath.getObjectName());
            if (!this.isDynamicPartition) {
                this.commitJob(stagingDir.toString());
            }
            if (this.isPartitioned) {
                if (this.isDynamicPartition) {
                    FileStatus[] generatedParts;
                    for (FileStatus part : generatedParts = HiveStatsUtils.getFileStatusRecurse((Path)stagingDir, (int)(this.partitionColumns.size() - this.hiveTablePartition.getPartitionSpec().size()), (FileSystem)fs)) {
                        this.commitJob(part.getPath().toString());
                        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>();
                        Warehouse.makeSpecFromName(fullPartSpec, (Path)part.getPath());
                        this.loadPartition(part.getPath(), table, fullPartSpec, client);
                    }
                } else {
                    LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                    for (String partCol : this.hiveTablePartition.getPartitionSpec().keySet()) {
                        partSpec.put(partCol, this.hiveTablePartition.getPartitionSpec().get(partCol).toString());
                    }
                    this.loadPartition(stagingDir, table, partSpec, client);
                }
            } else {
                this.moveFiles(stagingDir, new Path(table.getSd().getLocation()));
            }
        }
        catch (TException e) {
            throw new CatalogException("Failed to query Hive metaStore", (Throwable)e);
        }
        finally {
            fs.delete(stagingDir, true);
        }
    }

    public void initializeGlobal(int parallelism) throws IOException {
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            StorageDescriptor sd = this.hiveTablePartition.getStorageDescriptor();
            Object serdeLib = Class.forName(sd.getSerdeInfo().getSerializationLib()).newInstance();
            Preconditions.checkArgument((serdeLib instanceof Serializer && serdeLib instanceof Deserializer ? 1 : 0) != 0, (Object)("Expect a SerDe lib implementing both Serializer and Deserializer, but actually got " + serdeLib.getClass().getName()));
            this.recordSerDe = (Serializer)serdeLib;
            ReflectionUtils.setConf((Object)this.recordSerDe, (org.apache.hadoop.conf.Configuration)this.jobConf);
            SerDeUtils.initializeSerDe((Deserializer)((Deserializer)this.recordSerDe), (org.apache.hadoop.conf.Configuration)this.jobConf, (Properties)this.tableProperties, null);
            this.outputClass = this.recordSerDe.getSerializedClass();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SerDeException e) {
            throw new FlinkRuntimeException("Error initializing Hive serializer", e);
        }
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)("attempt__0000_r_" + String.format("%" + (6 - Integer.toString(taskNumber).length()) + "s", " ").replace(" ", "0") + taskNumber + "_0"));
        this.jobConf.set("mapred.task.id", taskAttemptID.toString());
        this.jobConf.setInt("mapred.task.partition", taskNumber);
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptID.toString());
        this.jobConf.setInt("mapreduce.task.partition", taskNumber);
        this.context = new TaskAttemptContextImpl(this.jobConf, taskAttemptID);
        if (!this.isDynamicPartition) {
            this.staticWriter = this.writerForLocation(this.hiveTablePartition.getStorageDescriptor().getLocation());
        } else {
            this.dynamicPartitionOffset = this.rowTypeInfo.getArity() - this.partitionColumns.size() + this.hiveTablePartition.getPartitionSpec().size();
        }
        this.numNonPartitionColumns = this.isPartitioned ? this.rowTypeInfo.getArity() - this.partitionColumns.size() : this.rowTypeInfo.getArity();
        this.hiveConversions = new HiveObjectConversion[this.numNonPartitionColumns];
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>(this.hiveConversions.length);
        for (int i = 0; i < this.numNonPartitionColumns; ++i) {
            DataType dataType = LegacyTypeInfoDataTypeConverter.toDataType((TypeInformation)this.rowTypeInfo.getTypeAt(i));
            ObjectInspector objectInspector = HiveInspectors.getObjectInspector(dataType);
            objectInspectors.add(objectInspector);
            this.hiveConversions[i] = HiveInspectors.getConversion(objectInspector, dataType.getLogicalType());
        }
        if (!this.isPartitioned) {
            this.rowObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(this.rowTypeInfo.getFieldNames()), objectInspectors);
        } else {
            this.rowObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(this.rowTypeInfo.getFieldNames()).subList(0, this.rowTypeInfo.getArity() - this.partitionColumns.size()), objectInspectors);
            this.defaultPartitionName = this.jobConf.get(HiveConf.ConfVars.DEFAULTPARTITIONNAME.varname, HiveConf.ConfVars.DEFAULTPARTITIONNAME.defaultStrVal);
        }
    }

    public void writeRecord(Row record) throws IOException {
        try {
            HivePartitionWriter partitionWriter = this.staticWriter;
            if (this.isDynamicPartition) {
                LinkedHashMap<String, String> dynPartSpec = new LinkedHashMap<String, String>();
                int numStaticPart = this.hiveTablePartition.getPartitionSpec().size();
                for (int i = this.dynamicPartitionOffset; i < record.getArity(); ++i) {
                    String partitionValue;
                    Object field = record.getField(i);
                    String string = partitionValue = field != null ? field.toString() : null;
                    if (partitionValue == null || partitionValue.isEmpty()) {
                        partitionValue = this.defaultPartitionName;
                    }
                    dynPartSpec.put(this.partitionColumns.get(i - this.dynamicPartitionOffset + numStaticPart), partitionValue);
                }
                String partName = Warehouse.makePartPath(dynPartSpec);
                partitionWriter = this.partitionToWriter.get(partName);
                if (partitionWriter == null) {
                    String stagingDir = this.hiveTablePartition.getStorageDescriptor().getLocation();
                    partitionWriter = this.writerForLocation(stagingDir + "/" + partName);
                    this.partitionToWriter.put(partName, partitionWriter);
                }
            }
            partitionWriter.recordWriter.write(this.recordSerDe.serialize(this.getConvertedRow(record), (ObjectInspector)this.rowObjectInspector));
        }
        catch (IOException | SerDeException e) {
            throw new IOException("Could not write Record.", e);
        }
        catch (MetaException e) {
            throw new CatalogException((Throwable)e);
        }
    }

    private void loadPartition(Path srcDir, Table table, Map<String, String> partSpec, HiveMetastoreClientWrapper client) throws TException, IOException {
        String tableName;
        Path tblLocation = new Path(table.getSd().getLocation());
        String dbName = this.tablePath.getDatabaseName();
        List<Partition> existingPart = client.listPartitions(dbName, tableName = this.tablePath.getObjectName(), new ArrayList<String>(partSpec.values()), (short)1);
        Path destDir = existingPart.isEmpty() ? new Path(tblLocation, Warehouse.makePartPath(partSpec)) : new Path(existingPart.get(0).getSd().getLocation());
        this.moveFiles(srcDir, destDir);
        if (existingPart.isEmpty()) {
            StorageDescriptor sd = new StorageDescriptor(this.hiveTablePartition.getStorageDescriptor());
            sd.setLocation(destDir.toString());
            Partition partition = HiveTableUtil.createHivePartition(dbName, tableName, new ArrayList<String>(partSpec.values()), sd, new HashMap<String, String>());
            partition.setValues(new ArrayList<String>(partSpec.values()));
            client.add_partition(partition);
        }
    }

    private void moveFiles(Path srcDir, Path destDir) throws IOException {
        if (!srcDir.equals((Object)destDir)) {
            FileStatus[] srcFiles;
            FileSystem fs = destDir.getFileSystem((org.apache.hadoop.conf.Configuration)this.jobConf);
            Preconditions.checkState((fs.exists(destDir) || fs.mkdirs(destDir) ? 1 : 0) != 0, (Object)("Failed to create dest path " + destDir));
            if (this.overwrite) {
                boolean purge = true;
                FileStatus[] existingFiles = fs.listStatus(destDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (existingFiles != null) {
                    HiveShim hiveShim = HiveShimLoader.loadHiveShim(this.hiveVersion);
                    for (FileStatus existingFile : existingFiles) {
                        Preconditions.checkState((boolean)hiveShim.moveToTrash(fs, existingFile.getPath(), (org.apache.hadoop.conf.Configuration)this.jobConf, true), (Object)("Failed to overwrite existing file " + existingFile));
                    }
                }
            }
            for (FileStatus srcFile : srcFiles = fs.listStatus(srcDir, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                Path srcPath = srcFile.getPath();
                Path destPath = new Path(destDir, srcPath.getName());
                int count = 1;
                while (!fs.rename(srcPath, destPath)) {
                    String name = srcPath.getName() + "_copy_" + count;
                    destPath = new Path(destDir, name);
                    ++count;
                }
            }
        }
    }

    private void commitJob(String location) throws IOException {
        this.jobConf.set("mapreduce.output.fileoutputformat.outputdir", location);
        JobContextImpl jobContext = new JobContextImpl(this.jobConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
        OutputCommitter outputCommitter = this.jobConf.getOutputCommitter();
        outputCommitter.commitJob((JobContext)jobContext);
    }

    private Object getConvertedRow(Row record) {
        ArrayList<Object> res = new ArrayList<Object>(this.numNonPartitionColumns);
        for (int i = 0; i < this.numNonPartitionColumns; ++i) {
            res.add(this.hiveConversions[i].toHiveObject(record.getField(i)));
        }
        return res;
    }

    public void close() throws IOException {
        for (HivePartitionWriter partitionWriter : this.getPartitionWriters()) {
            partitionWriter.recordWriter.close(false);
            if (!partitionWriter.outputCommitter.needsTaskCommit(this.context)) continue;
            partitionWriter.outputCommitter.commitTask(this.context);
        }
    }

    private List<HivePartitionWriter> getPartitionWriters() {
        if (this.isDynamicPartition) {
            return new ArrayList<HivePartitionWriter>(this.partitionToWriter.values());
        }
        return Collections.singletonList(this.staticWriter);
    }

    private HivePartitionWriter writerForLocation(String location) throws IOException {
        FileSinkOperator.RecordWriter recordWriter;
        OutputFormat outputFormat;
        JobConf clonedConf = new JobConf((org.apache.hadoop.conf.Configuration)this.jobConf);
        clonedConf.set("mapreduce.output.fileoutputformat.outputdir", location);
        try {
            StorageDescriptor sd = this.hiveTablePartition.getStorageDescriptor();
            Class outputFormatClz = Class.forName(sd.getOutputFormat(), true, Thread.currentThread().getContextClassLoader());
            outputFormatClz = HiveFileFormatUtils.getOutputFormatSubstitute(outputFormatClz);
            outputFormat = (OutputFormat)outputFormatClz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new FlinkRuntimeException("Unable to instantiate the hadoop output format", (Throwable)e);
        }
        ReflectionUtils.setConf((Object)outputFormat, (org.apache.hadoop.conf.Configuration)clonedConf);
        OutputCommitter outputCommitter = clonedConf.getOutputCommitter();
        JobContextImpl jobContext = new JobContextImpl(clonedConf, (org.apache.hadoop.mapreduce.JobID)new JobID());
        outputCommitter.setupJob((JobContext)jobContext);
        boolean isCompressed = clonedConf.getBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, false);
        if (isCompressed) {
            String typeStr;
            String codecStr = clonedConf.get(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC.varname);
            if (!StringUtils.isNullOrWhitespaceOnly((String)codecStr)) {
                try {
                    Class<?> codec = Class.forName(codecStr, true, Thread.currentThread().getContextClassLoader());
                    FileOutputFormat.setOutputCompressorClass((JobConf)clonedConf, codec);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!StringUtils.isNullOrWhitespaceOnly((String)(typeStr = clonedConf.get(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE.varname)))) {
                SequenceFile.CompressionType style = SequenceFile.CompressionType.valueOf((String)typeStr);
                SequenceFileOutputFormat.setOutputCompressionType((JobConf)clonedConf, (SequenceFile.CompressionType)style);
            }
        }
        String taskPartition = String.valueOf(clonedConf.getInt("mapreduce.task.partition", -1));
        Path taskPath = FileOutputFormat.getTaskOutputPath((JobConf)clonedConf, (String)taskPartition);
        try {
            recordWriter = HiveFileFormatUtils.getRecordWriter((JobConf)clonedConf, (OutputFormat)outputFormat, this.outputClass, (boolean)isCompressed, (Properties)this.tableProperties, (Path)taskPath, (Reporter)Reporter.NULL);
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        return new HivePartitionWriter(clonedConf, outputFormat, recordWriter, outputCommitter);
    }

    private static class HivePartitionWriter {
        private final JobConf jobConf;
        private final OutputFormat outputFormat;
        private final FileSinkOperator.RecordWriter recordWriter;
        private final OutputCommitter outputCommitter;

        HivePartitionWriter(JobConf jobConf, OutputFormat outputFormat, FileSinkOperator.RecordWriter recordWriter, OutputCommitter outputCommitter) {
            this.jobConf = jobConf;
            this.outputFormat = outputFormat;
            this.recordWriter = recordWriter;
            this.outputCommitter = outputCommitter;
        }
    }
}

