/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.io.LocatableInputSplitAssigner;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.hadoop.common.HadoopInputFormatCommonBase;
import org.apache.flink.api.java.hadoop.mapred.wrapper.HadoopDummyReporter;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.connectors.hive.HiveTableInputSplit;
import org.apache.flink.connectors.hive.HiveTablePartition;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.hive.util.HiveTableUtil;
import org.apache.flink.table.functions.hive.conversion.HiveInspectors;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableInputFormat
extends HadoopInputFormatCommonBase<Row, HiveTableInputSplit>
implements ResultTypeQueryable {
    private static final long serialVersionUID = 6351448428766433164L;
    private static Logger logger = LoggerFactory.getLogger(HiveTableInputFormat.class);
    private JobConf jobConf;
    protected transient Writable key;
    protected transient Writable value;
    private transient RecordReader<Writable, Writable> recordReader;
    protected transient boolean fetched = false;
    protected transient boolean hasNext;
    private RowTypeInfo rowTypeInfo;
    private List<String> partitionColNames;
    private List<HiveTablePartition> partitions;
    private transient Deserializer deserializer;
    private transient List<? extends StructField> structFields;
    private transient StructObjectInspector structObjectInspector;
    private transient InputFormat mapredInputFormat;
    private transient HiveTablePartition hiveTablePartition;

    public HiveTableInputFormat(JobConf jobConf, CatalogTable catalogTable, List<HiveTablePartition> partitions) {
        super(jobConf.getCredentials());
        Preconditions.checkNotNull((Object)catalogTable, (String)"catalogTable can not be null.");
        this.partitions = (List)Preconditions.checkNotNull(partitions, (String)"partitions can not be null.");
        this.jobConf = new JobConf((org.apache.hadoop.conf.Configuration)jobConf);
        this.partitionColNames = catalogTable.getPartitionKeys();
        TableSchema tableSchema = catalogTable.getSchema();
        this.rowTypeInfo = new RowTypeInfo(tableSchema.getFieldTypes(), tableSchema.getFieldNames());
    }

    public void open(HiveTableInputSplit split) throws IOException {
        this.hiveTablePartition = split.getHiveTablePartition();
        StorageDescriptor sd = this.hiveTablePartition.getStorageDescriptor();
        this.jobConf.set("mapreduce.input.fileinputformat.inputdir", sd.getLocation());
        try {
            this.mapredInputFormat = (InputFormat)Class.forName(sd.getInputFormat(), true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new FlinkHiveException("Unable to instantiate the hadoop input format", e);
        }
        ReflectionUtils.setConf((Object)this.mapredInputFormat, (org.apache.hadoop.conf.Configuration)this.jobConf);
        if (this.mapredInputFormat instanceof Configurable) {
            ((Configurable)this.mapredInputFormat).setConf((org.apache.hadoop.conf.Configuration)this.jobConf);
        } else if (this.mapredInputFormat instanceof JobConfigurable) {
            ((JobConfigurable)this.mapredInputFormat).configure(this.jobConf);
        }
        this.recordReader = this.mapredInputFormat.getRecordReader(split.getHadoopInputSplit(), this.jobConf, (Reporter)new HadoopDummyReporter());
        if (this.recordReader instanceof Configurable) {
            ((Configurable)this.recordReader).setConf((org.apache.hadoop.conf.Configuration)this.jobConf);
        }
        this.key = (Writable)this.recordReader.createKey();
        this.value = (Writable)this.recordReader.createValue();
        this.fetched = false;
        try {
            this.deserializer = (Deserializer)Class.forName(sd.getSerdeInfo().getSerializationLib()).newInstance();
            org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
            Properties properties = HiveTableUtil.createPropertiesFromStorageDescriptor(sd);
            SerDeUtils.initializeSerDe((Deserializer)this.deserializer, (org.apache.hadoop.conf.Configuration)conf, (Properties)properties, null);
            this.structObjectInspector = (StructObjectInspector)this.deserializer.getObjectInspector();
            this.structFields = this.structObjectInspector.getAllStructFieldRefs();
        }
        catch (Exception e) {
            throw new FlinkHiveException("Error happens when deserialize from storage file.", e);
        }
    }

    public HiveTableInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        ArrayList<HiveTableInputSplit> hiveSplits = new ArrayList<HiveTableInputSplit>();
        int splitNum = 0;
        for (HiveTablePartition partition : this.partitions) {
            InputFormat format;
            StorageDescriptor sd = partition.getStorageDescriptor();
            try {
                format = (InputFormat)Class.forName(sd.getInputFormat(), true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new FlinkHiveException("Unable to instantiate the hadoop input format", e);
            }
            ReflectionUtils.setConf((Object)format, (org.apache.hadoop.conf.Configuration)this.jobConf);
            this.jobConf.set("mapreduce.input.fileinputformat.inputdir", sd.getLocation());
            InputSplit[] splitArray = format.getSplits(this.jobConf, minNumSplits);
            for (int i = 0; i < splitArray.length; ++i) {
                hiveSplits.add(new HiveTableInputSplit(splitNum++, splitArray[i], this.jobConf, partition));
            }
        }
        return hiveSplits.toArray(new HiveTableInputSplit[hiveSplits.size()]);
    }

    public void configure(Configuration parameters) {
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        return null;
    }

    public InputSplitAssigner getInputSplitAssigner(HiveTableInputSplit[] inputSplits) {
        return new LocatableInputSplitAssigner((LocatableInputSplit[])inputSplits);
    }

    public boolean reachedEnd() throws IOException {
        if (!this.fetched) {
            this.fetchNext();
        }
        return !this.hasNext;
    }

    public void close() throws IOException {
        if (this.recordReader != null) {
            this.recordReader.close();
            this.recordReader = null;
        }
    }

    protected void fetchNext() throws IOException {
        this.hasNext = this.recordReader.next((Object)this.key, (Object)this.value);
        this.fetched = true;
    }

    public Row nextRecord(Row ignore) throws IOException {
        if (this.reachedEnd()) {
            return null;
        }
        Row row = new Row(this.rowTypeInfo.getArity());
        try {
            int index;
            Object hiveRowStruct = this.deserializer.deserialize(this.value);
            for (index = 0; index < this.structFields.size(); ++index) {
                StructField structField = this.structFields.get(index);
                Object object = HiveInspectors.toFlinkObject(structField.getFieldObjectInspector(), this.structObjectInspector.getStructFieldData(hiveRowStruct, structField));
                row.setField(index, object);
            }
            for (String partition : this.partitionColNames) {
                row.setField(index++, this.hiveTablePartition.getPartitionSpec().get(partition));
            }
        }
        catch (Exception e) {
            logger.error("Error happens when converting hive data type to flink data type.");
            throw new FlinkHiveException(e);
        }
        this.fetched = false;
        return row;
    }

    public TypeInformation getProducedType() {
        return this.rowTypeInfo;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        super.write(out);
        this.jobConf.write((DataOutput)out);
        out.writeObject(this.rowTypeInfo);
        out.writeObject(this.partitionColNames);
        out.writeObject(this.partitions);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.read(in);
        if (this.jobConf == null) {
            this.jobConf = new JobConf();
        }
        this.jobConf.readFields((DataInput)in);
        this.jobConf.getCredentials().addAll(this.credentials);
        Credentials currentUserCreds = HiveTableInputFormat.getCredentialsFromUGI(UserGroupInformation.getCurrentUser());
        if (currentUserCreds != null) {
            this.jobConf.getCredentials().addAll(currentUserCreds);
        }
        this.rowTypeInfo = (RowTypeInfo)in.readObject();
        this.partitionColNames = (List)in.readObject();
        this.partitions = (List)in.readObject();
    }
}

