/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connectors.hive;

import java.util.List;
import java.util.Map;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.connectors.hive.HiveTableSink;
import org.apache.flink.connectors.hive.HiveTableSource;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.factories.FunctionDefinitionFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.AggregateFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.ScalarFunctionDefinition;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.TableFunctionDefinition;
import org.apache.flink.table.functions.hive.HiveFunctionWrapper;
import org.apache.flink.table.functions.hive.HiveGenericUDAF;
import org.apache.flink.table.functions.hive.HiveGenericUDF;
import org.apache.flink.table.functions.hive.HiveGenericUDTF;
import org.apache.flink.table.functions.hive.HiveSimpleUDF;
import org.apache.flink.table.sinks.OutputFormatTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableFactory
implements TableSourceFactory<Row>,
TableSinkFactory<Row>,
FunctionDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableFactory.class);
    private final HiveConf hiveConf;
    private final String hiveVersion;

    public HiveTableFactory(HiveConf hiveConf) {
        this.hiveConf = (HiveConf)Preconditions.checkNotNull((Object)hiveConf, (String)"hiveConf cannot be null");
        this.hiveVersion = (String)Preconditions.checkNotNull((Object)hiveConf.get("hive-version"), (String)"Hive version is not defined");
    }

    public Map<String, String> requiredContext() {
        throw new UnsupportedOperationException();
    }

    public List<String> supportedProperties() {
        throw new UnsupportedOperationException();
    }

    public TableSink<Row> createTableSink(Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public TableSource<Row> createTableSource(Map<String, String> properties) {
        throw new UnsupportedOperationException();
    }

    public TableSource<Row> createTableSource(ObjectPath tablePath, CatalogTable table) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.valueOf((String)table.getProperties().get("is_generic"));
        if (!isGeneric) {
            return this.createInputFormatTableSource(tablePath, table);
        }
        return TableFactoryUtil.findAndCreateTableSource((CatalogTable)table);
    }

    private InputFormatTableSource<Row> createInputFormatTableSource(ObjectPath tablePath, CatalogTable table) {
        return new HiveTableSource(new JobConf((Configuration)this.hiveConf), tablePath, table);
    }

    public TableSink<Row> createTableSink(ObjectPath tablePath, CatalogTable table) {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkArgument((boolean)(table instanceof CatalogTableImpl));
        boolean isGeneric = Boolean.valueOf((String)table.getProperties().get("is_generic"));
        if (!isGeneric) {
            return this.createOutputFormatTableSink(tablePath, table);
        }
        return TableFactoryUtil.findAndCreateTableSink((CatalogTable)table);
    }

    private OutputFormatTableSink<Row> createOutputFormatTableSink(ObjectPath tablePath, CatalogTable table) {
        return new HiveTableSink(new JobConf((Configuration)this.hiveConf), tablePath, table);
    }

    public FunctionDefinition createFunctionDefinition(String name, CatalogFunction catalogFunction) {
        Class<?> clazz;
        String functionClassName = catalogFunction.getClassName();
        if (Boolean.valueOf((String)catalogFunction.getProperties().get("is_generic")).booleanValue()) {
            throw new TableException(String.format("HiveFunctionDefinitionFactory does not support generic functions %s yet", name));
        }
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(functionClassName);
            LOG.info("Successfully loaded Hive udf '{}' with class '{}'", (Object)name, (Object)functionClassName);
        }
        catch (ClassNotFoundException e) {
            throw new TableException(String.format("Failed to initiate an instance of class %s.", functionClassName), (Throwable)e);
        }
        if (UDF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveSimpleUDF", (Object)name);
            return new ScalarFunctionDefinition(name, (ScalarFunction)new HiveSimpleUDF(new HiveFunctionWrapper<UDF>(functionClassName)));
        }
        if (GenericUDF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveGenericUDF", (Object)name);
            return new ScalarFunctionDefinition(name, (ScalarFunction)new HiveGenericUDF(new HiveFunctionWrapper<GenericUDF>(functionClassName)));
        }
        if (GenericUDTF.class.isAssignableFrom(clazz)) {
            LOG.info("Transforming Hive function '{}' into a HiveGenericUDTF", (Object)name);
            HiveGenericUDTF udtf = new HiveGenericUDTF(new HiveFunctionWrapper<GenericUDTF>(functionClassName));
            return new TableFunctionDefinition(name, (TableFunction)udtf, GenericTypeInfo.of(Row.class));
        }
        if (GenericUDAFResolver2.class.isAssignableFrom(clazz) || UDAF.class.isAssignableFrom(clazz)) {
            HiveGenericUDAF udaf;
            if (GenericUDAFResolver2.class.isAssignableFrom(clazz)) {
                LOG.info("Transforming Hive function '{}' into a HiveGenericUDAF with no UDAF bridging and Hive version %s", (Object)name, (Object)this.hiveVersion);
                udaf = new HiveGenericUDAF(new HiveFunctionWrapper(functionClassName), false, this.hiveVersion);
            } else {
                LOG.info("Transforming Hive function '{}' into a HiveGenericUDAF with UDAF bridging and Hive version %s", (Object)name, (Object)this.hiveVersion);
                udaf = new HiveGenericUDAF(new HiveFunctionWrapper(functionClassName), true, this.hiveVersion);
            }
            return new AggregateFunctionDefinition(name, (AggregateFunction)udaf, GenericTypeInfo.of(Object.class), GenericTypeInfo.of(GenericUDAFEvaluator.AggregationBuffer.class));
        }
        throw new IllegalArgumentException(String.format("HiveFunctionDefinitionFactory cannot initiate FunctionDefinition for class %s", functionClassName));
    }
}

