# pylint: disable = super-init-not-called
from typing import Optional
from daipecore.decorator.DecoratedDecorator import DecoratedDecorator
from daipecore.decorator.OutputDecorator import OutputDecorator
from injecta.container.ContainerInterface import ContainerInterface
from pyspark.sql import DataFrame
from datalakebundle.table.create.TableDefinitionFactory import TableDefinitionFactory
from datalakebundle.table.schema.TableSchema import TableSchema
from datalakebundle.table.write.TableAppender import TableAppender


@DecoratedDecorator
class table_append(OutputDecorator):  # pylint: disable = invalid-name
    def __init__(self, identifier: str, table_schema: Optional[TableSchema] = None, options: Optional[dict] = None):
        self.__identifier = identifier
        self.__table_schema = table_schema
        self.__options = options or {}

    def process_result(self, result: DataFrame, container: ContainerInterface):
        table_definition_factory: TableDefinitionFactory = container.get(TableDefinitionFactory)
        table_appender: TableAppender = container.get(TableAppender)

        if self.__table_schema:
            table_definition = table_definition_factory.create_from_table_schema(self.__identifier, self.__table_schema)
        else:
            table_definition = table_definition_factory.create_from_dataframe(self.__identifier, result, self.__class__.__name__)

        table_appender.append(result, table_definition, self.__options)
