# -*- coding: utf-8 -*-
"""
Test suite for the community-developed Python SDK for interacting with Lacework APIs.
"""

from ast import operator
import pytest

from laceworksdk.api.v2.vulnerability_policies import VulnerabilityPoliciesAPI
from tests.api.test_crud_endpoint import CrudEndpoint


# Tests

@pytest.fixture(scope="module")
def api_object(api):
    return api.vulnerability_policies


@pytest.fixture(scope="module")
def api_object_create_body(random_text):
    return {
        "policy_type": "DockerFile",
        "policy_name": f"Test Container Policy {random_text}",
        "severity": "High",
        "state": True,
        "filter": {
            "rule": {
                "operator": "include",
                "values": [
                    "test"
                ]
            }
        },
        "props": {
            "description": f"Test Container Policy Description {random_text}"
        }
    }


@pytest.fixture(scope="module")
def api_object_update_body(random_text):
    return {
        "policy_name": f"Test Container Exception {random_text} (Updated)",
        "severity": "Medium",
        "props": {
            "description": f"Test Container Exception Description {random_text} (Updated)"
        }
    }


class TestVulnerabilityExceptions(CrudEndpoint):

    OBJECT_ID_NAME = "policyGuid"
    OBJECT_TYPE = VulnerabilityPoliciesAPI

    def test_api_get_by_guid(self, api_object):
        self._get_object_classifier_test(api_object, "guid", self.OBJECT_ID_NAME)
