# -*- coding: utf-8 -*-
"""
Lacework VulnerabilityPolicies API wrapper.
"""

from laceworksdk.api.crud_endpoint import CrudEndpoint


class VulnerabilityPoliciesAPI(CrudEndpoint):

    def __init__(self, session):
        """
        Initializes the VulnerabilityPoliciesAPI object.

        :param session: An instance of the HttpSession class

        :return VulnerabilityPoliciesAPI object.
        """

        super().__init__(session, "VulnerabilityPolicies")

    def create(self,
               policy_type,
               policy_name,
               severity,
               state,
               filter,
               props,
               policy_eval_type=None,
               fail_on_violation=False,
               alert_on_violation=False,
               **request_params):
        """
        A method to create a new VulnerabilityPolicies object.

        :param policy_type: A string representing the type of the policy.
        :param policy_name: A string representing the name of the policy.
        :param severity: A string representing the severity of the policy.
            ("Info", "Low", "Medium", "High", "Critical")
        :param state: A boolean representing the state of the policy.
        :param filter:
            obj:
                :param rule: An object representing a policy filter rule.
                    obj:
                        :param operator: A string representing the rule operator.
                            ("include", "exclude", "equals", "notEquals")
                        :param values: An array of strings representing the rule values.
                :param exception: An object representing a policy filter exception.
                    obj:
                        :param operator: A string representing the rule operator.
                            ("include", "exclude", "equals", "notEquals")
                        :param values: An array of strings representing the exception values.
        :param props: An object containing properties of the policy.
            obj:
                :param description: A string representing the property description.
                :param createdBy: A string representing the creator of the property.
                :param updatedBy: A string representing the updater of the property.
        :param policy_eval_type: A string representing the policy evaluation type.
        :param fail_on_violation: A boolean representing whether the policy should fail on violations.
        :param alert_on_violation: A boolean representing whether the policy should alert on violations.
        :param request_params: Additional request parameters.
            (provides support for parameters that may be added in the future)

        :return response json
        """

        return super().create(
            policy_type=policy_type,
            policy_name=policy_name,
            severity=severity,
            state=int(bool(state)),
            filter=filter,
            props=props,
            policy_eval_type=policy_eval_type,
            fail_on_violation=int(bool(fail_on_violation)),
            alert_on_violation=int(bool(alert_on_violation)),
            **request_params
        )

    def get(self,
            guid=None):
        """
        A method to get VulnerabilityPolicies objects.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return super().get(id=guid)

    def get_by_guid(self,
                    guid):
        """
        A method to get a VulnerabilityPolicies object by GUID.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return self.get(guid=guid)

    def update(self,
               guid,
               policy_type=None,
               policy_name=None,
               severity=None,
               state=None,
               filter=None,
               props=None,
               policy_eval_type=None,
               fail_on_violation=None,
               alert_on_violation=None,
               **request_params):
        """
        A method to update a VulnerabilityPolicies object.

        :param guid: A string representing the object GUID.
        :param policy_type: A string representing the type of the policy.
        :param policy_name: A string representing the name of the policy.
        :param severity: A string representing the severity of the policy.
            ("Info", "Low", "Medium", "High", "Critical")
        :param state: A boolean representing the state of the policy.
        :param filter:
            obj:
                :param rule: An object representing a policy filter rule.
                    obj:
                        :param operator: A string representing the rule operator.
                            ("include", "exclude", "equals", "notEquals")
                        :param values: An array of strings representing the rule values.
                :param exception: An object representing a policy filter exception.
                    obj:
                        :param operator: A string representing the rule operator.
                            ("include", "exclude", "equals", "notEquals")
                        :param values: An array of strings representing the exception values.
        :param props: An object containing properties of the policy.
            obj:
                :param description: A string representing the property description.
                :param createdBy: A string representing the creator of the property.
                :param updatedBy: A string representing the updater of the property.
        :param policy_eval_type: A string representing the policy evaluation type.
        :param fail_on_violation: A boolean representing whether the policy should fail on violations.
        :param alert_on_violation: A boolean representing whether the policy should alert on violations.
        :param request_params: Additional request parameters.
            (provides support for parameters that may be added in the future)

        :return response json
        """

        if state is not None:
            state = int(bool(state))
        if fail_on_violation is not None:
            fail_on_violation = int(bool(fail_on_violation))
        if alert_on_violation is not None:
            alert_on_violation = int(bool(alert_on_violation))

        return super().update(
            guid,
            policy_type=policy_type,
            policy_name=policy_name,
            severity=severity,
            state=state,
            filter=filter,
            props=props,
            policy_eval_type=policy_eval_type,
            fail_on_violation=fail_on_violation,
            alert_on_violation=alert_on_violation,
            **request_params
        )

    def delete(self,
               guid):
        """
        A method to delete a VulnerabilityPolicies object.

        :param guid: A string representing the object GUID.

        :return response json
        """

        return super().delete(id=guid)
