# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Trigger(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Trigger - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'topic_name': 'str',
            'target': 'TriggerTarget',
            'version': 'int',
            'enabled': 'bool',
            'match_criteria': 'list[MatchCriteria]',
            'event_ttl_seconds': 'int',
            'description': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'topic_name': 'topicName',
            'target': 'target',
            'version': 'version',
            'enabled': 'enabled',
            'match_criteria': 'matchCriteria',
            'event_ttl_seconds': 'eventTTLSeconds',
            'description': 'description',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._topic_name = None
        self._target = None
        self._version = None
        self._enabled = None
        self._match_criteria = None
        self._event_ttl_seconds = None
        self._description = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this Trigger.
        The globally unique identifier for the object.

        :return: The id of this Trigger.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Trigger.
        The globally unique identifier for the object.

        :param id: The id of this Trigger.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this Trigger.
        The name of the trigger

        :return: The name of this Trigger.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this Trigger.
        The name of the trigger

        :param name: The name of this Trigger.
        :type: str
        """
        

        self._name = name

    @property
    def topic_name(self):
        """
        Gets the topic_name of this Trigger.
        The topic that will cause the trigger to be invoked

        :return: The topic_name of this Trigger.
        :rtype: str
        """
        return self._topic_name

    @topic_name.setter
    def topic_name(self, topic_name):
        """
        Sets the topic_name of this Trigger.
        The topic that will cause the trigger to be invoked

        :param topic_name: The topic_name of this Trigger.
        :type: str
        """
        

        self._topic_name = topic_name

    @property
    def target(self):
        """
        Gets the target of this Trigger.
        The target to invoke when a matching event is received

        :return: The target of this Trigger.
        :rtype: TriggerTarget
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this Trigger.
        The target to invoke when a matching event is received

        :param target: The target of this Trigger.
        :type: TriggerTarget
        """
        

        self._target = target

    @property
    def version(self):
        """
        Gets the version of this Trigger.
        Version of this trigger

        :return: The version of this Trigger.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Trigger.
        Version of this trigger

        :param version: The version of this Trigger.
        :type: int
        """
        

        self._version = version

    @property
    def enabled(self):
        """
        Gets the enabled of this Trigger.
        Whether or not the trigger is enabled

        :return: The enabled of this Trigger.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this Trigger.
        Whether or not the trigger is enabled

        :param enabled: The enabled of this Trigger.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def match_criteria(self):
        """
        Gets the match_criteria of this Trigger.
        The configuration for when a trigger is considered to be a match for an event

        :return: The match_criteria of this Trigger.
        :rtype: list[MatchCriteria]
        """
        return self._match_criteria

    @match_criteria.setter
    def match_criteria(self, match_criteria):
        """
        Sets the match_criteria of this Trigger.
        The configuration for when a trigger is considered to be a match for an event

        :param match_criteria: The match_criteria of this Trigger.
        :type: list[MatchCriteria]
        """
        

        self._match_criteria = match_criteria

    @property
    def event_ttl_seconds(self):
        """
        Gets the event_ttl_seconds of this Trigger.
        How long each event is meaningful after origination, in seconds. Events older than this threshold may be dropped if the platform is delayed in processing events. Unset means events are valid indefinitely.

        :return: The event_ttl_seconds of this Trigger.
        :rtype: int
        """
        return self._event_ttl_seconds

    @event_ttl_seconds.setter
    def event_ttl_seconds(self, event_ttl_seconds):
        """
        Sets the event_ttl_seconds of this Trigger.
        How long each event is meaningful after origination, in seconds. Events older than this threshold may be dropped if the platform is delayed in processing events. Unset means events are valid indefinitely.

        :param event_ttl_seconds: The event_ttl_seconds of this Trigger.
        :type: int
        """
        

        self._event_ttl_seconds = event_ttl_seconds

    @property
    def description(self):
        """
        Gets the description of this Trigger.
        Description of the trigger. Can be up to 512 characters in length.

        :return: The description of this Trigger.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Trigger.
        Description of the trigger. Can be up to 512 characters in length.

        :param description: The description of this Trigger.
        :type: str
        """
        

        self._description = description

    @property
    def self_uri(self):
        """
        Gets the self_uri of this Trigger.
        The URI for this object

        :return: The self_uri of this Trigger.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this Trigger.
        The URI for this object

        :param self_uri: The self_uri of this Trigger.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

