# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class HistoricalShrinkageResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        HistoricalShrinkageResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'start_date': 'datetime',
            'end_date': 'datetime',
            'total_scheduled_duration_seconds': 'int',
            'total_logged_in_duration_seconds': 'int',
            'aggregated_shrinkage': 'HistoricalShrinkageAggregateResponse',
            'shrinkage_for_activity_categories': 'list[HistoricalShrinkageActivityCategoryResponse]'
        }

        self.attribute_map = {
            'start_date': 'startDate',
            'end_date': 'endDate',
            'total_scheduled_duration_seconds': 'totalScheduledDurationSeconds',
            'total_logged_in_duration_seconds': 'totalLoggedInDurationSeconds',
            'aggregated_shrinkage': 'aggregatedShrinkage',
            'shrinkage_for_activity_categories': 'shrinkageForActivityCategories'
        }

        self._start_date = None
        self._end_date = None
        self._total_scheduled_duration_seconds = None
        self._total_logged_in_duration_seconds = None
        self._aggregated_shrinkage = None
        self._shrinkage_for_activity_categories = None

    @property
    def start_date(self):
        """
        Gets the start_date of this HistoricalShrinkageResult.
        Beginning of the date range that was queried, in ISO-8601 format

        :return: The start_date of this HistoricalShrinkageResult.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this HistoricalShrinkageResult.
        Beginning of the date range that was queried, in ISO-8601 format

        :param start_date: The start_date of this HistoricalShrinkageResult.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this HistoricalShrinkageResult.
        End of the date range that was queried, in ISO-8601 format. If it was not set, end date will be set to the queried time

        :return: The end_date of this HistoricalShrinkageResult.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this HistoricalShrinkageResult.
        End of the date range that was queried, in ISO-8601 format. If it was not set, end date will be set to the queried time

        :param end_date: The end_date of this HistoricalShrinkageResult.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def total_scheduled_duration_seconds(self):
        """
        Gets the total_scheduled_duration_seconds of this HistoricalShrinkageResult.
        Total duration in seconds for which agents in the management unit are scheduled

        :return: The total_scheduled_duration_seconds of this HistoricalShrinkageResult.
        :rtype: int
        """
        return self._total_scheduled_duration_seconds

    @total_scheduled_duration_seconds.setter
    def total_scheduled_duration_seconds(self, total_scheduled_duration_seconds):
        """
        Sets the total_scheduled_duration_seconds of this HistoricalShrinkageResult.
        Total duration in seconds for which agents in the management unit are scheduled

        :param total_scheduled_duration_seconds: The total_scheduled_duration_seconds of this HistoricalShrinkageResult.
        :type: int
        """
        

        self._total_scheduled_duration_seconds = total_scheduled_duration_seconds

    @property
    def total_logged_in_duration_seconds(self):
        """
        Gets the total_logged_in_duration_seconds of this HistoricalShrinkageResult.
        Total duration in seconds for which agents in the management unit are actually logged-in

        :return: The total_logged_in_duration_seconds of this HistoricalShrinkageResult.
        :rtype: int
        """
        return self._total_logged_in_duration_seconds

    @total_logged_in_duration_seconds.setter
    def total_logged_in_duration_seconds(self, total_logged_in_duration_seconds):
        """
        Sets the total_logged_in_duration_seconds of this HistoricalShrinkageResult.
        Total duration in seconds for which agents in the management unit are actually logged-in

        :param total_logged_in_duration_seconds: The total_logged_in_duration_seconds of this HistoricalShrinkageResult.
        :type: int
        """
        

        self._total_logged_in_duration_seconds = total_logged_in_duration_seconds

    @property
    def aggregated_shrinkage(self):
        """
        Gets the aggregated_shrinkage of this HistoricalShrinkageResult.
        Aggregated shrinkage data for all the activity categories

        :return: The aggregated_shrinkage of this HistoricalShrinkageResult.
        :rtype: HistoricalShrinkageAggregateResponse
        """
        return self._aggregated_shrinkage

    @aggregated_shrinkage.setter
    def aggregated_shrinkage(self, aggregated_shrinkage):
        """
        Sets the aggregated_shrinkage of this HistoricalShrinkageResult.
        Aggregated shrinkage data for all the activity categories

        :param aggregated_shrinkage: The aggregated_shrinkage of this HistoricalShrinkageResult.
        :type: HistoricalShrinkageAggregateResponse
        """
        

        self._aggregated_shrinkage = aggregated_shrinkage

    @property
    def shrinkage_for_activity_categories(self):
        """
        Gets the shrinkage_for_activity_categories of this HistoricalShrinkageResult.
        Shrinkage for activity categories

        :return: The shrinkage_for_activity_categories of this HistoricalShrinkageResult.
        :rtype: list[HistoricalShrinkageActivityCategoryResponse]
        """
        return self._shrinkage_for_activity_categories

    @shrinkage_for_activity_categories.setter
    def shrinkage_for_activity_categories(self, shrinkage_for_activity_categories):
        """
        Sets the shrinkage_for_activity_categories of this HistoricalShrinkageResult.
        Shrinkage for activity categories

        :param shrinkage_for_activity_categories: The shrinkage_for_activity_categories of this HistoricalShrinkageResult.
        :type: list[HistoricalShrinkageActivityCategoryResponse]
        """
        

        self._shrinkage_for_activity_categories = shrinkage_for_activity_categories

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

