# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AgentActivity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AgentActivity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'agent': 'User',
            'num_evaluations': 'int',
            'average_evaluation_score': 'int',
            'num_critical_evaluations': 'int',
            'average_critical_score': 'float',
            'highest_evaluation_score': 'float',
            'lowest_evaluation_score': 'float',
            'highest_critical_score': 'float',
            'lowest_critical_score': 'float',
            'agent_evaluator_activity_list': 'list[AgentEvaluatorActivity]',
            'num_evaluations_without_view_permission': 'int',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'agent': 'agent',
            'num_evaluations': 'numEvaluations',
            'average_evaluation_score': 'averageEvaluationScore',
            'num_critical_evaluations': 'numCriticalEvaluations',
            'average_critical_score': 'averageCriticalScore',
            'highest_evaluation_score': 'highestEvaluationScore',
            'lowest_evaluation_score': 'lowestEvaluationScore',
            'highest_critical_score': 'highestCriticalScore',
            'lowest_critical_score': 'lowestCriticalScore',
            'agent_evaluator_activity_list': 'agentEvaluatorActivityList',
            'num_evaluations_without_view_permission': 'numEvaluationsWithoutViewPermission',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._agent = None
        self._num_evaluations = None
        self._average_evaluation_score = None
        self._num_critical_evaluations = None
        self._average_critical_score = None
        self._highest_evaluation_score = None
        self._lowest_evaluation_score = None
        self._highest_critical_score = None
        self._lowest_critical_score = None
        self._agent_evaluator_activity_list = None
        self._num_evaluations_without_view_permission = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this AgentActivity.
        The globally unique identifier for the object.

        :return: The id of this AgentActivity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AgentActivity.
        The globally unique identifier for the object.

        :param id: The id of this AgentActivity.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this AgentActivity.


        :return: The name of this AgentActivity.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AgentActivity.


        :param name: The name of this AgentActivity.
        :type: str
        """
        

        self._name = name

    @property
    def agent(self):
        """
        Gets the agent of this AgentActivity.


        :return: The agent of this AgentActivity.
        :rtype: User
        """
        return self._agent

    @agent.setter
    def agent(self, agent):
        """
        Sets the agent of this AgentActivity.


        :param agent: The agent of this AgentActivity.
        :type: User
        """
        

        self._agent = agent

    @property
    def num_evaluations(self):
        """
        Gets the num_evaluations of this AgentActivity.


        :return: The num_evaluations of this AgentActivity.
        :rtype: int
        """
        return self._num_evaluations

    @num_evaluations.setter
    def num_evaluations(self, num_evaluations):
        """
        Sets the num_evaluations of this AgentActivity.


        :param num_evaluations: The num_evaluations of this AgentActivity.
        :type: int
        """
        

        self._num_evaluations = num_evaluations

    @property
    def average_evaluation_score(self):
        """
        Gets the average_evaluation_score of this AgentActivity.


        :return: The average_evaluation_score of this AgentActivity.
        :rtype: int
        """
        return self._average_evaluation_score

    @average_evaluation_score.setter
    def average_evaluation_score(self, average_evaluation_score):
        """
        Sets the average_evaluation_score of this AgentActivity.


        :param average_evaluation_score: The average_evaluation_score of this AgentActivity.
        :type: int
        """
        

        self._average_evaluation_score = average_evaluation_score

    @property
    def num_critical_evaluations(self):
        """
        Gets the num_critical_evaluations of this AgentActivity.


        :return: The num_critical_evaluations of this AgentActivity.
        :rtype: int
        """
        return self._num_critical_evaluations

    @num_critical_evaluations.setter
    def num_critical_evaluations(self, num_critical_evaluations):
        """
        Sets the num_critical_evaluations of this AgentActivity.


        :param num_critical_evaluations: The num_critical_evaluations of this AgentActivity.
        :type: int
        """
        

        self._num_critical_evaluations = num_critical_evaluations

    @property
    def average_critical_score(self):
        """
        Gets the average_critical_score of this AgentActivity.


        :return: The average_critical_score of this AgentActivity.
        :rtype: float
        """
        return self._average_critical_score

    @average_critical_score.setter
    def average_critical_score(self, average_critical_score):
        """
        Sets the average_critical_score of this AgentActivity.


        :param average_critical_score: The average_critical_score of this AgentActivity.
        :type: float
        """
        

        self._average_critical_score = average_critical_score

    @property
    def highest_evaluation_score(self):
        """
        Gets the highest_evaluation_score of this AgentActivity.


        :return: The highest_evaluation_score of this AgentActivity.
        :rtype: float
        """
        return self._highest_evaluation_score

    @highest_evaluation_score.setter
    def highest_evaluation_score(self, highest_evaluation_score):
        """
        Sets the highest_evaluation_score of this AgentActivity.


        :param highest_evaluation_score: The highest_evaluation_score of this AgentActivity.
        :type: float
        """
        

        self._highest_evaluation_score = highest_evaluation_score

    @property
    def lowest_evaluation_score(self):
        """
        Gets the lowest_evaluation_score of this AgentActivity.


        :return: The lowest_evaluation_score of this AgentActivity.
        :rtype: float
        """
        return self._lowest_evaluation_score

    @lowest_evaluation_score.setter
    def lowest_evaluation_score(self, lowest_evaluation_score):
        """
        Sets the lowest_evaluation_score of this AgentActivity.


        :param lowest_evaluation_score: The lowest_evaluation_score of this AgentActivity.
        :type: float
        """
        

        self._lowest_evaluation_score = lowest_evaluation_score

    @property
    def highest_critical_score(self):
        """
        Gets the highest_critical_score of this AgentActivity.


        :return: The highest_critical_score of this AgentActivity.
        :rtype: float
        """
        return self._highest_critical_score

    @highest_critical_score.setter
    def highest_critical_score(self, highest_critical_score):
        """
        Sets the highest_critical_score of this AgentActivity.


        :param highest_critical_score: The highest_critical_score of this AgentActivity.
        :type: float
        """
        

        self._highest_critical_score = highest_critical_score

    @property
    def lowest_critical_score(self):
        """
        Gets the lowest_critical_score of this AgentActivity.


        :return: The lowest_critical_score of this AgentActivity.
        :rtype: float
        """
        return self._lowest_critical_score

    @lowest_critical_score.setter
    def lowest_critical_score(self, lowest_critical_score):
        """
        Sets the lowest_critical_score of this AgentActivity.


        :param lowest_critical_score: The lowest_critical_score of this AgentActivity.
        :type: float
        """
        

        self._lowest_critical_score = lowest_critical_score

    @property
    def agent_evaluator_activity_list(self):
        """
        Gets the agent_evaluator_activity_list of this AgentActivity.


        :return: The agent_evaluator_activity_list of this AgentActivity.
        :rtype: list[AgentEvaluatorActivity]
        """
        return self._agent_evaluator_activity_list

    @agent_evaluator_activity_list.setter
    def agent_evaluator_activity_list(self, agent_evaluator_activity_list):
        """
        Sets the agent_evaluator_activity_list of this AgentActivity.


        :param agent_evaluator_activity_list: The agent_evaluator_activity_list of this AgentActivity.
        :type: list[AgentEvaluatorActivity]
        """
        

        self._agent_evaluator_activity_list = agent_evaluator_activity_list

    @property
    def num_evaluations_without_view_permission(self):
        """
        Gets the num_evaluations_without_view_permission of this AgentActivity.


        :return: The num_evaluations_without_view_permission of this AgentActivity.
        :rtype: int
        """
        return self._num_evaluations_without_view_permission

    @num_evaluations_without_view_permission.setter
    def num_evaluations_without_view_permission(self, num_evaluations_without_view_permission):
        """
        Sets the num_evaluations_without_view_permission of this AgentActivity.


        :param num_evaluations_without_view_permission: The num_evaluations_without_view_permission of this AgentActivity.
        :type: int
        """
        

        self._num_evaluations_without_view_permission = num_evaluations_without_view_permission

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AgentActivity.
        The URI for this object

        :return: The self_uri of this AgentActivity.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AgentActivity.
        The URI for this object

        :param self_uri: The self_uri of this AgentActivity.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

