# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from fastfuels_sdk.client_library.models.meta_canopy_height_map_source import MetaCanopyHeightMapSource
from fastfuels_sdk.client_library.models.tree_map_version import TreeMapVersion
from typing import Optional, Set
from typing_extensions import Self

class TreeMapSource(BaseModel):
    """
    TreeMapSource
    """ # noqa: E501
    version: Optional[TreeMapVersion] = None
    seed: Optional[StrictInt] = None
    canopy_height_map_configuration: Optional[MetaCanopyHeightMapSource] = Field(default=None, alias="canopyHeightMapConfiguration")
    __properties: ClassVar[List[str]] = ["version", "seed", "canopyHeightMapConfiguration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TreeMapSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of canopy_height_map_configuration
        if self.canopy_height_map_configuration:
            _dict['canopyHeightMapConfiguration'] = self.canopy_height_map_configuration.to_dict()
        # set to None if canopy_height_map_configuration (nullable) is None
        # and model_fields_set contains the field
        if self.canopy_height_map_configuration is None and "canopy_height_map_configuration" in self.model_fields_set:
            _dict['canopyHeightMapConfiguration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TreeMapSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "version": obj.get("version"),
            "seed": obj.get("seed"),
            "canopyHeightMapConfiguration": MetaCanopyHeightMapSource.from_dict(obj["canopyHeightMapConfiguration"]) if obj.get("canopyHeightMapConfiguration") is not None else None
        })
        return _obj


