# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from fastfuels_sdk.client_library.models.topography_grid3_dep_source import TopographyGrid3DEPSource
from fastfuels_sdk.client_library.models.topography_grid_landfire_source import TopographyGridLandfireSource
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

TOPOGRAPHYGRIDSLOPESOURCE_ONE_OF_SCHEMAS = ["TopographyGrid3DEPSource", "TopographyGridLandfireSource"]

class TopographyGridSlopeSource(BaseModel):
    """
    TopographyGridSlopeSource
    """
    # data type: TopographyGrid3DEPSource
    oneof_schema_1_validator: Optional[TopographyGrid3DEPSource] = None
    # data type: TopographyGridLandfireSource
    oneof_schema_2_validator: Optional[TopographyGridLandfireSource] = None
    actual_instance: Optional[Union[TopographyGrid3DEPSource, TopographyGridLandfireSource]] = None
    one_of_schemas: Set[str] = { "TopographyGrid3DEPSource", "TopographyGridLandfireSource" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        if v is None:
            return v

        instance = TopographyGridSlopeSource.model_construct()
        error_messages = []
        match = 0
        # validate data type: TopographyGrid3DEPSource
        if not isinstance(v, TopographyGrid3DEPSource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TopographyGrid3DEPSource`")
        else:
            match += 1
        # validate data type: TopographyGridLandfireSource
        if not isinstance(v, TopographyGridLandfireSource):
            error_messages.append(f"Error! Input type `{type(v)}` is not `TopographyGridLandfireSource`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in TopographyGridSlopeSource with oneOf schemas: TopographyGrid3DEPSource, TopographyGridLandfireSource. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in TopographyGridSlopeSource with oneOf schemas: TopographyGrid3DEPSource, TopographyGridLandfireSource. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: Optional[str]) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        match = 0

        # deserialize data into TopographyGrid3DEPSource
        try:
            instance.actual_instance = TopographyGrid3DEPSource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into TopographyGridLandfireSource
        try:
            instance.actual_instance = TopographyGridLandfireSource.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TopographyGridSlopeSource with oneOf schemas: TopographyGrid3DEPSource, TopographyGridLandfireSource. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TopographyGridSlopeSource with oneOf schemas: TopographyGrid3DEPSource, TopographyGridLandfireSource. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], TopographyGrid3DEPSource, TopographyGridLandfireSource]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


