# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from fastfuels_sdk.client_library.models.feature_type import FeatureType
from fastfuels_sdk.client_library.models.surface_grid_interpolation_method import SurfaceGridInterpolationMethod
from fastfuels_sdk.client_library.models.surface_grid_landfire_fbfm40_group import SurfaceGridLandfireFBFM40Group
from typing import Optional, Set
from typing_extensions import Self

class SurfaceGridLandfireFBFM40SAVRSource(BaseModel):
    """
    SurfaceGridLandfireFBFM40SAVRSource
    """ # noqa: E501
    feature_masks: Optional[List[FeatureType]] = Field(default=None, description="List of feature masks to apply to the surface grid attribute", alias="featureMasks")
    source: Optional[StrictStr] = 'LANDFIRE'
    product: Optional[StrictStr] = 'FBFM40'
    version: Optional[StrictStr] = Field(default='2022', description="Version of the LANDFIRE data to use for the surface grid attribute.")
    interpolation_method: Optional[SurfaceGridInterpolationMethod] = Field(default=None, description="Interpolation method to use when resampling the LANDFIRE data to the desired surface grid resolution.", alias="interpolationMethod")
    remove_non_burnable: Optional[List[StrictStr]] = Field(default=None, alias="removeNonBurnable")
    groups: Optional[Annotated[List[SurfaceGridLandfireFBFM40Group], Field(min_length=1)]] = None
    __properties: ClassVar[List[str]] = ["featureMasks", "source", "product", "version", "interpolationMethod", "removeNonBurnable", "groups"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['LANDFIRE']):
            raise ValueError("must be one of enum values ('LANDFIRE')")
        return value

    @field_validator('product')
    def product_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['FBFM40']):
            raise ValueError("must be one of enum values ('FBFM40')")
        return value

    @field_validator('version')
    def version_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['2022']):
            raise ValueError("must be one of enum values ('2022')")
        return value

    @field_validator('remove_non_burnable')
    def remove_non_burnable_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['NB1', 'NB2', 'NB3', 'NB8', 'NB9']):
                raise ValueError("each list item must be one of ('NB1', 'NB2', 'NB3', 'NB8', 'NB9')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SurfaceGridLandfireFBFM40SAVRSource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if remove_non_burnable (nullable) is None
        # and model_fields_set contains the field
        if self.remove_non_burnable is None and "remove_non_burnable" in self.model_fields_set:
            _dict['removeNonBurnable'] = None

        # set to None if groups (nullable) is None
        # and model_fields_set contains the field
        if self.groups is None and "groups" in self.model_fields_set:
            _dict['groups'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SurfaceGridLandfireFBFM40SAVRSource from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "featureMasks": obj.get("featureMasks"),
            "source": obj.get("source") if obj.get("source") is not None else 'LANDFIRE',
            "product": obj.get("product") if obj.get("product") is not None else 'FBFM40',
            "version": obj.get("version") if obj.get("version") is not None else '2022',
            "interpolationMethod": obj.get("interpolationMethod"),
            "removeNonBurnable": obj.get("removeNonBurnable"),
            "groups": obj.get("groups")
        })
        return _obj


