# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from fastfuels_sdk.client_library.models.line_string import LineString
from fastfuels_sdk.client_library.models.multi_line_string import MultiLineString
from fastfuels_sdk.client_library.models.multi_point import MultiPoint
from fastfuels_sdk.client_library.models.multi_polygon import MultiPolygon
from fastfuels_sdk.client_library.models.point import Point
from fastfuels_sdk.client_library.models.polygon import Polygon
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

GEOMETRY_ONE_OF_SCHEMAS = ["LineString", "MultiLineString", "MultiPoint", "MultiPolygon", "Point", "Polygon"]

class Geometry(BaseModel):
    """
    Geometry
    """
    # data type: Point
    oneof_schema_1_validator: Optional[Point] = None
    # data type: MultiPoint
    oneof_schema_2_validator: Optional[MultiPoint] = None
    # data type: LineString
    oneof_schema_3_validator: Optional[LineString] = None
    # data type: MultiLineString
    oneof_schema_4_validator: Optional[MultiLineString] = None
    # data type: Polygon
    oneof_schema_5_validator: Optional[Polygon] = None
    # data type: MultiPolygon
    oneof_schema_6_validator: Optional[MultiPolygon] = None
    actual_instance: Optional[Union[LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon]] = None
    one_of_schemas: Set[str] = { "LineString", "MultiLineString", "MultiPoint", "MultiPolygon", "Point", "Polygon" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = Geometry.model_construct()
        error_messages = []
        match = 0
        # validate data type: Point
        if not isinstance(v, Point):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Point`")
        else:
            match += 1
        # validate data type: MultiPoint
        if not isinstance(v, MultiPoint):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiPoint`")
        else:
            match += 1
        # validate data type: LineString
        if not isinstance(v, LineString):
            error_messages.append(f"Error! Input type `{type(v)}` is not `LineString`")
        else:
            match += 1
        # validate data type: MultiLineString
        if not isinstance(v, MultiLineString):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiLineString`")
        else:
            match += 1
        # validate data type: Polygon
        if not isinstance(v, Polygon):
            error_messages.append(f"Error! Input type `{type(v)}` is not `Polygon`")
        else:
            match += 1
        # validate data type: MultiPolygon
        if not isinstance(v, MultiPolygon):
            error_messages.append(f"Error! Input type `{type(v)}` is not `MultiPolygon`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in Geometry with oneOf schemas: LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in Geometry with oneOf schemas: LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into Point
        try:
            instance.actual_instance = Point.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MultiPoint
        try:
            instance.actual_instance = MultiPoint.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into LineString
        try:
            instance.actual_instance = LineString.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MultiLineString
        try:
            instance.actual_instance = MultiLineString.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into Polygon
        try:
            instance.actual_instance = Polygon.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into MultiPolygon
        try:
            instance.actual_instance = MultiPolygon.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into Geometry with oneOf schemas: LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Geometry with oneOf schemas: LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], LineString, MultiLineString, MultiPoint, MultiPolygon, Point, Polygon]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


