# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class GeoJSONStyleProperties(BaseModel):
    """
    GeoJSONStyleProperties
    """ # noqa: E501
    stroke_color: Optional[StrictStr] = Field(default=None, alias="strokeColor")
    stroke_opacity: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, alias="strokeOpacity")
    stroke_width: Optional[Union[Annotated[float, Field(strict=True, ge=0.0)], Annotated[int, Field(strict=True, ge=0)]]] = Field(default=None, alias="strokeWidth")
    fill_color: Optional[StrictStr] = Field(default=None, alias="fillColor")
    fill_opacity: Optional[Union[Annotated[float, Field(le=1.0, strict=True, ge=0.0)], Annotated[int, Field(le=1, strict=True, ge=0)]]] = Field(default=None, alias="fillOpacity")
    __properties: ClassVar[List[str]] = ["strokeColor", "strokeOpacity", "strokeWidth", "fillColor", "fillOpacity"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeoJSONStyleProperties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if stroke_color (nullable) is None
        # and model_fields_set contains the field
        if self.stroke_color is None and "stroke_color" in self.model_fields_set:
            _dict['strokeColor'] = None

        # set to None if stroke_opacity (nullable) is None
        # and model_fields_set contains the field
        if self.stroke_opacity is None and "stroke_opacity" in self.model_fields_set:
            _dict['strokeOpacity'] = None

        # set to None if stroke_width (nullable) is None
        # and model_fields_set contains the field
        if self.stroke_width is None and "stroke_width" in self.model_fields_set:
            _dict['strokeWidth'] = None

        # set to None if fill_color (nullable) is None
        # and model_fields_set contains the field
        if self.fill_color is None and "fill_color" in self.model_fields_set:
            _dict['fillColor'] = None

        # set to None if fill_opacity (nullable) is None
        # and model_fields_set contains the field
        if self.fill_opacity is None and "fill_opacity" in self.model_fields_set:
            _dict['fillOpacity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeoJSONStyleProperties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "strokeColor": obj.get("strokeColor"),
            "strokeOpacity": obj.get("strokeOpacity"),
            "strokeWidth": obj.get("strokeWidth"),
            "fillColor": obj.get("fillColor"),
            "fillOpacity": obj.get("fillOpacity")
        })
        return _obj


