# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.create_water_feature_request import CreateWaterFeatureRequest
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.water_feature import WaterFeature

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class WaterFeatureApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_water_feature(
        self,
        domain_id: StrictStr,
        create_water_feature_request: CreateWaterFeatureRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WaterFeature:
        """Create Water Feature

        # Create Water Feature  This endpoint creates a new water feature resource for a specific domain. Water feature data represents various water-related attributes (e.g., lakes, rivers) that exist within the spatial context of a domain. The water feature data can be sourced from different data sources (e.g., OSM) and can include various details about water features in the domain.  On resource creation, the water feature data is set to a status of \"pending\". The data is processed in the background, and once it is available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the water feature.  ## Request Body  The request body should be a JSON object containing the following fields:  - `sources` (array of strings, required): List of sources from which the   water feature data should be collected. Currently, `\"OSM\"` is a supported source. - Additional fields might be included based on the source. For example,   if the source is `\"OSM\"`, the request can specify additional parameters   related to how the data should be fetched.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. Initially set to `\"pending\"`. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `422 Unprocessable Entity`: The domain is in a local coordinate system which   does not support water features.   - **Detail**: \"WaterFeature is not supported for local coordinate systems.\" - `429 Too Many Requests`: An error occurred while running the job for processing   the water feature data.   - **Detail**: An error message related to job submission.  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If using `\"OSM\"` as a source, additional parameters can be specified as needed. - The process of creating and updating the water feature data involves background   job execution, and the endpoint will return the initial resource with a pending status.

        :param domain_id: (required)
        :type domain_id: str
        :param create_water_feature_request: (required)
        :type create_water_feature_request: CreateWaterFeatureRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_serialize(
            domain_id=domain_id,
            create_water_feature_request=create_water_feature_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_water_feature_with_http_info(
        self,
        domain_id: StrictStr,
        create_water_feature_request: CreateWaterFeatureRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WaterFeature]:
        """Create Water Feature

        # Create Water Feature  This endpoint creates a new water feature resource for a specific domain. Water feature data represents various water-related attributes (e.g., lakes, rivers) that exist within the spatial context of a domain. The water feature data can be sourced from different data sources (e.g., OSM) and can include various details about water features in the domain.  On resource creation, the water feature data is set to a status of \"pending\". The data is processed in the background, and once it is available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the water feature.  ## Request Body  The request body should be a JSON object containing the following fields:  - `sources` (array of strings, required): List of sources from which the   water feature data should be collected. Currently, `\"OSM\"` is a supported source. - Additional fields might be included based on the source. For example,   if the source is `\"OSM\"`, the request can specify additional parameters   related to how the data should be fetched.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. Initially set to `\"pending\"`. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `422 Unprocessable Entity`: The domain is in a local coordinate system which   does not support water features.   - **Detail**: \"WaterFeature is not supported for local coordinate systems.\" - `429 Too Many Requests`: An error occurred while running the job for processing   the water feature data.   - **Detail**: An error message related to job submission.  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If using `\"OSM\"` as a source, additional parameters can be specified as needed. - The process of creating and updating the water feature data involves background   job execution, and the endpoint will return the initial resource with a pending status.

        :param domain_id: (required)
        :type domain_id: str
        :param create_water_feature_request: (required)
        :type create_water_feature_request: CreateWaterFeatureRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_serialize(
            domain_id=domain_id,
            create_water_feature_request=create_water_feature_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_water_feature_without_preload_content(
        self,
        domain_id: StrictStr,
        create_water_feature_request: CreateWaterFeatureRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Water Feature

        # Create Water Feature  This endpoint creates a new water feature resource for a specific domain. Water feature data represents various water-related attributes (e.g., lakes, rivers) that exist within the spatial context of a domain. The water feature data can be sourced from different data sources (e.g., OSM) and can include various details about water features in the domain.  On resource creation, the water feature data is set to a status of \"pending\". The data is processed in the background, and once it is available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the water feature.  ## Request Body  The request body should be a JSON object containing the following fields:  - `sources` (array of strings, required): List of sources from which the   water feature data should be collected. Currently, `\"OSM\"` is a supported source. - Additional fields might be included based on the source. For example,   if the source is `\"OSM\"`, the request can specify additional parameters   related to how the data should be fetched.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. Initially set to `\"pending\"`. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `422 Unprocessable Entity`: The domain is in a local coordinate system which   does not support water features.   - **Detail**: \"WaterFeature is not supported for local coordinate systems.\" - `429 Too Many Requests`: An error occurred while running the job for processing   the water feature data.   - **Detail**: An error message related to job submission.  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If using `\"OSM\"` as a source, additional parameters can be specified as needed. - The process of creating and updating the water feature data involves background   job execution, and the endpoint will return the initial resource with a pending status.

        :param domain_id: (required)
        :type domain_id: str
        :param create_water_feature_request: (required)
        :type create_water_feature_request: CreateWaterFeatureRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_serialize(
            domain_id=domain_id,
            create_water_feature_request=create_water_feature_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_water_feature_serialize(
        self,
        domain_id,
        create_water_feature_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_water_feature_request is not None:
            _body_params = create_water_feature_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/features/water',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_water_feature_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Water Feature Export

        # Create Water Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the water feature data of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the water feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or water features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_water_feature_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Water Feature Export

        # Create Water Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the water feature data of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the water feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or water features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_water_feature_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Water Feature Export

        # Create Water Feature Export  ## Endpoint  ``` POST /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the water feature data of a specific domain, in the specified format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format in which to export the water feature data. Possible value:   - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of the export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation). - `signedUrl` (string, optional): Initially `null`, populated when export is completed.  ## Error Responses  - `404 Not Found`: If the domain is not found, or there are no water or water features created. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - The export will be processed as a background job, and the status will initially be set to `\"pending\"`. - Check the export status using a separate endpoint to monitor progress. - Once the export is complete, use the `signedUrl` to download the GeoJSON file.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_water_feature_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/features/water/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_water_feature(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Water Feature

        # Delete Water Feature  This endpoint deletes an existing water feature resource for a specific domain. This action removes the water feature data from the database and cancels any ongoing job execution related to the water feature.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the water feature.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the water feature has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it.  - **Detail**: \"Domain not found\" - `404 Not Found`: The water feature for the specified domain does not exist.  - **Detail**: \"Water feature not found\"  ## Usage Notes  - Deleting a water feature is a permanent action and cannot be undone. Ensure that you have  the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the water feature and  remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_water_feature_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Water Feature

        # Delete Water Feature  This endpoint deletes an existing water feature resource for a specific domain. This action removes the water feature data from the database and cancels any ongoing job execution related to the water feature.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the water feature.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the water feature has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it.  - **Detail**: \"Domain not found\" - `404 Not Found`: The water feature for the specified domain does not exist.  - **Detail**: \"Water feature not found\"  ## Usage Notes  - Deleting a water feature is a permanent action and cannot be undone. Ensure that you have  the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the water feature and  remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_water_feature_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Water Feature

        # Delete Water Feature  This endpoint deletes an existing water feature resource for a specific domain. This action removes the water feature data from the database and cancels any ongoing job execution related to the water feature.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the water feature.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the water feature has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it.  - **Detail**: \"Domain not found\" - `404 Not Found`: The water feature for the specified domain does not exist.  - **Detail**: \"Water feature not found\"  ## Usage Notes  - Deleting a water feature is a permanent action and cannot be undone. Ensure that you have  the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the water feature and  remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_water_feature_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/features/water',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_water_feature(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> WaterFeature:
        """Get Water Feature

        # Get Water Feature  This endpoint retrieves the details of an existing water feature resource for a specific domain. The water feature data represents various water-related attributes (e.g., lakes, rivers) that have been created and stored for the given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the water feature.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The water feature for the specified domain does not exist or is empty.   - **Detail**: \"water feature empty.\"  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If the water feature data does not exist or is empty, a `404 Not Found` error will be raised.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_water_feature_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[WaterFeature]:
        """Get Water Feature

        # Get Water Feature  This endpoint retrieves the details of an existing water feature resource for a specific domain. The water feature data represents various water-related attributes (e.g., lakes, rivers) that have been created and stored for the given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the water feature.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The water feature for the specified domain does not exist or is empty.   - **Detail**: \"water feature empty.\"  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If the water feature data does not exist or is empty, a `404 Not Found` error will be raised.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_water_feature_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Water Feature

        # Get Water Feature  This endpoint retrieves the details of an existing water feature resource for a specific domain. The water feature data represents various water-related attributes (e.g., lakes, rivers) that have been created and stored for the given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the water feature.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the water feature resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the water feature. - `createdOn` (string): The timestamp when the water feature was created. - `modifiedOn` (string): The timestamp when the water feature was last modified. - `checksum` (string): A unique checksum for the water feature resource. - `sources` (array of strings): The list of sources used to gather the water feature data.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The water feature for the specified domain does not exist or is empty.   - **Detail**: \"water feature empty.\"  ## Usage Notes  - Ensure that the domain ID provided in the request path is valid and that the user   has access to the specified domain. - If the water feature data does not exist or is empty, a `404 Not Found` error will be raised.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "WaterFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_water_feature_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/features/water',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_water_feature_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Water Feature Export

        # Get Water Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a water feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_water_feature_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Water Feature Export

        # Get Water Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a water feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_water_feature_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Water Feature Export

        # Get Water Feature Export  ## Endpoint  ``` GET /v1/domains/{domainId}/features/water/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a feature export request (for water features) for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Possible value:     - `\"geojson\"`: Export the feature data in GeoJSON format.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of the last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Export not found or no feature data exists for the specified export format.  ## Usage Notes  - Use this endpoint to check the status of a water feature export request. - Once the status is `\"completed\"`, you can use the `signedUrl` to download the exported GeoJSON file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_water_feature_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_water_feature_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/features/water/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


