# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.create_topography_grid_request import CreateTopographyGridRequest
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.grid_attribute_metadata_response import GridAttributeMetadataResponse
from fastfuels_sdk.client_library.models.topography_grid import TopographyGrid

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class TopographyGridApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_topography_grid(
        self,
        domain_id: StrictStr,
        create_topography_grid_request: CreateTopographyGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TopographyGrid:
        """Create Topography Grid

        # Create Topography Grid  This endpoint creates a new topography grid resource for a specific domain. Topography grid data represents various topographic attributes (elevation, slope, and aspect) that exist within the spatial context of a domain. The topography grid data can be generated using different data sources (3DEP, LANDFIRE, or uniform values) and interpolation methods.  On resource creation, the topography grid data is set to a status of \"pending\". The topography grid data is generated in the background using the specified method and data sources. Once the topography grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the topography grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the topography grid. Possible values are:   - `\"elevation\"`   - `\"slope\"`   - `\"aspect\"`  ### Attribute Descriptions and Sources  - `elevation` (m): The elevation of the terrain above sea level. - `slope` (degrees): The slope of the terrain surface. - `aspect` (degrees): The aspect of the terrain surface (direction the slope faces).  Each attribute can be sourced from different data sources. By default, the system will use 3DEP (USGS 3D Elevation Program) data for all attributes. However, if you want to specify different sources or configurations for any attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"elevation\"],     \"elevation\": {         \"source\": \"3DEP\",         \"interpolationMethod\": \"cubic\"     } } ```  The structure of attribute configuration objects depends on the source specified:  #### 3DEP Source (Default)  If the source is `\"3DEP\"`, the object should have the following fields:  - `source` (string, required): Must be `\"3DEP\"`. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points without interpolation   - `\"linear\"`: Linear interpolation between points   - `\"cubic\"`: Smooth interpolation using cubic splines (default for elevation and slope)  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### LANDFIRE Source  If the source is `\"LANDFIRE\"`, the object should have the following fields:  - `source` (string, required): Must be `\"LANDFIRE\"`. - `version` (string, required): The version of the LANDFIRE product. Currently, only `\"2020\"` is supported. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points   - `\"linear\"`: Linear interpolation   - `\"cubic\"`: Smooth cubic interpolation   - `\"zipper\"`: Special method for LANDFIRE data  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `source` (string, required): Must be `\"uniform\"`. - `value` (float, required): The uniform value for the attribute.  Note: Uniform source is only available for the elevation attribute.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid. - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The status of the topography grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `422 Unprocessable Entity`: The request body is invalid, the data sources are not compatible with the domain CRS, or required fields are missing. - `429 Too Many Requests`: The system is currently unable to process additional job requests.

        :param domain_id: (required)
        :type domain_id: str
        :param create_topography_grid_request: (required)
        :type create_topography_grid_request: CreateTopographyGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_serialize(
            domain_id=domain_id,
            create_topography_grid_request=create_topography_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_topography_grid_with_http_info(
        self,
        domain_id: StrictStr,
        create_topography_grid_request: CreateTopographyGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TopographyGrid]:
        """Create Topography Grid

        # Create Topography Grid  This endpoint creates a new topography grid resource for a specific domain. Topography grid data represents various topographic attributes (elevation, slope, and aspect) that exist within the spatial context of a domain. The topography grid data can be generated using different data sources (3DEP, LANDFIRE, or uniform values) and interpolation methods.  On resource creation, the topography grid data is set to a status of \"pending\". The topography grid data is generated in the background using the specified method and data sources. Once the topography grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the topography grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the topography grid. Possible values are:   - `\"elevation\"`   - `\"slope\"`   - `\"aspect\"`  ### Attribute Descriptions and Sources  - `elevation` (m): The elevation of the terrain above sea level. - `slope` (degrees): The slope of the terrain surface. - `aspect` (degrees): The aspect of the terrain surface (direction the slope faces).  Each attribute can be sourced from different data sources. By default, the system will use 3DEP (USGS 3D Elevation Program) data for all attributes. However, if you want to specify different sources or configurations for any attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"elevation\"],     \"elevation\": {         \"source\": \"3DEP\",         \"interpolationMethod\": \"cubic\"     } } ```  The structure of attribute configuration objects depends on the source specified:  #### 3DEP Source (Default)  If the source is `\"3DEP\"`, the object should have the following fields:  - `source` (string, required): Must be `\"3DEP\"`. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points without interpolation   - `\"linear\"`: Linear interpolation between points   - `\"cubic\"`: Smooth interpolation using cubic splines (default for elevation and slope)  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### LANDFIRE Source  If the source is `\"LANDFIRE\"`, the object should have the following fields:  - `source` (string, required): Must be `\"LANDFIRE\"`. - `version` (string, required): The version of the LANDFIRE product. Currently, only `\"2020\"` is supported. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points   - `\"linear\"`: Linear interpolation   - `\"cubic\"`: Smooth cubic interpolation   - `\"zipper\"`: Special method for LANDFIRE data  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `source` (string, required): Must be `\"uniform\"`. - `value` (float, required): The uniform value for the attribute.  Note: Uniform source is only available for the elevation attribute.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid. - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The status of the topography grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `422 Unprocessable Entity`: The request body is invalid, the data sources are not compatible with the domain CRS, or required fields are missing. - `429 Too Many Requests`: The system is currently unable to process additional job requests.

        :param domain_id: (required)
        :type domain_id: str
        :param create_topography_grid_request: (required)
        :type create_topography_grid_request: CreateTopographyGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_serialize(
            domain_id=domain_id,
            create_topography_grid_request=create_topography_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_topography_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        create_topography_grid_request: CreateTopographyGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Topography Grid

        # Create Topography Grid  This endpoint creates a new topography grid resource for a specific domain. Topography grid data represents various topographic attributes (elevation, slope, and aspect) that exist within the spatial context of a domain. The topography grid data can be generated using different data sources (3DEP, LANDFIRE, or uniform values) and interpolation methods.  On resource creation, the topography grid data is set to a status of \"pending\". The topography grid data is generated in the background using the specified method and data sources. Once the topography grid data is generated and available for user access, the status is updated to \"completed\".  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to create the topography grid.  ## Request Body  The request body should be a JSON object containing the following fields:  - `attributes` (array of strings, required): List of attributes to include in the topography grid. Possible values are:   - `\"elevation\"`   - `\"slope\"`   - `\"aspect\"`  ### Attribute Descriptions and Sources  - `elevation` (m): The elevation of the terrain above sea level. - `slope` (degrees): The slope of the terrain surface. - `aspect` (degrees): The aspect of the terrain surface (direction the slope faces).  Each attribute can be sourced from different data sources. By default, the system will use 3DEP (USGS 3D Elevation Program) data for all attributes. However, if you want to specify different sources or configurations for any attribute, you can provide detailed instructions in the request body.  To specify additional information for an attribute, add a field with the attribute name to the request body. For example:  ```json {     \"attributes\": [\"elevation\"],     \"elevation\": {         \"source\": \"3DEP\",         \"interpolationMethod\": \"cubic\"     } } ```  The structure of attribute configuration objects depends on the source specified:  #### 3DEP Source (Default)  If the source is `\"3DEP\"`, the object should have the following fields:  - `source` (string, required): Must be `\"3DEP\"`. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points without interpolation   - `\"linear\"`: Linear interpolation between points   - `\"cubic\"`: Smooth interpolation using cubic splines (default for elevation and slope)  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### LANDFIRE Source  If the source is `\"LANDFIRE\"`, the object should have the following fields:  - `source` (string, required): Must be `\"LANDFIRE\"`. - `version` (string, required): The version of the LANDFIRE product. Currently, only `\"2020\"` is supported. - `interpolationMethod` (string, required): The interpolation method to use. Possible values are:   - `\"nearest\"`: Preserves exact data points   - `\"linear\"`: Linear interpolation   - `\"cubic\"`: Smooth cubic interpolation   - `\"zipper\"`: Special method for LANDFIRE data  Note: Aspect attribute automatically uses nearest neighbor interpolation regardless of what is specified.  #### Uniform Source  If the source is `\"uniform\"`, the object should have the following fields:  - `source` (string, required): Must be `\"uniform\"`. - `value` (float, required): The uniform value for the attribute.  Note: Uniform source is only available for the elevation attribute.  ## Response  If the request is successful, the endpoint will return a `201 Created` status code and the created topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid. - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The status of the topography grid. Will be set to `\"pending\"` initially. - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `422 Unprocessable Entity`: The request body is invalid, the data sources are not compatible with the domain CRS, or required fields are missing. - `429 Too Many Requests`: The system is currently unable to process additional job requests.

        :param domain_id: (required)
        :type domain_id: str
        :param create_topography_grid_request: (required)
        :type create_topography_grid_request: CreateTopographyGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_serialize(
            domain_id=domain_id,
            create_topography_grid_request=create_topography_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_topography_grid_serialize(
        self,
        domain_id,
        create_topography_grid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_topography_grid_request is not None:
            _body_params = create_topography_grid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/topography',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_topography_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Topography Grid Export

        # Create Topography Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the topography grid data of a specific domain. The export process runs in the background and can generate files in either zarr or GeoTIFF format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Supported values:   - `\"zarr\"`: Zarr array format, suitable for high-performance array storage   - `\"geotiff\"`: GeoTIFF format, suitable for GIS applications  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or topography grid not in completed status. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the topography grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_topography_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Topography Grid Export

        # Create Topography Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the topography grid data of a specific domain. The export process runs in the background and can generate files in either zarr or GeoTIFF format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Supported values:   - `\"zarr\"`: Zarr array format, suitable for high-performance array storage   - `\"geotiff\"`: GeoTIFF format, suitable for GIS applications  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or topography grid not in completed status. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the topography grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_topography_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Topography Grid Export

        # Create Topography Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the topography grid data of a specific domain. The export process runs in the background and can generate files in either zarr or GeoTIFF format.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Supported values:   - `\"zarr\"`: Zarr array format, suitable for high-performance array storage   - `\"geotiff\"`: GeoTIFF format, suitable for GIS applications  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or topography grid not in completed status. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the topography grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_topography_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/topography/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_topography_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Topography Grid

        # Delete Topography Grid  This endpoint deletes an existing topography grid resource for a specific domain. This action removes the topography grid data from the database and cancels any ongoing job execution related to the topography grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the topography grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the topography grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The topography grid for the specified domain does not exist.  ## Usage Notes  - Deleting a topography grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the topography grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_topography_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Topography Grid

        # Delete Topography Grid  This endpoint deletes an existing topography grid resource for a specific domain. This action removes the topography grid data from the database and cancels any ongoing job execution related to the topography grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the topography grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the topography grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The topography grid for the specified domain does not exist.  ## Usage Notes  - Deleting a topography grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the topography grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_topography_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Topography Grid

        # Delete Topography Grid  This endpoint deletes an existing topography grid resource for a specific domain. This action removes the topography grid data from the database and cancels any ongoing job execution related to the topography grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the topography grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the topography grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The topography grid for the specified domain does not exist.  ## Usage Notes  - Deleting a topography grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the topography grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_topography_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/grids/topography',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_topography_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> TopographyGrid:
        """Get Topography Grid

        # Get Topography Grid  This endpoint retrieves the details of an existing topography grid resource for a specific domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the topography grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid (elevation, slope, and/or aspect). - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The current status of the topography grid (e.g., \"pending\", \"completed\"). - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  The structure of attribute configuration objects will match what was provided during creation, with 3DEP as the default source. See the create_topography_grid endpoint documentation for details on data source configurations.  ## Error Responses  - `404 Not Found`: The specified domain does not exist, the user does not have access to it, or the topography grid for the specified domain does not exist.  ## Usage Notes  - Use this endpoint to check the status and details of a previously created topography grid. - The response will include all the information provided during the creation of the topography grid, along with its current status and timestamps.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_topography_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[TopographyGrid]:
        """Get Topography Grid

        # Get Topography Grid  This endpoint retrieves the details of an existing topography grid resource for a specific domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the topography grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid (elevation, slope, and/or aspect). - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The current status of the topography grid (e.g., \"pending\", \"completed\"). - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  The structure of attribute configuration objects will match what was provided during creation, with 3DEP as the default source. See the create_topography_grid endpoint documentation for details on data source configurations.  ## Error Responses  - `404 Not Found`: The specified domain does not exist, the user does not have access to it, or the topography grid for the specified domain does not exist.  ## Usage Notes  - Use this endpoint to check the status and details of a previously created topography grid. - The response will include all the information provided during the creation of the topography grid, along with its current status and timestamps.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_topography_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Topography Grid

        # Get Topography Grid  This endpoint retrieves the details of an existing topography grid resource for a specific domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the topography grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the topography grid resource in the response body. The response body will be a JSON object with the following fields:  - `attributes` (array of strings): The list of attributes included in the topography grid (elevation, slope, and/or aspect). - `elevation` (object, optional): The data source configuration for elevation. - `slope` (object, optional): The data source configuration for slope. - `aspect` (object, optional): The data source configuration for aspect. - `status` (string): The current status of the topography grid (e.g., \"pending\", \"completed\"). - `createdOn` (string): The timestamp when the topography grid was created. - `modifiedOn` (string): The timestamp when the topography grid was last modified. - `checksum` (string): A unique checksum for the topography grid resource.  The structure of attribute configuration objects will match what was provided during creation, with 3DEP as the default source. See the create_topography_grid endpoint documentation for details on data source configurations.  ## Error Responses  - `404 Not Found`: The specified domain does not exist, the user does not have access to it, or the topography grid for the specified domain does not exist.  ## Usage Notes  - Use this endpoint to check the status and details of a previously created topography grid. - The response will include all the information provided during the creation of the topography grid, along with its current status and timestamps.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "TopographyGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_topography_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/topography',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_topography_grid_attribute_metadata(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GridAttributeMetadataResponse:
        """Get Topography Grid Attribute Metadata

        # Get Topography Grid Attribute Metadata  This endpoint retrieves detailed metadata about the structure of the topography grid and its attributes for a given domain. This includes information about the grid's dimensions, chunking, and available attributes with their units and descriptions.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape` (array): Dimensions of the grid data [height, width]. - `dimensions` (array): Names of each dimension [\"y\", \"x\"]. - `chunks` (array): Number of chunks in each dimension. - `chunkShape` (array): Shape of each chunk [chunk_height, chunk_width]. - `attributes` (array): Detailed information about each available attribute:   - `name` (string): Attribute name (e.g., \"elevation\", \"slope\", \"aspect\")   - `description` (string): Description of what the attribute represents   - `units` (string): Units of measurement (e.g., \"m\", \"degrees\")  ### Error Responses  - `404 Not Found`: Topography grid not found or not accessible. - `422 Unprocessable Entity`: Topography grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_topography_grid_attribute_metadata_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GridAttributeMetadataResponse]:
        """Get Topography Grid Attribute Metadata

        # Get Topography Grid Attribute Metadata  This endpoint retrieves detailed metadata about the structure of the topography grid and its attributes for a given domain. This includes information about the grid's dimensions, chunking, and available attributes with their units and descriptions.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape` (array): Dimensions of the grid data [height, width]. - `dimensions` (array): Names of each dimension [\"y\", \"x\"]. - `chunks` (array): Number of chunks in each dimension. - `chunkShape` (array): Shape of each chunk [chunk_height, chunk_width]. - `attributes` (array): Detailed information about each available attribute:   - `name` (string): Attribute name (e.g., \"elevation\", \"slope\", \"aspect\")   - `description` (string): Description of what the attribute represents   - `units` (string): Units of measurement (e.g., \"m\", \"degrees\")  ### Error Responses  - `404 Not Found`: Topography grid not found or not accessible. - `422 Unprocessable Entity`: Topography grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_topography_grid_attribute_metadata_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Topography Grid Attribute Metadata

        # Get Topography Grid Attribute Metadata  This endpoint retrieves detailed metadata about the structure of the topography grid and its attributes for a given domain. This includes information about the grid's dimensions, chunking, and available attributes with their units and descriptions.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape` (array): Dimensions of the grid data [height, width]. - `dimensions` (array): Names of each dimension [\"y\", \"x\"]. - `chunks` (array): Number of chunks in each dimension. - `chunkShape` (array): Shape of each chunk [chunk_height, chunk_width]. - `attributes` (array): Detailed information about each available attribute:   - `name` (string): Attribute name (e.g., \"elevation\", \"slope\", \"aspect\")   - `description` (string): Description of what the attribute represents   - `units` (string): Units of measurement (e.g., \"m\", \"degrees\")  ### Error Responses  - `404 Not Found`: Topography grid not found or not accessible. - `422 Unprocessable Entity`: Topography grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_topography_grid_attribute_metadata_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/topography/attributes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_topography_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Topography Grid Export

        # Get Topography Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a topography grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_topography_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Topography Grid Export

        # Get Topography Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a topography grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_topography_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Topography Grid Export

        # Get Topography Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/topography/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a topography grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, only `\"zarr\"` is supported.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_topography_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_topography_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/topography/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


