# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import StrictStr, field_validator
from fastfuels_sdk.client_library.models.create_surface_grid_request import CreateSurfaceGridRequest
from fastfuels_sdk.client_library.models.export import Export
from fastfuels_sdk.client_library.models.grid_attribute_metadata_response import GridAttributeMetadataResponse
from fastfuels_sdk.client_library.models.surface_grid import SurfaceGrid

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class SurfaceGridApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_surface_grid(
        self,
        domain_id: StrictStr,
        create_surface_grid_request: CreateSurfaceGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SurfaceGrid:
        """Create Surface Grid

        # Create Surface Grid  Creates a new surface grid containing fuel attributes for a domain. Surface fuels are represented through five key attributes: fuel load, fuel depth, fuel moisture, surface area-to-volume ratio (SAVR), and fire behavior fuel models (FBFM).  ## Path Parameters - `domainId` (string, required): Domain identifier  ## Request Body Structure  ### Required Fields  - `attributes` (array[string]): One or more surface fuel attributes to include:   - `fuelLoad`: Fuel loading per unit area (kg/m²)   - `fuelDepth`: Depth of fuel bed above surface (m)   - `fuelMoisture`: Mass of water per unit mass of dry fuel (%)   - `SAVR`: Surface area-to-volume ratio (m²/m³)   - `FBFM`: Fire behavior fuel model classification  ### Data Sources  Each attribute requires a data source. Available sources vary by attribute:  #### 1. LANDFIRE Source (`source: \"LANDFIRE\"`) Available for: fuelLoad, fuelDepth, SAVR, FBFM  Base configuration: - `product`: \"FBFM40\" (Scott & Burgan) or \"FBFM13\" (Anderson) - `version`: \"2022\" - `interpolationMethod`: \"nearest\", \"linear\", \"cubic\", or \"zipper\" - `featureMasks`: Array of feature types to mask (optional) - `removeNonBurnable`: Array of non-burnable codes to replace (optional)  For FBFM40 product, certain attributes can calculate values by size class using the `groups` field:  Fuel Load: - Without groups: Computes total dead fuel load (1hr + 10hr + 100hr + dead herbaceous + dead woody) - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels + dead herbaceous + dead woody   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Additional fields:   - `curingLiveHerbaceous`: 0-1   - `curingLiveWoody`: 0-1  SAVR: - Without groups: Computes weighted average SAVR of dead fuels - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels  Fuel Depth: - Groups field is ignored - returns single fuel bed depth value  #### 2. Uniform Value Source (`source: \"uniform\"`) Available for: all attributes  Configuration: - `value`: Single numeric value applied across entire grid - `featureMasks`: Array of feature types to mask (optional)  #### 3. Uniform By Size Class Source (`source: \"uniformBySizeClass\"`) Available for: fuelMoisture only  Configuration: - `groups` (required): Array of size classes to include. Values must be a subset of:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Must provide corresponding value for each specified group:   - `oneHour`: Value for 1-hour fuels (if in groups)   - `tenHour`: Value for 10-hour fuels (if in groups)   - `hundredHour`: Value for 100-hour fuels (if in groups)   - `liveHerbaceous`: Value for live herbaceous fuels (if in groups)   - `liveWoody`: Value for live woody fuels (if in groups) - `featureMasks`: Array of feature types to mask (optional)  ### Feature Enhancement Options  #### Feature Masks (`featureMasks`) - Overlays high-resolution features from OpenStreetMap - Available features: \"road\", \"water\", \"building\" - Applies to any attribute source type  #### Non-Burnable Replacement (`removeNonBurnable`) - Removes specified LANDFIRE non-burnable classes - Available codes:   - \"NB1\": Urban/developed   - \"NB2\": Snow/ice   - \"NB3\": Agricultural   - \"NB8\": Water   - \"NB9\": Bare ground - Replaced using majority filter of surrounding burnable fuels - Only available for LANDFIRE sources  ### Modifications Optional list of modifications to apply to computed values: ```python modifications: [     {         \"conditions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"operator\": string,   # Comparison operator                 \"value\": any         # Target value             }         ],         \"actions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"modifier\": string,   # Modification type                 \"value\": any         # New value             }         ]     } ] ```  ## Response Returns SurfaceGrid object containing: - Request body fields - `status`: Job status - `createdOn`: Creation timestamp - `modifiedOn`: Last modified timestamp - `checksum`: Resource checksum  ## Errors - 404: Domain not found - 422: Invalid request or incompatible data sources - 429: Too many requests

        :param domain_id: (required)
        :type domain_id: str
        :param create_surface_grid_request: (required)
        :type create_surface_grid_request: CreateSurfaceGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_serialize(
            domain_id=domain_id,
            create_surface_grid_request=create_surface_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_surface_grid_with_http_info(
        self,
        domain_id: StrictStr,
        create_surface_grid_request: CreateSurfaceGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SurfaceGrid]:
        """Create Surface Grid

        # Create Surface Grid  Creates a new surface grid containing fuel attributes for a domain. Surface fuels are represented through five key attributes: fuel load, fuel depth, fuel moisture, surface area-to-volume ratio (SAVR), and fire behavior fuel models (FBFM).  ## Path Parameters - `domainId` (string, required): Domain identifier  ## Request Body Structure  ### Required Fields  - `attributes` (array[string]): One or more surface fuel attributes to include:   - `fuelLoad`: Fuel loading per unit area (kg/m²)   - `fuelDepth`: Depth of fuel bed above surface (m)   - `fuelMoisture`: Mass of water per unit mass of dry fuel (%)   - `SAVR`: Surface area-to-volume ratio (m²/m³)   - `FBFM`: Fire behavior fuel model classification  ### Data Sources  Each attribute requires a data source. Available sources vary by attribute:  #### 1. LANDFIRE Source (`source: \"LANDFIRE\"`) Available for: fuelLoad, fuelDepth, SAVR, FBFM  Base configuration: - `product`: \"FBFM40\" (Scott & Burgan) or \"FBFM13\" (Anderson) - `version`: \"2022\" - `interpolationMethod`: \"nearest\", \"linear\", \"cubic\", or \"zipper\" - `featureMasks`: Array of feature types to mask (optional) - `removeNonBurnable`: Array of non-burnable codes to replace (optional)  For FBFM40 product, certain attributes can calculate values by size class using the `groups` field:  Fuel Load: - Without groups: Computes total dead fuel load (1hr + 10hr + 100hr + dead herbaceous + dead woody) - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels + dead herbaceous + dead woody   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Additional fields:   - `curingLiveHerbaceous`: 0-1   - `curingLiveWoody`: 0-1  SAVR: - Without groups: Computes weighted average SAVR of dead fuels - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels  Fuel Depth: - Groups field is ignored - returns single fuel bed depth value  #### 2. Uniform Value Source (`source: \"uniform\"`) Available for: all attributes  Configuration: - `value`: Single numeric value applied across entire grid - `featureMasks`: Array of feature types to mask (optional)  #### 3. Uniform By Size Class Source (`source: \"uniformBySizeClass\"`) Available for: fuelMoisture only  Configuration: - `groups` (required): Array of size classes to include. Values must be a subset of:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Must provide corresponding value for each specified group:   - `oneHour`: Value for 1-hour fuels (if in groups)   - `tenHour`: Value for 10-hour fuels (if in groups)   - `hundredHour`: Value for 100-hour fuels (if in groups)   - `liveHerbaceous`: Value for live herbaceous fuels (if in groups)   - `liveWoody`: Value for live woody fuels (if in groups) - `featureMasks`: Array of feature types to mask (optional)  ### Feature Enhancement Options  #### Feature Masks (`featureMasks`) - Overlays high-resolution features from OpenStreetMap - Available features: \"road\", \"water\", \"building\" - Applies to any attribute source type  #### Non-Burnable Replacement (`removeNonBurnable`) - Removes specified LANDFIRE non-burnable classes - Available codes:   - \"NB1\": Urban/developed   - \"NB2\": Snow/ice   - \"NB3\": Agricultural   - \"NB8\": Water   - \"NB9\": Bare ground - Replaced using majority filter of surrounding burnable fuels - Only available for LANDFIRE sources  ### Modifications Optional list of modifications to apply to computed values: ```python modifications: [     {         \"conditions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"operator\": string,   # Comparison operator                 \"value\": any         # Target value             }         ],         \"actions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"modifier\": string,   # Modification type                 \"value\": any         # New value             }         ]     } ] ```  ## Response Returns SurfaceGrid object containing: - Request body fields - `status`: Job status - `createdOn`: Creation timestamp - `modifiedOn`: Last modified timestamp - `checksum`: Resource checksum  ## Errors - 404: Domain not found - 422: Invalid request or incompatible data sources - 429: Too many requests

        :param domain_id: (required)
        :type domain_id: str
        :param create_surface_grid_request: (required)
        :type create_surface_grid_request: CreateSurfaceGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_serialize(
            domain_id=domain_id,
            create_surface_grid_request=create_surface_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_surface_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        create_surface_grid_request: CreateSurfaceGridRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Surface Grid

        # Create Surface Grid  Creates a new surface grid containing fuel attributes for a domain. Surface fuels are represented through five key attributes: fuel load, fuel depth, fuel moisture, surface area-to-volume ratio (SAVR), and fire behavior fuel models (FBFM).  ## Path Parameters - `domainId` (string, required): Domain identifier  ## Request Body Structure  ### Required Fields  - `attributes` (array[string]): One or more surface fuel attributes to include:   - `fuelLoad`: Fuel loading per unit area (kg/m²)   - `fuelDepth`: Depth of fuel bed above surface (m)   - `fuelMoisture`: Mass of water per unit mass of dry fuel (%)   - `SAVR`: Surface area-to-volume ratio (m²/m³)   - `FBFM`: Fire behavior fuel model classification  ### Data Sources  Each attribute requires a data source. Available sources vary by attribute:  #### 1. LANDFIRE Source (`source: \"LANDFIRE\"`) Available for: fuelLoad, fuelDepth, SAVR, FBFM  Base configuration: - `product`: \"FBFM40\" (Scott & Burgan) or \"FBFM13\" (Anderson) - `version`: \"2022\" - `interpolationMethod`: \"nearest\", \"linear\", \"cubic\", or \"zipper\" - `featureMasks`: Array of feature types to mask (optional) - `removeNonBurnable`: Array of non-burnable codes to replace (optional)  For FBFM40 product, certain attributes can calculate values by size class using the `groups` field:  Fuel Load: - Without groups: Computes total dead fuel load (1hr + 10hr + 100hr + dead herbaceous + dead woody) - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels + dead herbaceous + dead woody   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Additional fields:   - `curingLiveHerbaceous`: 0-1   - `curingLiveWoody`: 0-1  SAVR: - Without groups: Computes weighted average SAVR of dead fuels - With groups: Values for specific size classes:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels  Fuel Depth: - Groups field is ignored - returns single fuel bed depth value  #### 2. Uniform Value Source (`source: \"uniform\"`) Available for: all attributes  Configuration: - `value`: Single numeric value applied across entire grid - `featureMasks`: Array of feature types to mask (optional)  #### 3. Uniform By Size Class Source (`source: \"uniformBySizeClass\"`) Available for: fuelMoisture only  Configuration: - `groups` (required): Array of size classes to include. Values must be a subset of:   - `oneHour`: 1-hour dead fuels   - `tenHour`: 10-hour dead fuels   - `hundredHour`: 100-hour dead fuels   - `liveHerbaceous`: Live herbaceous fuels   - `liveWoody`: Live woody fuels - Must provide corresponding value for each specified group:   - `oneHour`: Value for 1-hour fuels (if in groups)   - `tenHour`: Value for 10-hour fuels (if in groups)   - `hundredHour`: Value for 100-hour fuels (if in groups)   - `liveHerbaceous`: Value for live herbaceous fuels (if in groups)   - `liveWoody`: Value for live woody fuels (if in groups) - `featureMasks`: Array of feature types to mask (optional)  ### Feature Enhancement Options  #### Feature Masks (`featureMasks`) - Overlays high-resolution features from OpenStreetMap - Available features: \"road\", \"water\", \"building\" - Applies to any attribute source type  #### Non-Burnable Replacement (`removeNonBurnable`) - Removes specified LANDFIRE non-burnable classes - Available codes:   - \"NB1\": Urban/developed   - \"NB2\": Snow/ice   - \"NB3\": Agricultural   - \"NB8\": Water   - \"NB9\": Bare ground - Replaced using majority filter of surrounding burnable fuels - Only available for LANDFIRE sources  ### Modifications Optional list of modifications to apply to computed values: ```python modifications: [     {         \"conditions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"operator\": string,   # Comparison operator                 \"value\": any         # Target value             }         ],         \"actions\": [             {                 \"attribute\": string,  # Must be in attributes array                 \"modifier\": string,   # Modification type                 \"value\": any         # New value             }         ]     } ] ```  ## Response Returns SurfaceGrid object containing: - Request body fields - `status`: Job status - `createdOn`: Creation timestamp - `modifiedOn`: Last modified timestamp - `checksum`: Resource checksum  ## Errors - 404: Domain not found - 422: Invalid request or incompatible data sources - 429: Too many requests

        :param domain_id: (required)
        :type domain_id: str
        :param create_surface_grid_request: (required)
        :type create_surface_grid_request: CreateSurfaceGridRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_serialize(
            domain_id=domain_id,
            create_surface_grid_request=create_surface_grid_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_surface_grid_serialize(
        self,
        domain_id,
        create_surface_grid_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_surface_grid_request is not None:
            _body_params = create_surface_grid_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/surface',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def create_surface_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Create Surface Grid Export

        # Create Surface Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the surface grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the surface grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_surface_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Create Surface Grid Export

        # Create Surface Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the surface grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the surface grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_surface_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Surface Grid Export

        # Create Surface Grid Export  ## Endpoint  ``` POST /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint initiates the creation of an export file for the surface grid data of a specific domain in the zarr compressed format. The export process runs in the background.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format for the export. Currently, the supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `201 Created` status code and a JSON object with:  - `status` (string): Initially set to `\"pending\"`. - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp (7 days from creation).  ## Error Responses  - `404 Not Found`: Domain not found or user lacks access. - `422 Unprocessable Entity`: Invalid export format or request. - `429 Too Many Requests`: Error submitting the export job due to resource exhaustion.  ## Usage Notes  - Ensure the surface grid for the domain is completed before initiating an export. - Check the export status using the GET endpoint.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_surface_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/{domainId}/grids/surface/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_surface_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Surface Grid

        # Delete Surface Grid  This endpoint deletes an existing surface grid resource for a specific domain. This action removes the surface grid data from the database and cancels any ongoing job execution related to the surface grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the surface grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the surface grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.  ## Usage Notes  - Deleting a surface grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the surface grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_surface_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Surface Grid

        # Delete Surface Grid  This endpoint deletes an existing surface grid resource for a specific domain. This action removes the surface grid data from the database and cancels any ongoing job execution related to the surface grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the surface grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the surface grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.  ## Usage Notes  - Deleting a surface grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the surface grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_surface_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Surface Grid

        # Delete Surface Grid  This endpoint deletes an existing surface grid resource for a specific domain. This action removes the surface grid data from the database and cancels any ongoing job execution related to the surface grid.  ## Endpoint  ``` DELETE /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for which you want to delete the surface grid.  ## Response  If the request is successful, the endpoint will return a `204 No Content` status code. This indicates that the surface grid has been successfully deleted and no content is returned in the response body.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.  ## Usage Notes  - Deleting a surface grid is a permanent action and cannot be undone. Ensure that you have the correct domain ID before making the delete request. - The endpoint will also cancel any ongoing job execution related to the surface grid and remove the associated data from the cache and cloud storage.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_surface_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}/grids/surface',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_surface_grid(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SurfaceGrid:
        """Get Surface Grid

        # Get Surface Grid  This endpoint retrieves the details of an existing surface grid resource for a specific domain. Users can access the status and metadata of the surface grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the surface grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the surface grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the surface grid. - `createdOn` (string): The timestamp when the surface grid was created. - `modifiedOn` (string): The timestamp when the surface grid was last modified. - `checksum` (string): A unique checksum for the surface grid resource. - `attributes` (array of strings): The list of attributes included in the surface grid. - `fuelLoad`, `fuelDepth`, `fuelMoisture`, `SAVR`, `FBFM` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_surface_grid_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SurfaceGrid]:
        """Get Surface Grid

        # Get Surface Grid  This endpoint retrieves the details of an existing surface grid resource for a specific domain. Users can access the status and metadata of the surface grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the surface grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the surface grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the surface grid. - `createdOn` (string): The timestamp when the surface grid was created. - `modifiedOn` (string): The timestamp when the surface grid was last modified. - `checksum` (string): A unique checksum for the surface grid resource. - `attributes` (array of strings): The list of attributes included in the surface grid. - `fuelLoad`, `fuelDepth`, `fuelMoisture`, `SAVR`, `FBFM` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_surface_grid_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Surface Grid

        # Get Surface Grid  This endpoint retrieves the details of an existing surface grid resource for a specific domain. Users can access the status and metadata of the surface grid that has been created.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface ```  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain for   which you want to retrieve the surface grid.  ## Response  If the request is successful, the endpoint will return a `200 OK` status code and the surface grid resource in the response body. The response body will be a JSON object with the following fields:  - `status` (string): The status of the surface grid. - `createdOn` (string): The timestamp when the surface grid was created. - `modifiedOn` (string): The timestamp when the surface grid was last modified. - `checksum` (string): A unique checksum for the surface grid resource. - `attributes` (array of strings): The list of attributes included in the surface grid. - `fuelLoad`, `fuelDepth`, `fuelMoisture`, `SAVR`, `FBFM` (object): The data source information for the respective attribute.  ## Error Responses  - `404 Not Found`: The specified domain does not exist or the user does not have access to it. - `404 Not Found`: The surface grid for the specified domain does not exist.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "SurfaceGrid",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_surface_grid_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/surface',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_surface_grid_attribute_metadata(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GridAttributeMetadataResponse:
        """Get Surface Grid Attribute Metadata

        # Get Surface Grid Attribute Metadata  Retrieves metadata about the structure of the surface grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Surface grid not found or not accessible. - 422 Unprocessable Entity: Surface grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_surface_grid_attribute_metadata_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GridAttributeMetadataResponse]:
        """Get Surface Grid Attribute Metadata

        # Get Surface Grid Attribute Metadata  Retrieves metadata about the structure of the surface grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Surface grid not found or not accessible. - 422 Unprocessable Entity: Surface grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_surface_grid_attribute_metadata_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Surface Grid Attribute Metadata

        # Get Surface Grid Attribute Metadata  Retrieves metadata about the structure of the surface grid and its attributes for a given domain.  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/attributes ```  ## Path Parameters  - `domainId` (string, required): Unique identifier of the domain.  ## Response  ### Success Response (200 OK)  Returns a JSON response containing:  - `shape`: Dimensions of the grid data. - `dimensions`: Names of each dimension. - `chunks`: Number of chunks in each dimension. - `chunkShape`: Shape of each chunk. - `attributes`: Detailed information about each available attribute.  ### Error Responses  - 404 Not Found: Surface grid not found or not accessible. - 422 Unprocessable Entity: Surface grid not in 'completed' status.

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_attribute_metadata_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GridAttributeMetadataResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_surface_grid_attribute_metadata_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/surface/attributes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_surface_grid_export(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Export:
        """Get Surface Grid Export

        # Get Surface Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a surface grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_surface_grid_export_with_http_info(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Export]:
        """Get Surface Grid Export

        # Get Surface Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a surface grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_surface_grid_export_without_preload_content(
        self,
        domain_id: StrictStr,
        export_format: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Surface Grid Export

        # Get Surface Grid Export  ## Endpoint  ``` GET /v1/domains/{domainId}/grids/surface/exports/{exportFormat} ```  ## Description  This endpoint retrieves the details of a surface grid export request for a specific domain.  ## Path Parameters  - `domainId` (string, required): The unique identifier of the domain. - `exportFormat` (string, required): The format of the export. Currently, supported formats are `\"zarr\"` and `\"geotiff\"`.  ## Response  If successful, returns a `200 OK` status code and a JSON object with:  - `status` (string): Current status of the export (`\"pending\"`, `\"running\"`, `\"completed\"`, `\"failed\"`, or `\"expired\"`). - `createdOn` (string): Timestamp of export request creation. - `modifiedOn` (string): Timestamp of last modification. - `expiresOn` (string): Expiration timestamp. - `signedUrl` (string, optional): URL to download the exported file, if status is `\"completed\"`.  ## Error Responses  - `404 Not Found`: Domain or export request not found.  ## Usage Notes  - Use this endpoint to check the status of an export request. - When status is `\"completed\"`, use the `signedUrl` to download the file. - The signed URL expires 7 days after creation.

        :param domain_id: (required)
        :type domain_id: str
        :param export_format: (required)
        :type export_format: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_surface_grid_export_serialize(
            domain_id=domain_id,
            export_format=export_format,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Export",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_surface_grid_export_serialize(
        self,
        domain_id,
        export_format,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if export_format is not None:
            _path_params['exportFormat'] = export_format
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}/grids/surface/exports/{exportFormat}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


