# coding: utf-8

"""
    FastFuels API

    A JSON API for creating, editing, and retrieving 3D fuels data for next generation fire behavior models.

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import Optional
from typing_extensions import Annotated
from fastfuels_sdk.client_library.models.create_domain_request import CreateDomainRequest
from fastfuels_sdk.client_library.models.domain import Domain
from fastfuels_sdk.client_library.models.domain_sort_field import DomainSortField
from fastfuels_sdk.client_library.models.domain_sort_order import DomainSortOrder
from fastfuels_sdk.client_library.models.geo_json_feature import GeoJSONFeature
from fastfuels_sdk.client_library.models.geo_json_feature_collection import GeoJSONFeatureCollection
from fastfuels_sdk.client_library.models.geo_json_style_properties import GeoJSONStyleProperties
from fastfuels_sdk.client_library.models.list_domain_response import ListDomainResponse
from fastfuels_sdk.client_library.models.update_domain_request import UpdateDomainRequest

from fastfuels_sdk.client_library.api_client import ApiClient, RequestSerialized
from fastfuels_sdk.client_library.api_response import ApiResponse
from fastfuels_sdk.client_library.rest import RESTResponseType


class DomainsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_domain(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Domain:
        """Create Domain

        # Create Domain Endpoint  This endpoint creates a new domain resource based on a spatial extent and additional details provided by the user. The domain resource acts as the spatial container for all other resources that create data within the system.  ## What is a Domain Resource?  A domain resource is a spatial container that represents a specific geographical area. It includes metadata such as the name, description, creation date, and the spatial extent defined by geographic coordinates. Domains are used to organize and manage spatial data and operations within a defined area. The data can be vectorized, such as holding features or trees in an inventory, or rasterized, such as a 3D canopy fuel grid or a Digital Elevation Model (DEM).  ## Endpoint: `POST /domains`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The required fields differ slightly between these two types, but there are some shared fields as well.  #### Shared Fields  These fields are required for both Feature and FeatureCollection inputs:  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  On successful creation, the endpoint returns the newly created domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Will be \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Processing from Request to Response  The system performs several processing steps to convert the Request Body into the Response Body:  1. **CRS Handling and Projection**:    - If the input CRS is geographic (e.g., EPSG:4326), the geometry is automatically projected to the appropriate UTM zone.    - If the input CRS is already projected, the domain will keep that CRS.    - If the input CRS is 'local', the spatial data is assumed to be NOT geo-referenced, and no projection is performed.  2. **Bounding Box Calculation**:    - The system calculates the bounding box of the input geometry (or the combined geometries for a FeatureCollection).  3. **Resolution-based Padding**:    - The bounding box is padded out to the nearest multiple of the user-provided horizontal resolution.  4. **FeatureCollection Creation**:    - The system creates a FeatureCollection with two features: the padded bounding box (domain) and the original input geometry.  These steps ensure that the domain's extent is regularized, aligned with the specified resolution, and in a suitable projected coordinate system (when applicable), which allows for subsequent grid-based operations.  ### Important Notes  1. **Projection**: The domain will always be stored in a projected coordinate system if the input is geographic. This ensures consistency and accuracy for spatial operations within the domain.  2. **UTM Zone Selection**: When projecting from a geographic CRS, the system automatically selects the appropriate UTM zone based on the centroid of the input geometry.  3. **FeatureCollection Handling**: When a FeatureCollection is provided as input, the domain will be created based on the combined extent of all features in the collection.  4. **Zero Area Handling**: If the spatial extent has zero area (e.g., a point or line), the endpoint will raise an error.  5. **Resolution Alignment**: The spatial extent is padded out to the nearest multiple of horizontal and vertical resolution (in meters) to ensure grid alignment.  6. **Maximum Area**: Currently, the maximum area for a domain is 16 square kilometers. We are planning to increase this limit in the future. If this limitation is an issue for your use case, please contact us for assistance.  7. **CRS Preservation**: If you provide data in a specific projected CRS, that CRS will be preserved in the domain. This is useful for maintaining consistency with existing data sources or specific regional requirements.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\" - **500 Internal Server Error**: An error occurred while creating the domain resource.

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_domain_with_http_info(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Domain]:
        """Create Domain

        # Create Domain Endpoint  This endpoint creates a new domain resource based on a spatial extent and additional details provided by the user. The domain resource acts as the spatial container for all other resources that create data within the system.  ## What is a Domain Resource?  A domain resource is a spatial container that represents a specific geographical area. It includes metadata such as the name, description, creation date, and the spatial extent defined by geographic coordinates. Domains are used to organize and manage spatial data and operations within a defined area. The data can be vectorized, such as holding features or trees in an inventory, or rasterized, such as a 3D canopy fuel grid or a Digital Elevation Model (DEM).  ## Endpoint: `POST /domains`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The required fields differ slightly between these two types, but there are some shared fields as well.  #### Shared Fields  These fields are required for both Feature and FeatureCollection inputs:  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  On successful creation, the endpoint returns the newly created domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Will be \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Processing from Request to Response  The system performs several processing steps to convert the Request Body into the Response Body:  1. **CRS Handling and Projection**:    - If the input CRS is geographic (e.g., EPSG:4326), the geometry is automatically projected to the appropriate UTM zone.    - If the input CRS is already projected, the domain will keep that CRS.    - If the input CRS is 'local', the spatial data is assumed to be NOT geo-referenced, and no projection is performed.  2. **Bounding Box Calculation**:    - The system calculates the bounding box of the input geometry (or the combined geometries for a FeatureCollection).  3. **Resolution-based Padding**:    - The bounding box is padded out to the nearest multiple of the user-provided horizontal resolution.  4. **FeatureCollection Creation**:    - The system creates a FeatureCollection with two features: the padded bounding box (domain) and the original input geometry.  These steps ensure that the domain's extent is regularized, aligned with the specified resolution, and in a suitable projected coordinate system (when applicable), which allows for subsequent grid-based operations.  ### Important Notes  1. **Projection**: The domain will always be stored in a projected coordinate system if the input is geographic. This ensures consistency and accuracy for spatial operations within the domain.  2. **UTM Zone Selection**: When projecting from a geographic CRS, the system automatically selects the appropriate UTM zone based on the centroid of the input geometry.  3. **FeatureCollection Handling**: When a FeatureCollection is provided as input, the domain will be created based on the combined extent of all features in the collection.  4. **Zero Area Handling**: If the spatial extent has zero area (e.g., a point or line), the endpoint will raise an error.  5. **Resolution Alignment**: The spatial extent is padded out to the nearest multiple of horizontal and vertical resolution (in meters) to ensure grid alignment.  6. **Maximum Area**: Currently, the maximum area for a domain is 16 square kilometers. We are planning to increase this limit in the future. If this limitation is an issue for your use case, please contact us for assistance.  7. **CRS Preservation**: If you provide data in a specific projected CRS, that CRS will be preserved in the domain. This is useful for maintaining consistency with existing data sources or specific regional requirements.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\" - **500 Internal Server Error**: An error occurred while creating the domain resource.

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_domain_without_preload_content(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Domain

        # Create Domain Endpoint  This endpoint creates a new domain resource based on a spatial extent and additional details provided by the user. The domain resource acts as the spatial container for all other resources that create data within the system.  ## What is a Domain Resource?  A domain resource is a spatial container that represents a specific geographical area. It includes metadata such as the name, description, creation date, and the spatial extent defined by geographic coordinates. Domains are used to organize and manage spatial data and operations within a defined area. The data can be vectorized, such as holding features or trees in an inventory, or rasterized, such as a 3D canopy fuel grid or a Digital Elevation Model (DEM).  ## Endpoint: `POST /domains`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The required fields differ slightly between these two types, but there are some shared fields as well.  #### Shared Fields  These fields are required for both Feature and FeatureCollection inputs:  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  On successful creation, the endpoint returns the newly created domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Will be \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Processing from Request to Response  The system performs several processing steps to convert the Request Body into the Response Body:  1. **CRS Handling and Projection**:    - If the input CRS is geographic (e.g., EPSG:4326), the geometry is automatically projected to the appropriate UTM zone.    - If the input CRS is already projected, the domain will keep that CRS.    - If the input CRS is 'local', the spatial data is assumed to be NOT geo-referenced, and no projection is performed.  2. **Bounding Box Calculation**:    - The system calculates the bounding box of the input geometry (or the combined geometries for a FeatureCollection).  3. **Resolution-based Padding**:    - The bounding box is padded out to the nearest multiple of the user-provided horizontal resolution.  4. **FeatureCollection Creation**:    - The system creates a FeatureCollection with two features: the padded bounding box (domain) and the original input geometry.  These steps ensure that the domain's extent is regularized, aligned with the specified resolution, and in a suitable projected coordinate system (when applicable), which allows for subsequent grid-based operations.  ### Important Notes  1. **Projection**: The domain will always be stored in a projected coordinate system if the input is geographic. This ensures consistency and accuracy for spatial operations within the domain.  2. **UTM Zone Selection**: When projecting from a geographic CRS, the system automatically selects the appropriate UTM zone based on the centroid of the input geometry.  3. **FeatureCollection Handling**: When a FeatureCollection is provided as input, the domain will be created based on the combined extent of all features in the collection.  4. **Zero Area Handling**: If the spatial extent has zero area (e.g., a point or line), the endpoint will raise an error.  5. **Resolution Alignment**: The spatial extent is padded out to the nearest multiple of horizontal and vertical resolution (in meters) to ensure grid alignment.  6. **Maximum Area**: Currently, the maximum area for a domain is 16 square kilometers. We are planning to increase this limit in the future. If this limitation is an issue for your use case, please contact us for assistance.  7. **CRS Preservation**: If you provide data in a specific projected CRS, that CRS will be preserved in the domain. This is useful for maintaining consistency with existing data sources or specific regional requirements.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\" - **500 Internal Server Error**: An error occurred while creating the domain resource.

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_domain_serialize(
        self,
        create_domain_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_domain_request is not None:
            _body_params = create_domain_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_domain(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Domain

        # Delete Domain Endpoint  This endpoint deletes an existing domain resource based on the provided domain ID.  ## Endpoint: `DELETE /domains/{domainId}`  ### Path Parameters  To delete a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to delete.  ### Response  The response does not return any content on a successful deletion and will have a status code of 204 No Content.  ### Example Request  ```http DELETE /domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1 ```  ### Example Response  ``` HTTP/1.1 204 No Content ```  ### Important Notes  1. Deleting a domain is a permanent action and cannot be undone. Once a domain is deleted, it is removed from the database and cannot be recovered. 2. Ensure that you have the correct domain ID before making the delete request to avoid accidentally deleting the wrong domain.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while deleting the domain resource.   - **Detail**: \"An error occurred while deleting the domain resource.\"  ### Example Error Response  ```json {   \"detail\": \"Resource not found.\" } ```  ### Example Internal Server Error Response  ```json {   \"detail\": \"An error occurred while deleting the domain resource.\" } ```

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_domain_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Domain

        # Delete Domain Endpoint  This endpoint deletes an existing domain resource based on the provided domain ID.  ## Endpoint: `DELETE /domains/{domainId}`  ### Path Parameters  To delete a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to delete.  ### Response  The response does not return any content on a successful deletion and will have a status code of 204 No Content.  ### Example Request  ```http DELETE /domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1 ```  ### Example Response  ``` HTTP/1.1 204 No Content ```  ### Important Notes  1. Deleting a domain is a permanent action and cannot be undone. Once a domain is deleted, it is removed from the database and cannot be recovered. 2. Ensure that you have the correct domain ID before making the delete request to avoid accidentally deleting the wrong domain.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while deleting the domain resource.   - **Detail**: \"An error occurred while deleting the domain resource.\"  ### Example Error Response  ```json {   \"detail\": \"Resource not found.\" } ```  ### Example Internal Server Error Response  ```json {   \"detail\": \"An error occurred while deleting the domain resource.\" } ```

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_domain_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Domain

        # Delete Domain Endpoint  This endpoint deletes an existing domain resource based on the provided domain ID.  ## Endpoint: `DELETE /domains/{domainId}`  ### Path Parameters  To delete a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to delete.  ### Response  The response does not return any content on a successful deletion and will have a status code of 204 No Content.  ### Example Request  ```http DELETE /domains/1e7d8d3c9f8b4c3ba9e7c3b4f8d7a9c1 ```  ### Example Response  ``` HTTP/1.1 204 No Content ```  ### Important Notes  1. Deleting a domain is a permanent action and cannot be undone. Once a domain is deleted, it is removed from the database and cannot be recovered. 2. Ensure that you have the correct domain ID before making the delete request to avoid accidentally deleting the wrong domain.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while deleting the domain resource.   - **Detail**: \"An error occurred while deleting the domain resource.\"  ### Example Error Response  ```json {   \"detail\": \"Resource not found.\" } ```  ### Example Internal Server Error Response  ```json {   \"detail\": \"An error occurred while deleting the domain resource.\" } ```

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_domain_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/v1/domains/{domainId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_domain(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Domain:
        """Get Domain

        # Get Domain Endpoint  This endpoint retrieves a specific domain resource based on the provided domain ID.  ## Endpoint: `GET /domains/{domainId}`  ### Path Parameters  To retrieve a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to retrieve.  ### Response  The response returns the details of the requested domain resource, including its metadata and spatial information.  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain in meters. - **verticalResolution**: (float) The vertical resolution of the domain in meters. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while retrieving the domain resource.   - **Detail**: \"An error occurred while getting the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_domain_with_http_info(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Domain]:
        """Get Domain

        # Get Domain Endpoint  This endpoint retrieves a specific domain resource based on the provided domain ID.  ## Endpoint: `GET /domains/{domainId}`  ### Path Parameters  To retrieve a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to retrieve.  ### Response  The response returns the details of the requested domain resource, including its metadata and spatial information.  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain in meters. - **verticalResolution**: (float) The vertical resolution of the domain in meters. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while retrieving the domain resource.   - **Detail**: \"An error occurred while getting the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_domain_without_preload_content(
        self,
        domain_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Domain

        # Get Domain Endpoint  This endpoint retrieves a specific domain resource based on the provided domain ID.  ## Endpoint: `GET /domains/{domainId}`  ### Path Parameters  To retrieve a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to retrieve.  ### Response  The response returns the details of the requested domain resource, including its metadata and spatial information.  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain in meters. - **verticalResolution**: (float) The vertical resolution of the domain in meters. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while retrieving the domain resource.   - **Detail**: \"An error occurred while getting the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_domain_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains/{domainId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def list_domains(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="The page number to retrieve. Page number is zero-indexed.")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of resources to retrieve per page.")] = None,
        sort_by: Optional[DomainSortField] = None,
        sort_order: Optional[DomainSortOrder] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListDomainResponse:
        """List Domains

        # List Domains Endpoint  This endpoint retrieves a paginated list of domain resources based on the query parameters provided by the user.  ## Endpoint: `GET /domains`  ### Query Parameters  To retrieve a list of domains, the following query parameters can be used:  - **page**: (integer, optional) The page number to retrieve. Page number is zero-indexed. Default is 0. - **size**: (integer, optional) The number of resources to retrieve per page. Minimum is 1 and maximum is 1000. Default is 100. - **sortBy**: (string, optional) The field by which to sort the domains. Valid values are:   - \"createdOn\"   - \"modifiedOn\"   - \"name\" - **sortOrder**: (string, optional) The order in which to sort the results. Valid values are:   - \"ascending\"   - \"descending\"  ### Response  The response is a paginated list of domain resources, including metadata about the current page and the size of each page.  - **domains**: (array) A list of Domain objects. - **currentPage**: (integer) The current page number. - **pageSize**: (integer) The number of domains per page. - **totalItems**: (integer) The total number of domain resources that belong to the user.  Each Domain object in the list follows the Domain schema.  ### Example Request  ```http GET /domains?page=0&size=10&sortBy=createdOn&sortOrder=ascending ```  ### Important Notes  1. The `page` parameter is zero-indexed, meaning that the first page is `0`. 2. The `size` parameter determines the number of domains returned per page, with a minimum of 1 and a maximum of 1000. 3. The `sortBy` parameter allows sorting by specific fields, and the `sortOrder` parameter determines the order of sorting (ascending or descending).  ### Error Responses  - **422 Unprocessable Entity**: Invalid query parameters.   - **Detail**: \"Invalid value for query parameter 'page'. Must be a non-negative integer.\"   - **Detail**: \"Invalid value for query parameter 'size'. Must be an integer between 1 and 1000.\" - **500 Internal Server Error**: An error occurred while listing the domain resources.

        :param page: The page number to retrieve. Page number is zero-indexed.
        :type page: int
        :param size: The number of resources to retrieve per page.
        :type size: int
        :param sort_by:
        :type sort_by: DomainSortField
        :param sort_order:
        :type sort_order: DomainSortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_domains_serialize(
            page=page,
            size=size,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDomainResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def list_domains_with_http_info(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="The page number to retrieve. Page number is zero-indexed.")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of resources to retrieve per page.")] = None,
        sort_by: Optional[DomainSortField] = None,
        sort_order: Optional[DomainSortOrder] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListDomainResponse]:
        """List Domains

        # List Domains Endpoint  This endpoint retrieves a paginated list of domain resources based on the query parameters provided by the user.  ## Endpoint: `GET /domains`  ### Query Parameters  To retrieve a list of domains, the following query parameters can be used:  - **page**: (integer, optional) The page number to retrieve. Page number is zero-indexed. Default is 0. - **size**: (integer, optional) The number of resources to retrieve per page. Minimum is 1 and maximum is 1000. Default is 100. - **sortBy**: (string, optional) The field by which to sort the domains. Valid values are:   - \"createdOn\"   - \"modifiedOn\"   - \"name\" - **sortOrder**: (string, optional) The order in which to sort the results. Valid values are:   - \"ascending\"   - \"descending\"  ### Response  The response is a paginated list of domain resources, including metadata about the current page and the size of each page.  - **domains**: (array) A list of Domain objects. - **currentPage**: (integer) The current page number. - **pageSize**: (integer) The number of domains per page. - **totalItems**: (integer) The total number of domain resources that belong to the user.  Each Domain object in the list follows the Domain schema.  ### Example Request  ```http GET /domains?page=0&size=10&sortBy=createdOn&sortOrder=ascending ```  ### Important Notes  1. The `page` parameter is zero-indexed, meaning that the first page is `0`. 2. The `size` parameter determines the number of domains returned per page, with a minimum of 1 and a maximum of 1000. 3. The `sortBy` parameter allows sorting by specific fields, and the `sortOrder` parameter determines the order of sorting (ascending or descending).  ### Error Responses  - **422 Unprocessable Entity**: Invalid query parameters.   - **Detail**: \"Invalid value for query parameter 'page'. Must be a non-negative integer.\"   - **Detail**: \"Invalid value for query parameter 'size'. Must be an integer between 1 and 1000.\" - **500 Internal Server Error**: An error occurred while listing the domain resources.

        :param page: The page number to retrieve. Page number is zero-indexed.
        :type page: int
        :param size: The number of resources to retrieve per page.
        :type size: int
        :param sort_by:
        :type sort_by: DomainSortField
        :param sort_order:
        :type sort_order: DomainSortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_domains_serialize(
            page=page,
            size=size,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDomainResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def list_domains_without_preload_content(
        self,
        page: Annotated[Optional[Annotated[int, Field(strict=True, ge=0)]], Field(description="The page number to retrieve. Page number is zero-indexed.")] = None,
        size: Annotated[Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]], Field(description="The number of resources to retrieve per page.")] = None,
        sort_by: Optional[DomainSortField] = None,
        sort_order: Optional[DomainSortOrder] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List Domains

        # List Domains Endpoint  This endpoint retrieves a paginated list of domain resources based on the query parameters provided by the user.  ## Endpoint: `GET /domains`  ### Query Parameters  To retrieve a list of domains, the following query parameters can be used:  - **page**: (integer, optional) The page number to retrieve. Page number is zero-indexed. Default is 0. - **size**: (integer, optional) The number of resources to retrieve per page. Minimum is 1 and maximum is 1000. Default is 100. - **sortBy**: (string, optional) The field by which to sort the domains. Valid values are:   - \"createdOn\"   - \"modifiedOn\"   - \"name\" - **sortOrder**: (string, optional) The order in which to sort the results. Valid values are:   - \"ascending\"   - \"descending\"  ### Response  The response is a paginated list of domain resources, including metadata about the current page and the size of each page.  - **domains**: (array) A list of Domain objects. - **currentPage**: (integer) The current page number. - **pageSize**: (integer) The number of domains per page. - **totalItems**: (integer) The total number of domain resources that belong to the user.  Each Domain object in the list follows the Domain schema.  ### Example Request  ```http GET /domains?page=0&size=10&sortBy=createdOn&sortOrder=ascending ```  ### Important Notes  1. The `page` parameter is zero-indexed, meaning that the first page is `0`. 2. The `size` parameter determines the number of domains returned per page, with a minimum of 1 and a maximum of 1000. 3. The `sortBy` parameter allows sorting by specific fields, and the `sortOrder` parameter determines the order of sorting (ascending or descending).  ### Error Responses  - **422 Unprocessable Entity**: Invalid query parameters.   - **Detail**: \"Invalid value for query parameter 'page'. Must be a non-negative integer.\"   - **Detail**: \"Invalid value for query parameter 'size'. Must be an integer between 1 and 1000.\" - **500 Internal Server Error**: An error occurred while listing the domain resources.

        :param page: The page number to retrieve. Page number is zero-indexed.
        :type page: int
        :param size: The number of resources to retrieve per page.
        :type size: int
        :param sort_by:
        :type sort_by: DomainSortField
        :param sort_order:
        :type sort_order: DomainSortOrder
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._list_domains_serialize(
            page=page,
            size=size,
            sort_by=sort_by,
            sort_order=sort_order,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListDomainResponse",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _list_domains_serialize(
        self,
        page,
        size,
        sort_by,
        sort_order,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        if size is not None:
            
            _query_params.append(('size', size))
            
        if sort_by is not None:
            
            _query_params.append(('sortBy', sort_by.value))
            
        if sort_order is not None:
            
            _query_params.append(('sortOrder', sort_order.value))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/v1/domains',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def preview_domain(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Domain:
        """Preview Domain

        # Preview Domain Endpoint  This endpoint processes a CreateDomainRequest and returns a Domain object without saving the data to the database. It allows users to preview what their domain will look like before actually creating it.  ## Endpoint: `POST /domains/preview`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The structure is identical to the Create Domain endpoint's request body.  #### Shared Fields  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string. - **tags**: (array of strings, optional) A list of tags associated with the domain.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  The response returns a preview of the domain resource with the following fields:  - **id**: (string) Will always be \"preview\" for this endpoint. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The current date and time. - **modifiedOn**: (datetime) The current date and time. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Processing  The preview endpoint performs the same processing steps as the create endpoint:  1. **CRS Handling and Projection**: Projects the geometry to UTM if necessary. 2. **Bounding Box Calculation**: Calculates the bounding box of the input geometry. 3. **Resolution-based Padding**: Pads the bounding box to align with the specified resolution. 4. **FeatureCollection Creation**: Creates a FeatureCollection with the padded domain and original input geometries.  ### Important Notes  1. This endpoint does not save any data to the database. It's purely for preview purposes. 2. The `id` field will always be \"preview\" in the response. 3. The `createdOn` and `modifiedOn` fields will be set to the current time but are not persisted. 4. All the same validations and checks applied in the create endpoint are also applied here, including area limitations and CONUS checks.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\"   - **Detail**: \"Invalid spatial extent. The spatial extent must be entirely within CONUS.\" - **500 Internal Server Error**: An error occurred while previewing the domain resource.   - **Detail**: \"An error occurred while previewing the domain resource.\"

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._preview_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def preview_domain_with_http_info(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Domain]:
        """Preview Domain

        # Preview Domain Endpoint  This endpoint processes a CreateDomainRequest and returns a Domain object without saving the data to the database. It allows users to preview what their domain will look like before actually creating it.  ## Endpoint: `POST /domains/preview`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The structure is identical to the Create Domain endpoint's request body.  #### Shared Fields  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string. - **tags**: (array of strings, optional) A list of tags associated with the domain.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  The response returns a preview of the domain resource with the following fields:  - **id**: (string) Will always be \"preview\" for this endpoint. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The current date and time. - **modifiedOn**: (datetime) The current date and time. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Processing  The preview endpoint performs the same processing steps as the create endpoint:  1. **CRS Handling and Projection**: Projects the geometry to UTM if necessary. 2. **Bounding Box Calculation**: Calculates the bounding box of the input geometry. 3. **Resolution-based Padding**: Pads the bounding box to align with the specified resolution. 4. **FeatureCollection Creation**: Creates a FeatureCollection with the padded domain and original input geometries.  ### Important Notes  1. This endpoint does not save any data to the database. It's purely for preview purposes. 2. The `id` field will always be \"preview\" in the response. 3. The `createdOn` and `modifiedOn` fields will be set to the current time but are not persisted. 4. All the same validations and checks applied in the create endpoint are also applied here, including area limitations and CONUS checks.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\"   - **Detail**: \"Invalid spatial extent. The spatial extent must be entirely within CONUS.\" - **500 Internal Server Error**: An error occurred while previewing the domain resource.   - **Detail**: \"An error occurred while previewing the domain resource.\"

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._preview_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def preview_domain_without_preload_content(
        self,
        create_domain_request: CreateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Preview Domain

        # Preview Domain Endpoint  This endpoint processes a CreateDomainRequest and returns a Domain object without saving the data to the database. It allows users to preview what their domain will look like before actually creating it.  ## Endpoint: `POST /domains/preview`  ### Request Body  The request body should be a GeoJSON object defined by the [GeoJSON specification (RFC 7946)](https://datatracker.ietf.org/doc/html/rfc7946). It can be either a Feature or a FeatureCollection. The structure is identical to the Create Domain endpoint's request body.  #### Shared Fields  - **type**: (string) Must be either \"Feature\" or \"FeatureCollection\". - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **horizontalResolution**: (float) The horizontal resolution in meters of a regular grid representation of the domain. - **verticalResolution**: (float) The vertical resolution in meters of a regular grid representation of the domain. - **crs**: (GeoJsonCRS) The GeoJSON specification formatted coordinate reference system (CRS) of the domain.   - **type**: (string) Must be \"name\".   - **properties**: (object) The properties object containing the CRS details.     - **name**: (string) The name of the CRS, e.g., \"EPSG:4326\". Must be either 'local' or a valid authority string. - **tags**: (array of strings, optional) A list of tags associated with the domain.  #### Feature-specific Fields  When the input type is \"Feature\", the following additional field is required:  - **geometry**: (GeoJSON Geometry object) A GeoJSON geometry object defining the spatial location of the domain.   - **type**: (string) Must be a valid GeoJSON type, e.g., \"Polygon\".   - **coordinates**: (array) An array of coordinates defining the geometry.  #### FeatureCollection-specific Fields  When the input type is \"FeatureCollection\", the following additional field is required:  - **features**: (array of Feature objects) An array of Feature objects. Each Feature object should have:   - **type**: (string) Must be \"Feature\".   - **geometry**: (GeoJSON Geometry object) As described in the Feature-specific fields.  ### Response  The response returns a preview of the domain resource with the following fields:  - **id**: (string) Will always be \"preview\" for this endpoint. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The current date and time. - **modifiedOn**: (datetime) The current date and time. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Processing  The preview endpoint performs the same processing steps as the create endpoint:  1. **CRS Handling and Projection**: Projects the geometry to UTM if necessary. 2. **Bounding Box Calculation**: Calculates the bounding box of the input geometry. 3. **Resolution-based Padding**: Pads the bounding box to align with the specified resolution. 4. **FeatureCollection Creation**: Creates a FeatureCollection with the padded domain and original input geometries.  ### Important Notes  1. This endpoint does not save any data to the database. It's purely for preview purposes. 2. The `id` field will always be \"preview\" in the response. 3. The `createdOn` and `modifiedOn` fields will be set to the current time but are not persisted. 4. All the same validations and checks applied in the create endpoint are also applied here, including area limitations and CONUS checks.  ### Error Responses  - **422 Unprocessable Entity**: The spatial extent is invalid.   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be greater than zero meters.\"   - **Detail**: \"Invalid spatial extent. The area of the spatial extent must be less than sixteen square kilometers.\"   - **Detail**: \"Invalid spatial extent. The spatial extent must be entirely within CONUS.\" - **500 Internal Server Error**: An error occurred while previewing the domain resource.   - **Detail**: \"An error occurred while previewing the domain resource.\"

        :param create_domain_request: (required)
        :type create_domain_request: CreateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._preview_domain_serialize(
            create_domain_request=create_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _preview_domain_serialize(
        self,
        create_domain_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_domain_request is not None:
            _body_params = create_domain_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/preview',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def reproject_geojson(
        self,
        geo_json_feature_collection: GeoJSONFeatureCollection,
        target_epsg: Annotated[Optional[StrictInt], Field(description="The target EPSG code to reproject the GeoJSON to.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GeoJSONFeatureCollection:
        """Reproject Geojson

        # Reproject GeoJSON Endpoint  This endpoint reprojects a GeoJSON FeatureCollection to a different coordinate reference system (CRS) using the specified EPSG code.  ## Endpoint: `POST /domains/reproject`  ### Query Parameters  To reproject a GeoJSON, the following query parameter is required:  - **targetEPSG**: (integer, optional) The EPSG code of the target coordinate reference system. Default is 4362.  ### Request Body  The request body should be a GeoJSON FeatureCollection object that includes:  - **type**: (string) Must be \"FeatureCollection\". - **features**: (array) An array of Feature objects, each containing:   - **type**: (string) Must be \"Feature\".   - **geometry**: (object) A GeoJSON geometry object.   - **properties**: (object, optional) Properties associated with the feature.  ### Response  The response returns the reprojected GeoJSON FeatureCollection with all geometries transformed to the target coordinate reference system while preserving the original properties of each feature.  ### Example Request  ```http POST /domains/reproject?targetEPSG=32633 Content-Type: application/json  {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in source CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```  ### Example Response  ```json {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in target CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```

        :param geo_json_feature_collection: (required)
        :type geo_json_feature_collection: GeoJSONFeatureCollection
        :param target_epsg: The target EPSG code to reproject the GeoJSON to.
        :type target_epsg: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reproject_geojson_serialize(
            geo_json_feature_collection=geo_json_feature_collection,
            target_epsg=target_epsg,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeatureCollection",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def reproject_geojson_with_http_info(
        self,
        geo_json_feature_collection: GeoJSONFeatureCollection,
        target_epsg: Annotated[Optional[StrictInt], Field(description="The target EPSG code to reproject the GeoJSON to.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GeoJSONFeatureCollection]:
        """Reproject Geojson

        # Reproject GeoJSON Endpoint  This endpoint reprojects a GeoJSON FeatureCollection to a different coordinate reference system (CRS) using the specified EPSG code.  ## Endpoint: `POST /domains/reproject`  ### Query Parameters  To reproject a GeoJSON, the following query parameter is required:  - **targetEPSG**: (integer, optional) The EPSG code of the target coordinate reference system. Default is 4362.  ### Request Body  The request body should be a GeoJSON FeatureCollection object that includes:  - **type**: (string) Must be \"FeatureCollection\". - **features**: (array) An array of Feature objects, each containing:   - **type**: (string) Must be \"Feature\".   - **geometry**: (object) A GeoJSON geometry object.   - **properties**: (object, optional) Properties associated with the feature.  ### Response  The response returns the reprojected GeoJSON FeatureCollection with all geometries transformed to the target coordinate reference system while preserving the original properties of each feature.  ### Example Request  ```http POST /domains/reproject?targetEPSG=32633 Content-Type: application/json  {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in source CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```  ### Example Response  ```json {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in target CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```

        :param geo_json_feature_collection: (required)
        :type geo_json_feature_collection: GeoJSONFeatureCollection
        :param target_epsg: The target EPSG code to reproject the GeoJSON to.
        :type target_epsg: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reproject_geojson_serialize(
            geo_json_feature_collection=geo_json_feature_collection,
            target_epsg=target_epsg,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeatureCollection",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def reproject_geojson_without_preload_content(
        self,
        geo_json_feature_collection: GeoJSONFeatureCollection,
        target_epsg: Annotated[Optional[StrictInt], Field(description="The target EPSG code to reproject the GeoJSON to.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reproject Geojson

        # Reproject GeoJSON Endpoint  This endpoint reprojects a GeoJSON FeatureCollection to a different coordinate reference system (CRS) using the specified EPSG code.  ## Endpoint: `POST /domains/reproject`  ### Query Parameters  To reproject a GeoJSON, the following query parameter is required:  - **targetEPSG**: (integer, optional) The EPSG code of the target coordinate reference system. Default is 4362.  ### Request Body  The request body should be a GeoJSON FeatureCollection object that includes:  - **type**: (string) Must be \"FeatureCollection\". - **features**: (array) An array of Feature objects, each containing:   - **type**: (string) Must be \"Feature\".   - **geometry**: (object) A GeoJSON geometry object.   - **properties**: (object, optional) Properties associated with the feature.  ### Response  The response returns the reprojected GeoJSON FeatureCollection with all geometries transformed to the target coordinate reference system while preserving the original properties of each feature.  ### Example Request  ```http POST /domains/reproject?targetEPSG=32633 Content-Type: application/json  {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in source CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```  ### Example Response  ```json {   \"type\": \"FeatureCollection\",   \"features\": [     {       \"type\": \"Feature\",       \"geometry\": {         \"type\": \"Polygon\",         \"coordinates\": [[[...coordinates in target CRS...]]]       },       \"properties\": {         \"name\": \"Example Feature\"       }     }   ] } ```

        :param geo_json_feature_collection: (required)
        :type geo_json_feature_collection: GeoJSONFeatureCollection
        :param target_epsg: The target EPSG code to reproject the GeoJSON to.
        :type target_epsg: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._reproject_geojson_serialize(
            geo_json_feature_collection=geo_json_feature_collection,
            target_epsg=target_epsg,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeatureCollection",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _reproject_geojson_serialize(
        self,
        geo_json_feature_collection,
        target_epsg,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if target_epsg is not None:
            
            _query_params.append(('targetEPSG', target_epsg))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if geo_json_feature_collection is not None:
            _body_params = geo_json_feature_collection


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/v1/domains/reproject',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_domain(
        self,
        domain_id: StrictStr,
        update_domain_request: UpdateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> Domain:
        """Update Domain

        # Update Domain Endpoint  This endpoint updates an existing domain resource based on the provided domain ID and request body. Users can modify specific fields of the domain, while other fields remain unchanged.  ## Endpoint: `PATCH /domains/{domainId}`  ### Path Parameters  To update a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to update.  ### Request Body  To update a domain, the request body should include one or more of the following fields:  - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **tags**: (array of strings, optional) A list of tags associated with the domain.  ### Fields that Can Be Updated  - **name**: The name of the domain. - **description**: A brief description of the domain. - **tags**: The list of tags associated with the domain.  ### Fields that Cannot Be Updated  The following fields cannot be updated. If you wish to change these fields, you need to create a new domain resource with the desired values:  - **id**: The unique identifier for the domain. - **createdOn**: The date and time the domain was created. - **type**: Always \"FeatureCollection\". - **features**: The FeatureCollection containing the domain and input geometries. - **horizontalResolution**: The horizontal resolution of the domain. - **verticalResolution**: The vertical resolution of the domain. - **crs**: The coordinate reference system of the domain. - **utmAuthorityString**: The UTM authority string of the domain.  ### Response  The response returns the updated domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Important Notes  1. Only the **name**, **description**, and **tags** fields can be updated. If you wish to change any other fields (such as features, horizontalResolution, verticalResolution, crs, etc.), you must create a new domain resource with the desired values. 2. The **modifiedOn** field will be automatically updated to the current date and time whenever any updatable field is changed.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while updating the domain resource.   - **Detail**: \"An error occurred while updating the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param update_domain_request: (required)
        :type update_domain_request: UpdateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_domain_serialize(
            domain_id=domain_id,
            update_domain_request=update_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_domain_with_http_info(
        self,
        domain_id: StrictStr,
        update_domain_request: UpdateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[Domain]:
        """Update Domain

        # Update Domain Endpoint  This endpoint updates an existing domain resource based on the provided domain ID and request body. Users can modify specific fields of the domain, while other fields remain unchanged.  ## Endpoint: `PATCH /domains/{domainId}`  ### Path Parameters  To update a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to update.  ### Request Body  To update a domain, the request body should include one or more of the following fields:  - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **tags**: (array of strings, optional) A list of tags associated with the domain.  ### Fields that Can Be Updated  - **name**: The name of the domain. - **description**: A brief description of the domain. - **tags**: The list of tags associated with the domain.  ### Fields that Cannot Be Updated  The following fields cannot be updated. If you wish to change these fields, you need to create a new domain resource with the desired values:  - **id**: The unique identifier for the domain. - **createdOn**: The date and time the domain was created. - **type**: Always \"FeatureCollection\". - **features**: The FeatureCollection containing the domain and input geometries. - **horizontalResolution**: The horizontal resolution of the domain. - **verticalResolution**: The vertical resolution of the domain. - **crs**: The coordinate reference system of the domain. - **utmAuthorityString**: The UTM authority string of the domain.  ### Response  The response returns the updated domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Important Notes  1. Only the **name**, **description**, and **tags** fields can be updated. If you wish to change any other fields (such as features, horizontalResolution, verticalResolution, crs, etc.), you must create a new domain resource with the desired values. 2. The **modifiedOn** field will be automatically updated to the current date and time whenever any updatable field is changed.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while updating the domain resource.   - **Detail**: \"An error occurred while updating the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param update_domain_request: (required)
        :type update_domain_request: UpdateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_domain_serialize(
            domain_id=domain_id,
            update_domain_request=update_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_domain_without_preload_content(
        self,
        domain_id: StrictStr,
        update_domain_request: UpdateDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Domain

        # Update Domain Endpoint  This endpoint updates an existing domain resource based on the provided domain ID and request body. Users can modify specific fields of the domain, while other fields remain unchanged.  ## Endpoint: `PATCH /domains/{domainId}`  ### Path Parameters  To update a specific domain, the following path parameter is required:  - **domainId**: (string) The unique identifier of the domain to update.  ### Request Body  To update a domain, the request body should include one or more of the following fields:  - **name**: (string, optional) The name of the domain. - **description**: (string, optional) A brief description of the domain. - **tags**: (array of strings, optional) A list of tags associated with the domain.  ### Fields that Can Be Updated  - **name**: The name of the domain. - **description**: A brief description of the domain. - **tags**: The list of tags associated with the domain.  ### Fields that Cannot Be Updated  The following fields cannot be updated. If you wish to change these fields, you need to create a new domain resource with the desired values:  - **id**: The unique identifier for the domain. - **createdOn**: The date and time the domain was created. - **type**: Always \"FeatureCollection\". - **features**: The FeatureCollection containing the domain and input geometries. - **horizontalResolution**: The horizontal resolution of the domain. - **verticalResolution**: The vertical resolution of the domain. - **crs**: The coordinate reference system of the domain. - **utmAuthorityString**: The UTM authority string of the domain.  ### Response  The response returns the updated domain resource with the following fields:  - **id**: (string) A unique identifier for the domain. - **name**: (string) The name of the domain. - **description**: (string) A brief description of the domain. - **createdOn**: (datetime) The date and time the domain was created. - **modifiedOn**: (datetime) The date and time the domain was last modified. - **type**: (string) Always \"FeatureCollection\". - **features**: (array) An array of two Feature objects:   1. The domain feature (padded bounding box):      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the padded spatial extent of the domain.      - **properties**: (object) Additional properties of the domain feature.        - **name**: (string) Will be \"domain\".        - **area**: (float) The area of the domain in square meters.        - **perimeter**: (float) The perimeter of the domain in meters.   2. The input feature:      - **type**: (string) Will be \"Feature\".      - **geometry**: (GeoJSON) The GeoJSON geometry representing the original input geometry.      - **properties**: (object) Additional properties of the input feature.        - **name**: (string) Will be \"input\".        - **area**: (float) The area of the input geometry in square meters.        - **perimeter**: (float) The perimeter of the input geometry in meters. - **horizontalResolution**: (float) The horizontal resolution of the domain. - **verticalResolution**: (float) The vertical resolution of the domain. - **crs**: (GeoJsonCRS) The coordinate reference system of the domain. - **utmAuthorityString**: (string, optional) The UTM authority string if the input was projected to UTM. - **tags**: (array of strings) A list of tags associated with the domain.  ### Important Notes  1. Only the **name**, **description**, and **tags** fields can be updated. If you wish to change any other fields (such as features, horizontalResolution, verticalResolution, crs, etc.), you must create a new domain resource with the desired values. 2. The **modifiedOn** field will be automatically updated to the current date and time whenever any updatable field is changed.  ### Error Responses  - **404 Not Found**: The specified domain does not exist or the user does not have access to it.   - **Detail**: \"Resource not found.\" - **500 Internal Server Error**: An error occurred while updating the domain resource.   - **Detail**: \"An error occurred while updating the domain resource.\"

        :param domain_id: (required)
        :type domain_id: str
        :param update_domain_request: (required)
        :type update_domain_request: UpdateDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_domain_serialize(
            domain_id=domain_id,
            update_domain_request=update_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "Domain",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_domain_serialize(
        self,
        domain_id,
        update_domain_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_domain_request is not None:
            _body_params = update_domain_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/domains/{domainId}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_feature_style(
        self,
        domain_id: StrictStr,
        feature_name: StrictStr,
        geo_json_style_properties: GeoJSONStyleProperties,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GeoJSONFeature:
        """Update Feature Style

        # Update Feature Style  Updates the style properties of a specific feature in a domain while preserving its geometry. This endpoint allows you to customize the visual appearance of either the domain boundary or input geometry features.  ## Endpoint  ``` PATCH /domains/{domainId}/features/{featureName}/style ```  ## Path Parameters  - `domainId` (string, required)   - The unique identifier of the domain containing the feature to update  - `featureName` (string, required)   - The name of the feature to update   - Must be either \"domain\" or \"input\"     - \"domain\" refers to the padded bounding box feature     - \"input\" refers to the original input geometry feature  ## Request Body  The request body should contain style properties to update. All properties are optional:  ```json {   \"strokeColor\": string,     // The color of line/boundary (e.g., \"#555555\")   \"strokeOpacity\": number,   // The opacity of lines/boundaries (0-1)   \"strokeWidth\": number,     // The width of lines/boundaries   \"fillColor\": string,       // The fill color for polygons (e.g., \"#555555\")   \"fillOpacity\": number      // The opacity of polygon fills (0-1) } ```  ## Response  Returns the updated feature with the new style properties. The response includes:  - `type`: Always \"Feature\" - `geometry`: The unchanged GeoJSON geometry of the feature - `properties`: Object containing:   - `name`: The feature name (\"domain\" or \"input\")   - `area`: The area of the feature in square meters   - `perimeter`: The perimeter of the feature in meters   - `style`: The updated style properties  ## Example Request  ```http PATCH /domains/abc123/features/domain/style Content-Type: application/json  {   \"strokeColor\": \"#FF0000\",   \"strokeWidth\": 3,   \"strokeOpacity\": 0.8,   \"fillColor\": \"#FFA500\",   \"fillOpacity\": 0.3 } ```  ## Example Response  ```json {   \"type\": \"Feature\",   \"geometry\": {     \"type\": \"Polygon\",     \"coordinates\": [/* ... */]   },   \"properties\": {     \"name\": \"domain\",     \"area\": 10000.0,     \"perimeter\": 400.0,     \"style\": {       \"strokeColor\": \"#FF0000\",       \"strokeWidth\": 3,       \"strokeOpacity\": 0.8,       \"fillColor\": \"#FFA500\",       \"fillOpacity\": 0.3     }   } } ```  ## Error Responses  - **404 Not Found**   - The specified domain or feature does not exist   - The user does not have access to the specified domain  - **500 Internal Server Error**   - An error occurred while updating the feature style   - Response includes an error message in the detail field  ## Notes  - Style properties are merged with existing styles - only specified properties are updated - Unspecified style properties retain their existing values - The geometry and other feature properties remain unchanged - Style changes are persistent and will be saved to the database

        :param domain_id: (required)
        :type domain_id: str
        :param feature_name: (required)
        :type feature_name: str
        :param geo_json_style_properties: (required)
        :type geo_json_style_properties: GeoJSONStyleProperties
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_feature_style_serialize(
            domain_id=domain_id,
            feature_name=feature_name,
            geo_json_style_properties=geo_json_style_properties,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_feature_style_with_http_info(
        self,
        domain_id: StrictStr,
        feature_name: StrictStr,
        geo_json_style_properties: GeoJSONStyleProperties,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GeoJSONFeature]:
        """Update Feature Style

        # Update Feature Style  Updates the style properties of a specific feature in a domain while preserving its geometry. This endpoint allows you to customize the visual appearance of either the domain boundary or input geometry features.  ## Endpoint  ``` PATCH /domains/{domainId}/features/{featureName}/style ```  ## Path Parameters  - `domainId` (string, required)   - The unique identifier of the domain containing the feature to update  - `featureName` (string, required)   - The name of the feature to update   - Must be either \"domain\" or \"input\"     - \"domain\" refers to the padded bounding box feature     - \"input\" refers to the original input geometry feature  ## Request Body  The request body should contain style properties to update. All properties are optional:  ```json {   \"strokeColor\": string,     // The color of line/boundary (e.g., \"#555555\")   \"strokeOpacity\": number,   // The opacity of lines/boundaries (0-1)   \"strokeWidth\": number,     // The width of lines/boundaries   \"fillColor\": string,       // The fill color for polygons (e.g., \"#555555\")   \"fillOpacity\": number      // The opacity of polygon fills (0-1) } ```  ## Response  Returns the updated feature with the new style properties. The response includes:  - `type`: Always \"Feature\" - `geometry`: The unchanged GeoJSON geometry of the feature - `properties`: Object containing:   - `name`: The feature name (\"domain\" or \"input\")   - `area`: The area of the feature in square meters   - `perimeter`: The perimeter of the feature in meters   - `style`: The updated style properties  ## Example Request  ```http PATCH /domains/abc123/features/domain/style Content-Type: application/json  {   \"strokeColor\": \"#FF0000\",   \"strokeWidth\": 3,   \"strokeOpacity\": 0.8,   \"fillColor\": \"#FFA500\",   \"fillOpacity\": 0.3 } ```  ## Example Response  ```json {   \"type\": \"Feature\",   \"geometry\": {     \"type\": \"Polygon\",     \"coordinates\": [/* ... */]   },   \"properties\": {     \"name\": \"domain\",     \"area\": 10000.0,     \"perimeter\": 400.0,     \"style\": {       \"strokeColor\": \"#FF0000\",       \"strokeWidth\": 3,       \"strokeOpacity\": 0.8,       \"fillColor\": \"#FFA500\",       \"fillOpacity\": 0.3     }   } } ```  ## Error Responses  - **404 Not Found**   - The specified domain or feature does not exist   - The user does not have access to the specified domain  - **500 Internal Server Error**   - An error occurred while updating the feature style   - Response includes an error message in the detail field  ## Notes  - Style properties are merged with existing styles - only specified properties are updated - Unspecified style properties retain their existing values - The geometry and other feature properties remain unchanged - Style changes are persistent and will be saved to the database

        :param domain_id: (required)
        :type domain_id: str
        :param feature_name: (required)
        :type feature_name: str
        :param geo_json_style_properties: (required)
        :type geo_json_style_properties: GeoJSONStyleProperties
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_feature_style_serialize(
            domain_id=domain_id,
            feature_name=feature_name,
            geo_json_style_properties=geo_json_style_properties,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_feature_style_without_preload_content(
        self,
        domain_id: StrictStr,
        feature_name: StrictStr,
        geo_json_style_properties: GeoJSONStyleProperties,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Feature Style

        # Update Feature Style  Updates the style properties of a specific feature in a domain while preserving its geometry. This endpoint allows you to customize the visual appearance of either the domain boundary or input geometry features.  ## Endpoint  ``` PATCH /domains/{domainId}/features/{featureName}/style ```  ## Path Parameters  - `domainId` (string, required)   - The unique identifier of the domain containing the feature to update  - `featureName` (string, required)   - The name of the feature to update   - Must be either \"domain\" or \"input\"     - \"domain\" refers to the padded bounding box feature     - \"input\" refers to the original input geometry feature  ## Request Body  The request body should contain style properties to update. All properties are optional:  ```json {   \"strokeColor\": string,     // The color of line/boundary (e.g., \"#555555\")   \"strokeOpacity\": number,   // The opacity of lines/boundaries (0-1)   \"strokeWidth\": number,     // The width of lines/boundaries   \"fillColor\": string,       // The fill color for polygons (e.g., \"#555555\")   \"fillOpacity\": number      // The opacity of polygon fills (0-1) } ```  ## Response  Returns the updated feature with the new style properties. The response includes:  - `type`: Always \"Feature\" - `geometry`: The unchanged GeoJSON geometry of the feature - `properties`: Object containing:   - `name`: The feature name (\"domain\" or \"input\")   - `area`: The area of the feature in square meters   - `perimeter`: The perimeter of the feature in meters   - `style`: The updated style properties  ## Example Request  ```http PATCH /domains/abc123/features/domain/style Content-Type: application/json  {   \"strokeColor\": \"#FF0000\",   \"strokeWidth\": 3,   \"strokeOpacity\": 0.8,   \"fillColor\": \"#FFA500\",   \"fillOpacity\": 0.3 } ```  ## Example Response  ```json {   \"type\": \"Feature\",   \"geometry\": {     \"type\": \"Polygon\",     \"coordinates\": [/* ... */]   },   \"properties\": {     \"name\": \"domain\",     \"area\": 10000.0,     \"perimeter\": 400.0,     \"style\": {       \"strokeColor\": \"#FF0000\",       \"strokeWidth\": 3,       \"strokeOpacity\": 0.8,       \"fillColor\": \"#FFA500\",       \"fillOpacity\": 0.3     }   } } ```  ## Error Responses  - **404 Not Found**   - The specified domain or feature does not exist   - The user does not have access to the specified domain  - **500 Internal Server Error**   - An error occurred while updating the feature style   - Response includes an error message in the detail field  ## Notes  - Style properties are merged with existing styles - only specified properties are updated - Unspecified style properties retain their existing values - The geometry and other feature properties remain unchanged - Style changes are persistent and will be saved to the database

        :param domain_id: (required)
        :type domain_id: str
        :param feature_name: (required)
        :type feature_name: str
        :param geo_json_style_properties: (required)
        :type geo_json_style_properties: GeoJSONStyleProperties
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_feature_style_serialize(
            domain_id=domain_id,
            feature_name=feature_name,
            geo_json_style_properties=geo_json_style_properties,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GeoJSONFeature",
            '422': "HTTPValidationError",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_feature_style_serialize(
        self,
        domain_id,
        feature_name,
        geo_json_style_properties,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params['domainId'] = domain_id
        if feature_name is not None:
            _path_params['featureName'] = feature_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if geo_json_style_properties is not None:
            _body_params = geo_json_style_properties


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'APIKeyHeader', 
            'HTTPBearer'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/v1/domains/{domainId}/features/{featureName}/style',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


