import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the storage container
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#container StorageObject#container}
    */
    readonly container: string;
    /**
    * Raw content in string-form of the data
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#content StorageObject#content}
    */
    readonly content?: string;
    /**
    * Overrides the behavior of the browser
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#content_disposition StorageObject#content_disposition}
    */
    readonly contentDisposition?: string;
    /**
    * Set the content-encoding metadata
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#content_encoding StorageObject#content_encoding}
    */
    readonly contentEncoding?: string;
    /**
    * Set the MIME type for the object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#content_type StorageObject#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#copy_from StorageObject#copy_from}
    */
    readonly copyFrom?: string;
    /**
    * The date and time in UNIX Epoch time stamp format when the system removes the object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#delete_at StorageObject#delete_at}
    */
    readonly deleteAt?: number;
    /**
    * MD5 checksum value of the request body. Unquoted. Strongly Recommended
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#etag StorageObject#etag}
    */
    readonly etag?: string;
    /**
    * File path for the content to use for data
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#file StorageObject#file}
    */
    readonly file?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#id StorageObject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The object metadata
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#metadata StorageObject#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Name of the storage object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#name StorageObject#name}
    */
    readonly name: string;
    /**
    * Sets the transfer encoding. Can only be 'chunked' or Nil, requires Content-Length to be 0 if set
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opc/r/storage_object#transfer_encoding StorageObject#transfer_encoding}
    */
    readonly transferEncoding?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/opc/r/storage_object opc_storage_object}
*/
export declare class StorageObject extends cdktf.TerraformResource {
    static readonly tfResourceType = "opc_storage_object";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/opc/r/storage_object opc_storage_object} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageObjectConfig
    */
    constructor(scope: Construct, id: string, config: StorageObjectConfig);
    get acceptRanges(): string;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _contentDisposition?;
    get contentDisposition(): string;
    set contentDisposition(value: string);
    resetContentDisposition(): void;
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    get contentEncoding(): string;
    set contentEncoding(value: string);
    resetContentEncoding(): void;
    get contentEncodingInput(): string | undefined;
    get contentLength(): number;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _copyFrom?;
    get copyFrom(): string;
    set copyFrom(value: string);
    resetCopyFrom(): void;
    get copyFromInput(): string | undefined;
    private _deleteAt?;
    get deleteAt(): number;
    set deleteAt(value: number);
    resetDeleteAt(): void;
    get deleteAtInput(): number | undefined;
    private _etag?;
    get etag(): string;
    set etag(value: string);
    resetEtag(): void;
    get etagInput(): string | undefined;
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastModified(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get objectManifest(): string;
    get timestamp(): string;
    get transactionId(): string;
    private _transferEncoding?;
    get transferEncoding(): string;
    set transferEncoding(value: string);
    resetTransferEncoding(): void;
    get transferEncodingInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
